-- MariaDB dump 10.18  Distrib 10.4.17-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: prochefco_dbmm
-- ------------------------------------------------------
-- Server version	10.4.17-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_analytics_usage_version_log`
--

LOCK TABLES `admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` DISABLE KEYS */;
INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.4.1');
/*!40000 ALTER TABLE `admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'User ID',
  `password_hash` varchar(100) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Deprecated',
  `last_updated` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES (1,1,'75d964f5ead384a0a43e0e70c1b6bfd831f6b2e53c4c6d1e7ed1a66addc10456:ZK613VutAzjCa860:2',0,1603639530),(2,2,'51d7b4000c8d65ccc0340d1fda3369fda330f3f858be035ff64edecbfb5ccd48:FPMvXufG1aJDTElj:2',0,1604333312),(3,1,'269a9bc3a0736128c5e27471aaf341871a3ab4c4340c99924ce9e7de761454d8:c0zgE9OCdANVLKf7:2',0,1604333487),(4,3,'d3b85ea27e54b9485e0ac1b7d25fb7860ca260f6c0d30066ea995b4fe8f888bb:mL6acwZE0kstSkzV:2',0,1605019852),(5,2,'df4ac681b6f3c8aac0533ad11f7881bb69137287b4d771b69a37012c0f1d6e40:Y7EyG2t1yAKkTl2R:2',0,1605360529),(6,4,'d8abb6240b365bec69e04b8d60b627227fb3b1edde48cd122c3ce0429b1839f7:f2eRpK3WyJ0ruOvr:2',0,1605360650),(7,5,'4f6ee352d23761c3e370e236c20d5a7d217ca37eaa41dde9b8459fcb9dc218b2:0CoLBf7tfvxMArQo:2',0,1605360814),(8,4,'9734ece28094d1ab4f5eecaa13d6b4a6a5f79f1d46722e84b238f6da67de383c:Owyq9niZzmYaW8K9:2',0,1605781349),(9,6,'08d94a69a09265f28088e879eab378aaf048ec84810f96d109e923cf43d577f2:EocCC0ogewzaCtPc:2',0,1606283475),(10,7,'26e369eef4cb90ad3305fe55b93d2bb61b69291f94bdf5d50c7920c34aed4519:e0zOn8j626mQcDb1:2',0,1606892331),(11,8,'d83d3ece9adba6244ef1fd090dfad2382a094ce0a9552c09be98a84cdd999178:RNbYKTnhO6jqlyiN:2',0,1607695017),(12,5,'0660c6c498b44a9fc83fcd40ad7606dac2c119c8a298ae8236c0e3aefcbefe11:n0aVbMfsokGHtog8:2',0,1608022553);
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT 0 COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_system_messages`
--

LOCK TABLES `admin_system_messages` WRITE;
/*!40000 ALTER TABLE `admin_system_messages` DISABLE KEYS */;
INSERT INTO `admin_system_messages` VALUES ('6574525426784678a4023b3d1743a4de',1,'2020-12-16 10:18:00');
/*!40000 ALTER TABLE `admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT 0 COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT 1 COMMENT 'User Is Active',
  `extra` text DEFAULT NULL COMMENT 'User Extra Data',
  `rp_token` text DEFAULT NULL COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT 0 COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  `refresh_token` text DEFAULT NULL COMMENT 'Email connector refresh token',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES (1,'Eran','Greenwald','eran.freelance@gmail.com','eran','269a9bc3a0736128c5e27471aaf341871a3ab4c4340c99924ce9e7de761454d8:c0zgE9OCdANVLKf7:2','2020-10-25 15:25:30','2020-12-16 09:15:47','2020-12-16 09:15:47',83,0,1,'{\"configState\":{\"payment_other_mci_smartpayplus\":\"0\",\"payment_other_account\":\"1\",\"payment_other_recommended_solutions\":\"1\",\"payment_other_express_checkout_other\":\"1\",\"payment_other_other_paypal_payment_solutions\":\"0\",\"payment_other_paypal_group_all_in_one\":\"1\",\"payment_other_other_payment_methods\":\"1\",\"payment_other_klarna_section\":\"0\",\"payment_other_amazon_payment\":\"0\",\"payment_other_checkmo\":\"0\",\"payment_other_cashondelivery\":\"0\",\"payment_other_banktransfer\":\"0\",\"payment_other_free\":\"0\",\"payment_other_purchaseorder\":\"0\",\"payment_other_mci_smartpayplus_iframe\":\"0\",\"shipping_origin\":\"1\",\"shipping_shipper_autocomplete\":\"1\",\"carriers_flatrate\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_tablerate\":\"0\",\"carriers_shipper\":\"0\",\"carriers_instore\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"catalog_search\":\"0\",\"catalog_fields_masks\":\"0\",\"catalog_frontend\":\"0\",\"catalog_review\":\"0\",\"catalog_productalert\":\"0\",\"catalog_productalert_cron\":\"0\",\"catalog_placeholder\":\"0\",\"catalog_recently_products\":\"0\",\"catalog_product_video\":\"0\",\"catalog_price\":\"0\",\"catalog_layered_navigation\":\"0\",\"catalog_seo\":\"1\",\"catalog_navigation\":\"0\",\"catalog_downloadable\":\"0\",\"catalog_custom_options\":\"0\",\"web_default\":\"1\",\"web_url\":\"0\",\"web_seo\":\"0\",\"web_unsecure\":\"0\",\"web_secure\":\"0\",\"web_default_layouts\":\"0\",\"web_cookie\":\"0\",\"web_session\":\"0\",\"web_browser_capabilities\":\"0\",\"codazon_ajaxlayerednavpro_rating_builder\":\"1\",\"codazon_ajaxlayerednavpro_general\":\"0\",\"quickshop_general\":\"1\",\"messenger_general\":\"1\",\"checkout_options\":\"1\",\"general_region\":\"0\",\"general_country\":\"0\",\"general_locale\":\"0\",\"general_store_information\":\"0\",\"general_single_store_mode\":\"0\",\"admin_security\":\"1\",\"admin_emails\":\"0\",\"admin_url\":\"0\",\"admin_dashboard\":\"0\",\"admin_usage\":\"1\",\"admin_startup\":\"0\",\"admin_captcha\":\"0\",\"dev_static\":\"1\",\"dev_front_end_development_workflow\":\"1\",\"dev_restrict\":\"1\",\"dev_debug\":\"1\",\"dev_template\":\"0\",\"dev_translate_inline\":\"1\",\"dev_js\":\"1\",\"dev_css\":\"1\",\"dev_image\":\"0\",\"dev_caching\":\"0\",\"dev_grid\":\"1\",\"codazon_shopbybrand_general\":\"0\",\"codazon_shopbybrand_featured_brands\":\"0\",\"codazon_shopbybrand_brand_search_box\":\"0\",\"codazon_shopbybrand_all_brand_page\":\"0\",\"codazon_shopbybrand_product_view_page\":\"1\",\"codazon_shopbybrand_brand_page\":\"0\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"sales_email_general\":\"1\",\"sales_email_order\":\"1\",\"sales_email_order_comment\":\"0\",\"contact_email\":\"1\",\"contact_contact\":\"1\",\"customer_create_account\":\"1\",\"customer_password\":\"1\",\"customer_account_share\":\"0\",\"customer_online_customers\":\"1\",\"customer_account_information\":\"0\",\"customer_address\":\"1\",\"customer_startup\":\"0\",\"customer_address_templates\":\"1\",\"customer_captcha\":\"1\",\"customer_enhancedprivacy\":\"0\",\"sales_email_shipment\":\"1\",\"sales_email_invoice\":\"1\",\"sales_email_invoice_comment\":\"0\",\"sales_email_shipment_comment\":\"0\",\"sales_email_creditmemo\":\"0\",\"sales_email_creditmemo_comment\":\"0\",\"sales_email_order_ready_for_pickup\":\"0\",\"shipping_shipping_policy\":\"1\",\"mfblog_sidebar\":\"1\",\"mfblog_index_page\":\"0\",\"mfblog_post_view\":\"0\",\"mfblog_post_list\":\"0\",\"mfblog_search\":\"0\",\"mfblog_seo\":\"0\",\"mfblog_general\":\"1\",\"mfblog_product_page\":\"0\",\"mfblog_author\":\"0\",\"mfblog_tag\":\"0\",\"mfblog_permalink\":\"0\",\"mfblog_social\":\"0\",\"mfblog_top_menu\":\"0\",\"multishipping_options\":\"1\",\"carriers_dotsquares\":\"0\",\"hdfshipsection_general\":\"0\",\"system_smtp\":\"0\",\"payment_other_paypluslandingpage\":\"0\",\"newsletter_subscription\":\"1\",\"newsletter_general\":\"0\",\"carriers_flatrateone\":\"0\",\"carriers_flatratetwo\":\"0\",\"carriers_flatratethree\":\"0\",\"carriers_flatratefive\":\"0\",\"carriers_flatratefour\":\"0\",\"smtp_general\":\"1\",\"smtp_configuration_option\":\"1\",\"smtp_developer\":\"1\",\"smtp_module\":\"1\",\"cataloginventory_options\":\"1\",\"cataloginventory_item_options\":\"1\",\"cataloginventory_indexer\":\"1\",\"cataloginventory_bulk_operations\":\"1\",\"amasty_acart_information\":\"1\",\"amasty_acart_testing\":\"1\",\"amasty_acart_email_templates\":\"1\",\"amasty_acart_amasty_information\":\"1\",\"amasty_acart_general\":\"0\",\"amasty_acart_blacklist\":\"0\",\"amasty_acart_debug\":\"0\",\"system_full_page_cache\":\"1\",\"system_mysqlmq\":\"0\",\"system_cron\":\"0\",\"system_currency\":\"0\",\"system_adminnotification\":\"0\",\"system_backup\":\"0\",\"system_bulk\":\"0\",\"system_media_storage_configuration\":\"0\",\"system_upload_configuration\":\"0\",\"system_media_gallery\":\"0\",\"system_adobe_stock_integration\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(2,'Nitzan','Mashiach','nitzan@pichefkes.co.il','pichefkes','df4ac681b6f3c8aac0533ad11f7881bb69137287b4d771b69a37012c0f1d6e40:Y7EyG2t1yAKkTl2R:2','2020-11-02 16:08:32','2020-12-16 10:18:16','2020-12-16 07:44:41',44,0,1,'{\"configState\":{\"catalog_product_video\":\"1\",\"catalog_fields_masks\":\"0\",\"catalog_frontend\":\"0\",\"catalog_review\":\"0\",\"catalog_productalert\":\"0\",\"catalog_productalert_cron\":\"0\",\"catalog_placeholder\":\"1\",\"catalog_recently_products\":\"1\",\"catalog_price\":\"0\",\"catalog_layered_navigation\":\"0\",\"catalog_search\":\"0\",\"catalog_seo\":\"0\",\"catalog_navigation\":\"0\",\"catalog_downloadable\":\"0\",\"catalog_custom_options\":\"0\",\"shipping_shipper_autocomplete\":\"1\",\"shipping_shipping_policy\":\"1\",\"carriers_flatrate\":\"1\",\"carriers_dotsquares\":\"1\",\"carriers_freeshipping\":\"1\",\"carriers_tablerate\":\"1\",\"carriers_instore\":\"1\",\"carriers_shipper\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"mfblog_social\":\"1\",\"mfblog_tag\":\"1\",\"mfblog_product_page\":\"1\",\"mfblog_sidebar\":\"1\",\"hdfshipsection_general\":\"1\",\"shipping_origin\":\"1\",\"payment_other_mci_smartpayplus\":\"1\",\"payment_other_mci_smartpayplus_iframe\":\"1\",\"payment_other_purchaseorder\":\"0\",\"payment_other_account\":\"1\",\"payment_other_recommended_solutions\":\"1\",\"payment_other_express_checkout_other\":\"0\",\"payment_other_other_paypal_payment_solutions\":\"0\",\"payment_other_paypal_group_all_in_one\":\"1\",\"payment_other_other_payment_methods\":\"1\",\"payment_other_klarna_section\":\"0\",\"payment_other_amazon_payment\":\"0\",\"payment_other_checkmo\":\"1\",\"payment_other_cashondelivery\":\"1\",\"payment_other_banktransfer\":\"1\",\"payment_other_free\":\"0\",\"system_smtp\":\"1\",\"dev_front_end_development_workflow\":\"1\",\"admin_usage\":\"0\",\"general_store_information\":\"1\",\"payment_other_paypluslandingpage\":\"1\",\"codazon_shopbybrand_brand_page\":\"1\",\"codazon_shopbybrand_all_brand_page\":\"1\",\"codazon_shopbybrand_featured_brands\":\"1\",\"codazon_shopbybrand_brand_search_box\":\"1\",\"codazon_shopbybrand_product_view_page\":\"1\",\"codazon_shopbybrand_general\":\"1\",\"sociallogin_general\":\"0\",\"web_url\":\"1\",\"general_locale\":\"1\",\"dev_translate_inline\":\"1\",\"dev_restrict\":\"0\",\"dev_debug\":\"0\",\"dev_template\":\"0\",\"dev_js\":\"0\",\"dev_css\":\"0\",\"dev_image\":\"0\",\"dev_caching\":\"0\",\"dev_static\":\"0\",\"dev_grid\":\"0\",\"carriers_flatrateone\":\"1\",\"carriers_flatratetwo\":\"1\",\"carriers_flatratethree\":\"0\",\"carriers_flatratefour\":\"0\",\"carriers_flatratefive\":\"0\",\"amasty_affiliate_account\":\"1\",\"amasty_affiliate_general\":\"1\",\"amasty_affiliate_url\":\"1\",\"amasty_affiliate_commission\":\"1\",\"amasty_affiliate_withdrawal\":\"1\",\"amasty_affiliate_friends\":\"1\",\"amasty_affiliate_terms\":\"1\",\"amasty_affiliate_amasty_information\":\"1\",\"amasty_affiliate_email\":\"1\",\"smtp_general\":\"1\",\"smtp_configuration_option\":\"1\",\"smtp_developer\":\"1\",\"sociallogin_facebook\":\"1\",\"weltpixel_googletagmanager_api\":\"0\",\"weltpixel_googletagmanager_general\":\"0\",\"weltpixel_googletagmanager_adwords_conversion_tracking\":\"0\",\"weltpixel_googletagmanager_adwords_remarketing\":\"0\",\"weltpixel_googletagmanager_json_export\":\"1\",\"admin_captcha\":\"0\",\"admin_security\":\"0\",\"admin_url\":\"0\",\"admin_startup\":\"0\",\"admin_emails\":\"0\",\"system_full_page_cache\":\"0\",\"system_upload_configuration\":\"0\",\"system_cron\":\"0\",\"system_currency\":\"1\",\"sales_email_general\":\"1\",\"sales_email_order\":\"1\",\"sales_email_order_comment\":\"1\",\"sales_email_invoice\":\"1\",\"sales_email_invoice_comment\":\"1\",\"sales_email_shipment\":\"1\",\"sales_email_shipment_comment\":\"1\",\"sales_email_creditmemo\":\"1\",\"sales_email_creditmemo_comment\":\"1\",\"sales_email_order_ready_for_pickup\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"sales_msrp\":\"0\",\"sales_gift_options\":\"1\",\"sales_orders\":\"0\",\"sales_dashboard\":\"0\",\"sales_minimum_order\":\"1\",\"sales_identity\":\"1\",\"sales_reorder\":\"0\",\"sales_totals_sort\":\"1\",\"sales_general\":\"1\",\"sales_zerograndtotal_creditmemo\":\"0\",\"sales_instant_purchase\":\"0\",\"admin_dashboard\":\"1\",\"analytics_general\":\"1\",\"reports_dashboard\":\"1\",\"reports_options\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(3,'LitExtension','LitExtension','LitExtension@LitExtension.com','LitExtension','d3b85ea27e54b9485e0ac1b7d25fb7860ca260f6c0d30066ea995b4fe8f888bb:mL6acwZE0kstSkzV:2','2020-11-10 14:50:52','2020-11-24 02:21:50','2020-11-24 02:21:50',11,0,1,'{\"configState\":{\"catalog_price\":\"1\",\"sales_general\":\"0\",\"sales_totals_sort\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(4,'Itamar','Mor','zoola21@gmail.com','itamar','9734ece28094d1ab4f5eecaa13d6b4a6a5f79f1d46722e84b238f6da67de383c:Owyq9niZzmYaW8K9:2','2020-11-14 13:30:50','2020-12-16 09:19:09','2020-12-16 09:19:09',21,0,1,'{\"configState\":{\"hdfshipsection_general\":\"1\",\"recaptcha_backend_type_recaptcha\":\"0\",\"google_analytics\":\"1\",\"google_adwords\":\"1\",\"carriers_dotsquares\":\"1\",\"shipping_shipper_autocomplete\":\"1\",\"shipping_origin\":\"1\",\"codazon_shopbybrand_general\":\"1\",\"codazon_shopbybrand_featured_brands\":\"1\",\"codazon_shopbybrand_brand_search_box\":\"1\",\"codazon_shopbybrand_all_brand_page\":\"1\",\"codazon_shopbybrand_brand_page\":\"1\",\"codazon_shopbybrand_product_view_page\":\"1\",\"dev_translate_inline\":\"1\",\"dev_front_end_development_workflow\":\"0\",\"dev_restrict\":\"0\",\"dev_debug\":\"0\",\"dev_template\":\"0\",\"dev_js\":\"0\",\"dev_css\":\"0\",\"dev_image\":\"0\",\"dev_caching\":\"0\",\"dev_static\":\"0\",\"dev_grid\":\"0\",\"carriers_flatrate\":\"0\",\"carriers_shipper\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_tablerate\":\"0\",\"carriers_flatrateone\":\"0\",\"carriers_flatratetwo\":\"0\",\"carriers_flatratethree\":\"0\",\"carriers_flatratefour\":\"0\",\"carriers_flatratefive\":\"0\",\"carriers_instore\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"amasty_acart_email_templates\":\"1\",\"weltpixel_googletagmanager_general\":\"0\",\"weltpixel_googletagmanager_api\":\"1\",\"weltpixel_googletagmanager_adwords_conversion_tracking\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(5,'Lior','Keinan','ebhive@gmail.com','ebhive','0660c6c498b44a9fc83fcd40ad7606dac2c119c8a298ae8236c0e3aefcbefe11:n0aVbMfsokGHtog8:2','2020-11-14 13:33:34','2020-12-15 08:56:17','2020-12-15 08:56:17',15,0,1,'{\"configState\":{\"dev_debug\":\"1\",\"dev_restrict\":\"1\",\"dev_front_end_development_workflow\":\"1\",\"dev_template\":\"1\",\"dev_translate_inline\":\"1\",\"dev_js\":\"1\",\"dev_grid\":\"1\",\"dev_static\":\"1\",\"dev_caching\":\"1\",\"dev_image\":\"1\",\"dev_css\":\"1\",\"system_media_gallery\":\"1\",\"system_upload_configuration\":\"1\",\"system_media_storage_configuration\":\"1\",\"system_bulk\":\"1\",\"system_full_page_cache\":\"1\",\"system_backup\":\"1\",\"system_adminnotification\":\"1\",\"system_currency\":\"1\",\"system_cron\":\"1\",\"admin_emails\":\"1\",\"admin_startup\":\"1\",\"admin_url\":\"1\",\"admin_security\":\"1\",\"admin_dashboard\":\"1\",\"admin_captcha\":\"1\",\"admin_usage\":\"1\",\"sales_email_order\":\"1\",\"sales_email_general\":\"1\",\"checkout_options\":\"1\",\"checkout_cart\":\"1\",\"sales_email_order_comment\":\"1\",\"sales_email_invoice\":\"1\",\"sales_email_invoice_comment\":\"1\",\"sales_email_shipment\":\"1\",\"sales_email_shipment_comment\":\"1\",\"sales_email_creditmemo\":\"1\",\"sales_email_creditmemo_comment\":\"1\",\"sales_email_order_ready_for_pickup\":\"1\",\"contact_contact\":\"1\",\"contact_email\":\"1\",\"mfblog_index_page\":\"0\",\"mfblog_top_menu\":\"1\",\"mfblog_general\":\"1\",\"mfblog_post_view\":\"0\",\"mfblog_post_list\":\"0\",\"mfblog_sidebar\":\"0\",\"mfblog_product_page\":\"0\",\"mfblog_author\":\"0\",\"mfblog_tag\":\"0\",\"mfblog_search\":\"0\",\"mfblog_permalink\":\"1\",\"mfblog_seo\":\"0\",\"mfblog_social\":\"0\",\"web_default\":\"0\",\"web_default_layouts\":\"0\",\"catalog_frontend\":\"0\",\"cataloginventory_options\":\"1\",\"cataloginventory_item_options\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"newsletter_general\":\"1\",\"newsletter_subscription\":\"1\",\"carriers_shipper\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_tablerate\":\"0\",\"carriers_instore\":\"1\",\"carriers_flatrate\":\"0\",\"carriers_dotsquares\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"codazon_lookbook_general\":\"1\",\"codazon_lookbook_images\":\"1\",\"codazon_lookbook_lookbook_category_list\":\"1\",\"codazon_shopbybrand_general\":\"1\",\"codazon_shopbybrand_featured_brands\":\"1\",\"codazon_shopbybrand_brand_search_box\":\"1\",\"codazon_shopbybrand_all_brand_page\":\"1\",\"codazon_shopbybrand_brand_page\":\"1\",\"codazon_shopbybrand_product_view_page\":\"1\",\"general_store_information\":\"1\",\"general_single_store_mode\":\"1\",\"general_locale\":\"0\",\"general_region\":\"0\",\"sales_general\":\"1\",\"smtp_general\":\"1\",\"smtp_configuration_option\":\"1\",\"smtp_module\":\"1\",\"smtp_developer\":\"1\",\"ot_base_extensions\":\"1\",\"ot_base_feed\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(6,'Reena','vijay','devteam@pichefkes.co.il','devteam','08d94a69a09265f28088e879eab378aaf048ec84810f96d109e923cf43d577f2:EocCC0ogewzaCtPc:2','2020-11-25 05:51:15','2020-12-05 04:19:41','2020-12-05 04:18:37',15,0,1,'{\"configState\":{\"hdfshipsection_general\":\"1\",\"carriers_dotsquares\":\"1\",\"carriers_flatrate\":\"0\",\"carriers_shipper\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_tablerate\":\"0\",\"carriers_instore\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"carriers_matrixrate\":\"1\",\"carriers_flatrateone\":\"0\",\"carriers_flatratetwo\":\"0\",\"carriers_flatratethree\":\"0\",\"carriers_flatratefour\":\"0\",\"carriers_flatratefive\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(7,'shalom','shalom','shalom@starltd.net','shalom','26e369eef4cb90ad3305fe55b93d2bb61b69291f94bdf5d50c7920c34aed4519:e0zOn8j626mQcDb1:2','2020-12-02 06:58:51','2020-12-13 22:20:21','2020-12-13 22:09:08',3,0,1,'{\"configState\":{\"payment_other_paypluslandingpage\":\"1\",\"general_single_store_mode\":\"1\",\"general_store_information\":\"1\",\"general_locale\":\"1\",\"general_region\":\"1\",\"general_country\":\"1\",\"web_url\":\"1\",\"web_seo\":\"1\",\"web_unsecure\":\"1\",\"web_secure\":\"1\",\"web_default\":\"0\",\"web_default_layouts\":\"0\",\"web_cookie\":\"0\",\"web_session\":\"0\",\"web_browser_capabilities\":\"0\",\"admin_dashboard\":\"1\",\"admin_usage\":\"1\",\"admin_security\":\"1\",\"admin_url\":\"1\",\"admin_startup\":\"1\",\"system_mysqlmq\":\"1\",\"system_cron\":\"1\",\"system_smtp\":\"1\",\"system_full_page_cache\":\"1\",\"system_currency\":\"0\",\"system_adminnotification\":\"0\",\"system_backup\":\"0\",\"system_bulk\":\"0\",\"system_media_storage_configuration\":\"0\",\"system_upload_configuration\":\"0\",\"system_media_gallery\":\"0\",\"system_adobe_stock_integration\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL),(8,'m','m','wizeshift@gmail.com','cheli','d83d3ece9adba6244ef1fd090dfad2382a094ce0a9552c09be98a84cdd999178:RNbYKTnhO6jqlyiN:2','2020-12-11 13:56:57','2020-12-12 17:10:16','2020-12-12 17:10:16',10,0,1,'{\"configState\":{\"codazon_shopbybrand_general\":\"1\",\"codazon_shopbybrand_featured_brands\":\"1\",\"codazon_shopbybrand_brand_search_box\":\"1\",\"codazon_shopbybrand_all_brand_page\":\"1\",\"codazon_shopbybrand_brand_page\":\"0\",\"codazon_shopbybrand_product_view_page\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_expiration`
--

DROP TABLE IF EXISTS `admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user_expiration` (
  `user_id` int(10) unsigned NOT NULL COMMENT 'User ID',
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `ADMIN_USER_EXPIRATION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_expiration`
--

LOCK TABLES `admin_user_expiration` WRITE;
/*!40000 ALTER TABLE `admin_user_expiration` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_user_expiration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session ID value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT 1 COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
INSERT INTO `admin_user_session` VALUES (201,'qn7q10rs1qjg2e4tb0ltkbi2ap',4,2,'2020-12-14 17:27:12','2020-12-15 11:02:41','79.183.25.86'),(203,'oljtf1lvu0joda4msqo7tmqvpq',1,2,'2020-12-14 19:35:24','2020-12-15 07:28:44','85.250.238.250'),(204,'la8ms1hgpmcibbd3u5mqg12j0n',2,2,'2020-12-14 19:52:35','2020-12-15 08:49:22','94.159.220.207'),(205,'m306q29011nuvh1bcckhl2opnv',1,2,'2020-12-15 07:28:44','2020-12-15 09:36:17','84.94.36.245'),(206,'gt3laqbota10hic31fsrod0pr1',5,0,'2020-12-15 08:49:07','2020-12-15 08:56:02','79.179.15.154'),(207,'gp273qnhet6cgrkicgceooghs9',2,2,'2020-12-15 08:49:22','2020-12-16 07:44:43','185.184.246.186'),(208,'eq1camqajrbtra2d4fu9kd42gj',5,1,'2020-12-15 08:56:18','2020-12-15 14:47:02','79.179.15.154'),(209,'4g2la9ou9fje4933rbb3ue3mr7',1,2,'2020-12-15 09:36:17','2020-12-16 07:45:05','84.94.36.245'),(210,'32tuicf8n64a8bc22n0h46hlq8',4,2,'2020-12-15 11:02:41','2020-12-16 09:19:11','62.219.16.202'),(211,'t62hcm5n93tgrcq0g8k2674430',2,1,'2020-12-16 07:44:43','2020-12-16 10:21:10','94.159.220.207'),(212,'i32ol6q0hthsp2futlsb1suv65',1,2,'2020-12-16 07:45:05','2020-12-16 09:15:49','84.94.36.245'),(213,'i38q2o6oi4gmigu9hu51e3m6f9',1,1,'2020-12-16 09:15:49','2020-12-16 11:20:46','84.94.36.245'),(214,'t22bfltp8sl0imagtrricr4g14',4,1,'2020-12-16 09:19:11','2020-12-16 09:57:57','62.219.16.202');
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT 0 COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text DEFAULT NULL COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT 0 COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT 0 COMMENT 'Flag if notification might be removed',
  `is_amasty` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Is Amasty Notification',
  `expiration_date` datetime DEFAULT NULL COMMENT 'Expiration Date',
  `image_url` text DEFAULT NULL COMMENT 'Image Url',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES (1,4,'2020-10-25 15:25:28','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0,0,NULL,NULL),(2,4,'2020-10-27 08:57:14','Don`t wait for big sale — save up to 20% right now!','This year we`re breaking the rules of classic sales. We say NO to discounts for the biggest sales days only, and say YES to monthly deals.\nWe`ve compiled this list of offers to make it easier for you to save!','https://u.amasty.com/29k',0,1,1,'2020-11-03 08:57:14','https://amasty.com/static/news/215.svg'),(3,3,'2020-11-02 07:50:45','New version 2.9.7 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                    https://magefan.com/magento2-blog-extension?version=2.9.7\n                                 ','https://magefan.com/magento2-blog-extension?version=2.9.7',0,0,0,NULL,NULL),(4,4,'2020-11-02 07:50:45','FAQ: How to configure &quot;read more&quot; in your Magento 2 blog post',' If you still don&#039;t know how to configure read more functionality in your magento 2 blog post, please read this article.\n                    Online documentation for Magento 2 blog extension is also available on our website. http://goo.gl/XOEdpy ','http://magefan.com/blog/add-read-more-tag-to-blog-post-content/?from=notification1',0,0,0,NULL,NULL),(5,4,'2020-10-29 00:00:00','Happy Halloween - Spooky Discounts','20% off on ALL extensions. Reveal the spooky code NOW! No trick---','https://www.mageplaza.com/deals/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=sale-12',0,0,0,NULL,NULL),(6,4,'2020-11-02 12:45:36','Orot extension has been installed. Remember to flush all cache, recompile, log-out and log back in.','You can see versions of the installed extensions right in the admin, as well as configure notifications about major updates.','https://magento.orot.tech/how-to-install-extension.html',0,0,0,NULL,NULL),(7,4,'2020-11-02 16:19:52','2021 Planning - reach out to us today to get your free site assessment to identify top conversion drivers.  ','Considering moving to Magento Commerce in 2021? Would you like a demo or free site assessment? Our team of experts would love to help. Get started now. https://bit.ly/3lcgILt','https://bit.ly/3lcgILt',0,0,0,NULL,NULL),(8,1,'2020-11-04 14:28:07','Please help prioritize our roadmap - SHORT survey','We are looking to better understand how we can help you manage all of your digital ecommerce from one place. Please help us prioritize our roadmap! Very short survey is here! http://selfserve.decipherinc.com/survey/selfserve/9d5/201000','http://selfserve.decipherinc.com/survey/selfserve/9d5/201000',0,0,0,NULL,NULL),(9,4,'2020-10-30 09:19:18','October updates for your Amasty extensions!','Hello to October updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&amp;utm_medium=message&amp;utm_campaign=updates',0,1,1,'2020-11-10 09:19:18','https://amasty.com/static/news/217.svg'),(10,4,'2020-11-05 06:00:00','Important WeltPixel Product Updates - October 2020 ','Magento 2.4.1 conmpatibility for all WeltPixel Products. As usual, we take your feedback and add it to our products so with each release the product you are using gets better and better. Get your updates from the Downloadable Products section of your weltpixel.com account.','https://support.weltpixel.com/hc/en-us/articles/115002963573-WeltPixel-Product-Updates-Change-Log-and-New-Releases?utm_source=Admin&amp;utm_medium=Notifications&amp;utm_campaign=Release1.10.1',0,0,0,NULL,NULL),(11,4,'2020-11-10 17:55:47','Webinar : Merry Marketing - Best Practices for the Holiday Season and Beyond','As we approach the holiday season and prepare for 2021, we are bringing together best practices from Adobe and a few of our key partners Wagento and Leadous. Join our executives on Thurs, Nov 12th as we have an open discussion on how to leverage digital performance to drive results for the holidays and into the new year. Save your Seat: https://bit.ly/38w0pF9','https://bit.ly/38w0pF9',0,0,0,NULL,NULL),(12,4,'2020-11-06 11:14:14','Amazon Pay for Subscriptions and Recurring Payments is here!','With Subscriptions and Recurring Payments, your store can generate consistent and repeating revenue. Now, we’ve made it easier for Amazon customers to take advantage of your subscription model.','https://u.amasty.com/2ap',0,1,1,'2020-11-13 11:14:14','https://amasty.com/static/news/219.svg'),(13,4,'2020-11-11 10:40:52','Black Friday—all month long! Check our November specials','Every month we bring you special deals on products to improve your Magento site. Check what specials we prepared for you this November.','https://u.amasty.com/2c3',0,1,1,'2020-11-18 10:40:52','https://amasty.com/static/news/220.svg'),(14,4,'2020-11-18 10:44:54','Dropshipping now includes Export Orders extension','We’re excited to share our latest update to Dropshipping. The extension currently offers the flexibility to ship products to your customers directly from a supplier. We’re now expanding its capabilities by including our Export Orders extension (a $200 dollar value).','https://u.amasty.com/2d0',0,1,1,'2020-11-25 10:44:54','https://amasty.com/static/news/223.svg'),(15,4,'2020-11-23 19:59:51','Upgrade to Magento Commerce quickly with Rapid Deployment Packages','Our experienced solution partners offer special design and implementation packages for businesses to upgrade their site quickly and cost effectively. Learn More: https://adobe.ly/3nqaXKx','https://adobe.ly/3nqaXKx',0,0,0,NULL,NULL),(16,1,'2020-11-24 02:21:54','BLACK FRIDAY Sale won’t last forever! 27% OFF any Magento 2 Extension','Be the first to open the Black Friday season and get the best solutions for your store at a fair price NOW! Only this week 27% OFF any Magento 2 Extension. URL: https://magefan.com/magento2-extensions ','https://magefan.com/magento2-extensions?from=ntf-black-friday2020',0,0,0,NULL,NULL),(17,4,'2020-11-23 06:00:00','Psst..BLACK FRIDAY: Pearl Theme Professional Package ONLY NOW at special price!','We only drop prices once a year, take advantage now! Black Friday Limited Deal available Nov 23 - Dec 2.','https://www.weltpixel.com/magento-2-theme-pearl?utm_source=Admin&amp;utm_medium=Notifications&amp;utm_campaign=Black_Friday',0,0,0,NULL,NULL),(18,4,'2020-11-26 00:00:00','BFCM MEGA SALES 2020 - UP TO 25% OFF','Up to 25% off on your order. Black friday starts early. Don&#039;t miss out. Check it out!!!','https://www.mageplaza.com/deals/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=bfcm20',0,0,0,NULL,NULL),(19,4,'2020-11-27 07:04:48','Upgrade to Magento 2 and let us help','As Magento 1 reached its end of life, we wanted to remind you that Amasty can assist you when you`re ready to migrate to Magento 2.','https://u.amasty.com/2jo',0,1,1,'2020-12-04 07:04:48','https://amasty.com/static/news/225.svg'),(20,4,'2020-12-01 22:02:47','[Video] Fuel Your Business Growth with Magento Commerce','Follow along as our friends at Goodacre Farm &amp; Supply transform their business into a cloud-based eCommerce machine with easy content creation, support for multiple web stores, and personalized product recommendations. Watch Now: https://bit.ly/3m8S2mW','https://bit.ly/3m8S2mW',0,0,0,NULL,NULL),(21,4,'2020-11-30 12:19:13','November updates for your Amasty extensions!','Hello to November updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&amp;utm_medium=message&amp;utm_campaign=updates',0,1,1,'2020-12-07 12:19:13','https://amasty.com/static/news/226.svg'),(22,4,'2020-12-07 16:29:27','SURVEY: Business Financing and Support','Please complete if you are responsible for your business finances. We&#039;d like to hear from you about your past and future business financing needs. Strictly confidential.','http://selfserve.decipherinc.com/survey/selfserve/9d5/g30c/201100',1,0,0,NULL,NULL),(23,4,'2020-12-03 07:59:55','Check our best year-end deals! Up to 25% off. Advent calendar. Gifts','Each month we bring you a collection of special offers on products to improve your Magento site. This month, we`ve packed our site chock-full of holiday specials for you. Check out and act quickly on these deals we`re offering through December.','https://u.amasty.com/2l6',0,1,1,'2020-12-10 07:59:55','https://amasty.com/static/news/229.svg'),(24,4,'2020-12-11 00:37:39','Experience the new Interactive Tour to compare Open Source and Magento Commerce.','Create closer consumer connections in the New Year. Explore our interactive product simulation and learn how Magento Commerce delivers everything you need to drive growth in an increasingly competitive online market. https://adobe.ly/3okS1wS','https://adobe.ly/3okS1wS',1,0,0,NULL,NULL),(25,4,'2020-12-09 09:45:36','Improve your Magento performance with our Optimization Service','Your Magento site already offers products that your customers love. Why not give them stable and fast performance while they shop for their holiday gifts this year.','https://u.amasty.com/2mq',1,0,1,'2020-12-16 09:45:36','https://amasty.com/static/news/231.svg');
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int(10) unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int(10) unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int(10) unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_asset`
--

LOCK TABLES `adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_category`
--

LOCK TABLES `adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_stock_creator`
--

LOCK TABLES `adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adobe_user_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text DEFAULT NULL COMMENT 'Access Token',
  `refresh_token` text DEFAULT NULL COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  KEY `ADOBE_USER_PROFILE_ID` (`id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adobe_user_profile`
--

LOCK TABLES `adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_attribute`
--

DROP TABLE IF EXISTS `amasty_acart_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_attribute` (
  `attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Id',
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule Id',
  `code` varchar(255) NOT NULL COMMENT 'Email',
  PRIMARY KEY (`attr_id`),
  KEY `AMASTY_ACART_ATTRIBUTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  CONSTRAINT `AMASTY_ACART_ATTRIBUTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Amasty Acart Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_attribute`
--

LOCK TABLES `amasty_acart_attribute` WRITE;
/*!40000 ALTER TABLE `amasty_acart_attribute` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_blacklist`
--

DROP TABLE IF EXISTS `amasty_acart_blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_blacklist` (
  `blacklist_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Blacklist Id',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  PRIMARY KEY (`blacklist_id`),
  UNIQUE KEY `AMASTY_ACART_BLACKLIST_CUSTOMER_EMAIL` (`customer_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_acart_blacklist';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_blacklist`
--

LOCK TABLES `amasty_acart_blacklist` WRITE;
/*!40000 ALTER TABLE `amasty_acart_blacklist` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_blacklist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_history`
--

DROP TABLE IF EXISTS `amasty_acart_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_history` (
  `history_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'History Id',
  `rule_quote_id` int(10) unsigned DEFAULT NULL COMMENT 'Rule Quote ID',
  `schedule_id` int(10) unsigned DEFAULT NULL COMMENT 'Schedule ID',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `public_key` varchar(32) DEFAULT NULL COMMENT 'Public Key',
  `email_subject` varchar(255) DEFAULT NULL COMMENT 'Email Subject',
  `email_body` mediumtext DEFAULT NULL COMMENT 'Email Body',
  `sales_rule_id` int(10) unsigned DEFAULT NULL COMMENT 'Sales Rule ID',
  `sales_rule_coupon_id` int(10) unsigned DEFAULT NULL COMMENT 'Sales Rule Coupon ID',
  `sales_rule_coupon` varchar(255) DEFAULT NULL COMMENT 'Sales Rule Coupon',
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'Dcheduled Date',
  `executed_at` timestamp NULL DEFAULT NULL COMMENT 'Executed Date',
  `finished_at` timestamp NULL DEFAULT NULL COMMENT 'Finished Date',
  `sales_rule_coupon_expiration_date` timestamp NULL DEFAULT NULL COMMENT 'Expiration Date',
  PRIMARY KEY (`history_id`),
  KEY `AMASTY_ACART_HISTORY_STATUS` (`status`),
  KEY `FK_819FFF7D7B22D8B71DEF484849FC07B4` (`rule_quote_id`),
  KEY `AMASTY_ACART_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` (`sales_rule_id`),
  KEY `FK_7A03CD2AE836B6F728B65DF1B24EDE36` (`sales_rule_coupon_id`),
  KEY `FK_A2FF7CCCBC2589647A3585E511AE08D7` (`schedule_id`),
  CONSTRAINT `AMASTY_ACART_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`sales_rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_7A03CD2AE836B6F728B65DF1B24EDE36` FOREIGN KEY (`sales_rule_coupon_id`) REFERENCES `salesrule_coupon` (`coupon_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_819FFF7D7B22D8B71DEF484849FC07B4` FOREIGN KEY (`rule_quote_id`) REFERENCES `amasty_acart_rule_quote` (`rule_quote_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A2FF7CCCBC2589647A3585E511AE08D7` FOREIGN KEY (`schedule_id`) REFERENCES `amasty_acart_schedule` (`schedule_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_acart_history';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_history`
--

LOCK TABLES `amasty_acart_history` WRITE;
/*!40000 ALTER TABLE `amasty_acart_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_quote_email`
--

DROP TABLE IF EXISTS `amasty_acart_quote_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_quote_email` (
  `quote_email_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Quote Email Id',
  `quote_id` int(10) unsigned NOT NULL COMMENT 'Quote ID',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  PRIMARY KEY (`quote_email_id`),
  UNIQUE KEY `AMASTY_ACART_QUOTE_EMAIL_QUOTE_ID` (`quote_id`),
  CONSTRAINT `AMASTY_ACART_QUOTE_EMAIL_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8 COMMENT='amasty_acart_quote_email';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_quote_email`
--

LOCK TABLES `amasty_acart_quote_email` WRITE;
/*!40000 ALTER TABLE `amasty_acart_quote_email` DISABLE KEYS */;
INSERT INTO `amasty_acart_quote_email` VALUES (7,16,'moutzak@gmail.com'),(8,18,'l.keinan@012.net.il'),(9,17,'eran.freelace@gmail.com'),(10,19,'wizeshift@gmail.com'),(11,20,'test@gmail.com'),(12,24,'moutzak@gmail.com'),(13,25,'zoola21@gmail.com'),(14,26,'eran.freelance@gmail.com'),(15,32,'zoola21@gmail.com'),(16,33,'moutzak@gmail.com'),(17,34,'moutzak@gmail.com'),(18,37,'moutzak@gmail.com'),(19,40,'zoola21@gmail.com'),(20,41,'moutzak@gmail.com'),(21,42,'ebhive@gmail.com'),(22,44,'zoola21@gmail.com'),(23,48,'ttttt@gmail.com'),(25,57,'zuvzuv30@gmail.com'),(26,59,'moutzak@gmail.com'),(27,60,'ebhive@gmail.com'),(28,61,'eran.freelance@gmail.com'),(30,67,'eran1820@gmail.com'),(31,68,'test@gmail.com'),(32,73,'moutzak@gmail.com'),(33,74,'ir@gmail.com'),(35,87,'wizeshift@gmail.com'),(36,88,'indahashisrael@gmail.com'),(37,89,'moutzak@gmail.com'),(38,93,'mahi@yopmail.com'),(39,98,'indahashisrael@gmail.com'),(40,103,'mahi@yopmail.com'),(41,109,'testse@gmail.com'),(42,111,'test@gmail.com'),(43,113,'mahi@yopmail.com'),(45,117,'wizeshift@gmail.com'),(46,118,'wizeshift@gmail.com'),(47,119,'ebhive@gmail.com'),(48,123,'test@gmail.com'),(49,126,'test@gmail.com'),(50,130,'test@gmail.com'),(51,142,'moutzak@gmail.com'),(52,143,'moutzak@gmail.com'),(53,144,'moutzak@gmail.com'),(55,146,'moutzak@gmail.com'),(56,147,'test@gmail.com'),(57,148,'wizeshift@gmail.com'),(58,149,'eran1820@gmail.com'),(59,156,'keinan@sbcglobal.net'),(60,155,'mahi@yopmail.com'),(61,158,'moutzak@gmail.com'),(62,159,'moutzak@gmail.com'),(66,168,'mahi@yopmail.com'),(67,174,'testing@gmail.com'),(68,175,'testing@gmail.com'),(69,176,'testing@gmail.com'),(70,178,'wizeshift@gmail.com'),(71,179,'wizeshift@gmail.com'),(72,181,'indahashisrael@gmail.com'),(74,188,'moutzak@gmail.com'),(75,190,'indahashisrael@gmail.com'),(77,193,'nomail@gmail.com'),(81,211,'moutzak@gmail.com'),(82,212,'wizeshift@gmail.com'),(83,213,'wizeshift@gmail.com'),(84,214,'moutzak@gmail.com'),(85,215,'test@gmail.com'),(90,220,'moutzak@gmail.com'),(94,228,'moutzak@gmail.com'),(95,229,'eran.freelance@gmail.com'),(97,238,'moutzak@gmail.com'),(98,239,'tr@td.com'),(99,240,'test@gmail.com'),(100,242,'shalom@starltd.net'),(101,243,'eran.freelance@gmail.com'),(102,246,'moutzak@gmail.com'),(103,252,'saga1974@walla.com'),(104,256,'yaniv_996@walla.co'),(105,257,'Ziva8989@gmail.com'),(106,260,'esteronid@gmail.com'),(107,263,'Sharonbn26@gmail.com'),(108,265,'wizeshift@gmail.com'),(109,269,'aviganitshak@gmail.com'),(110,267,'dana.shakked@gmail.com'),(111,271,'oferdgani@gmail.com'),(112,273,'edna1969s@gmail.com'),(113,274,'porisdr@netvision.net.il'),(114,275,'toledanomart@gmail.com'),(115,278,'wizeshift@gmail.com'),(116,279,'liel357159@gmail.com'),(117,281,'wizeshift@gmail.com'),(118,283,'mottigl@gmail.com'),(119,285,'mari14157@gmail.com'),(120,288,'iritiber@gmail.com'),(121,290,'meirnid@gmail.com'),(122,289,'dikla2403@gmail.com'),(123,296,'barbi1411@gmail.com'),(124,298,'ayelety8@gmail.com'),(125,297,'nissinmaimon@gmail.com'),(126,299,'kholod.201498@gmail.com'),(127,300,'danagoldi@gmail.com'),(128,301,'naorshauli@gmail.com'),(129,303,'keren.tadela1@gmail.com'),(130,305,'eran.freelane@gmail.com'),(131,308,'adiron3000@gmail.com'),(132,309,'moutzak@gmail.com'),(133,310,'aviya2209@gmail.com'),(134,311,'Sapirhaya@gmail.com'),(135,312,'aharon105@walla.co.il'),(136,313,'ellaza@gmail.com'),(137,315,'alonskornik3@walla.com'),(138,316,'moutzak@gmail.com'),(139,320,'shlombh@gmail.com'),(140,323,'pelenaga@gmail.com'),(141,325,'andrewain@yahoo.com'),(142,328,'ariek@pcb.co.il'),(143,330,'shirahayat7@gmail.com'),(144,332,'kprokip1@gmail.com'),(145,333,'hamutal1962@gmail.com'),(146,334,'makras8080@gmail.com'),(147,338,'ebhive@gmail.com'),(148,340,'pinozem0848@gmail.com'),(149,341,'pinhasnoa5@gmail.com'),(150,342,'talazouri@gmail.com'),(151,345,'shelly6756@gmail.com'),(152,349,'izcafe1@gmaim.com'),(153,354,'ellaza@gmail.com'),(154,361,'hen-hazan@hotmail.com'),(155,366,'hasida2310@gmail.com'),(156,368,'pelenaga@gmail.com'),(157,373,'shirelf13@gmail.com'),(158,376,'Aviel08090@gmail.com'),(159,374,'reutadar@gmsil.com'),(160,380,'ohanat13@gmail.com'),(161,385,'ashermail2@gmail.com'),(162,386,'viktoriad@gmx.net'),(163,387,'ruthribak@gmail.com'),(164,391,'hen654654@gmail.com'),(165,396,'adir25534@gmail.com'),(166,397,'liatbu00@walla.com'),(167,398,'levifink1@gmail.com'),(168,399,'yael.ben-haim@weizmann.ac.il'),(169,400,'lena@hassadna.com'),(170,401,'zvika.maoz@gmail.com'),(171,402,'jessy5864@gmail.com'),(172,407,'adi.orji@gmail.com'),(173,408,'yaelkatzeff@gmail.com'),(174,413,'Ahlam_abas@walla.com');
/*!40000 ALTER TABLE `amasty_acart_quote_email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_rule`
--

DROP TABLE IF EXISTS `amasty_acart_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `is_active` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Is Active',
  `priority` smallint(6) NOT NULL DEFAULT 1 COMMENT 'Priority',
  `conditions_serialized` mediumtext DEFAULT NULL COMMENT 'Conditions Serialized',
  `store_ids` varchar(255) NOT NULL DEFAULT '' COMMENT 'Stores',
  `customer_group_ids` varchar(255) NOT NULL DEFAULT '' COMMENT 'Customer Groups',
  `cancel_condition` varchar(255) NOT NULL DEFAULT '' COMMENT 'Cancel Condition',
  `utm_source` varchar(255) DEFAULT NULL COMMENT 'Utm Source',
  `utm_medium` varchar(255) DEFAULT NULL COMMENT 'Utm Medium',
  `utm_term` varchar(255) DEFAULT NULL COMMENT 'Utm Term',
  `utm_content` varchar(255) DEFAULT NULL COMMENT 'Utm Content',
  `utm_campaign` varchar(255) DEFAULT NULL COMMENT 'Utm Campaign',
  PRIMARY KEY (`rule_id`),
  FULLTEXT KEY `FTI_20E92A70B7022B6D3721BA343A07BC85` (`name`,`utm_source`,`utm_medium`,`utm_term`,`utm_content`,`utm_campaign`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Amasty Acart Rule Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_rule`
--

LOCK TABLES `amasty_acart_rule` WRITE;
/*!40000 ALTER TABLE `amasty_acart_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_rule_quote`
--

DROP TABLE IF EXISTS `amasty_acart_rule_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_rule_quote` (
  `rule_quote_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Quote Id',
  `quote_id` int(10) unsigned DEFAULT NULL COMMENT 'Quote ID',
  `rule_id` int(10) unsigned DEFAULT NULL COMMENT 'Rule ID',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `store_id` smallint(5) unsigned DEFAULT 0 COMMENT 'Store Id',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer Id',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  `customer_firstname` varchar(255) DEFAULT NULL COMMENT 'Customer Firstname',
  `customer_lastname` varchar(255) DEFAULT NULL COMMENT 'Customer Lastname',
  `test_mode` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Test Mode',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Date',
  `abandoned_status` varchar(25) NOT NULL DEFAULT 'notrestored' COMMENT 'Abandoned Cart Status',
  PRIMARY KEY (`rule_quote_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_STATUS` (`status`),
  KEY `AMASTY_ACART_RULE_QUOTE_CUSTOMER_EMAIL` (`customer_email`),
  KEY `AMASTY_ACART_RULE_QUOTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_acart_rule_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_rule_quote`
--

LOCK TABLES `amasty_acart_rule_quote` WRITE;
/*!40000 ALTER TABLE `amasty_acart_rule_quote` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_rule_quote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_acart_schedule`
--

DROP TABLE IF EXISTS `amasty_acart_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_acart_schedule` (
  `schedule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Schedule Id',
  `rule_id` int(10) unsigned NOT NULL COMMENT 'Rule ID',
  `template_id` int(10) unsigned NOT NULL COMMENT 'Template ID',
  `days` smallint(5) unsigned DEFAULT NULL COMMENT 'Days',
  `hours` smallint(5) unsigned DEFAULT NULL COMMENT 'Hours',
  `minutes` smallint(5) unsigned DEFAULT NULL COMMENT 'Minutes',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT 0.0000 COMMENT 'Discount Amount',
  `expired_in_days` smallint(5) unsigned DEFAULT NULL COMMENT 'Expired In Days',
  `discount_qty` decimal(12,4) DEFAULT NULL COMMENT 'Discount Qty',
  `discount_step` int(10) unsigned NOT NULL COMMENT 'Discount Step',
  `subtotal_is_greater_than` smallint(5) unsigned DEFAULT NULL COMMENT 'Subtotal Is Greater Than',
  `use_shopping_cart_rule` tinyint(1) NOT NULL COMMENT 'Use Shopping Cart Rule',
  `sales_rule_id` int(10) unsigned DEFAULT NULL COMMENT 'Sales Rule ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Date',
  `send_same_coupon` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Send Same Coupon',
  PRIMARY KEY (`schedule_id`),
  KEY `AMASTY_ACART_SCHEDULE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `AMASTY_ACART_SCHEDULE_TEMPLATE_ID_EMAIL_TEMPLATE_TEMPLATE_ID` (`template_id`),
  KEY `AMASTY_ACART_SCHEDULE_SALES_RULE_ID_SALESRULE_RULE_ID` (`sales_rule_id`),
  CONSTRAINT `AMASTY_ACART_SCHEDULE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_ACART_SCHEDULE_SALES_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`sales_rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_SCHEDULE_TEMPLATE_ID_EMAIL_TEMPLATE_TEMPLATE_ID` FOREIGN KEY (`template_id`) REFERENCES `email_template` (`template_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_acart_schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_acart_schedule`
--

LOCK TABLES `amasty_acart_schedule` WRITE;
/*!40000 ALTER TABLE `amasty_acart_schedule` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_acart_schedule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_account`
--

DROP TABLE IF EXISTS `amasty_affiliate_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_account` (
  `account_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Account_id',
  `customer_id` int(10) unsigned NOT NULL COMMENT 'Customer_id',
  `is_affiliate_active` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Is_affiliate_active',
  `accepted_terms_conditions` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Accepted_terms_conditions',
  `receive_notifications` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Receive_notifications',
  `paypal_email` varchar(255) DEFAULT NULL COMMENT 'Paypal_email',
  `referring_code` varchar(255) DEFAULT NULL COMMENT 'Referring_code',
  `referring_website` varchar(255) DEFAULT NULL COMMENT 'Referring_website',
  `balance` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `on_hold` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `commission_paid` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `lifetime_commission` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `widget_width` int(10) unsigned NOT NULL DEFAULT 350 COMMENT 'Widget_width',
  `widget_height` int(10) unsigned NOT NULL DEFAULT 350 COMMENT 'Widget_height',
  `widget_title` varchar(255) DEFAULT 'Bestsellers' COMMENT 'Widget_title',
  `widget_products_num` int(10) unsigned DEFAULT 6 COMMENT 'Widget_products_num',
  `widget_type` varchar(255) NOT NULL DEFAULT 'new' COMMENT 'Widget_type',
  `widget_show_name` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Widget_show_name',
  `widget_show_price` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Widget_show_price',
  PRIMARY KEY (`account_id`),
  KEY `AMASTY_AFFILIATE_ACCOUNT_ACCOUNT_ID` (`account_id`),
  KEY `AMASTY_AFFILIATE_ACCOUNT_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` (`customer_id`),
  CONSTRAINT `AMASTY_AFFILIATE_ACCOUNT_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_account';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_account`
--

LOCK TABLES `amasty_affiliate_account` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_account` DISABLE KEYS */;
INSERT INTO `amasty_affiliate_account` VALUES (1,6268,1,1,1,'','fhGInbZCkV','',0.00,0.00,0.00,0.00,350,350,'Bestsellers',6,'new',1,1);
/*!40000 ALTER TABLE `amasty_affiliate_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_banner`
--

DROP TABLE IF EXISTS `amasty_affiliate_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_banner` (
  `banner_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Banner_id',
  `title` text DEFAULT NULL COMMENT 'Title',
  `type` varchar(255) NOT NULL COMMENT 'Type',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `text` text DEFAULT NULL COMMENT 'Text',
  `link` varchar(255) DEFAULT NULL COMMENT 'Link',
  `rel_no_follow` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Rel_no_follow',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Status',
  PRIMARY KEY (`banner_id`),
  KEY `AMASTY_AFFILIATE_BANNER_BANNER_ID` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_banner';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_banner`
--

LOCK TABLES `amasty_affiliate_banner` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_banner` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_banner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_coupon`
--

DROP TABLE IF EXISTS `amasty_affiliate_coupon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_coupon` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `account_id` int(10) unsigned NOT NULL COMMENT 'Account_id',
  `program_id` int(10) unsigned NOT NULL COMMENT 'Program_id',
  `coupon_id` int(10) unsigned NOT NULL COMMENT 'Coupon_id',
  `current_profit` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `is_system` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Coupon is system',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_AFFILIATE_COUPON_ACCOUNT_ID` (`entity_id`),
  KEY `FK_6FEF863BBC7D0066999A3F5E0CC92039` (`account_id`),
  KEY `FK_5ADB7D70F4F4B46C96E39C8C486CDD3B` (`program_id`),
  CONSTRAINT `FK_5ADB7D70F4F4B46C96E39C8C486CDD3B` FOREIGN KEY (`program_id`) REFERENCES `amasty_affiliate_program` (`program_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_6FEF863BBC7D0066999A3F5E0CC92039` FOREIGN KEY (`account_id`) REFERENCES `amasty_affiliate_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_coupon';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_coupon`
--

LOCK TABLES `amasty_affiliate_coupon` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_coupon` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_coupon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_lifetime`
--

DROP TABLE IF EXISTS `amasty_affiliate_lifetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_lifetime` (
  `lifetime_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Lifetime_id',
  `affiliate_account_id` int(10) unsigned DEFAULT NULL COMMENT 'Affiliate_account_id',
  `program_id` int(10) unsigned NOT NULL COMMENT 'Program_id',
  `customer_email` varchar(255) NOT NULL COMMENT 'Customer_email',
  PRIMARY KEY (`lifetime_id`),
  KEY `AMASTY_AFFILIATE_LIFETIME_LIFETIME_ID` (`lifetime_id`),
  KEY `FK_C49AF50EFC642B292317CFA0E848F967` (`affiliate_account_id`),
  KEY `FK_59F98076397B2114899B6212EF53E5AD` (`program_id`),
  CONSTRAINT `FK_59F98076397B2114899B6212EF53E5AD` FOREIGN KEY (`program_id`) REFERENCES `amasty_affiliate_program` (`program_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C49AF50EFC642B292317CFA0E848F967` FOREIGN KEY (`affiliate_account_id`) REFERENCES `amasty_affiliate_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_lifetime';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_lifetime`
--

LOCK TABLES `amasty_affiliate_lifetime` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_lifetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_lifetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_links`
--

DROP TABLE IF EXISTS `amasty_affiliate_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link_id',
  `affiliate_account_id` int(10) unsigned NOT NULL COMMENT 'Affiliate_account_id',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Created_at',
  `link_type` varchar(255) DEFAULT NULL COMMENT 'Link_type',
  `element_id` int(10) unsigned DEFAULT NULL COMMENT 'Element_id',
  PRIMARY KEY (`link_id`),
  KEY `AMASTY_AFFILIATE_LINKS_LINK_ID` (`link_id`),
  KEY `FK_C286D118B486401FC3D5C2A784E79DEC` (`affiliate_account_id`),
  CONSTRAINT `FK_C286D118B486401FC3D5C2A784E79DEC` FOREIGN KEY (`affiliate_account_id`) REFERENCES `amasty_affiliate_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_links';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_links`
--

LOCK TABLES `amasty_affiliate_links` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_program`
--

DROP TABLE IF EXISTS `amasty_affiliate_program`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_program` (
  `program_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Program_id',
  `rule_id` int(10) unsigned DEFAULT NULL COMMENT 'Rule_id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `withdrawal_type` varchar(255) NOT NULL COMMENT 'Withdrawal_type',
  `is_active` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Is_active',
  `commission_value` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `commission_per_profit_amount` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `commission_value_type` varchar(255) DEFAULT NULL COMMENT 'Commission_value_type',
  `from_second_order` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'From_second_order',
  `commission_type_second` varchar(255) DEFAULT NULL COMMENT 'Commission_type_second',
  `commission_value_second` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `is_lifetime` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Is_lifetime',
  `frequency` varchar(255) DEFAULT NULL COMMENT 'Frequency',
  `total_sales` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `available_customers` text DEFAULT NULL COMMENT 'Available Customers Ids',
  `available_groups` text DEFAULT NULL COMMENT 'Available users groups',
  PRIMARY KEY (`program_id`),
  KEY `AMASTY_AFFILIATE_PROGRAM_PROGRAM_ID` (`program_id`),
  KEY `AMASTY_AFFILIATE_PROGRAM_RULE_ID_SALESRULE_RULE_ID` (`rule_id`),
  CONSTRAINT `AMASTY_AFFILIATE_PROGRAM_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_program';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_program`
--

LOCK TABLES `amasty_affiliate_program` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_program` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_program` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_affiliate_transaction`
--

DROP TABLE IF EXISTS `amasty_affiliate_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_affiliate_transaction` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Transaction_id',
  `affiliate_account_id` int(10) unsigned NOT NULL COMMENT 'Affiliate_account_id',
  `program_id` int(10) unsigned NOT NULL COMMENT 'Program_id',
  `order_increment_id` varchar(32) DEFAULT NULL COMMENT 'Order_increment_id',
  `profit` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `balance` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `commission` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `discount` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Updated_at',
  `type` varchar(255) NOT NULL COMMENT 'Type',
  `status` varchar(255) NOT NULL COMMENT 'Status',
  PRIMARY KEY (`transaction_id`),
  KEY `AMASTY_AFFILIATE_TRANSACTION_TRANSACTION_ID` (`transaction_id`),
  KEY `FK_DB443F26218B8E96BBA081A8A362BAA1` (`affiliate_account_id`),
  CONSTRAINT `FK_DB443F26218B8E96BBA081A8A362BAA1` FOREIGN KEY (`affiliate_account_id`) REFERENCES `amasty_affiliate_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_affiliate_transaction';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_affiliate_transaction`
--

LOCK TABLES `amasty_affiliate_transaction` WRITE;
/*!40000 ALTER TABLE `amasty_affiliate_transaction` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_affiliate_transaction` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_category`
--

DROP TABLE IF EXISTS `amasty_feed_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_category` (
  `feed_category_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Feed Category Id',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `use_taxonomy` smallint(6) NOT NULL COMMENT 'Flag to use taxonomy',
  `taxonomy_source` varchar(25) NOT NULL COMMENT 'Source for taxonomy ',
  PRIMARY KEY (`feed_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_feed_category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_category`
--

LOCK TABLES `amasty_feed_category` WRITE;
/*!40000 ALTER TABLE `amasty_feed_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_feed_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_category_mapping`
--

DROP TABLE IF EXISTS `amasty_feed_category_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_category_mapping` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `feed_category_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Feed Category ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Category ID',
  `variable` varchar(255) DEFAULT NULL COMMENT 'Variable',
  `skip` tinyint(1) NOT NULL COMMENT 'Skip this category in feed',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_FEED_CATEGORY_FEED_CATEGORY_ID` (`feed_category_id`),
  KEY `CATALOG_CATEGORY_ENTITY_CATEGORY_ID` (`category_id`),
  CONSTRAINT `AMASTY_FEED_CTGR_FEED_CTGR_ID_FEED_CTGR_FEED_CTGR_ID` FOREIGN KEY (`feed_category_id`) REFERENCES `amasty_feed_category` (`feed_category_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_feed_category_mapping';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_category_mapping`
--

LOCK TABLES `amasty_feed_category_mapping` WRITE;
/*!40000 ALTER TABLE `amasty_feed_category_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_feed_category_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_entity`
--

DROP TABLE IF EXISTS `amasty_feed_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `filename` varchar(255) DEFAULT NULL COMMENT 'File Name',
  `feed_type` varchar(255) DEFAULT NULL COMMENT 'Feed Type',
  `is_active` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Is Active',
  `store_id` smallint(5) unsigned DEFAULT 0 COMMENT 'Store ID',
  `execute_mode` varchar(255) NOT NULL DEFAULT 'manual' COMMENT 'Execute Mode',
  `csv_column_name` smallint(6) NOT NULL DEFAULT 1 COMMENT 'Csv Column Name',
  `csv_header` text DEFAULT NULL COMMENT 'Csv Header',
  `csv_enclosure` varchar(255) DEFAULT NULL COMMENT 'Csv Enclosure',
  `csv_delimiter` varchar(255) DEFAULT NULL COMMENT 'Csv Delimiter',
  `format_price_currency` varchar(255) DEFAULT NULL COMMENT 'Format Price Currency',
  `csv_field` mediumtext DEFAULT NULL COMMENT 'Csv Field',
  `xml_header` mediumtext DEFAULT NULL COMMENT 'Xml Header',
  `xml_item` varchar(255) DEFAULT NULL COMMENT 'Xml Item',
  `xml_content` mediumtext DEFAULT NULL COMMENT 'Xml Content',
  `xml_footer` mediumtext DEFAULT NULL COMMENT 'Xml Footer',
  `format_price_currency_show` smallint(6) NOT NULL DEFAULT 1 COMMENT 'Format Price Currency Show',
  `format_price_decimals` varchar(255) NOT NULL DEFAULT 'two' COMMENT 'Format Price Decimals',
  `format_price_decimal_point` varchar(255) NOT NULL DEFAULT 'dot' COMMENT 'Format Price Decimal Point',
  `format_price_thousands_separator` varchar(255) NOT NULL DEFAULT 'comma' COMMENT 'Format Price Thousands Separator',
  `format_date` varchar(255) DEFAULT NULL COMMENT 'Format Date',
  `conditions_serialized` mediumtext DEFAULT NULL COMMENT 'Conditions Serialized',
  `generated_at` timestamp NULL DEFAULT NULL COMMENT 'Generated At',
  `delivery_enabled` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Delivery Enabled',
  `delivery_host` varchar(255) DEFAULT NULL COMMENT 'Delivery Host',
  `delivery_type` varchar(255) DEFAULT NULL COMMENT 'Delivery Type',
  `delivery_user` varchar(255) DEFAULT NULL COMMENT 'Delivery User',
  `delivery_password` varchar(255) DEFAULT NULL COMMENT 'Delivery Password',
  `delivery_path` varchar(255) DEFAULT NULL COMMENT 'Delivery Path',
  `delivery_passive_mode` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Delivery Passive Mode',
  `utm_source` varchar(255) DEFAULT NULL COMMENT 'Utm Source',
  `utm_medium` varchar(255) DEFAULT NULL COMMENT 'Utm Medium',
  `utm_term` varchar(255) DEFAULT NULL COMMENT 'Utm Term',
  `utm_content` varchar(255) DEFAULT NULL COMMENT 'Utm Content',
  `utm_campaign` varchar(255) DEFAULT NULL COMMENT 'Utm Campaign',
  `is_template` smallint(6) NOT NULL DEFAULT 0 COMMENT 'Is Template',
  `compress` varchar(255) NOT NULL DEFAULT '' COMMENT 'Compress',
  `exclude_disabled` tinyint(1) NOT NULL COMMENT 'Exclude Disabled Products',
  `exclude_out_of_stock` tinyint(1) NOT NULL COMMENT 'Exclude Out of Stock Products',
  `exclude_not_visible` tinyint(1) NOT NULL COMMENT 'Exclude Not Visible Products',
  `products_amount` int(11) NOT NULL COMMENT 'Number of products',
  `generation_type` varchar(255) NOT NULL COMMENT 'Used generation type',
  `status` smallint(6) NOT NULL COMMENT 'Last feed generation status',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_FEED_ENTITY_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='amasty_feed_entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_entity`
--

LOCK TABLES `amasty_feed_entity` WRITE;
/*!40000 ALTER TABLE `amasty_feed_entity` DISABLE KEYS */;
INSERT INTO `amasty_feed_entity` VALUES (3,'Shopping','Shopping','csv',1,0,'manual',1,NULL,'double_quote','comma','USD','a:11:{i:0;a:5:{s:6:\"header\";s:3:\"mpn\";s:9:\"attribute\";s:9:\"basic|sku\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:1;a:5:{s:6:\"header\";s:12:\"manufacturer\";s:9:\"attribute\";s:20:\"product|manufacturer\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:2;a:6:{s:6:\"header\";s:12:\"product name\";s:9:\"attribute\";s:12:\"product|name\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";s:6:\"modify\";a:1:{i:0;a:3:{s:6:\"modify\";s:10:\"strip_tags\";s:4:\"arg0\";s:0:\"\";s:4:\"arg1\";s:0:\"\";}}}i:3;a:6:{s:6:\"header\";s:21:\"product  description \";s:9:\"attribute\";s:19:\"product|description\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";s:6:\"modify\";a:1:{i:1;a:3:{s:6:\"modify\";s:10:\"strip_tags\";s:4:\"arg0\";s:0:\"\";s:4:\"arg1\";s:0:\"\";}}}i:4;a:5:{s:6:\"header\";s:5:\"price\";s:9:\"attribute\";s:13:\"product|price\";s:6:\"format\";s:5:\"price\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:5;a:6:{s:6:\"header\";s:5:\"stock\";s:9:\"attribute\";s:21:\"inventory|is_in_stock\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";s:6:\"modify\";a:2:{i:2;a:3:{s:6:\"modify\";s:7:\"replace\";s:4:\"arg0\";s:1:\"1\";s:4:\"arg1\";s:3:\"Yes\";}i:3;a:3:{s:6:\"modify\";s:7:\"replace\";s:4:\"arg0\";s:1:\"0\";s:4:\"arg1\";s:2:\"No\";}}}i:6;a:3:{s:6:\"header\";s:17:\"stock description\";s:11:\"static_text\";s:3:\"New\";s:6:\"delete\";s:0:\"\";}i:7;a:5:{s:6:\"header\";s:11:\"product url\";s:9:\"attribute\";s:9:\"url|short\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:8;a:5:{s:6:\"header\";s:9:\"image url\";s:9:\"attribute\";s:15:\"image|thumbnail\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:9;a:5:{s:6:\"header\";s:8:\"category\";s:9:\"attribute\";s:17:\"category|category\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:11;a:3:{s:6:\"header\";s:13:\"shipping rate\";s:11:\"static_text\";s:0:\"\";s:6:\"delete\";s:0:\"\";}}',NULL,NULL,NULL,NULL,1,'two','dot','comma','Y-m-d','{\"type\":\"Magento\\\\CatalogRule\\\\Model\\\\Rule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(4,'Bing','Bing','txt',1,0,'manual',1,NULL,'double_quote','tab','USD','a:7:{i:0;a:5:{s:6:\"header\";s:4:\"MPID\";s:9:\"attribute\";s:9:\"basic|sku\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:1;a:6:{s:6:\"header\";s:5:\"Title\";s:9:\"attribute\";s:12:\"product|name\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";s:6:\"modify\";a:1:{i:0;a:3:{s:6:\"modify\";s:10:\"strip_tags\";s:4:\"arg0\";s:0:\"\";s:4:\"arg1\";s:0:\"\";}}}i:2;a:6:{s:6:\"header\";s:11:\"Description\";s:9:\"attribute\";s:19:\"product|description\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";s:6:\"modify\";a:1:{i:1;a:3:{s:6:\"modify\";s:10:\"strip_tags\";s:4:\"arg0\";s:0:\"\";s:4:\"arg1\";s:0:\"\";}}}i:3;a:5:{s:6:\"header\";s:5:\"Price\";s:9:\"attribute\";s:17:\"price|final_price\";s:6:\"format\";s:5:\"price\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:4;a:5:{s:6:\"header\";s:10:\"ProductURL\";s:9:\"attribute\";s:9:\"url|short\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:5;a:5:{s:6:\"header\";s:3:\"SKU\";s:9:\"attribute\";s:9:\"basic|sku\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}i:6;a:5:{s:6:\"header\";s:5:\"Brand\";s:9:\"attribute\";s:20:\"product|manufacturer\";s:6:\"format\";s:5:\"as_is\";s:6:\"parent\";s:2:\"no\";s:6:\"delete\";s:0:\"\";}}',NULL,NULL,NULL,NULL,1,'two','dot','comma','Y-m-d','{\"type\":\"Magento\\\\CatalogRule\\\\Model\\\\Rule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(7,'Google','Google','xml',1,0,'manual',1,NULL,NULL,NULL,'USD',NULL,'<?xml version=\"1.0\"?> <rss version=\"2.0\" xmlns:g=\"http://base.google.com/ns/1.0\"> <channel>  <created_at>{{DATE}}</created_at>','item','<g:id>{attribute=\"basic|sku\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</g:id>\n<title>{attribute=\"product|name\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</title>\n<description>{attribute=\"product|description\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape|length:500\"}</description>\n<g:product_type>{attribute=\"basic|product_type\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</g:product_type>\n<link>{attribute=\"url|short\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</link>\n<g:image_link>{attribute=\"image|thumbnail\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</g:image_link>\n<g:condition>New</g:condition>\n<g:availability>{attribute=\"inventory|is_in_stock\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"replace:1^In Stock|replace:0^Out of Stock\"}</g:availability>\n<g:price>{attribute=\"price|final_price\" format=\"price\" parent=\"no\" optional=\"yes\" modify=\"\"}</g:price>\n<g:brand>{attribute=\"product|manufacturer\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</g:brand>\n<g:google_product_category>GOOGLE CATEGORIES (https://support.google.com/merchants/answer/160081)</g:google_product_category>\n<g:tax>\n <g:country>US</g:country>\n <g:rate>0</g:rate>\n <g:tax_ship>n</g:tax_ship>\n</g:tax>\n<g:shipping>\n <g:country>US</g:country>\n <g:price>0 USD</g:price>\n</g:shipping>\n<g:identifier_exists>FALSE</g:identifier_exists>','</channel> </rss>',1,'two','dot','comma','Y-m-d','a:6:{s:4:\"type\";s:48:\"Magento\\CatalogRule\\Model\\Rule\\Condition\\Combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(8,'Amazon Product','AmazonProducts','xml',1,0,'manual',1,NULL,NULL,NULL,'USD',NULL,'<?xml version=\"1.0\" encoding=\"utf-8\" ?><AmazonEnvelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"amzn-envelope.xsd\"><Header><DocumentVersion>1.01</DocumentVersion><MerchantIdentifier>YOUR_MERCHANT_IDENTIFIER</MerchantIdentifier></Header><MessageType>Product</MessageType>','Message','\n<MessageID>{attribute=\"product|product_id\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</MessageID>\n<OperationType>Update</OperationType>\n<Product>\n    <SKU>{attribute=\"basic|sku\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</SKU>\n    <StandardProductID>Standard_Product_ID</StandardProductID>\n    <LaunchDate>{attribute=\"product|created_at\" format=\"date\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</LaunchDate>\n    <ReleaseDate>{attribute=\"product|created_at\" format=\"date\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</ReleaseDate>\n    <Condition>New</Condition>\n    <DescriptionData>\n            <Title>{attribute=\"product|name\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</Title>\n            <Brand>{attribute=\"product|manufacturer\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</Brand>\n            <Description>{attribute=\"product|description\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape|length:500\"}</Description>\n            <MaxOrderQuantity>{attribute=\"product|qty\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</MaxOrderQuantity>\n            <RecommendedBrowseNode>{attribute=\"category_path|category\" format=\"as_is\" parent=\"yes\" optional=\"no\" modify=\"html_escape\"}</RecommendedBrowseNode>\n            <ShippingWeight unitOfMeasure=\"KG\">{attribute=\"product|weight\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</ShippingWeight>\n            <SearchTerms>{attribute=\"product|meta_keyword\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</SearchTerms>\n    </DescriptionData>\n</Product>\n','</AmazonEnvelope>',1,'two','dot','comma','Y-m-d','a:6:{s:4:\"type\";s:48:\"Magento\\CatalogRule\\Model\\Rule\\Condition\\Combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(9,'Amazon Inventory','AmazonInventory','xml',1,0,'manual',1,NULL,NULL,NULL,'USD',NULL,'<?xml version=\"1.0\" encoding=\"utf-8\" ?><AmazonEnvelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"amzn-envelope.xsd\"><Header><DocumentVersion>1.01</DocumentVersion><MerchantIdentifier>YOUR_MERCHANT_IDENTIFIER</MerchantIdentifier></Header><MessageType>Inventory</MessageType>','Message','\n<MessageID>{attribute=\"product|product_id\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</MessageID>\n<OperationType>Update</OperationType>\n<Inventory>\n    <SKU>{attribute=\"basic|sku\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</SKU>\n    <Available>{attribute=\"product|is_in_stock\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</Available>\n    <Quantity>{attribute=\"product|qty\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</Quantity>\n    <FulfillmentLatency>7</FulfillmentLatency>\n</Inventory>\n','</AmazonEnvelope>',1,'two','dot','comma','Y-m-d','a:6:{s:4:\"type\";s:48:\"Magento\\CatalogRule\\Model\\Rule\\Condition\\Combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(10,'Amazon Price','AmazonPrice','xml',1,0,'manual',1,NULL,NULL,NULL,'USD',NULL,'<?xml version=\"1.0\" encoding=\"utf-8\" ?><AmazonEnvelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"amzn-envelope.xsd\"><Header><DocumentVersion>1.01</DocumentVersion><MerchantIdentifier>YOUR_MERCHANT_IDENTIFIER</MerchantIdentifier></Header><MessageType>Price</MessageType>','Message','\n<MessageID>{attribute=\"product|product_id\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</MessageID>\n<Price>\n    <SKU>{attribute=\"basic|sku\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</SKU>\n    <StandardPrice currency=\"USD\">{attribute=\"product|price\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</StandardPrice>\n    <Sale>\n        <StartDate>{attribute=\"product|special_from_date\" format=\"date\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</StartDate>\n        <EndDate>{attribute=\"product|special_to_date\" format=\"date\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</EndDate>\n        <SalePrice currency=\"USD\">{attribute=\"product|special_price\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</SalePrice>\n    </Sale>\n</Price>\n','</AmazonEnvelope>',1,'two','dot','comma','Y-m-d','a:6:{s:4:\"type\";s:48:\"Magento\\CatalogRule\\Model\\Rule\\Condition\\Combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0),(11,'Amazon Image','AmazonImage','xml',1,0,'manual',1,NULL,NULL,NULL,'USD',NULL,'<?xml version=\"1.0\" encoding=\"utf-8\" ?><AmazonEnvelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"amzn-envelope.xsd\"><Header><DocumentVersion>1.01</DocumentVersion><MerchantIdentifier>YOUR_MERCHANT_IDENTIFIER</MerchantIdentifier></Header><MessageType>ProductImage</MessageType>','Message','\n<MessageID>{attribute=\"product|product_id\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</MessageID>\n<OperationType>Update</OperationType>\n<ProductImage>\n    <SKU>{attribute=\"basic|sku\" format=\"as_is\" parent=\"no\" optional=\"no\" modify=\"html_escape\"}</SKU>\n    <ImageType>Main</ImageType>\n    <ImageLocation>{attribute=\"image|image\" format=\"as_is\" parent=\"no\" optional=\"yes\" modify=\"html_escape\"}</ImageLocation>\n</ProductImage>\n','</AmazonEnvelope>',0,'two','dot','comma','Y-m-d','a:6:{s:4:\"type\";s:48:\"Magento\\CatalogRule\\Model\\Rule\\Condition\\Combine\";s:9:\"attribute\";N;s:8:\"operator\";N;s:5:\"value\";s:1:\"1\";s:18:\"is_value_processed\";N;s:10:\"aggregator\";s:3:\"all\";}',NULL,0,NULL,'ftp',NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'',0,0,0,0,'',0);
/*!40000 ALTER TABLE `amasty_feed_entity` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`prochefco_dbyusr`@`localhost`*/ /*!50003 TRIGGER trg_amasty_feed_entity_after_insert AFTER INSERT ON amasty_feed_entity FOR EACH ROW
BEGIN
INSERT IGNORE INTO `amasty_feed_entity_cl` (`entity_id`) VALUES (NEW.`entity_id`);
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`prochefco_dbyusr`@`localhost`*/ /*!50003 TRIGGER trg_amasty_feed_entity_after_update AFTER UPDATE ON amasty_feed_entity FOR EACH ROW
BEGIN
IF (NOT(NEW.`entity_id` <=> OLD.`entity_id`) OR NOT(NEW.`name` <=> OLD.`name`) OR NOT(NEW.`filename` <=> OLD.`filename`) OR NOT(NEW.`feed_type` <=> OLD.`feed_type`) OR NOT(NEW.`is_active` <=> OLD.`is_active`) OR NOT(NEW.`store_id` <=> OLD.`store_id`) OR NOT(NEW.`execute_mode` <=> OLD.`execute_mode`) OR NOT(NEW.`csv_column_name` <=> OLD.`csv_column_name`) OR NOT(NEW.`csv_header` <=> OLD.`csv_header`) OR NOT(NEW.`csv_enclosure` <=> OLD.`csv_enclosure`) OR NOT(NEW.`csv_delimiter` <=> OLD.`csv_delimiter`) OR NOT(NEW.`format_price_currency` <=> OLD.`format_price_currency`) OR NOT(NEW.`csv_field` <=> OLD.`csv_field`) OR NOT(NEW.`xml_header` <=> OLD.`xml_header`) OR NOT(NEW.`xml_item` <=> OLD.`xml_item`) OR NOT(NEW.`xml_content` <=> OLD.`xml_content`) OR NOT(NEW.`xml_footer` <=> OLD.`xml_footer`) OR NOT(NEW.`format_price_currency_show` <=> OLD.`format_price_currency_show`) OR NOT(NEW.`format_price_decimals` <=> OLD.`format_price_decimals`) OR NOT(NEW.`format_price_decimal_point` <=> OLD.`format_price_decimal_point`) OR NOT(NEW.`format_price_thousands_separator` <=> OLD.`format_price_thousands_separator`) OR NOT(NEW.`format_date` <=> OLD.`format_date`) OR NOT(NEW.`conditions_serialized` <=> OLD.`conditions_serialized`) OR NOT(NEW.`generated_at` <=> OLD.`generated_at`) OR NOT(NEW.`delivery_enabled` <=> OLD.`delivery_enabled`) OR NOT(NEW.`delivery_host` <=> OLD.`delivery_host`) OR NOT(NEW.`delivery_type` <=> OLD.`delivery_type`) OR NOT(NEW.`delivery_user` <=> OLD.`delivery_user`) OR NOT(NEW.`delivery_password` <=> OLD.`delivery_password`) OR NOT(NEW.`delivery_path` <=> OLD.`delivery_path`) OR NOT(NEW.`delivery_passive_mode` <=> OLD.`delivery_passive_mode`) OR NOT(NEW.`utm_source` <=> OLD.`utm_source`) OR NOT(NEW.`utm_medium` <=> OLD.`utm_medium`) OR NOT(NEW.`utm_term` <=> OLD.`utm_term`) OR NOT(NEW.`utm_content` <=> OLD.`utm_content`) OR NOT(NEW.`utm_campaign` <=> OLD.`utm_campaign`) OR NOT(NEW.`is_template` <=> OLD.`is_template`) OR NOT(NEW.`compress` <=> OLD.`compress`) OR NOT(NEW.`exclude_disabled` <=> OLD.`exclude_disabled`) OR NOT(NEW.`exclude_out_of_stock` <=> OLD.`exclude_out_of_stock`) OR NOT(NEW.`exclude_not_visible` <=> OLD.`exclude_not_visible`) OR NOT(NEW.`products_amount` <=> OLD.`products_amount`) OR NOT(NEW.`generation_type` <=> OLD.`generation_type`) OR NOT(NEW.`status` <=> OLD.`status`)) THEN INSERT IGNORE INTO `amasty_feed_entity_cl` (`entity_id`) VALUES (NEW.`entity_id`); END IF;
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8 */ ;
/*!50003 SET character_set_results = utf8 */ ;
/*!50003 SET collation_connection  = utf8_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = '' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`prochefco_dbyusr`@`localhost`*/ /*!50003 TRIGGER trg_amasty_feed_entity_after_delete AFTER DELETE ON amasty_feed_entity FOR EACH ROW
BEGIN
INSERT IGNORE INTO `amasty_feed_entity_cl` (`entity_id`) VALUES (OLD.`entity_id`);
END */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `amasty_feed_entity_cl`
--

DROP TABLE IF EXISTS `amasty_feed_entity_cl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_entity_cl` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_feed_entity_cl';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_entity_cl`
--

LOCK TABLES `amasty_feed_entity_cl` WRITE;
/*!40000 ALTER TABLE `amasty_feed_entity_cl` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_feed_entity_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_field`
--

DROP TABLE IF EXISTS `amasty_feed_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_field` (
  `feed_field_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Custom Field Id',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`feed_field_id`),
  UNIQUE KEY `AMASTY_FEED_FIELD_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_feed_field';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_field`
--

LOCK TABLES `amasty_feed_field` WRITE;
/*!40000 ALTER TABLE `amasty_feed_field` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_feed_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_field_conditions`
--

DROP TABLE IF EXISTS `amasty_feed_field_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_field_conditions` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Condition Id',
  `feed_field_id` int(11) NOT NULL COMMENT 'Custom Field Id',
  `conditions_serialized` mediumtext DEFAULT NULL COMMENT 'Conditions',
  `result_serialized` mediumtext DEFAULT NULL COMMENT 'Result',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amasty_feed_field_conditions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_field_conditions`
--

LOCK TABLES `amasty_feed_field_conditions` WRITE;
/*!40000 ALTER TABLE `amasty_feed_field_conditions` DISABLE KEYS */;
/*!40000 ALTER TABLE `amasty_feed_field_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `amasty_feed_google_taxonomy`
--

DROP TABLE IF EXISTS `amasty_feed_google_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `amasty_feed_google_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `category` text DEFAULT NULL COMMENT 'Category',
  `language_code` text DEFAULT NULL COMMENT 'Language Code',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43417 DEFAULT CHARSET=utf8 COMMENT='amasty_feed_google_taxonomy';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `amasty_feed_google_taxonomy`
--

LOCK TABLES `amasty_feed_google_taxonomy` WRITE;
/*!40000 ALTER TABLE `amasty_feed_google_taxonomy` DISABLE KEYS */;
INSERT INTO `amasty_feed_google_taxonomy` VALUES (1,'Baby & Kleinkind','de-DE'),(2,'Baby & Kleinkind > Baby Badebedarf','de-DE'),(3,'Baby & Kleinkind > Baby Badebedarf > Babybadewannen','de-DE'),(4,'Baby & Kleinkind > Baby Badebedarf > Shampoo-Schutzschilder','de-DE'),(5,'Baby & Kleinkind > Baby Gesundheitsbedarf','de-DE'),(6,'Baby & Kleinkind > Baby Gesundheitsbedarf > Baby-Gesundheits- & Pflegesets','de-DE'),(7,'Baby & Kleinkind > Baby Gesundheitsbedarf > Nasensauger','de-DE'),(8,'Baby & Kleinkind > Baby Gesundheitsbedarf > Reinigungstücher für Schnuller','de-DE'),(9,'Baby & Kleinkind > Baby Gesundheitsbedarf > Schnuller & Beißringe','de-DE'),(10,'Baby & Kleinkind > Baby Gesundheitsbedarf > Schnullerclips & -ketten','de-DE'),(11,'Baby & Kleinkind > Babysicherheit','de-DE'),(12,'Baby & Kleinkind > Babysicherheit > Baby- & Haustierschutzgitter','de-DE'),(13,'Baby & Kleinkind > Babysicherheit > Baby-Schutzleisten','de-DE'),(14,'Baby & Kleinkind > Babysicherheit > Babyfone','de-DE'),(15,'Baby & Kleinkind > Babysicherheit > Babysicherheitsgurte & -leinen','de-DE'),(16,'Baby & Kleinkind > Babysicherheit > Babysicherungen & Schutzvorrichtungen','de-DE'),(17,'Baby & Kleinkind > Babysicherheit > Zubehör für Baby- & Haustierschutzgitter','de-DE'),(18,'Baby & Kleinkind > Babyspielwaren','de-DE'),(19,'Baby & Kleinkind > Babyspielwaren > ABC-Lernspielzeuge','de-DE'),(20,'Baby & Kleinkind > Babyspielwaren > Baby-Aktiv-Spielzeug','de-DE'),(21,'Baby & Kleinkind > Babyspielwaren > Baby-Mobile-Zubehör','de-DE'),(22,'Baby & Kleinkind > Babyspielwaren > Baby-Mobiles','de-DE'),(23,'Baby & Kleinkind > Babyspielwaren > Babylauflernhilfen','de-DE'),(24,'Baby & Kleinkind > Babyspielwaren > Babyrasseln','de-DE'),(25,'Baby & Kleinkind > Babyspielwaren > Babyschaukeln & Türhopser','de-DE'),(26,'Baby & Kleinkind > Babyspielwaren > Babywippen','de-DE'),(27,'Baby & Kleinkind > Babyspielwaren > Lauf- & Spielgitter','de-DE'),(28,'Baby & Kleinkind > Babyspielwaren > Schnuller & Beruhigung','de-DE'),(29,'Baby & Kleinkind > Babyspielwaren > Sortier-, Stapel- & Steckspielzeug','de-DE'),(30,'Baby & Kleinkind > Babyspielwaren > Spiel- & Krabbeldecken','de-DE'),(31,'Baby & Kleinkind > Babyspielwaren > Zieh- & Schiebespielzeug','de-DE'),(32,'Baby & Kleinkind > Babytransport','de-DE'),(33,'Baby & Kleinkind > Babytransport > Baby- & Kleinkindautositze','de-DE'),(34,'Baby & Kleinkind > Babytransport > Babyträger','de-DE'),(35,'Baby & Kleinkind > Babytransport > Kinderwagen','de-DE'),(36,'Baby & Kleinkind > Babytransportzubehör','de-DE'),(37,'Baby & Kleinkind > Babytransportzubehör > Einkaufswagen- & Hochstuhlbezüge','de-DE'),(38,'Baby & Kleinkind > Babytransportzubehör > Fußsäcke','de-DE'),(39,'Baby & Kleinkind > Babytransportzubehör > Zubehör für Baby- & Kleinkindautositze','de-DE'),(40,'Baby & Kleinkind > Babytransportzubehör > Zubehör für Babyträger','de-DE'),(41,'Baby & Kleinkind > Babytransportzubehör > Zubehör für Kinderwagen','de-DE'),(42,'Baby & Kleinkind > Geschenksets für Babys','de-DE'),(43,'Baby & Kleinkind > Puckdecken','de-DE'),(44,'Baby & Kleinkind > Stillen & Füttern','de-DE'),(45,'Baby & Kleinkind > Stillen & Füttern > Baby-Spucktücher','de-DE'),(46,'Baby & Kleinkind > Stillen & Füttern > Babyflaschen','de-DE'),(47,'Baby & Kleinkind > Stillen & Füttern > Babypflege-Timer','de-DE'),(48,'Baby & Kleinkind > Stillen & Füttern > Flaschenwärmer & Sterilisatoren','de-DE'),(49,'Baby & Kleinkind > Stillen & Füttern > Lerntassen','de-DE'),(50,'Baby & Kleinkind > Stillen & Füttern > Lätzchen','de-DE'),(51,'Baby & Kleinkind > Stillen & Füttern > Milchpumpen','de-DE'),(52,'Baby & Kleinkind > Stillen & Füttern > Milchpumpenzubehör','de-DE'),(53,'Baby & Kleinkind > Stillen & Füttern > Muttermilchbehälter','de-DE'),(54,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder','de-DE'),(55,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Baby-Snacks','de-DE'),(56,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Babygetreide','de-DE'),(57,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Babynahrung','de-DE'),(58,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Babysäfte','de-DE'),(59,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Getränke und Milchmischgetränke','de-DE'),(60,'Baby & Kleinkind > Stillen & Füttern > Nahrung für Babys & Kleinkinder > Milchnahrung','de-DE'),(61,'Baby & Kleinkind > Stillen & Füttern > Sauger für Babyflaschen','de-DE'),(62,'Baby & Kleinkind > Stillen & Füttern > Stillhütchen & -einlagen','de-DE'),(63,'Baby & Kleinkind > Stillen & Füttern > Stillkissen','de-DE'),(64,'Baby & Kleinkind > Stillen & Füttern > Stillkissenbezüge','de-DE'),(65,'Baby & Kleinkind > Stillen & Füttern > Stilltücher','de-DE'),(66,'Baby & Kleinkind > Töpfchentraining','de-DE'),(67,'Baby & Kleinkind > Töpfchentraining > Töpfchen','de-DE'),(68,'Baby & Kleinkind > Töpfchentraining > Töpfchentrainingsets','de-DE'),(69,'Baby & Kleinkind > Wickelbedarf','de-DE'),(70,'Baby & Kleinkind > Wickelbedarf > Baby-Reinigungstücher','de-DE'),(71,'Baby & Kleinkind > Wickelbedarf > Behandlung von Windeldermatitis','de-DE'),(72,'Baby & Kleinkind > Wickelbedarf > Behälter & Warmhalter für Baby-Reinigungstücher','de-DE'),(73,'Baby & Kleinkind > Wickelbedarf > Wickelauflagen','de-DE'),(74,'Baby & Kleinkind > Wickelbedarf > Wickelauflagen & Bezüge','de-DE'),(75,'Baby & Kleinkind > Wickelbedarf > Windel-Organizer','de-DE'),(76,'Baby & Kleinkind > Wickelbedarf > Windelbeutel','de-DE'),(77,'Baby & Kleinkind > Wickelbedarf > Windeleimer','de-DE'),(78,'Baby & Kleinkind > Wickelbedarf > Windeleimerzubehör','de-DE'),(79,'Baby & Kleinkind > Wickelbedarf > Windeleinlagen','de-DE'),(80,'Baby & Kleinkind > Wickelbedarf > Windeln','de-DE'),(81,'Baby & Kleinkind > Wickelbedarf > Windelsets','de-DE'),(82,'Bekleidung & Accessoires','de-DE'),(83,'Bekleidung & Accessoires > Bekleidung','de-DE'),(84,'Bekleidung & Accessoires > Bekleidung > Anzüge','de-DE'),(85,'Bekleidung & Accessoires > Bekleidung > Anzüge > Anzüge & Hosenanzüge','de-DE'),(86,'Bekleidung & Accessoires > Bekleidung > Anzüge > Kostüme','de-DE'),(87,'Bekleidung & Accessoires > Bekleidung > Anzüge > Smokings','de-DE'),(88,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung','de-DE'),(89,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Baby- & Kleinkind-Kombis','de-DE'),(90,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Baby- & Kleinkind-Oberbekleidung','de-DE'),(91,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Baby- & Kleinkindsocken','de-DE'),(92,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Baby-Bodys','de-DE'),(93,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Baby-Schlafkleidung & -Schlafsäcke','de-DE'),(94,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Babyüberhosen','de-DE'),(95,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Bademode für Babys & Kleinkinder','de-DE'),(96,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Kleider für Babys & Kleinkinder','de-DE'),(97,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Kleinkindunterwäsche','de-DE'),(98,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Oberteile für Babys & Kleinkinder','de-DE'),(99,'Bekleidung & Accessoires > Bekleidung > Baby- & Kleinkindbekleidung > Unterteile für Babys & Kleinkinder','de-DE'),(100,'Bekleidung & Accessoires > Bekleidung > Bademode','de-DE'),(101,'Bekleidung & Accessoires > Bekleidung > Brautmoden','de-DE'),(102,'Bekleidung & Accessoires > Bekleidung > Brautmoden > Brautjungfernkleider','de-DE'),(103,'Bekleidung & Accessoires > Bekleidung > Brautmoden > Brautkleider','de-DE'),(104,'Bekleidung & Accessoires > Bekleidung > Einteiler','de-DE'),(105,'Bekleidung & Accessoires > Bekleidung > Einteiler > Latzhosen','de-DE'),(106,'Bekleidung & Accessoires > Bekleidung > Einteiler > Overalls','de-DE'),(107,'Bekleidung & Accessoires > Bekleidung > Einteiler > Turn- & Gymnastikanzüge','de-DE'),(108,'Bekleidung & Accessoires > Bekleidung > Hosen','de-DE'),(109,'Bekleidung & Accessoires > Bekleidung > Kleider','de-DE'),(110,'Bekleidung & Accessoires > Bekleidung > Kombinationen','de-DE'),(111,'Bekleidung & Accessoires > Bekleidung > Nachtwäsche & Loungewear','de-DE'),(112,'Bekleidung & Accessoires > Bekleidung > Nachtwäsche & Loungewear > Bademäntel','de-DE'),(113,'Bekleidung & Accessoires > Bekleidung > Nachtwäsche & Loungewear > Loungewear','de-DE'),(114,'Bekleidung & Accessoires > Bekleidung > Nachtwäsche & Loungewear > Nachthemden','de-DE'),(115,'Bekleidung & Accessoires > Bekleidung > Nachtwäsche & Loungewear > Schlafanzüge','de-DE'),(116,'Bekleidung & Accessoires > Bekleidung > Röcke','de-DE'),(117,'Bekleidung & Accessoires > Bekleidung > Shirts & Tops','de-DE'),(118,'Bekleidung & Accessoires > Bekleidung > Shorts','de-DE'),(119,'Bekleidung & Accessoires > Bekleidung > Skorts','de-DE'),(120,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung','de-DE'),(121,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > American Football-Hosen','de-DE'),(122,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Boxshorts','de-DE'),(123,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Jagdbekleidung','de-DE'),(124,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Jagdbekleidung > Ghillie-Anzüge','de-DE'),(125,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Jagdbekleidung > Jagd- & Angelwesten','de-DE'),(126,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Jagdbekleidung > Jagd- & taktische Hosen','de-DE'),(127,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Kampfsporthosen','de-DE'),(128,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Motorradbekleidung','de-DE'),(129,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Motorradbekleidung > Motorrad-Kombis','de-DE'),(130,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Motorradbekleidung > Motorradhosen','de-DE'),(131,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Motorradbekleidung > Motorradjacken','de-DE'),(132,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Paintballbekleidung','de-DE'),(133,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung','de-DE'),(134,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung > Fahrradhosen (kurz)','de-DE'),(135,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung > Fahrradhosen (lang)','de-DE'),(136,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung > Fahrradtrikots','de-DE'),(137,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung > Fahrradträgerhosen','de-DE'),(138,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Radsport-Funktionsbekleidung > Radsport-Zeitfahranzüge','de-DE'),(139,'Bekleidung & Accessoires > Bekleidung > Sportbekleidung > Tanzkleider, Tanzröcke und Tanzkostüme','de-DE'),(140,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung','de-DE'),(141,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Dirndl','de-DE'),(142,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Hakama-Hosen','de-DE'),(143,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Kimono-Oberbekleidung','de-DE'),(144,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Kimonos','de-DE'),(145,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Religiöse Festkleidung','de-DE'),(146,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Religiöse Festkleidung > Tauf- & Kommunionskleider','de-DE'),(147,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Saris','de-DE'),(148,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Trachten Lederhosen','de-DE'),(149,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Traditionelle japanische formelle Kleidung','de-DE'),(150,'Bekleidung & Accessoires > Bekleidung > Traditionelle & Festkleidung > Yukata','de-DE'),(151,'Bekleidung & Accessoires > Bekleidung > Uniformen','de-DE'),(152,'Bekleidung & Accessoires > Bekleidung > Uniformen > Arbeitshosen','de-DE'),(153,'Bekleidung & Accessoires > Bekleidung > Uniformen > Fliegeruniformen','de-DE'),(154,'Bekleidung & Accessoires > Bekleidung > Uniformen > Militäruniformen','de-DE'),(155,'Bekleidung & Accessoires > Bekleidung > Uniformen > Schuluniformen','de-DE'),(156,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sicherheitsdienst-Bekleidung','de-DE'),(157,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen','de-DE'),(158,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > American Football-Uniformen','de-DE'),(159,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Baseballuniformen','de-DE'),(160,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Basketballuniformen','de-DE'),(161,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Cheerleading-Uniformen','de-DE'),(162,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Fußballuniformen','de-DE'),(163,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Hockeyuniformen','de-DE'),(164,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Kampfsportuniformen','de-DE'),(165,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Kricketuniformen','de-DE'),(166,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Ringeruniformen','de-DE'),(167,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Schiedsrichteruniformen','de-DE'),(168,'Bekleidung & Accessoires > Bekleidung > Uniformen > Sportuniformen > Softballuniformen','de-DE'),(169,'Bekleidung & Accessoires > Bekleidung > Uniformen > Uniformen für das Restaurantgewerbe','de-DE'),(170,'Bekleidung & Accessoires > Bekleidung > Uniformen > Uniformen für das Restaurantgewerbe > Kochhosen','de-DE'),(171,'Bekleidung & Accessoires > Bekleidung > Uniformen > Uniformen für das Restaurantgewerbe > Kochjacken','de-DE'),(172,'Bekleidung & Accessoires > Bekleidung > Uniformen > Uniformen für das Restaurantgewerbe > Kochmützen','de-DE'),(173,'Bekleidung & Accessoires > Bekleidung > Uniformen > Ärztekittel','de-DE'),(174,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken','de-DE'),(175,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > BH-Zubehör','de-DE'),(176,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > BH-Zubehör > BH-Einlagen','de-DE'),(177,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > BH-Zubehör > BH-Träger & -Erweiterungen','de-DE'),(178,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > BH-Zubehör > BH-Träger-Pads','de-DE'),(179,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > BH-Zubehör > Brustaufkleber','de-DE'),(180,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Büstenhalter','de-DE'),(181,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Dessous','de-DE'),(182,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Dessous-Accessoires','de-DE'),(183,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Dessous-Accessoires > Strumpfbänder','de-DE'),(184,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Dessous-Accessoires > Strumpfhalter','de-DE'),(185,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Lange Unterhosen','de-DE'),(186,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Petticoats & Rüschenhöschen','de-DE'),(187,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Shapewear','de-DE'),(188,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Socken','de-DE'),(189,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Strumpfhosen','de-DE'),(190,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Suspensorien','de-DE'),(191,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Unterhemden','de-DE'),(192,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Unterhosen','de-DE'),(193,'Bekleidung & Accessoires > Bekleidung > Unterwäsche & Socken > Unterwäsche','de-DE'),(194,'Bekleidung & Accessoires > Bekleidung > Überbekleidung','de-DE'),(195,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Chaps','de-DE'),(196,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Mäntel & Jacken','de-DE'),(197,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Regenanzüge','de-DE'),(198,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Regenhosen','de-DE'),(199,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Schneehosen und - anzüge','de-DE'),(200,'Bekleidung & Accessoires > Bekleidung > Überbekleidung > Westen','de-DE'),(201,'Bekleidung & Accessoires > Bekleidungsaccessoires','de-DE'),(202,'Bekleidung & Accessoires > Bekleidungsaccessoires > Accessoires für traditionelle Kleidung','de-DE'),(203,'Bekleidung & Accessoires > Bekleidungsaccessoires > Accessoires für traditionelle Kleidung > Obis','de-DE'),(204,'Bekleidung & Accessoires > Bekleidungsaccessoires > Accessoires für traditionelle Kleidung > Tabi-Socken','de-DE'),(205,'Bekleidung & Accessoires > Bekleidungsaccessoires > Ansteckbuttons','de-DE'),(206,'Bekleidung & Accessoires > Bekleidungsaccessoires > Armstulpen','de-DE'),(207,'Bekleidung & Accessoires > Bekleidungsaccessoires > Bandanas & Stofftücher','de-DE'),(208,'Bekleidung & Accessoires > Bekleidungsaccessoires > Beinstulpen','de-DE'),(209,'Bekleidung & Accessoires > Bekleidungsaccessoires > Braut-Accessoires','de-DE'),(210,'Bekleidung & Accessoires > Bekleidungsaccessoires > Braut-Accessoires > Brautschleier','de-DE'),(211,'Bekleidung & Accessoires > Bekleidungsaccessoires > Einstecktücher','de-DE'),(212,'Bekleidung & Accessoires > Bekleidungsaccessoires > Fächer','de-DE'),(213,'Bekleidung & Accessoires > Bekleidungsaccessoires > Gürtel','de-DE'),(214,'Bekleidung & Accessoires > Bekleidungsaccessoires > Gürtelschnallen','de-DE'),(215,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires','de-DE'),(216,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Diademe','de-DE'),(217,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Duttkissen','de-DE'),(218,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haargabeln','de-DE'),(219,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haargummis','de-DE'),(220,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haarklammern, -nadeln & -clips','de-DE'),(221,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haarkränze','de-DE'),(222,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haarkämme','de-DE'),(223,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haarnetze','de-DE'),(224,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Haarverlängerungen','de-DE'),(225,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Perücken','de-DE'),(226,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Perücken-Accessoires','de-DE'),(227,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Perücken-Accessoires > Perückenkleber','de-DE'),(228,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Perücken-Accessoires > Perückennetze','de-DE'),(229,'Bekleidung & Accessoires > Bekleidungsaccessoires > Haaraccessoires > Stirnbänder','de-DE'),(230,'Bekleidung & Accessoires > Bekleidungsaccessoires > Halswärmer','de-DE'),(231,'Bekleidung & Accessoires > Bekleidungsaccessoires > Handschuhe & Fausthandschuhe','de-DE'),(232,'Bekleidung & Accessoires > Bekleidungsaccessoires > Hosenträger','de-DE'),(233,'Bekleidung & Accessoires > Bekleidungsaccessoires > Hüte','de-DE'),(234,'Bekleidung & Accessoires > Bekleidungsaccessoires > Knopfnieten','de-DE'),(235,'Bekleidung & Accessoires > Bekleidungsaccessoires > Kopfbekleidung & -tücher','de-DE'),(236,'Bekleidung & Accessoires > Bekleidungsaccessoires > Kopfbekleidung & -tücher > Fascinators','de-DE'),(237,'Bekleidung & Accessoires > Bekleidungsaccessoires > Kopfbekleidung & -tücher > Kopfschmuck','de-DE'),(238,'Bekleidung & Accessoires > Bekleidungsaccessoires > Kopfbekleidung & -tücher > Turbane','de-DE'),(239,'Bekleidung & Accessoires > Bekleidungsaccessoires > Kragenstäbchen','de-DE'),(240,'Bekleidung & Accessoires > Bekleidungsaccessoires > Krawatten','de-DE'),(241,'Bekleidung & Accessoires > Bekleidungsaccessoires > Krawattennadeln','de-DE'),(242,'Bekleidung & Accessoires > Bekleidungsaccessoires > Leis','de-DE'),(243,'Bekleidung & Accessoires > Bekleidungsaccessoires > Manschettenknöpfe','de-DE'),(244,'Bekleidung & Accessoires > Bekleidungsaccessoires > Muffe','de-DE'),(245,'Bekleidung & Accessoires > Bekleidungsaccessoires > Ohrenschützer','de-DE'),(246,'Bekleidung & Accessoires > Bekleidungsaccessoires > Schals & Halstücher','de-DE'),(247,'Bekleidung & Accessoires > Bekleidungsaccessoires > Schwangerschaftsgürtel & Bauchstützen','de-DE'),(248,'Bekleidung & Accessoires > Bekleidungsaccessoires > Schweißbänder','de-DE'),(249,'Bekleidung & Accessoires > Bekleidungsaccessoires > Schärpen','de-DE'),(250,'Bekleidung & Accessoires > Bekleidungsaccessoires > Sonnenbrillen','de-DE'),(251,'Bekleidung & Accessoires > Bekleidungsaccessoires > Sturmhauben','de-DE'),(252,'Bekleidung & Accessoires > Bekleidungsaccessoires > Zubehör für Baby- & Kleinkindbekleidung','de-DE'),(253,'Bekleidung & Accessoires > Bekleidungsaccessoires > Zubehör für Baby- & Kleinkindbekleidung > Baby- & Kleinkindhandschuhe','de-DE'),(254,'Bekleidung & Accessoires > Bekleidungsaccessoires > Zubehör für Baby- & Kleinkindbekleidung > Babyschutzbekleidung','de-DE'),(255,'Bekleidung & Accessoires > Bekleidungsaccessoires > Zubehör für Baby- & Kleinkindbekleidung > Gürtel für Babys & Kleinkinder','de-DE'),(256,'Bekleidung & Accessoires > Bekleidungsaccessoires > Zubehör für Baby- & Kleinkindbekleidung > Kopfbedeckungen für Babys & Kleinkinder','de-DE'),(257,'Bekleidung & Accessoires > Handtaschen & Geldbörsenaccessoires','de-DE'),(258,'Bekleidung & Accessoires > Handtaschen & Geldbörsenaccessoires > Brieftaschenketten','de-DE'),(259,'Bekleidung & Accessoires > Handtaschen & Geldbörsenaccessoires > Scheckheftetuis','de-DE'),(260,'Bekleidung & Accessoires > Handtaschen & Geldbörsenaccessoires > Schlüsselanhänger','de-DE'),(261,'Bekleidung & Accessoires > Handtaschen & Geldbörsenaccessoires > Tragebänder','de-DE'),(262,'Bekleidung & Accessoires > Handtaschen, Geldbörsen & Etuis','de-DE'),(263,'Bekleidung & Accessoires > Handtaschen, Geldbörsen & Etuis > Ausweistaschen','de-DE'),(264,'Bekleidung & Accessoires > Handtaschen, Geldbörsen & Etuis > Geldbeutel & Geldklammern','de-DE'),(265,'Bekleidung & Accessoires > Handtaschen, Geldbörsen & Etuis > Handtaschen','de-DE'),(266,'Bekleidung & Accessoires > Handtaschen, Geldbörsen & Etuis > Visitenkartenetuis','de-DE'),(267,'Bekleidung & Accessoires > Kostüme & Accessoires','de-DE'),(268,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires','de-DE'),(269,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Glatzen','de-DE'),(270,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Kostüm-Accessoire-Sets','de-DE'),(271,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Kostüm-Handschuhe','de-DE'),(272,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Kostümhüte','de-DE'),(273,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Plastikschmuck','de-DE'),(274,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Spezial-Schminkeffekte','de-DE'),(275,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Tabakwarenimitate','de-DE'),(276,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümaccessoires > Umhänge für Kostüme','de-DE'),(277,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostüme & Verkleidungen','de-DE'),(278,'Bekleidung & Accessoires > Kostüme & Accessoires > Kostümschuhe','de-DE'),(279,'Bekleidung & Accessoires > Kostüme & Accessoires > Masken','de-DE'),(280,'Bekleidung & Accessoires > Schmuck','de-DE'),(281,'Bekleidung & Accessoires > Schmuck > Armbanduhren & Taschenuhren','de-DE'),(282,'Bekleidung & Accessoires > Schmuck > Armbänder','de-DE'),(283,'Bekleidung & Accessoires > Schmuck > Broschen und Anstecknadeln','de-DE'),(284,'Bekleidung & Accessoires > Schmuck > Charms & Anhänger','de-DE'),(285,'Bekleidung & Accessoires > Schmuck > Fußkettchen','de-DE'),(286,'Bekleidung & Accessoires > Schmuck > Halsketten','de-DE'),(287,'Bekleidung & Accessoires > Schmuck > Körperschmuck','de-DE'),(288,'Bekleidung & Accessoires > Schmuck > Ohrringe','de-DE'),(289,'Bekleidung & Accessoires > Schmuck > Ringe','de-DE'),(290,'Bekleidung & Accessoires > Schmuck > Schmucksets','de-DE'),(291,'Bekleidung & Accessoires > Schmuck > Uhrenaccessoires','de-DE'),(292,'Bekleidung & Accessoires > Schmuck > Uhrenaccessoires > Aufkleber für Uhren','de-DE'),(293,'Bekleidung & Accessoires > Schmuck > Uhrenaccessoires > Uhrenarmbänder','de-DE'),(294,'Bekleidung & Accessoires > Schmuck > Uhrenaccessoires > Uhrenbeweger','de-DE'),(295,'Bekleidung & Accessoires > Schuh-Accessoires','de-DE'),(296,'Bekleidung & Accessoires > Schuh-Accessoires > Gamaschen','de-DE'),(297,'Bekleidung & Accessoires > Schuh-Accessoires > Schnürsenkel','de-DE'),(298,'Bekleidung & Accessoires > Schuh-Accessoires > Sporen','de-DE'),(299,'Bekleidung & Accessoires > Schuh-Accessoires > Stiefelsocken','de-DE'),(300,'Bekleidung & Accessoires > Schuh-Accessoires > Überschuhe','de-DE'),(301,'Bekleidung & Accessoires > Schuhe','de-DE'),(302,'Bürobedarf','de-DE'),(303,'Bürobedarf > Ablage & Organisation','de-DE'),(304,'Bürobedarf > Ablage & Organisation > Adressbücher','de-DE'),(305,'Bürobedarf > Ablage & Organisation > Akten- & Schreibmappen','de-DE'),(306,'Bürobedarf > Ablage & Organisation > Aktenaufbewahrungsboxen','de-DE'),(307,'Bürobedarf > Ablage & Organisation > Aktenhüllen und Klemmhefter','de-DE'),(308,'Bürobedarf > Ablage & Organisation > Bindesysteme','de-DE'),(309,'Bürobedarf > Ablage & Organisation > Bindesysteme > Aktenordner','de-DE'),(310,'Bürobedarf > Ablage & Organisation > Bindesysteme > Aktenordnerzubehör','de-DE'),(311,'Bürobedarf > Ablage & Organisation > Bindesysteme > Aktenordnerzubehör > Einbandringe','de-DE'),(312,'Bürobedarf > Ablage & Organisation > Bindesysteme > Aktenordnerzubehör > Klarsichthüllen','de-DE'),(313,'Bürobedarf > Ablage & Organisation > Bindesysteme > Aktenordnerzubehör > Registerblätter','de-DE'),(314,'Bürobedarf > Ablage & Organisation > Bindesysteme > Bindegeräte','de-DE'),(315,'Bürobedarf > Ablage & Organisation > Bindesysteme > Binderücken','de-DE'),(316,'Bürobedarf > Ablage & Organisation > CD-/DVD-Ordnungssysteme','de-DE'),(317,'Bürobedarf > Ablage & Organisation > Federmappen','de-DE'),(318,'Bürobedarf > Ablage & Organisation > Geldkassetten','de-DE'),(319,'Bürobedarf > Ablage & Organisation > Kalender, Organizer & Zeitplaner','de-DE'),(320,'Bürobedarf > Ablage & Organisation > Karteikästen','de-DE'),(321,'Bürobedarf > Ablage & Organisation > Kartenhüllen','de-DE'),(322,'Bürobedarf > Ablage & Organisation > Postkartenorganizer','de-DE'),(323,'Bürobedarf > Ablage & Organisation > Postsortiersysteme','de-DE'),(324,'Bürobedarf > Ablage & Organisation > Register- & Hängemappen','de-DE'),(325,'Bürobedarf > Ablage & Organisation > Rezeptkästen','de-DE'),(326,'Bürobedarf > Ablage & Organisation > Schreibtischorganizer','de-DE'),(327,'Bürobedarf > Ablage & Organisation > Visitenkarten-Ständer','de-DE'),(328,'Bürobedarf > Ablage & Organisation > Visitenkartenbücher','de-DE'),(329,'Bürobedarf > Bücherzubehör','de-DE'),(330,'Bürobedarf > Bücherzubehör > Bucheinbände','de-DE'),(331,'Bürobedarf > Bücherzubehör > Buchständer & -stützen','de-DE'),(332,'Bürobedarf > Bücherzubehör > Leselampen','de-DE'),(333,'Bürobedarf > Bücherzubehör > Lesezeichen','de-DE'),(334,'Bürobedarf > Büroarbeitsmittel','de-DE'),(335,'Bürobedarf > Büroarbeitsmittel > Bleistiftspitzer','de-DE'),(336,'Bürobedarf > Büroarbeitsmittel > Brieföffner','de-DE'),(337,'Bürobedarf > Büroarbeitsmittel > Bürostempel','de-DE'),(338,'Bürobedarf > Büroarbeitsmittel > Heftgeräte','de-DE'),(339,'Bürobedarf > Büroarbeitsmittel > Heftklammernzieher','de-DE'),(340,'Bürobedarf > Büroarbeitsmittel > Klebebandabroller','de-DE'),(341,'Bürobedarf > Büroarbeitsmittel > Klemmbretter','de-DE'),(342,'Bürobedarf > Büroarbeitsmittel > Lupen','de-DE'),(343,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte','de-DE'),(344,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte','de-DE'),(345,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte > Bleistifte','de-DE'),(346,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte > Bleistifte > Schreibbleistifte','de-DE'),(347,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte > Bleistifte > Zeichenbleistifte & Buntstifte','de-DE'),(348,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte > Füller- & Bleistift-Sets','de-DE'),(349,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Füller & Bleistifte > Schreibstifte, Kugelschreiber & Füller','de-DE'),(350,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Markierstifte & Textmarker','de-DE'),(351,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Multifunktions-Schreibgeräte','de-DE'),(352,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Pastellkreiden','de-DE'),(353,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Tafelkreide','de-DE'),(354,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Wachsmalstifte','de-DE'),(355,'Bürobedarf > Büroarbeitsmittel > Schreibgeräte > Zeichenkohle','de-DE'),(356,'Bürobedarf > Büroarbeitsmittel > Schreibwerkzeugzubehör','de-DE'),(357,'Bürobedarf > Büroarbeitsmittel > Schreibwerkzeugzubehör > Bleistiftminen','de-DE'),(358,'Bürobedarf > Büroarbeitsmittel > Schreibwerkzeugzubehör > Füllertinte & -patronen','de-DE'),(359,'Bürobedarf > Büroarbeitsmittel > Schreibwerkzeugzubehör > Marker-Nachfülltinte','de-DE'),(360,'Bürobedarf > Büroarbeitsmittel > Tischglocken','de-DE'),(361,'Bürobedarf > Bürogeräte','de-DE'),(362,'Bürobedarf > Bürogeräte > Aktenvernichter','de-DE'),(363,'Bürobedarf > Bürogeräte > Diktiergeräte & Geräte zur Transkription','de-DE'),(364,'Bürobedarf > Bürogeräte > Elektronische Wörterbücher & Übersetzungsgeräte','de-DE'),(365,'Bürobedarf > Bürogeräte > Etikettendrucker','de-DE'),(366,'Bürobedarf > Bürogeräte > Frankiermaschinen','de-DE'),(367,'Bürobedarf > Bürogeräte > Laminiergeräte','de-DE'),(368,'Bürobedarf > Bürogeräte > Schreibmaschinen','de-DE'),(369,'Bürobedarf > Bürogeräte > Stempeluhren','de-DE'),(370,'Bürobedarf > Bürogeräte > Taschenrechner','de-DE'),(371,'Bürobedarf > Bürogeräte > Taschenrechner-Zubehör','de-DE'),(372,'Bürobedarf > Büromatten & Stuhlunterlagen','de-DE'),(373,'Bürobedarf > Büromatten & Stuhlunterlagen > Arbeitsplatzmatten','de-DE'),(374,'Bürobedarf > Büromatten & Stuhlunterlagen > Büromatten','de-DE'),(375,'Bürobedarf > Büromatten & Stuhlunterlagen > Stuhlunterlagen','de-DE'),(376,'Bürobedarf > Bürowagen','de-DE'),(377,'Bürobedarf > Bürowagen > Aktenwagen','de-DE'),(378,'Bürobedarf > Bürowagen > Bücherwagen','de-DE'),(379,'Bürobedarf > Bürowagen > Medienwagen','de-DE'),(380,'Bürobedarf > Bürowagen > Mehrzweckwagen','de-DE'),(381,'Bürobedarf > Bürowagen > Postwagen','de-DE'),(382,'Bürobedarf > Impulsschweißgeräte','de-DE'),(383,'Bürobedarf > Laptophalter','de-DE'),(384,'Bürobedarf > Namensschilder','de-DE'),(385,'Bürobedarf > Papierbearbeitung','de-DE'),(386,'Bürobedarf > Papierbearbeitung > Blattwender','de-DE'),(387,'Bürobedarf > Papierbearbeitung > Briefbeschwerer','de-DE'),(388,'Bürobedarf > Papierbearbeitung > Locher','de-DE'),(389,'Bürobedarf > Papierbearbeitung > Papierfalzmaschinen','de-DE'),(390,'Bürobedarf > Papierbearbeitung > Papierrüttler','de-DE'),(391,'Bürobedarf > Papierbearbeitung > Schreibunterlagen','de-DE'),(392,'Bürobedarf > Präsentationsbedarf','de-DE'),(393,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln','de-DE'),(394,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Hartschaumstoffplatten','de-DE'),(395,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Pinnwände','de-DE'),(396,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Plakatkartons','de-DE'),(397,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Trägerplatten','de-DE'),(398,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Zubehör für Anschlagbretter','de-DE'),(399,'Bürobedarf > Präsentationsbedarf > Ausstellungstafeln > Zubehör für Anschlagbretter > Dekorative Elemente für Anschlagbretter','de-DE'),(400,'Bürobedarf > Präsentationsbedarf > Dokumentenkameras','de-DE'),(401,'Bürobedarf > Präsentationsbedarf > Flipchart-Blöcke','de-DE'),(402,'Bürobedarf > Präsentationsbedarf > Flipcharts','de-DE'),(403,'Bürobedarf > Präsentationsbedarf > Folien','de-DE'),(404,'Bürobedarf > Präsentationsbedarf > Laserpointer','de-DE'),(405,'Bürobedarf > Präsentationsbedarf > Lesepulte','de-DE'),(406,'Bürobedarf > Präsentationsbedarf > Präsentationsfernbedienungen','de-DE'),(407,'Bürobedarf > Präsentationsbedarf > Schreibtafeln','de-DE'),(408,'Bürobedarf > Präsentationsbedarf > Whiteboards','de-DE'),(409,'Bürobedarf > Schreibtischunterlagen','de-DE'),(410,'Bürobedarf > Schreibwaren','de-DE'),(411,'Bürobedarf > Schreibwaren > Büroklammern & Papierklammern','de-DE'),(412,'Bürobedarf > Schreibwaren > Büroklebeband','de-DE'),(413,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder','de-DE'),(414,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Adressaufkleber','de-DE'),(415,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Klebebänder für Etikettiergeräte','de-DE'),(416,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Label Clips','de-DE'),(417,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Trennblätter','de-DE'),(418,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Versandanhänger','de-DE'),(419,'Bürobedarf > Schreibwaren > Etiketten & Anhängerschilder > Versandaufkleber & -etiketten','de-DE'),(420,'Bürobedarf > Schreibwaren > Gummibänder','de-DE'),(421,'Bürobedarf > Schreibwaren > Heftklammern','de-DE'),(422,'Bürobedarf > Schreibwaren > Klebepads','de-DE'),(423,'Bürobedarf > Schreibwaren > Korrekturflüssigkeiten, Korrekturstifte & Korrekturbänder','de-DE'),(424,'Bürobedarf > Schreibwaren > Laminierfolie & Schutzhüllen','de-DE'),(425,'Bürobedarf > Schreibwaren > Musterklammern','de-DE'),(426,'Bürobedarf > Schreibwaren > Papierprodukte','de-DE'),(427,'Bürobedarf > Schreibwaren > Papierprodukte > Blanko-Ausweise','de-DE'),(428,'Bürobedarf > Schreibwaren > Papierprodukte > Briefpapier','de-DE'),(429,'Bürobedarf > Schreibwaren > Papierprodukte > Briefumschläge','de-DE'),(430,'Bürobedarf > Schreibwaren > Papierprodukte > Drucker- & Kopierpapier','de-DE'),(431,'Bürobedarf > Schreibwaren > Papierprodukte > Feinkarton','de-DE'),(432,'Bürobedarf > Schreibwaren > Papierprodukte > Geschäftsformulare & -belege','de-DE'),(433,'Bürobedarf > Schreibwaren > Papierprodukte > Haftnotizen','de-DE'),(434,'Bürobedarf > Schreibwaren > Papierprodukte > Karteikarten','de-DE'),(435,'Bürobedarf > Schreibwaren > Papierprodukte > Kassenrollen','de-DE'),(436,'Bürobedarf > Schreibwaren > Papierprodukte > Notizbücher & Notizblöcke','de-DE'),(437,'Bürobedarf > Schreibwaren > Papierprodukte > Papier für Hefter','de-DE'),(438,'Bürobedarf > Schreibwaren > Papierprodukte > Postkarten','de-DE'),(439,'Bürobedarf > Schreibwaren > Papierprodukte > Scheckformulare','de-DE'),(440,'Bürobedarf > Schreibwaren > Papierprodukte > Visitenkarten','de-DE'),(441,'Bürobedarf > Schreibwaren > Radiergummis','de-DE'),(442,'Bürobedarf > Schreibwaren > Reißzwecken & Pins','de-DE'),(443,'Bürobedarf > Versandbedarf','de-DE'),(444,'Bürobedarf > Versandbedarf > Packband','de-DE'),(445,'Bürobedarf > Versandbedarf > Umzugs- & Versandkartons','de-DE'),(446,'Bürobedarf > Versandbedarf > Verpackungsmaterialien','de-DE'),(447,'Elektronik','de-DE'),(448,'Elektronik > Audio','de-DE'),(449,'Elektronik > Audio > Audiokomponenten','de-DE'),(450,'Elektronik > Audio > Audiokomponenten > AV-Receiver','de-DE'),(451,'Elektronik > Audio > Audiokomponenten > Audiomixer','de-DE'),(452,'Elektronik > Audio > Audiokomponenten > Audiotransmitter','de-DE'),(453,'Elektronik > Audio > Audiokomponenten > Audiotransmitter > Bluetooth-Sender','de-DE'),(454,'Elektronik > Audio > Audiokomponenten > Audiotransmitter > FM-Transmitter','de-DE'),(455,'Elektronik > Audio > Audiokomponenten > Audioverstärker','de-DE'),(456,'Elektronik > Audio > Audiokomponenten > Audioverstärker > Kopfhörerverstärker','de-DE'),(457,'Elektronik > Audio > Audiokomponenten > Audioverstärker > Stereoverstärker','de-DE'),(458,'Elektronik > Audio > Audiokomponenten > Channel Strips','de-DE'),(459,'Elektronik > Audio > Audiokomponenten > DI-Boxen','de-DE'),(460,'Elektronik > Audio > Audiokomponenten > Kopfhörer & Headsets','de-DE'),(461,'Elektronik > Audio > Audiokomponenten > Lautsprecher','de-DE'),(462,'Elektronik > Audio > Audiokomponenten > Mikrofone','de-DE'),(463,'Elektronik > Audio > Audiokomponenten > Signalprozessoren','de-DE'),(464,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Effektprozessoren','de-DE'),(465,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Equalizer','de-DE'),(466,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Frequenzweichen','de-DE'),(467,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Mikrofonvorverstärker','de-DE'),(468,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Noise Gates & Kompressoren','de-DE'),(469,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Phono-Vorverstärker','de-DE'),(470,'Elektronik > Audio > Audiokomponenten > Signalprozessoren > Steuerungssysteme für PA-Anlagen','de-DE'),(471,'Elektronik > Audio > Audiokomponenten > Studio-Aufnahmesets','de-DE'),(472,'Elektronik > Audio > Audioplayer & -rekorder','de-DE'),(473,'Elektronik > Audio > Audioplayer & -rekorder > CD-Player & -Rekorder','de-DE'),(474,'Elektronik > Audio > Audioplayer & -rekorder > Diktiergeräte','de-DE'),(475,'Elektronik > Audio > Audioplayer & -rekorder > Ghettoblaster','de-DE'),(476,'Elektronik > Audio > Audioplayer & -rekorder > Heimkinosysteme','de-DE'),(477,'Elektronik > Audio > Audioplayer & -rekorder > Jukeboxen','de-DE'),(478,'Elektronik > Audio > Audioplayer & -rekorder > Karaokesysteme','de-DE'),(479,'Elektronik > Audio > Audioplayer & -rekorder > Kassettenspieler & -Rekorder','de-DE'),(480,'Elektronik > Audio > Audioplayer & -rekorder > MP3-Player','de-DE'),(481,'Elektronik > Audio > Audioplayer & -rekorder > Mehrspurrekorder','de-DE'),(482,'Elektronik > Audio > Audioplayer & -rekorder > MiniDisc-Player','de-DE'),(483,'Elektronik > Audio > Audioplayer & -rekorder > Plattenspieler','de-DE'),(484,'Elektronik > Audio > Audioplayer & -rekorder > Radios','de-DE'),(485,'Elektronik > Audio > Audioplayer & -rekorder > Stereoanlagen','de-DE'),(486,'Elektronik > Audio > Audioplayer & -rekorder > Tonbandgeräte','de-DE'),(487,'Elektronik > Audio > Audiozubehör','de-DE'),(488,'Elektronik > Audio > Audiozubehör > Audio- & Video-Receiver-Zubehör','de-DE'),(489,'Elektronik > Audio > Audiozubehör > Kopfhörer- & Headset-Zubehör','de-DE'),(490,'Elektronik > Audio > Audiozubehör > Kopfhörer- & Headset-Zubehör > Kopfhörer- & In-Ear-Ohrhörer-Polster','de-DE'),(491,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör','de-DE'),(492,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör > Bass-Shaker','de-DE'),(493,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör > Lautsprecherkomponenten & -sets','de-DE'),(494,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör > Lautsprecherständer','de-DE'),(495,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör > Lautsprechertaschen, -abdeckungen & -cases','de-DE'),(496,'Elektronik > Audio > Audiozubehör > Lautsprecherzubehör > Taschen für Lautsprecherständer','de-DE'),(497,'Elektronik > Audio > Audiozubehör > Mikrofonständer','de-DE'),(498,'Elektronik > Audio > Audiozubehör > Mikrofonzubehör','de-DE'),(499,'Elektronik > Audio > Audiozubehör > Plattenspielerzubehör','de-DE'),(500,'Elektronik > Audio > Audiozubehör > Satellitenradio-Zubehör','de-DE'),(501,'Elektronik > Audio > Audiozubehör > Zubehör für Karaoke-Systeme','de-DE'),(502,'Elektronik > Audio > Audiozubehör > Zubehör für Karaoke-Systeme > Karaoke-Speicherchips','de-DE'),(503,'Elektronik > Audio > Audiozubehör > Zubehör für MP3-Player','de-DE'),(504,'Elektronik > Audio > Audiozubehör > Zubehör für MP3-Player > MP3-Player-Taschen','de-DE'),(505,'Elektronik > Audio > Audiozubehör > Zubehör für MP3-Player > Zubehörsets für MP3-Player & Mobiltelefone','de-DE'),(506,'Elektronik > Audio > Beschallungsanlagen','de-DE'),(507,'Elektronik > Audio > Bühnenausstattung','de-DE'),(508,'Elektronik > Audio > Bühnenausstattung > Drahtlossender','de-DE'),(509,'Elektronik > Audio > DJ- & Spezialaudiogeräte','de-DE'),(510,'Elektronik > Audio > DJ- & Spezialaudiogeräte > DJ CD-Player','de-DE'),(511,'Elektronik > Audio > DJ- & Spezialaudiogeräte > DJ Systeme','de-DE'),(512,'Elektronik > Audio > Megafone','de-DE'),(513,'Elektronik > Computer','de-DE'),(514,'Elektronik > Computer > Barebone-Computer','de-DE'),(515,'Elektronik > Computer > Computerserver','de-DE'),(516,'Elektronik > Computer > Datenbrillen','de-DE'),(517,'Elektronik > Computer > Desktop-Computer','de-DE'),(518,'Elektronik > Computer > E-Book-Reader & Handheld-Computer','de-DE'),(519,'Elektronik > Computer > E-Book-Reader & Handheld-Computer > Datenerfassungsgeräte','de-DE'),(520,'Elektronik > Computer > E-Book-Reader & Handheld-Computer > E-Book-Reader','de-DE'),(521,'Elektronik > Computer > E-Book-Reader & Handheld-Computer > PDAs','de-DE'),(522,'Elektronik > Computer > Interaktive Kioske','de-DE'),(523,'Elektronik > Computer > Laptops','de-DE'),(524,'Elektronik > Computer > Multitouch-Tischcomputer','de-DE'),(525,'Elektronik > Computer > Tablet-PCs','de-DE'),(526,'Elektronik > Computer > Thin Clients & Zero Clients','de-DE'),(527,'Elektronik > Drucken, Kopieren, Scannen & Faxen','de-DE'),(528,'Elektronik > Drucken, Kopieren, Scannen & Faxen > 3D-Drucker','de-DE'),(529,'Elektronik > Drucken, Kopieren, Scannen & Faxen > 3D-Drucker-Zubehör','de-DE'),(530,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Drucker, Kopierer & Faxgeräte','de-DE'),(531,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Scanner','de-DE'),(532,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Scannerzubehör','de-DE'),(533,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte','de-DE'),(534,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Duplexeinheiten','de-DE'),(535,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial','de-DE'),(536,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Drucker-Farbbänder','de-DE'),(537,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Druckerfilter','de-DE'),(538,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Druckertrommeln & Sets','de-DE'),(539,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Druckerwartungssets','de-DE'),(540,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Druckköpfe','de-DE'),(541,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Toner & Tintenpatronen','de-DE'),(542,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Drucker-Verbrauchsmaterial > Toner- & Inkjet-Kartuschen','de-DE'),(543,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Druckerspeicher','de-DE'),(544,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Druckertische','de-DE'),(545,'Elektronik > Drucken, Kopieren, Scannen & Faxen > Zubehör für Drucker, Kopierer & Faxgeräte > Ersatzteile für Drucker, Kopierer & Faxgeräte','de-DE'),(546,'Elektronik > Elektrische Instrumente Seefahrt','de-DE'),(547,'Elektronik > Elektrische Instrumente Seefahrt > Audio- und Videoemfpänger','de-DE'),(548,'Elektronik > Elektrische Instrumente Seefahrt > Fischfinder','de-DE'),(549,'Elektronik > Elektrische Instrumente Seefahrt > Marine-Lautsprecher','de-DE'),(550,'Elektronik > Elektrische Instrumente Seefahrt > Schiffsradar','de-DE'),(551,'Elektronik > Elektrische Instrumente Seefahrt > Seefunkgeräte','de-DE'),(552,'Elektronik > Elektrische Instrumente Seefahrt > Seekartenplotter & GPS','de-DE'),(553,'Elektronik > Elektronische Leiterplatten & Bauteile','de-DE'),(554,'Elektronik > Elektronische Leiterplatten & Bauteile > Decoder & Encoder für Schaltkreise','de-DE'),(555,'Elektronik > Elektronische Leiterplatten & Bauteile > Elektronische Filter','de-DE'),(556,'Elektronik > Elektronische Leiterplatten & Bauteile > Halbleiter','de-DE'),(557,'Elektronik > Elektronische Leiterplatten & Bauteile > Halbleiter > Dioden','de-DE'),(558,'Elektronik > Elektronische Leiterplatten & Bauteile > Halbleiter > Integrierte Schaltkreise & Chips','de-DE'),(559,'Elektronik > Elektronische Leiterplatten & Bauteile > Halbleiter > Mikrocontroller','de-DE'),(560,'Elektronik > Elektronische Leiterplatten & Bauteile > Halbleiter > Transistoren','de-DE'),(561,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten','de-DE'),(562,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Computer-Leiterplatten','de-DE'),(563,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Computer-Leiterplatten > Computer-Inverterplatine','de-DE'),(564,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Computer-Leiterplatten > Festplatten-Leiterplatten','de-DE'),(565,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Computer-Leiterplatten > Motherboards','de-DE'),(566,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Entwicklungsboard','de-DE'),(567,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Kamera-Leiterplatten','de-DE'),(568,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Drucker, Kopierer & Faxgeräte','de-DE'),(569,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Fernsehgeräte','de-DE'),(570,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Fitnessgeräte','de-DE'),(571,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Haushaltsgeräte','de-DE'),(572,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Pools und Spas','de-DE'),(573,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplatten > Leiterplatten für Scanner','de-DE'),(574,'Elektronik > Elektronische Leiterplatten & Bauteile > Leiterplattenzubehör','de-DE'),(575,'Elektronik > Elektronische Leiterplatten & Bauteile > Passive elektronische Bauelemente','de-DE'),(576,'Elektronik > Elektronische Leiterplatten & Bauteile > Passive elektronische Bauelemente > Induktoren','de-DE'),(577,'Elektronik > Elektronische Leiterplatten & Bauteile > Passive elektronische Bauelemente > Kondensatoren','de-DE'),(578,'Elektronik > Elektronische Leiterplatten & Bauteile > Passive elektronische Bauelemente > Oszillatoren','de-DE'),(579,'Elektronik > Elektronische Leiterplatten & Bauteile > Passive elektronische Bauelemente > Widerstände','de-DE'),(580,'Elektronik > Elektronische Leiterplatten & Bauteile > Platinenentwicklung','de-DE'),(581,'Elektronik > Elektronische Leiterplatten & Bauteile > Platinenentwicklung > Steckplatinen','de-DE'),(582,'Elektronik > Elektronisches Zubehör','de-DE'),(583,'Elektronik > Elektronisches Zubehör > Adapter','de-DE'),(584,'Elektronik > Elektronisches Zubehör > Adapter > Audio/Video-Adapter','de-DE'),(585,'Elektronik > Elektronisches Zubehör > Adapter > Speicheradapter','de-DE'),(586,'Elektronik > Elektronisches Zubehör > Adapter > USB-Adapter','de-DE'),(587,'Elektronik > Elektronisches Zubehör > Antennen','de-DE'),(588,'Elektronik > Elektronisches Zubehör > Antennenzubehör','de-DE'),(589,'Elektronik > Elektronisches Zubehör > Antennenzubehör > Antennenhalterungen & -befestigungen','de-DE'),(590,'Elektronik > Elektronisches Zubehör > Antennenzubehör > Dreheinrichtungen','de-DE'),(591,'Elektronik > Elektronisches Zubehör > Antennenzubehör > Satelliten-LNBs','de-DE'),(592,'Elektronik > Elektronisches Zubehör > Audio- und Video-Splitter & -Switches','de-DE'),(593,'Elektronik > Elektronisches Zubehör > Audio- und Video-Splitter & -Switches > DVI-Splitter und -Switches','de-DE'),(594,'Elektronik > Elektronisches Zubehör > Audio- und Video-Splitter & -Switches > HDMI-Splitter & -Switches','de-DE'),(595,'Elektronik > Elektronisches Zubehör > Audio- und Video-Splitter & -Switches > VGA-Splitter und -Switches','de-DE'),(596,'Elektronik > Elektronisches Zubehör > Computerkomponenten','de-DE'),(597,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Blade-Server-Gehäuse','de-DE'),(598,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Backplates & I/O Shields','de-DE'),(599,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Kühlkomponenten','de-DE'),(600,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Starter-Kits','de-DE'),(601,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten','de-DE'),(602,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten > Computer-Steckkarten & -Adapter','de-DE'),(603,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten > Grafikkarten & Videoadapter','de-DE'),(604,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten > Riser-Karten','de-DE'),(605,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten > Soundkarten','de-DE'),(606,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computer-Steckkarten > TV-Karten und -Adapter','de-DE'),(607,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computernetzteile','de-DE'),(608,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Computerregale & -Befestigungssysteme','de-DE'),(609,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte','de-DE'),(610,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Computer Mäuse & Trackballs','de-DE'),(611,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Digitale Stifte','de-DE'),(612,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Eingabegeräte zur Gestensteuerung','de-DE'),(613,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Elektronische Kartenlesegeräte','de-DE'),(614,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Fingerabdruck-Lesegeräte','de-DE'),(615,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Gamecontroller','de-DE'),(616,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Grafiktabletts','de-DE'),(617,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > KVM-Switches','de-DE'),(618,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Speicherkartenlesegerät','de-DE'),(619,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Strichcode-Scanner','de-DE'),(620,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Tastaturen','de-DE'),(621,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Touchpads','de-DE'),(622,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Eingabegeräte > Ziffernblöcke','de-DE'),(623,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Ersatzteile für E-Book-Reader','de-DE'),(624,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Ersatzteile für E-Book-Reader > Ersatzbildschirme für E-Book-Reader','de-DE'),(625,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile','de-DE'),(626,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Bildschirmdigitalisierer','de-DE'),(627,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Ersatzbildschirme','de-DE'),(628,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Ersatzkabel','de-DE'),(629,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Ersatzlautsprecher','de-DE'),(630,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Ersatztastaturen','de-DE'),(631,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptop-Scharniere','de-DE'),(632,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Laptopteile > Laptopgehäuse','de-DE'),(633,'Elektronik > Elektronisches Zubehör > Computerkomponenten > PC-Gehäuse','de-DE'),(634,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Prozessoren','de-DE'),(635,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte','de-DE'),(636,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Bandlaufwerke','de-DE'),(637,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Datenspeicher-Duplizierer','de-DE'),(638,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Datenspeicher-Duplizierer > CD-/DVD-Brenner','de-DE'),(639,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Datenspeicher-Duplizierer > Festplatten-Duplizierer','de-DE'),(640,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Datenspeicher-Duplizierer > USB-Laufwerk-Duplizierer','de-DE'),(641,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Disk-Arrays','de-DE'),(642,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Diskettenlaufwerke','de-DE'),(643,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Festplatten','de-DE'),(644,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Festplattenzubehör','de-DE'),(645,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Festplattenzubehör > Festplatten-Dockingstationen','de-DE'),(646,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Festplattenzubehör > Festplatten-Transporttaschen','de-DE'),(647,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Festplattenzubehör > Festplattengehäuse & -steckplätze','de-DE'),(648,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Netzwerkspeichersysteme','de-DE'),(649,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > Optische Laufwerke','de-DE'),(650,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Speichergeräte > USB-Massenspeicher','de-DE'),(651,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Tablet-PC-Ersatzteile','de-DE'),(652,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Tablet-PC-Ersatzteile > Tablet-Bildschirme und Bildschirm-Digitizer','de-DE'),(653,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Tablet-PC-Ersatzteile > Tablet-Ersatzlautsprecher','de-DE'),(654,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Tablet-PC-Ersatzteile > Tablet-Gehäuse & -Rahmen','de-DE'),(655,'Elektronik > Elektronisches Zubehör > Computerkomponenten > USB- & FireWire-Hubs','de-DE'),(656,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Zubehör für Eingabegeräte','de-DE'),(657,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Zubehör für Eingabegeräte > Halterung für Strichcodeleser','de-DE'),(658,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Zubehör für Eingabegeräte > Mäuse und Trackball-Zubehör','de-DE'),(659,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Zubehör für Eingabegeräte > Tastaturtasten & -kappen','de-DE'),(660,'Elektronik > Elektronisches Zubehör > Computerkomponenten > Zubehör für Eingabegeräte > Zubehör für Gamecontroller','de-DE'),(661,'Elektronik > Elektronisches Zubehör > Computerzubehör','de-DE'),(662,'Elektronik > Elektronisches Zubehör > Computerzubehör > Computer-Monitorständer','de-DE'),(663,'Elektronik > Elektronisches Zubehör > Computerzubehör > Computer-Schutzhüllen','de-DE'),(664,'Elektronik > Elektronisches Zubehör > Computerzubehör > Computerzubehör-Sets','de-DE'),(665,'Elektronik > Elektronisches Zubehör > Computerzubehör > Ersatzspitzen für Stylus Pens','de-DE'),(666,'Elektronik > Elektronisches Zubehör > Computerzubehör > Laptop-Dockingstationen','de-DE'),(667,'Elektronik > Elektronisches Zubehör > Computerzubehör > Mousepads','de-DE'),(668,'Elektronik > Elektronisches Zubehör > Computerzubehör > Stylus Pens','de-DE'),(669,'Elektronik > Elektronisches Zubehör > Computerzubehör > Ständer für Tablet-PCs','de-DE'),(670,'Elektronik > Elektronisches Zubehör > Computerzubehör > Tastatur- & Maus-Handballenauflage','de-DE'),(671,'Elektronik > Elektronisches Zubehör > Computerzubehör > Tastaturablagen','de-DE'),(672,'Elektronik > Elektronisches Zubehör > Computerzubehör > Zubehör für E-Book-Reader & Handheld-Computer','de-DE'),(673,'Elektronik > Elektronisches Zubehör > Computerzubehör > Zubehör für E-Book-Reader & Handheld-Computer > PDA-Zubehör','de-DE'),(674,'Elektronik > Elektronisches Zubehör > Computerzubehör > Zubehör für E-Book-Reader & Handheld-Computer > PDA-Zubehör > PDA-Taschen','de-DE'),(675,'Elektronik > Elektronisches Zubehör > Computerzubehör > Zubehör für E-Book-Reader & Handheld-Computer > Zubehör für E-Book-Reader','de-DE'),(676,'Elektronik > Elektronisches Zubehör > Computerzubehör > Zubehör für E-Book-Reader & Handheld-Computer > Zubehör für E-Book-Reader > E-Book-Reader-Taschen','de-DE'),(677,'Elektronik > Elektronisches Zubehör > Drei- und Einbeinstative für Mobiltelefone und Tablets','de-DE'),(678,'Elektronik > Elektronisches Zubehör > Elektronik-Folien & -Überzüge','de-DE'),(679,'Elektronik > Elektronisches Zubehör > Elektronik-Folien & -Überzüge > Blickschutzfilter','de-DE'),(680,'Elektronik > Elektronisches Zubehör > Elektronik-Folien & -Überzüge > Display-Schutzfolien','de-DE'),(681,'Elektronik > Elektronisches Zubehör > Elektronik-Folien & -Überzüge > Elektronik-Sticker & -Aufkleber','de-DE'),(682,'Elektronik > Elektronisches Zubehör > Elektronik-Folien & -Überzüge > Tastaturschutz','de-DE'),(683,'Elektronik > Elektronisches Zubehör > Elektronikreiniger','de-DE'),(684,'Elektronik > Elektronisches Zubehör > Fernbedienungen','de-DE'),(685,'Elektronik > Elektronisches Zubehör > Kabel','de-DE'),(686,'Elektronik > Elektronisches Zubehör > Kabel > Audio- & Videokabel','de-DE'),(687,'Elektronik > Elektronisches Zubehör > Kabel > Datenübertragungs- & Speicherkabel','de-DE'),(688,'Elektronik > Elektronisches Zubehör > Kabel > KVM-Kabel','de-DE'),(689,'Elektronik > Elektronisches Zubehör > Kabel > Netzwerkkabel','de-DE'),(690,'Elektronik > Elektronisches Zubehör > Kabel > System- & Netzkabel','de-DE'),(691,'Elektronik > Elektronisches Zubehör > Kabel > Telefonkabel','de-DE'),(692,'Elektronik > Elektronisches Zubehör > Kabel-Management','de-DE'),(693,'Elektronik > Elektronisches Zubehör > Kabel-Management > Aderhülsen & Kabelmuffen','de-DE'),(694,'Elektronik > Elektronisches Zubehör > Kabel-Management > Kabelbinder','de-DE'),(695,'Elektronik > Elektronisches Zubehör > Kabel-Management > Kabelbinderpistolen','de-DE'),(696,'Elektronik > Elektronisches Zubehör > Kabel-Management > Kabelmarkierungen','de-DE'),(697,'Elektronik > Elektronisches Zubehör > Kabel-Management > Kabelschellen','de-DE'),(698,'Elektronik > Elektronisches Zubehör > Kabel-Management > Kabelträger','de-DE'),(699,'Elektronik > Elektronisches Zubehör > Kabel-Management > Schalttafeln','de-DE'),(700,'Elektronik > Elektronisches Zubehör > Leermedien','de-DE'),(701,'Elektronik > Elektronisches Zubehör > Signalstörer','de-DE'),(702,'Elektronik > Elektronisches Zubehör > Signalstörer > GPS-Störsender','de-DE'),(703,'Elektronik > Elektronisches Zubehör > Signalstörer > Mobiltelefon-Störsender','de-DE'),(704,'Elektronik > Elektronisches Zubehör > Signalstörer > Radarstörer','de-DE'),(705,'Elektronik > Elektronisches Zubehör > Signalverstärker','de-DE'),(706,'Elektronik > Elektronisches Zubehör > Speicher','de-DE'),(707,'Elektronik > Elektronisches Zubehör > Speicher > Cache-Speicher','de-DE'),(708,'Elektronik > Elektronisches Zubehör > Speicher > Flash-Speicher','de-DE'),(709,'Elektronik > Elektronisches Zubehör > Speicher > Flash-Speicher > Flash-Speicherkarten','de-DE'),(710,'Elektronik > Elektronisches Zubehör > Speicher > RAM','de-DE'),(711,'Elektronik > Elektronisches Zubehör > Speicher > ROM','de-DE'),(712,'Elektronik > Elektronisches Zubehör > Speicher > Videospeicher','de-DE'),(713,'Elektronik > Elektronisches Zubehör > Speicherkartenzubehör','de-DE'),(714,'Elektronik > Elektronisches Zubehör > Speicherkartenzubehör > Speicherkartenetuis','de-DE'),(715,'Elektronik > Elektronisches Zubehör > Stromversorgung','de-DE'),(716,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien','de-DE'),(717,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Akkus & Batterien für schnurlose Telefone','de-DE'),(718,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Akkus für Tablet-Computer','de-DE'),(719,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Batterien für E-Book-Reader','de-DE'),(720,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Batterien für Videospielkonsolen & Game-Controller','de-DE'),(721,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Handy-Akkus','de-DE'),(722,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Kameraakkus & -batterien','de-DE'),(723,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Laptopakkus','de-DE'),(724,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > MP3-Player-Batterien','de-DE'),(725,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Mehrzweckbatterien','de-DE'),(726,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > PDA-Batterien','de-DE'),(727,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > USV-Batterien','de-DE'),(728,'Elektronik > Elektronisches Zubehör > Stromversorgung > Akkus & Batterien > Videokameraakkus & -batterien','de-DE'),(729,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör','de-DE'),(730,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör > Akkuladegeräte für Kameras','de-DE'),(731,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör > Batteriehalter','de-DE'),(732,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör > Batterieladegeräte','de-DE'),(733,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör > Laderegler','de-DE'),(734,'Elektronik > Elektronisches Zubehör > Stromversorgung > Batteriezubehör > Universal-Batterieprüfgeräte','de-DE'),(735,'Elektronik > Elektronisches Zubehör > Stromversorgung > Brennstoffzellen','de-DE'),(736,'Elektronik > Elektronisches Zubehör > Stromversorgung > Gehäuse für Stromversorgungsgeräte','de-DE'),(737,'Elektronik > Elektronisches Zubehör > Stromversorgung > Leistungsregler','de-DE'),(738,'Elektronik > Elektronisches Zubehör > Stromversorgung > Netzteil- & Ladegerätezubehör','de-DE'),(739,'Elektronik > Elektronisches Zubehör > Stromversorgung > Netzteile & Ladegeräte','de-DE'),(740,'Elektronik > Elektronisches Zubehör > Stromversorgung > Reiseadapter','de-DE'),(741,'Elektronik > Elektronisches Zubehör > Stromversorgung > Steckdosenleisten & Überspannungsschutz','de-DE'),(742,'Elektronik > Elektronisches Zubehör > Stromversorgung > USV','de-DE'),(743,'Elektronik > Elektronisches Zubehör > Stromversorgung > Zubehör für USV','de-DE'),(744,'Elektronik > Elektronisches Zubehör > Stromversorgung > Überspannungsschutzgeräte','de-DE'),(745,'Elektronik > GPS-Navigationssysteme','de-DE'),(746,'Elektronik > GPS-Tracker','de-DE'),(747,'Elektronik > GPS-Zubehör','de-DE'),(748,'Elektronik > GPS-Zubehör > GPS-Halterungen','de-DE'),(749,'Elektronik > GPS-Zubehör > GPS-Taschen','de-DE'),(750,'Elektronik > Geräte zur Mauterhebung','de-DE'),(751,'Elektronik > Kommunikationsgeräte','de-DE'),(752,'Elektronik > Kommunikationsgeräte > Anrufbeantworter','de-DE'),(753,'Elektronik > Kommunikationsgeräte > Anruferkennung','de-DE'),(754,'Elektronik > Kommunikationsgeräte > Funkgeräte','de-DE'),(755,'Elektronik > Kommunikationsgeräte > Funkgeräte > CB-Funkgeräte','de-DE'),(756,'Elektronik > Kommunikationsgeräte > Funkgeräte > Funkscanner','de-DE'),(757,'Elektronik > Kommunikationsgeräte > Funkgeräte > Funksprechgeräte','de-DE'),(758,'Elektronik > Kommunikationsgeräte > Funkzubehör','de-DE'),(759,'Elektronik > Kommunikationsgeräte > Pager','de-DE'),(760,'Elektronik > Kommunikationsgeräte > Sprechanlagen','de-DE'),(761,'Elektronik > Kommunikationsgeräte > Sprechanlagen-Zubehör','de-DE'),(762,'Elektronik > Kommunikationsgeräte > Telefone','de-DE'),(763,'Elektronik > Kommunikationsgeräte > Telefone > Konferenztelefone','de-DE'),(764,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefone','de-DE'),(765,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör','de-DE'),(766,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Auswurfhilfen für SIM-Karten','de-DE'),(767,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Ersatzteile für Mobiltelefone','de-DE'),(768,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Handy-Prepaid- & -SIM-Karten','de-DE'),(769,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Handycharms & -anhänger','de-DE'),(770,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Mobiltelefonhalterungen & -ständer','de-DE'),(771,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Mobiltelefontaschen','de-DE'),(772,'Elektronik > Kommunikationsgeräte > Telefone > Mobiltelefonzubehör > Zubehör für Mobiltelefon-Kameras','de-DE'),(773,'Elektronik > Kommunikationsgeräte > Telefone > Satellitentelefone','de-DE'),(774,'Elektronik > Kommunikationsgeräte > Telefone > Schnurlostelefone','de-DE'),(775,'Elektronik > Kommunikationsgeräte > Telefone > Schnurtelefone','de-DE'),(776,'Elektronik > Kommunikationsgeräte > Telefone > Telefonzubehör','de-DE'),(777,'Elektronik > Kommunikationsgeräte > Telefone > Telefonzubehör > Telefonkarten','de-DE'),(778,'Elektronik > Kommunikationsgeräte > Videokonferenzsysteme','de-DE'),(779,'Elektronik > Komponenten','de-DE'),(780,'Elektronik > Komponenten > Beschleunigungssensoren','de-DE'),(781,'Elektronik > Komponenten > Modulatoren','de-DE'),(782,'Elektronik > Komponenten > Splitter','de-DE'),(783,'Elektronik > Komponenten > Steckverbinder','de-DE'),(784,'Elektronik > Komponenten > Wandler','de-DE'),(785,'Elektronik > Komponenten > Wandler > Audiowandler','de-DE'),(786,'Elektronik > Komponenten > Wandler > Signalwandler','de-DE'),(787,'Elektronik > Netzwerktechnik','de-DE'),(788,'Elektronik > Netzwerktechnik > Bridges & Router','de-DE'),(789,'Elektronik > Netzwerktechnik > Bridges & Router > Netzwerk-Bridges','de-DE'),(790,'Elektronik > Netzwerktechnik > Bridges & Router > VoIP-Gateways & -Router','de-DE'),(791,'Elektronik > Netzwerktechnik > Bridges & Router > Wireless Access Points','de-DE'),(792,'Elektronik > Netzwerktechnik > Bridges & Router > Wireless Router','de-DE'),(793,'Elektronik > Netzwerktechnik > Druckerserver','de-DE'),(794,'Elektronik > Netzwerktechnik > Hubs & Schalter','de-DE'),(795,'Elektronik > Netzwerktechnik > Konzentratoren & Multiplexer','de-DE'),(796,'Elektronik > Netzwerktechnik > Modems','de-DE'),(797,'Elektronik > Netzwerktechnik > Modemzubehör','de-DE'),(798,'Elektronik > Netzwerktechnik > Netzwerkkarten','de-DE'),(799,'Elektronik > Netzwerktechnik > Netzwerksicherheitssysteme & Firewalls','de-DE'),(800,'Elektronik > Netzwerktechnik > PoE-Adapter','de-DE'),(801,'Elektronik > Netzwerktechnik > Repeater & Sende/-Empfangsgeräte','de-DE'),(802,'Elektronik > Radargeschwindigkeitsmesser','de-DE'),(803,'Elektronik > Radarwarner','de-DE'),(804,'Elektronik > Spielautomatenbedarf','de-DE'),(805,'Elektronik > Spielautomatenbedarf > Basketballspiele','de-DE'),(806,'Elektronik > Spielautomatenbedarf > Flipper','de-DE'),(807,'Elektronik > Spielautomatenbedarf > Flipper-Zubehör','de-DE'),(808,'Elektronik > Spielautomatenbedarf > Skee-Ball-Maschinen','de-DE'),(809,'Elektronik > Spielautomatenbedarf > Spielautomaten','de-DE'),(810,'Elektronik > Spielautomatenbedarf > Zubehör für Spielautomaten','de-DE'),(811,'Elektronik > Video','de-DE'),(812,'Elektronik > Video > Computermonitore','de-DE'),(813,'Elektronik > Video > Fernseher','de-DE'),(814,'Elektronik > Video > Projektoren','de-DE'),(815,'Elektronik > Video > Projektoren > Diaprojektoren','de-DE'),(816,'Elektronik > Video > Projektoren > Multimedia-Projektoren','de-DE'),(817,'Elektronik > Video > Projektoren > Overhead-Projektoren','de-DE'),(818,'Elektronik > Video > Satelliten- & Kabelfernsehen','de-DE'),(819,'Elektronik > Video > Satelliten- & Kabelfernsehen > Kabelfernsehen-Receiver','de-DE'),(820,'Elektronik > Video > Satelliten- & Kabelfernsehen > Satelliten-Receiver','de-DE'),(821,'Elektronik > Video > Video-Multiplexer','de-DE'),(822,'Elektronik > Video > Videoabspielgeräte & -rekorder','de-DE'),(823,'Elektronik > Video > Videoabspielgeräte & -rekorder > DVD- & Blu-ray-Player','de-DE'),(824,'Elektronik > Video > Videoabspielgeräte & -rekorder > DVD-Rekorder','de-DE'),(825,'Elektronik > Video > Videoabspielgeräte & -rekorder > Digitale Videorekorder','de-DE'),(826,'Elektronik > Video > Videoabspielgeräte & -rekorder > Netzwerk-Mediaplayer','de-DE'),(827,'Elektronik > Video > Videoabspielgeräte & -rekorder > Videorekorder','de-DE'),(828,'Elektronik > Video > Videobearbeitungshardware & Videoproduktionsausrüstung','de-DE'),(829,'Elektronik > Video > Videoserver','de-DE'),(830,'Elektronik > Video > Videotransmitter','de-DE'),(831,'Elektronik > Video > Videozubehör','de-DE'),(832,'Elektronik > Video > Videozubehör > 3D-Brillen','de-DE'),(833,'Elektronik > Video > Videozubehör > Computerbildschirmzubehör','de-DE'),(834,'Elektronik > Video > Videozubehör > Computerbildschirmzubehör > Farbkalibrierung','de-DE'),(835,'Elektronik > Video > Videozubehör > Projektorzubehör','de-DE'),(836,'Elektronik > Video > Videozubehör > Projektorzubehör > Projektionsleinwände','de-DE'),(837,'Elektronik > Video > Videozubehör > Projektorzubehör > Projektorersatzleuchten','de-DE'),(838,'Elektronik > Video > Videozubehör > Projektorzubehör > Projektorhalterungen','de-DE'),(839,'Elektronik > Video > Videozubehör > Projektorzubehör > Rockvorhänge für Leinwände','de-DE'),(840,'Elektronik > Video > Videozubehör > Projektorzubehör > Ständer für Projektionsflächen','de-DE'),(841,'Elektronik > Video > Videozubehör > Spulgeräte','de-DE'),(842,'Elektronik > Video > Videozubehör > TV-Zubehör','de-DE'),(843,'Elektronik > Video > Videozubehör > TV-Zubehör > Ersatzlampen für Fernseher','de-DE'),(844,'Elektronik > Video > Videozubehör > TV-Zubehör > TV- & Monitorhalterungen','de-DE'),(845,'Elektronik > Video > Videozubehör > TV-Zubehör > TV-Konverter & Receiver','de-DE'),(846,'Elektronik > Video > Videozubehör > TV-Zubehör > TV-Lautsprecher','de-DE'),(847,'Elektronik > Videospielkonsolen','de-DE'),(848,'Elektronik > Zubehör für Videospielkonsolen','de-DE'),(849,'Elektronik > Zubehör für Videospielkonsolen > Zubehör für Spielkonsolen','de-DE'),(850,'Elektronik > Zubehör für Videospielkonsolen > Zubehör für mobile Spielkonsolen','de-DE'),(851,'Fahrzeuge & Teile','de-DE'),(852,'Fahrzeuge & Teile > Fahrzeuge','de-DE'),(853,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge','de-DE'),(854,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Autos, LKWs & Lieferwagen','de-DE'),(855,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Gelände- & Allradfahrzeuge','de-DE'),(856,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Gelände- & Allradfahrzeuge > Go-Karts','de-DE'),(857,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Gelände- & Allradfahrzeuge > Quads','de-DE'),(858,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Golfwagen','de-DE'),(859,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Motorräder & -roller','de-DE'),(860,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Schneemobile','de-DE'),(861,'Fahrzeuge & Teile > Fahrzeuge > Kraftfahrzeuge > Wohnmobile','de-DE'),(862,'Fahrzeuge & Teile > Fahrzeuge > Luftfahrzeuge','de-DE'),(863,'Fahrzeuge & Teile > Fahrzeuge > Wasserfahrzeuge','de-DE'),(864,'Fahrzeuge & Teile > Fahrzeuge > Wasserfahrzeuge > Jetski','de-DE'),(865,'Fahrzeuge & Teile > Fahrzeuge > Wasserfahrzeuge > Motorboote','de-DE'),(866,'Fahrzeuge & Teile > Fahrzeuge > Wasserfahrzeuge > Segelboote','de-DE'),(867,'Fahrzeuge & Teile > Fahrzeuge > Wasserfahrzeuge > Yachten','de-DE'),(868,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör','de-DE'),(869,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit','de-DE'),(870,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > ATV- & UTV-Schutzausrüstung','de-DE'),(871,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > ATV- & UTV-Schutzausrüstung > ATV- & UTV-Griffpolster','de-DE'),(872,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme','de-DE'),(873,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Auto-Alarmanlagen','de-DE'),(874,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Fernbediente schlüssellose Systeme','de-DE'),(875,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Kfz-Türschlösser','de-DE'),(876,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Kfz-Türschlösser > Kfz-Türschlosssicherungen','de-DE'),(877,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Kfz-Türschlösser > Türknöpfe','de-DE'),(878,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Kfz-Türschlösser > Türschlösser & Schließsysteme','de-DE'),(879,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Kupplungsschlösser','de-DE'),(880,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Lenkradschlösser','de-DE'),(881,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Motorrad-Schlösser & -Alarmanlagen','de-DE'),(882,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Radkrallen','de-DE'),(883,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Wegfahrsperren','de-DE'),(884,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Auto-Alarmanlagen & Schließsysteme > Zubehör für Auto-Alarmanlagen','de-DE'),(885,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung','de-DE'),(886,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Airbagteile','de-DE'),(887,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Fensternetze','de-DE'),(888,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Gurtpolster','de-DE'),(889,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Gurtschlösser','de-DE'),(890,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Kfz-Warnflaggen','de-DE'),(891,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Sicherheitsgurtbänder','de-DE'),(892,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Sicherheitsgurte','de-DE'),(893,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Unterlegkeile','de-DE'),(894,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Warnleuchten','de-DE'),(895,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Kfz-Sicherheitsausrüstung > Überrollkäfige & -bügel','de-DE'),(896,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung','de-DE'),(897,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad-Genickschutz','de-DE'),(898,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad-Handprotektoren','de-DE'),(899,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad-Nierengurte','de-DE'),(900,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad: Brust- und Rückenprotektoren','de-DE'),(901,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad: Ellbogen- und Handgelenkschützer','de-DE'),(902,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorrad: Knie- & Schienbeinschützer','de-DE'),(903,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorradbrillen','de-DE'),(904,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorradhandschuhe','de-DE'),(905,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorradhelme','de-DE'),(906,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Fahrzeugsicherheit > Motorrad-Schutzausrüstung > Motorradhelmersatzteile & -zubehör','de-DE'),(907,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Flugzeugteile & -Zubehör','de-DE'),(908,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik','de-DE'),(909,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > A/V-Player & im Armaturenbrett integrierte Systeme für Autos','de-DE'),(910,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Audioverstärker für Autos','de-DE'),(911,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Equalizer & Frequenzweichen für Autos','de-DE'),(912,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Freisprechanlagen','de-DE'),(913,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Halterungen für Kfz-Videomonitore','de-DE'),(914,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Kassettenadapter','de-DE'),(915,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Kassettenspieler für Autos','de-DE'),(916,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Lautsprecher für Autos','de-DE'),(917,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Parkkameras für Autos','de-DE'),(918,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Elektronik > Subwoofer für Autos','de-DE'),(919,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile','de-DE'),(920,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Abschleppzubehör','de-DE'),(921,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Aufhängungsteile für Autos','de-DE'),(922,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Bodenbeläge & Polster','de-DE'),(923,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Getriebe- & Antriebsteile','de-DE'),(924,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Auspuff','de-DE'),(925,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Beleuchtung','de-DE'),(926,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Bremsen','de-DE'),(927,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Elektroniksysteme','de-DE'),(928,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Innenausstattung','de-DE'),(929,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Klimatisierung','de-DE'),(930,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Motoren','de-DE'),(931,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Motorteile','de-DE'),(932,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder','de-DE'),(933,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Felgen & Reifen für Kfz','de-DE'),(934,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Felgen & Reifen für Kfz > Autofelgen & -räder','de-DE'),(935,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Felgen & Reifen für Kfz > Felgen & Räder für ATV & UTV','de-DE'),(936,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Felgen & Reifen für Kfz > Motorradfelgen & -räder','de-DE'),(937,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Radteile','de-DE'),(938,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Reifen','de-DE'),(939,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Reifen > Autoreifen','de-DE'),(940,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Reifen > Motorradreifen','de-DE'),(941,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Reifen > Reifen für ATV & UTV','de-DE'),(942,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Räder > Kfz-Reifenzubehör','de-DE'),(943,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Sensoren & -Messinstrumente','de-DE'),(944,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Sitze','de-DE'),(945,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Spiegel','de-DE'),(946,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kfz-Steuerelemente','de-DE'),(947,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Kraftstoffanlagen','de-DE'),(948,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Rahmen- & Karosserieteile','de-DE'),(949,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Teile für Kfz-Fenster','de-DE'),(950,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Teile > Teile für Kfz-Ölkreislauf','de-DE'),(951,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege','de-DE'),(952,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen','de-DE'),(953,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeug-Hardtops','de-DE'),(954,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen','de-DE'),(955,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen > Bootsabdeckplanen','de-DE'),(956,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen > Golfcart-Abdeckplanen','de-DE'),(957,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen > Kfz-Abdeckplanen','de-DE'),(958,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen > Motorradabdeckplanen','de-DE'),(959,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugabdeckplanen > Unterstände & Abdeckungen für Wohnmobile','de-DE'),(960,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Fahrzeugverdecke','de-DE'),(961,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Golfcart-Gehäuse','de-DE'),(962,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Ladeflächenabdeckungen','de-DE'),(963,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugabdeckungen > Windschutzscheiben-Abdeckungen','de-DE'),(964,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeuglack','de-DE'),(965,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeuglack > Bremssattellack','de-DE'),(966,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeuglack > Rahmen- & Karosserielack','de-DE'),(967,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung','de-DE'),(968,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Autowaschbürsten','de-DE'),(969,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Autowaschmittel','de-DE'),(970,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Einspritzanlagenreinigungs-Sets','de-DE'),(971,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Fahrzeug-Glasreiniger','de-DE'),(972,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Kfz-Teppich- & Polsterreiniger','de-DE'),(973,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreinigung > Wachse, Polituren & Schutzmittel für Fahrzeuge','de-DE'),(974,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge','de-DE'),(975,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Aufladegeräte für Fahrzeugbatterien','de-DE'),(976,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Fahrzeugbatterie-Prüfgeräte','de-DE'),(977,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Fahrzeugdiagnosegeräte','de-DE'),(978,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Karosseriedichtmasse','de-DE'),(979,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Kfz-Bremsreparatur-Sets','de-DE'),(980,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Kfz-Starthilfen','de-DE'),(981,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Kfz-Überbrückungskabel','de-DE'),(982,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Werkzeuge für Kupplungsausrichtung & -ausbau','de-DE'),(983,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Werkzeuge für Reifenreparatur & -wechsel','de-DE'),(984,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Fahrzeugreparatur- & Spezialwerkzeuge > Windschutzscheibenreparatursets','de-DE'),(985,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor','de-DE'),(986,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Abdeckungen für Anhängerkupplungen','de-DE'),(987,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Autofolien','de-DE'),(988,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Fahrzeug-Außendesigns','de-DE'),(989,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Fahrzeug-Dekosets','de-DE'),(990,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Fahrzeug-Embleme','de-DE'),(991,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kennzeichen','de-DE'),(992,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kennzeichenhalterungen','de-DE'),(993,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kennzeichenrahmen','de-DE'),(994,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Antennenbälle','de-DE'),(995,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Armaturenbrett-Zubehör','de-DE'),(996,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Aufkleber','de-DE'),(997,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Fahnen','de-DE'),(998,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Kennzeichenabdeckungen','de-DE'),(999,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Kfz-Lufterfrischer','de-DE'),(1000,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Lenkradbezüge','de-DE'),(1001,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Magnete','de-DE'),(1002,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Rückspiegel-Deko','de-DE'),(1003,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Schalthebelverkleidung','de-DE'),(1004,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Dekor > Schaltknäufe','de-DE'),(1005,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten','de-DE'),(1006,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Benzin- & Ölzusätze','de-DE'),(1007,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Bremsflüssigkeit','de-DE'),(1008,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Flüssigkeit für hydraulische Kupplungen','de-DE'),(1009,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Frostschutzmittel','de-DE'),(1010,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Getriebeöl','de-DE'),(1011,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Kfz-Schmierstoffe','de-DE'),(1012,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Kühlsystemadditive','de-DE'),(1013,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Motorreiniger','de-DE'),(1014,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Motoröl','de-DE'),(1015,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Servolenkflüssigkeit','de-DE'),(1016,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Tankreiniger','de-DE'),(1017,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kfz-Flüssigkeiten > Wischwasser','de-DE'),(1018,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Kfz-Wartung & -Pflege > Kraftstoffkanister','de-DE'),(1019,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme','de-DE'),(1020,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Boxen & Sortiersysteme für Ladeflächen','de-DE'),(1021,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Bügel & Haken für Kopfstützen','de-DE'),(1022,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Anhänger','de-DE'),(1023,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Anhänger > Bootsanhänger','de-DE'),(1024,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Anhänger > Kleinanhänger & Transportanhänger','de-DE'),(1025,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Anhänger > Pferde- & Viehanhänger','de-DE'),(1026,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Anhänger > Wohnwagen','de-DE'),(1027,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger','de-DE'),(1028,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogepäckträger für Angelruten','de-DE'),(1029,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogepäckträger für Kanus & Kajaks','de-DE'),(1030,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogepäckträger für Motorräder & Motorroller','de-DE'),(1031,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogepäckträger für Skier & Snowboards','de-DE'),(1032,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogepäckträger für Surfbretter','de-DE'),(1033,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Autogewehrhalter','de-DE'),(1034,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Fahrradträger','de-DE'),(1035,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Gepäckträger','de-DE'),(1036,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträger > Grundgestelle für Autogepäckträger','de-DE'),(1037,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträgerzubehör','de-DE'),(1038,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträgerzubehör > Fahrradträgerzubehör','de-DE'),(1039,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Gepäckträgerzubehör > Ski- & Snowboardträger-Zubehör','de-DE'),(1040,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Kfz-Ladenetze','de-DE'),(1041,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Laderampen','de-DE'),(1042,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Motorradtaschen & -koffer','de-DE'),(1043,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Stauraum- & Transportsysteme > Utensilientaschen fürs Auto','de-DE'),(1044,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör','de-DE'),(1045,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern','de-DE'),(1046,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Anker','de-DE'),(1047,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Ankerketten','de-DE'),(1048,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Ankerleinen & -seile','de-DE'),(1049,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Ankerwinden','de-DE'),(1050,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Bootshaken','de-DE'),(1051,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Bootsleitern','de-DE'),(1052,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Klampen & Klemmen','de-DE'),(1053,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Anlegen & Ankern > Stufentritte','de-DE'),(1054,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Beleuchtung für Wasserfahrzeuge','de-DE'),(1055,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Kraftstoffsysteme für Wasserfahrzeuge','de-DE'),(1056,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Kraftstoffsysteme für Wasserfahrzeuge > Benzinuhren für Wasserfahrzeuge','de-DE'),(1057,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Kraftstoffsysteme für Wasserfahrzeuge > Kraftstoffleitungen & Teile für Wasserfahrzeuge','de-DE'),(1058,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Kraftstoffsysteme für Wasserfahrzeuge > Kraftstoffpumpen & Teile für Wasserfahrzeuge','de-DE'),(1059,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Kraftstoffsysteme für Wasserfahrzeuge > Kraftstofftanks & Teile für Wasserfahrzeuge','de-DE'),(1060,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Segelbootteile','de-DE'),(1061,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugantriebe & -motoren','de-DE'),(1062,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugauspuffteile','de-DE'),(1063,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugauspuffteile > Schalldämpfer & Teile für Wasserfahrzeuge','de-DE'),(1064,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugauspuffteile > Wasserfahrzeugkrümmer','de-DE'),(1065,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile','de-DE'),(1066,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Motorlager für Wasserfahrzeuge','de-DE'),(1067,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Motorschlösser für Wasserfahrzeuge','de-DE'),(1068,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeug Laufrad','de-DE'),(1069,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeug-Zündungsteile','de-DE'),(1070,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeugkolben & Teile','de-DE'),(1071,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeuglichtmaschinen','de-DE'),(1072,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeugmotorsteuerung','de-DE'),(1073,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeugpropeller','de-DE'),(1074,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugmotorteile > Wasserfahrzeugvergaser & Teile','de-DE'),(1075,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugpflege','de-DE'),(1076,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugpflege > Wasserfahrzeugpolituren','de-DE'),(1077,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugpflege > Wasserfahrzeugreiniger','de-DE'),(1078,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugsteuerung','de-DE'),(1079,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugsteuerung > Steuerkabel für Wasserfahrzeuge','de-DE'),(1080,'Fahrzeuge & Teile > Fahrzeugersatzteile & -zubehör > Wasserfahrzeugteile & Zubehör > Wasserfahrzeugsteuerung > Steuerräder für Wasserfahrzeuge','de-DE'),(1081,'Für Erwachsene','de-DE'),(1082,'Für Erwachsene > Erotik','de-DE'),(1083,'Für Erwachsene > Erotik > Erotikbücher','de-DE'),(1084,'Für Erwachsene > Erotik > Erotische DVDs & Videos','de-DE'),(1085,'Für Erwachsene > Erotik > Erotische Kleidung','de-DE'),(1086,'Für Erwachsene > Erotik > Erotische Lebensmittel & Esswaren','de-DE'),(1087,'Für Erwachsene > Erotik > Erotische Spiele','de-DE'),(1088,'Für Erwachsene > Erotik > Erotische Zeitschriften','de-DE'),(1089,'Für Erwachsene > Erotik > Pole Dance-Tanzstangenkits','de-DE'),(1090,'Für Erwachsene > Erotik > Sexspielzeug','de-DE'),(1091,'Für Erwachsene > Waffen','de-DE'),(1092,'Für Erwachsene > Waffen > Elektroschockpistolen & Taser-Waffen','de-DE'),(1093,'Für Erwachsene > Waffen > Fechtwaffen','de-DE'),(1094,'Für Erwachsene > Waffen > Hieb- und Stichwaffen','de-DE'),(1095,'Für Erwachsene > Waffen > Kampfmesser','de-DE'),(1096,'Für Erwachsene > Waffen > Nunchakus','de-DE'),(1097,'Für Erwachsene > Waffen > Peitschen','de-DE'),(1098,'Für Erwachsene > Waffen > Schlagringe','de-DE'),(1099,'Für Erwachsene > Waffen > Schlagstockwaffen','de-DE'),(1100,'Für Erwachsene > Waffen > Schusswaffen','de-DE'),(1101,'Für Erwachsene > Waffen > Schusswaffenzubehör','de-DE'),(1102,'Für Erwachsene > Waffen > Schusswaffenzubehör > Material & Ausrüstung zum Nachladen von Schusswaffen','de-DE'),(1103,'Für Erwachsene > Waffen > Schusswaffenzubehör > Material & Ausrüstung zum Nachladen von Schusswaffen > Ladepressen','de-DE'),(1104,'Für Erwachsene > Waffen > Schusswaffenzubehör > Munition','de-DE'),(1105,'Für Erwachsene > Waffen > Schusswaffenzubehör > Munitionskisten & -halter','de-DE'),(1106,'Für Erwachsene > Waffen > Schusswaffenzubehör > Picatinny-Schienen','de-DE'),(1107,'Für Erwachsene > Waffen > Schusswaffenzubehör > Pistolentaschen','de-DE'),(1108,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffengriffe','de-DE'),(1109,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffengurte','de-DE'),(1110,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffenreinigung','de-DE'),(1111,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffenreinigung > Schusswaffen-Reinigungsmittel','de-DE'),(1112,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffenreinigung > Schusswaffen-Reinigungspatches','de-DE'),(1113,'Für Erwachsene > Waffen > Schusswaffenzubehör > Schusswaffenreinigung > Schusswaffen-Reinigungstücher','de-DE'),(1114,'Für Erwachsene > Waffen > Schusswaffenzubehör > Waffenkoffer und -taschen','de-DE'),(1115,'Für Erwachsene > Waffen > Schusswaffenzubehör > Waffenleuchten','de-DE'),(1116,'Für Erwachsene > Waffen > Speerwaffen','de-DE'),(1117,'Für Erwachsene > Waffen > Tränengas & Pfefferspray','de-DE'),(1118,'Für Erwachsene > Waffen > Wurfsterne','de-DE'),(1119,'Gesundheit & Schönheit','de-DE'),(1120,'Gesundheit & Schönheit > Gesundheitspflege','de-DE'),(1121,'Gesundheit & Schönheit > Gesundheitspflege > Akupunktur','de-DE'),(1122,'Gesundheit & Schönheit > Gesundheitspflege > Akupunktur > Akupunkturmodelle','de-DE'),(1123,'Gesundheit & Schönheit > Gesundheitspflege > Akupunktur > Akupunkturnadeln','de-DE'),(1124,'Gesundheit & Schönheit > Gesundheitspflege > Amputationsstrümpfe','de-DE'),(1125,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin','de-DE'),(1126,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin > CPAP-Geräte','de-DE'),(1127,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin > CPAP-Masken','de-DE'),(1128,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin > Dampfinhalatoren','de-DE'),(1129,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin > Inhalatoren','de-DE'),(1130,'Gesundheit & Schönheit > Gesundheitspflege > Beatmungsmedizin > Sauerstoffbehälter','de-DE'),(1131,'Gesundheit & Schönheit > Gesundheitspflege > Behälter für Verhütungsmittel','de-DE'),(1132,'Gesundheit & Schönheit > Gesundheitspflege > Bettpfannen','de-DE'),(1133,'Gesundheit & Schönheit > Gesundheitspflege > Ergo- & Physiotherapeutische Hilfsmittel','de-DE'),(1134,'Gesundheit & Schönheit > Gesundheitspflege > Ergo- & Physiotherapeutische Hilfsmittel > Elektrische Muskelstimulatoren','de-DE'),(1135,'Gesundheit & Schönheit > Gesundheitspflege > Ergo- & Physiotherapeutische Hilfsmittel > Therapieschaukeln','de-DE'),(1136,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe','de-DE'),(1137,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Antiseptika & Reinigung','de-DE'),(1138,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Augenwaschbedarf','de-DE'),(1139,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Erste-Hilfe-Koffer','de-DE'),(1140,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Medizinisches Klebeband & Verbandsmaterial','de-DE'),(1141,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Schutzhüllen für Gipsverbände','de-DE'),(1142,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Warm & Kalt Therapie','de-DE'),(1143,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Warm & Kalt Therapie > Eisanwendungen','de-DE'),(1144,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Warm & Kalt Therapie > Wärmecremes','de-DE'),(1145,'Gesundheit & Schönheit > Gesundheitspflege > Erste Hilfe > Warm & Kalt Therapie > Wärmflaschen & Heizkissen','de-DE'),(1146,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung','de-DE'),(1147,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Energie-Gel & -Nahrung','de-DE'),(1148,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Flüssignahrung zur künstlichen Ernährung','de-DE'),(1149,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Mahlzeitenersatz-Getränke','de-DE'),(1150,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Pürierte Lebensmittel','de-DE'),(1151,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Sportriegel','de-DE'),(1152,'Gesundheit & Schönheit > Gesundheitspflege > Fitness & Ernährung > Vitamine & Nahrungsergänzungsmittel','de-DE'),(1153,'Gesundheit & Schönheit > Gesundheitspflege > Hausnotrufgeräte','de-DE'),(1154,'Gesundheit & Schönheit > Gesundheitspflege > Hörhilfen','de-DE'),(1155,'Gesundheit & Schönheit > Gesundheitspflege > Inkontinenzartikel','de-DE'),(1156,'Gesundheit & Schönheit > Gesundheitspflege > Kondome','de-DE'),(1157,'Gesundheit & Schönheit > Gesundheitspflege > Kontaktgels & -lotionen','de-DE'),(1158,'Gesundheit & Schönheit > Gesundheitspflege > Lichttherapielampen','de-DE'),(1159,'Gesundheit & Schönheit > Gesundheitspflege > Medikamente & Arzneimittel','de-DE'),(1160,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte','de-DE'),(1161,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Aktivitätsmonitore','de-DE'),(1162,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Alkoholmessgeräte','de-DE'),(1163,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Blutdruckmessgeräte','de-DE'),(1164,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Blutzuckermessgeräte','de-DE'),(1165,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Cholesterinmessgeräte','de-DE'),(1166,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Fieberthermometer','de-DE'),(1167,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Fruchtbarkeitsmonitore & Ovulationstests ','de-DE'),(1168,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Körperfettanalyse','de-DE'),(1169,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Personenwaagen','de-DE'),(1170,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Pränatale Herzfrequenzmesser','de-DE'),(1171,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Messgeräte > Pulsoximeter','de-DE'),(1172,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests','de-DE'),(1173,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > Allergietest-Sets','de-DE'),(1174,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > Blutgruppentests','de-DE'),(1175,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > Drogentests','de-DE'),(1176,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > HIV-Tests','de-DE'),(1177,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > Harnwegsinfektionstests','de-DE'),(1178,'Gesundheit & Schönheit > Gesundheitspflege > Medizinische Tests > Schwangerschaftstests','de-DE'),(1179,'Gesundheit & Schönheit > Gesundheitspflege > Medizinisches Gleitgel','de-DE'),(1180,'Gesundheit & Schönheit > Gesundheitspflege > Notfall-Armband','de-DE'),(1181,'Gesundheit & Schönheit > Gesundheitspflege > Pillendosen','de-DE'),(1182,'Gesundheit & Schönheit > Gesundheitspflege > Probenbehälter','de-DE'),(1183,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf','de-DE'),(1184,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Behindertengerechte Möbel & Vorrichtungen','de-DE'),(1185,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Behindertengerechte Möbel & Vorrichtungen > Duschbänke & -sitze','de-DE'),(1186,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Gehhilfen','de-DE'),(1187,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Gehhilfen > Gehstöcke','de-DE'),(1188,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Gehhilfen > Krücken','de-DE'),(1189,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Gehhilfen > Rollatoren','de-DE'),(1190,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Gehhilfenzubehör','de-DE'),(1191,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör & Bedarf zur Barrierefreiheit','de-DE'),(1192,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör & Bedarf zur Barrierefreiheit > Elektromobile','de-DE'),(1193,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör & Bedarf zur Barrierefreiheit > Rollstühle','de-DE'),(1194,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör & Bedarf zur Barrierefreiheit > Treppenlifte','de-DE'),(1195,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör & Bedarf zur Barrierefreiheit > Umlagerungsbretter & -tücher','de-DE'),(1196,'Gesundheit & Schönheit > Gesundheitspflege > Senioren- & Behindertenbedarf > Zubehör für Behindertengerechte Möbel & Vorrichtungen','de-DE'),(1197,'Gesundheit & Schönheit > Gesundheitspflege > Spermizide','de-DE'),(1198,'Gesundheit & Schönheit > Gesundheitspflege > Stützen & Bandagen','de-DE'),(1199,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte','de-DE'),(1200,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Blutzuckermessung','de-DE'),(1201,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Blutzuckermessung > Blutzucker-Kontrolllösung','de-DE'),(1202,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Blutzuckermessung > Blutzuckerteststreifen','de-DE'),(1203,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Blutzuckermessung > Stechhilfen','de-DE'),(1204,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Zubehör für Aktivitätsmonitore','de-DE'),(1205,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Zubehör für Badezimmerwaagen','de-DE'),(1206,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Zubehör für Blutdrucküberwachungsgeräte','de-DE'),(1207,'Gesundheit & Schönheit > Gesundheitspflege > Zubehör für biometrische Messgeräte > Zubehör für Blutdrucküberwachungsgeräte > Blutdruckmanschetten','de-DE'),(1208,'Gesundheit & Schönheit > Körperpflege','de-DE'),(1209,'Gesundheit & Schönheit > Körperpflege > Augenpflege','de-DE'),(1210,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Augentropfen','de-DE'),(1211,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillen','de-DE'),(1212,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillengläser','de-DE'),(1213,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillenzubehör','de-DE'),(1214,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillenzubehör > Brillenbänder & -ketten','de-DE'),(1215,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillenzubehör > Brillenetuis & -halter','de-DE'),(1216,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Brillenzubehör > Kontaktlinsenreiniger','de-DE'),(1217,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Kontaktlinsen','de-DE'),(1218,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Kontaktlinsenpflege','de-DE'),(1219,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Kontaktlinsenpflege > Kontaktlinsen-Pflegesets','de-DE'),(1220,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Kontaktlinsenpflege > Kontaktlinsenbehälter','de-DE'),(1221,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Kontaktlinsenpflege > Kontaktlinsenpflegemittel','de-DE'),(1222,'Gesundheit & Schönheit > Körperpflege > Augenpflege > Sonnenbrillengläser','de-DE'),(1223,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel','de-DE'),(1224,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel > Damen-Deodorant','de-DE'),(1225,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel > Intim-Waschlotionen für Frauen','de-DE'),(1226,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel > Menstruationstassen','de-DE'),(1227,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel > Slipeinlagen & Binden','de-DE'),(1228,'Gesundheit & Schönheit > Körperpflege > Damenhygieneartikel > Tampons','de-DE'),(1229,'Gesundheit & Schönheit > Körperpflege > Deodorants & Antitranspirante','de-DE'),(1230,'Gesundheit & Schönheit > Körperpflege > Einlaufsets & -zubehör','de-DE'),(1231,'Gesundheit & Schönheit > Körperpflege > Fußpflege','de-DE'),(1232,'Gesundheit & Schönheit > Körperpflege > Fußpflege > Ballenpflege','de-DE'),(1233,'Gesundheit & Schönheit > Körperpflege > Fußpflege > Einlegesohlen & Einlagen','de-DE'),(1234,'Gesundheit & Schönheit > Körperpflege > Fußpflege > Fußgeruchskiller','de-DE'),(1235,'Gesundheit & Schönheit > Körperpflege > Fußpflege > Hühneraugen- & Hornhautprodukte','de-DE'),(1236,'Gesundheit & Schönheit > Körperpflege > Fußpflege > Zehenspreizer','de-DE'),(1237,'Gesundheit & Schönheit > Körperpflege > Gleitmittel','de-DE'),(1238,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik','de-DE'),(1239,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haar-Decoloration','de-DE'),(1240,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarfärbemittel','de-DE'),(1241,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarpflege-Sets','de-DE'),(1242,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarscheren','de-DE'),(1243,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte','de-DE'),(1244,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Haarglätter','de-DE'),(1245,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Haartrockner','de-DE'),(1246,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Hairstyling-Sets','de-DE'),(1247,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Kämme & Bürsten','de-DE'),(1248,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Lockenstäbe','de-DE'),(1249,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarstyling-Geräte > Lockenwickler','de-DE'),(1250,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Haarverdichter','de-DE'),(1251,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Mittel für Dauerwellen & Haarglättung, chemische Haarglättung','de-DE'),(1252,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Mittel gegen Haarverlust','de-DE'),(1253,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Shampoo & Spülung','de-DE'),(1254,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Styling-Gel, Haarspray & Haarschaum','de-DE'),(1255,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Trockenhauben','de-DE'),(1256,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Zubehör für Haarcolorationen','de-DE'),(1257,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Zubehör für Haarstyling-Geräte','de-DE'),(1258,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Zubehör für Haarstyling-Geräte > Haareisenzubehör','de-DE'),(1259,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Zubehör für Haarstyling-Geräte > Haartrocknerzubehör','de-DE'),(1260,'Gesundheit & Schönheit > Körperpflege > Haarkosmetik > Zubehör für Haarstyling-Geräte > Lockenwicklerklammern & -nadeln','de-DE'),(1261,'Gesundheit & Schönheit > Körperpflege > Kosmetika','de-DE'),(1262,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel','de-DE'),(1263,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Bade- & Naturschwämme','de-DE'),(1264,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Badebürsten','de-DE'),(1265,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Duschhauben','de-DE'),(1266,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Feuchttücher für Erwachsene','de-DE'),(1267,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Flüssigseifen','de-DE'),(1268,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Handdesinfektionsmittel','de-DE'),(1269,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Schaumbäder & Badesalze','de-DE'),(1270,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Seife','de-DE'),(1271,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Seife in Pulverform','de-DE'),(1272,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Badeartikel > Waschlotion','de-DE'),(1273,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Düfte','de-DE'),(1274,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Geschenkkörbe Bad & Körperpflege','de-DE'),(1275,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege','de-DE'),(1276,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Aknebehandlung','de-DE'),(1277,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Anti-Aging-Hautpflegeprodukte','de-DE'),(1278,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Bräunungsprodukte','de-DE'),(1279,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Bräunungsprodukte > Selbstbräuner','de-DE'),(1280,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Bräunungsprodukte > Sonnenöle & -lotionen','de-DE'),(1281,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Gesichtspeeling','de-DE'),(1282,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Gesichtsreiniger','de-DE'),(1283,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Gesichtsreinigersets','de-DE'),(1284,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Insektenschutzmittel','de-DE'),(1285,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Komprimierte Gesichtsmasken','de-DE'),(1286,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Körperpuder','de-DE'),(1287,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Körperöle','de-DE'),(1288,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Lippenpflege','de-DE'),(1289,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Lotion & Feuchtigkeitscremes','de-DE'),(1290,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Make-up-Entferner','de-DE'),(1291,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Porenreinigungspflaster','de-DE'),(1292,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Reinigungswasser & Adstringentien','de-DE'),(1293,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Sonnencreme','de-DE'),(1294,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Vaseline','de-DE'),(1295,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Hautpflege > Warzenentferner','de-DE'),(1296,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör','de-DE'),(1297,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien','de-DE'),(1298,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Applikatoren für Lotionen und Sonnenschutzcremes','de-DE'),(1299,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Bimssteine','de-DE'),(1300,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Fußfeilen','de-DE'),(1301,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Gesichtsbürsten','de-DE'),(1302,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Gesichtssaunas','de-DE'),(1303,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Hautpflegeroller','de-DE'),(1304,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Hautreinigungs-Bürstenköpfe','de-DE'),(1305,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Hautpflegeutensilien > Mitesser-Entferner','de-DE'),(1306,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör','de-DE'),(1307,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Augenbrauenschablonen','de-DE'),(1308,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Ersatzkissen für Wimpernzangen','de-DE'),(1309,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Make-up-Pinsel','de-DE'),(1310,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Make-up-Schwämme','de-DE'),(1311,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Make-up-Spiegel','de-DE'),(1312,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Nachfüllbare Make-up-Paletten & -Koffer','de-DE'),(1313,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Pudertücher','de-DE'),(1314,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Schlupflid-Kleber & -Klebestreifen','de-DE'),(1315,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Wimpernformer','de-DE'),(1316,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Zubehör für künstliche Wimpern','de-DE'),(1317,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Zubehör für künstliche Wimpern > Applikatoren für künstliche Wimpern','de-DE'),(1318,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Zubehör für künstliche Wimpern > Entferner für künstliche Wimpern','de-DE'),(1319,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Make-up Zubehör > Zubehör für künstliche Wimpern > Kleber für künstliche Wimpern','de-DE'),(1320,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre','de-DE'),(1321,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Finger- & Zehenspreizer','de-DE'),(1322,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Maniküre-Sets','de-DE'),(1323,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelfeilen & Sandblattfeilen','de-DE'),(1324,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelfräser','de-DE'),(1325,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelhautscheren','de-DE'),(1326,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelhautschieber','de-DE'),(1327,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelknipser','de-DE'),(1328,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelpiercing-Zubehör','de-DE'),(1329,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nagelpolierer','de-DE'),(1330,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetik-Zubehör > Maniküre & Pediküre > Nageltrockner','de-DE'),(1331,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Kosmetiksets','de-DE'),(1332,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up','de-DE'),(1333,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen','de-DE'),(1334,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Augenbrauen Make-up','de-DE'),(1335,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Eyeliner & Kajal','de-DE'),(1336,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Künstliche Wimpern','de-DE'),(1337,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Lidschatten','de-DE'),(1338,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Lidschatten-Grundierung','de-DE'),(1339,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Mascara','de-DE'),(1340,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Mascara-Grundierung','de-DE'),(1341,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Augen > Wimpern- & Augenbrauenbehandlung','de-DE'),(1342,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Kostüm- & Bühnen-Make-up','de-DE'),(1343,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Körper-Make-up','de-DE'),(1344,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Körper-Make-up > Bodypainting-Farbe','de-DE'),(1345,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Körper-Make-up > Glitter für Körper und Haar','de-DE'),(1346,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen','de-DE'),(1347,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen > Lipgloss','de-DE'),(1348,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen > Lipliner','de-DE'),(1349,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen > Lippen- & Wangentönung','de-DE'),(1350,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen > Lippenstift','de-DE'),(1351,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Lippen > Lippenstift-Grundierung','de-DE'),(1352,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Spray zum Fixieren von Make-up','de-DE'),(1353,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint','de-DE'),(1354,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint > Gesichtsgrundierung','de-DE'),(1355,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint > Grundierungen & Concealer','de-DE'),(1356,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint > Highlighter & Luminizer','de-DE'),(1357,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint > Puder','de-DE'),(1358,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Teint > Rouge & Bronzepuder','de-DE'),(1359,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Make-up > Temporäre Tattoos','de-DE'),(1360,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege','de-DE'),(1361,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Künstliche Nägel','de-DE'),(1362,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagelhautcremes & -Lotionen','de-DE'),(1363,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagelkleber','de-DE'),(1364,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagelkunst-Zubehör','de-DE'),(1365,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagellack-Überlacke und -Trockensprays','de-DE'),(1366,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagellacke','de-DE'),(1367,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagellackentferner','de-DE'),(1368,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Nagelpflege > Nagellackverdünner','de-DE'),(1369,'Gesundheit & Schönheit > Körperpflege > Kosmetika > Reiniger für Kosmetikwerkzeuge','de-DE'),(1370,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung','de-DE'),(1371,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Augenkissen','de-DE'),(1372,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massagegeräte','de-DE'),(1373,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massagestein-Wärmer','de-DE'),(1374,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massagesteine','de-DE'),(1375,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massagestühle','de-DE'),(1376,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massagetische','de-DE'),(1377,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Massageöle','de-DE'),(1378,'Gesundheit & Schönheit > Körperpflege > Massage & Entspannung > Rückenkratzer','de-DE'),(1379,'Gesundheit & Schönheit > Körperpflege > Mundpflege','de-DE'),(1380,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Aufbissschienen','de-DE'),(1381,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Ersatzdüsen für Mundduschen','de-DE'),(1382,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Gebissreiniger','de-DE'),(1383,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Interdentalreiniger','de-DE'),(1384,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Mundduschen','de-DE'),(1385,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Mundspray','de-DE'),(1386,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Mundwasser','de-DE'),(1387,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Reparatursets für Zahnprothesen','de-DE'),(1388,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Spangen-, Gebiss- & Aufbissschienendosen','de-DE'),(1389,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnaufhellung','de-DE'),(1390,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnbürsten','de-DE'),(1391,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnbürstenzubehör','de-DE'),(1392,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnbürstenzubehör > Ersatzköpfe für Zahnbürsten','de-DE'),(1393,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnbürstenzubehör > Zahnbürstendesinfektionsmittel','de-DE'),(1394,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnbürstenzubehör > Zahnbürstenhüllen','de-DE'),(1395,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnersatz','de-DE'),(1396,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnfleischstimulierende Geräte','de-DE'),(1397,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnpasta','de-DE'),(1398,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnpastapressen & -spender','de-DE'),(1399,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnprothesehaftmittel','de-DE'),(1400,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnseide','de-DE'),(1401,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zahnstocher','de-DE'),(1402,'Gesundheit & Schönheit > Körperpflege > Mundpflege > Zungenreiniger','de-DE'),(1403,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege','de-DE'),(1404,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrenreinigungssets','de-DE'),(1405,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrenstöpsel','de-DE'),(1406,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrentrockner','de-DE'),(1407,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrentropfen','de-DE'),(1408,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrkerzen','de-DE'),(1409,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrlöffel','de-DE'),(1410,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrspritzen','de-DE'),(1411,'Gesundheit & Schönheit > Körperpflege > Ohrenpflege > Ohrstöpselspender','de-DE'),(1412,'Gesundheit & Schönheit > Körperpflege > Pinzetten','de-DE'),(1413,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen','de-DE'),(1414,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Alaunstifte','de-DE'),(1415,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Elektrorasierer','de-DE'),(1416,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haar- & Bartschneider','de-DE'),(1417,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haaraufheller','de-DE'),(1418,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung','de-DE'),(1419,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Elektrolysegeräte','de-DE'),(1420,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Enthaarungsmittel','de-DE'),(1421,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Enthaarungswachs-Wärmer','de-DE'),(1422,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Epilatoren','de-DE'),(1423,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Laserhaarentfernung','de-DE'),(1424,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Haarentfernung > Waxing-Sets & Zubehör','de-DE'),(1425,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasiercreme','de-DE'),(1426,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasierer & Rasierklingen','de-DE'),(1427,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasierpinsel','de-DE'),(1428,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasierschalen','de-DE'),(1429,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasiersets','de-DE'),(1430,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Rasierwasser','de-DE'),(1431,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Zubehör für Haarschneidegeräte & Trimmer','de-DE'),(1432,'Gesundheit & Schönheit > Körperpflege > Rasieren & Trimmen > Zubehör für elektrische Rasierer','de-DE'),(1433,'Gesundheit & Schönheit > Körperpflege > Rückengesundheit','de-DE'),(1434,'Gesundheit & Schönheit > Körperpflege > Rückengesundheit > Stützkissen für Rücken- & Lendenbereich','de-DE'),(1435,'Gesundheit & Schönheit > Körperpflege > Schlafhilfen','de-DE'),(1436,'Gesundheit & Schönheit > Körperpflege > Schlafhilfen > Hilfsmittel gegen Schnarchen und Schlaf-Apnoe','de-DE'),(1437,'Gesundheit & Schönheit > Körperpflege > Schlafhilfen > Reisekissen','de-DE'),(1438,'Gesundheit & Schönheit > Körperpflege > Schlafhilfen > Schlafmasken','de-DE'),(1439,'Gesundheit & Schönheit > Körperpflege > Schlafhilfen > Soundmaschinen','de-DE'),(1440,'Gesundheit & Schönheit > Körperpflege > Sonnenbänke','de-DE'),(1441,'Gesundheit & Schönheit > Körperpflege > Tanningzelt','de-DE'),(1442,'Gesundheit & Schönheit > Körperpflege > Wattebällchen','de-DE'),(1443,'Gesundheit & Schönheit > Körperpflege > Wattestäbchen','de-DE'),(1444,'Gesundheit & Schönheit > Schmuckreinigung & -pflege','de-DE'),(1445,'Gesundheit & Schönheit > Schmuckreinigung & -pflege > Dampfstrahlreiniger für Schmuck','de-DE'),(1446,'Gesundheit & Schönheit > Schmuckreinigung & -pflege > Hilfsmittel zur Schmuckreinigung','de-DE'),(1447,'Gesundheit & Schönheit > Schmuckreinigung & -pflege > Lösungen und Poliermittel zur Schmuckreinigung','de-DE'),(1448,'Gesundheit & Schönheit > Schmuckreinigung & -pflege > Schmuckständer & -kästen','de-DE'),(1449,'Gesundheit & Schönheit > Schmuckreinigung & -pflege > Uhrreparatursätze','de-DE'),(1450,'Heim & Garten','de-DE'),(1451,'Heim & Garten > Badzubehör','de-DE'),(1452,'Heim & Garten > Badzubehör > Badematten & Badteppiche','de-DE'),(1453,'Heim & Garten > Badzubehör > Badewannen- & Duschablagen','de-DE'),(1454,'Heim & Garten > Badzubehör > Badewannenkissen','de-DE'),(1455,'Heim & Garten > Badzubehör > Badezimmer-Zubehörsets','de-DE'),(1456,'Heim & Garten > Badzubehör > Badzubehörhalterungen','de-DE'),(1457,'Heim & Garten > Badzubehör > Duschvorhangringe','de-DE'),(1458,'Heim & Garten > Badzubehör > Duschvorhangstangen','de-DE'),(1459,'Heim & Garten > Badzubehör > Duschvorhänge','de-DE'),(1460,'Heim & Garten > Badzubehör > Garderobenhaken','de-DE'),(1461,'Heim & Garten > Badzubehör > Haltegriffe','de-DE'),(1462,'Heim & Garten > Badzubehör > Handtuchhalter','de-DE'),(1463,'Heim & Garten > Badzubehör > Händetrockner','de-DE'),(1464,'Heim & Garten > Badzubehör > Kosmetiktuchhalter','de-DE'),(1465,'Heim & Garten > Badzubehör > Medizinschränke','de-DE'),(1466,'Heim & Garten > Badzubehör > Seifen- & Lotionsspender','de-DE'),(1467,'Heim & Garten > Badzubehör > Seifenablagen','de-DE'),(1468,'Heim & Garten > Badzubehör > Toilettenbürsten & -halter','de-DE'),(1469,'Heim & Garten > Badzubehör > Toilettenbürstenköpfe','de-DE'),(1470,'Heim & Garten > Badzubehör > Toilettenpapierhalter','de-DE'),(1471,'Heim & Garten > Badzubehör > Zahnbürstenhalter','de-DE'),(1472,'Heim & Garten > Badzubehör > Zubehör für Händetrockner','de-DE'),(1473,'Heim & Garten > Beleuchtung','de-DE'),(1474,'Heim & Garten > Beleuchtung > Bilderbeleuchtung','de-DE'),(1475,'Heim & Garten > Beleuchtung > Bodeneinbauleuchten','de-DE'),(1476,'Heim & Garten > Beleuchtung > Flutlichter & Punktstrahler','de-DE'),(1477,'Heim & Garten > Beleuchtung > Lampen','de-DE'),(1478,'Heim & Garten > Beleuchtung > Leuchten','de-DE'),(1479,'Heim & Garten > Beleuchtung > Leuchten > Deckenleuchten','de-DE'),(1480,'Heim & Garten > Beleuchtung > Leuchten > Kronleuchter','de-DE'),(1481,'Heim & Garten > Beleuchtung > Leuchten > Unterbauleuchten','de-DE'),(1482,'Heim & Garten > Beleuchtung > Leuchten > Wandleuchten, Wandbeleuchtung','de-DE'),(1483,'Heim & Garten > Beleuchtung > Leuchtmittel','de-DE'),(1484,'Heim & Garten > Beleuchtung > Leuchtmittel > Glühlampen','de-DE'),(1485,'Heim & Garten > Beleuchtung > Leuchtmittel > Kompaktleuchtstofflampen','de-DE'),(1486,'Heim & Garten > Beleuchtung > Leuchtmittel > LED-Leuchtmittel','de-DE'),(1487,'Heim & Garten > Beleuchtung > Leuchtmittel > Leuchtstoffröhren','de-DE'),(1488,'Heim & Garten > Beleuchtung > Lichtschienensysteme','de-DE'),(1489,'Heim & Garten > Beleuchtung > Lichtschienensysteme > Leuchten für Lichtschienensysteme','de-DE'),(1490,'Heim & Garten > Beleuchtung > Lichtschienensysteme > Schienen für Lichtschienensysteme','de-DE'),(1491,'Heim & Garten > Beleuchtung > Lichtschienensysteme > Zubehör für Lichtschienensysteme','de-DE'),(1492,'Heim & Garten > Beleuchtung > Lichtschläuche & Lichterketten','de-DE'),(1493,'Heim & Garten > Beleuchtung > Nachtlichter & indirekte Beleuchtung','de-DE'),(1494,'Heim & Garten > Beleuchtung > Notbeleuchtung','de-DE'),(1495,'Heim & Garten > Beleuchtung > Schwimmende Lichter','de-DE'),(1496,'Heim & Garten > Beleuchtung > Tiki-Fackeln & Öllampen','de-DE'),(1497,'Heim & Garten > Beleuchtung > Wegbeleuchtung','de-DE'),(1498,'Heim & Garten > Beleuchtungszubehör','de-DE'),(1499,'Heim & Garten > Beleuchtungszubehör > Beleuchtungszeitschaltuhren','de-DE'),(1500,'Heim & Garten > Beleuchtungszubehör > Brennstoff für Öllampen','de-DE'),(1501,'Heim & Garten > Beleuchtungszubehör > Lampenschirme','de-DE'),(1502,'Heim & Garten > Beleuchtungszubehör > Laternenhalterungen','de-DE'),(1503,'Heim & Garten > Beleuchtungszubehör > Laternensockel','de-DE'),(1504,'Heim & Garten > Bett- und Haushaltswäsche','de-DE'),(1505,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche','de-DE'),(1506,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Baldachine & Betthimmel','de-DE'),(1507,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Bettbezüge','de-DE'),(1508,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Bettlaken','de-DE'),(1509,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Bettvolants','de-DE'),(1510,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Decken','de-DE'),(1511,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Kissenbezüge','de-DE'),(1512,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Kopfkissen','de-DE'),(1513,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Matratzenschoner','de-DE'),(1514,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Matratzenschoner > Matratzenauflagen','de-DE'),(1515,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Matratzenschoner > Matratzenbezüge','de-DE'),(1516,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Schlafunterlagen','de-DE'),(1517,'Heim & Garten > Bett- und Haushaltswäsche > Bettwäsche > Steppdecken & Quilts','de-DE'),(1518,'Heim & Garten > Bett- und Haushaltswäsche > Handtücher','de-DE'),(1519,'Heim & Garten > Bett- und Haushaltswäsche > Handtücher > Badhandtücher & Waschlappen','de-DE'),(1520,'Heim & Garten > Bett- und Haushaltswäsche > Handtücher > Geschirrtücher','de-DE'),(1521,'Heim & Garten > Bett- und Haushaltswäsche > Handtücher > Strandtücher','de-DE'),(1522,'Heim & Garten > Bett- und Haushaltswäsche > Küchentuchsets','de-DE'),(1523,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche','de-DE'),(1524,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Stoffservietten','de-DE'),(1525,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Tischläufer','de-DE'),(1526,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Tischsets','de-DE'),(1527,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Tischtücher','de-DE'),(1528,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Tischvorhänge','de-DE'),(1529,'Heim & Garten > Bett- und Haushaltswäsche > Tischwäsche > Zierdecken','de-DE'),(1530,'Heim & Garten > Dekoration','de-DE'),(1531,'Heim & Garten > Dekoration > Bilderrahmen','de-DE'),(1532,'Heim & Garten > Dekoration > Briefkasten-Zubehör','de-DE'),(1533,'Heim & Garten > Dekoration > Briefkasten-Zubehör > Briefkasten-Standanlagen','de-DE'),(1534,'Heim & Garten > Dekoration > Briefkasten-Zubehör > Briefkastenanlagen','de-DE'),(1535,'Heim & Garten > Dekoration > Briefkasten-Zubehör > Briefkastenfahnen','de-DE'),(1536,'Heim & Garten > Dekoration > Briefkasten-Zubehör > Briefkastengehäuse','de-DE'),(1537,'Heim & Garten > Dekoration > Briefkasten-Zubehör > Briefkastentüren','de-DE'),(1538,'Heim & Garten > Dekoration > Briefkästen','de-DE'),(1539,'Heim & Garten > Dekoration > Briefschlitze','de-DE'),(1540,'Heim & Garten > Dekoration > Brunnen & Teiche','de-DE'),(1541,'Heim & Garten > Dekoration > Brunnen & Teiche > Brunnen & Wasserfälle','de-DE'),(1542,'Heim & Garten > Dekoration > Brunnen & Teiche > Brunnen- & Teichzubehör','de-DE'),(1543,'Heim & Garten > Dekoration > Brunnen & Teiche > Teiche','de-DE'),(1544,'Heim & Garten > Dekoration > Buchstützen','de-DE'),(1545,'Heim & Garten > Dekoration > Deko-Aufkleber','de-DE'),(1546,'Heim & Garten > Dekoration > Dekorative Flaschen','de-DE'),(1547,'Heim & Garten > Dekoration > Dekorative Gefäße','de-DE'),(1548,'Heim & Garten > Dekoration > Dekorteller','de-DE'),(1549,'Heim & Garten > Dekoration > Ecosphere-Kugeln','de-DE'),(1550,'Heim & Garten > Dekoration > Fensterdrapierung','de-DE'),(1551,'Heim & Garten > Dekoration > Fensterdrapierung > Buntglasscheiben','de-DE'),(1552,'Heim & Garten > Dekoration > Fensterdrapierung > Fensterfolie','de-DE'),(1553,'Heim & Garten > Dekoration > Fensterdrapierung > Fliegengitter','de-DE'),(1554,'Heim & Garten > Dekoration > Fensterdrapierung > Jalousien & Rollos','de-DE'),(1555,'Heim & Garten > Dekoration > Fensterdrapierung > Querbehänge','de-DE'),(1556,'Heim & Garten > Dekoration > Fensterdrapierung > Vorhänge & Gardinen','de-DE'),(1557,'Heim & Garten > Dekoration > Fensterschmuckmagnete','de-DE'),(1558,'Heim & Garten > Dekoration > Festtags-Dekoartikel','de-DE'),(1559,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Adventskalender','de-DE'),(1560,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Haken für Weihnachtssocken','de-DE'),(1561,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Krippen','de-DE'),(1562,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Modellbaudörfer & -zubehör mit saisonalem Bezug','de-DE'),(1563,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Ostereier-Färbe-Sets','de-DE'),(1564,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Traditionelle Japanische Puppen','de-DE'),(1565,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsbaumdecken','de-DE'),(1566,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsbaumschmuck','de-DE'),(1567,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsbaumständer','de-DE'),(1568,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsschmuck-Aufhänger','de-DE'),(1569,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsschmuck-Displays','de-DE'),(1570,'Heim & Garten > Dekoration > Festtags-Dekoartikel > Weihnachtsstrümpfe','de-DE'),(1571,'Heim & Garten > Dekoration > Figuren zur Dekoration','de-DE'),(1572,'Heim & Garten > Dekoration > Flaggen & Windsäcke','de-DE'),(1573,'Heim & Garten > Dekoration > Flammenlose Kerzen','de-DE'),(1574,'Heim & Garten > Dekoration > Futterspender','de-DE'),(1575,'Heim & Garten > Dekoration > Futterspender > Eichhörnchenfutterspender','de-DE'),(1576,'Heim & Garten > Dekoration > Futterspender > Schmetterlingsfutterspender','de-DE'),(1577,'Heim & Garten > Dekoration > Futterspender > Vogelfutterspender','de-DE'),(1578,'Heim & Garten > Dekoration > Fußmatten','de-DE'),(1579,'Heim & Garten > Dekoration > Garderoben','de-DE'),(1580,'Heim & Garten > Dekoration > Garten- & Trittsteine','de-DE'),(1581,'Heim & Garten > Dekoration > Gartendeko','de-DE'),(1582,'Heim & Garten > Dekoration > Glasfensterbilder','de-DE'),(1583,'Heim & Garten > Dekoration > Globen','de-DE'),(1584,'Heim & Garten > Dekoration > Hausnummern & Buchstaben','de-DE'),(1585,'Heim & Garten > Dekoration > Hausnummernschilder','de-DE'),(1586,'Heim & Garten > Dekoration > Kartonschablonen','de-DE'),(1587,'Heim & Garten > Dekoration > Kindermesslatten','de-DE'),(1588,'Heim & Garten > Dekoration > Kreuzblumen','de-DE'),(1589,'Heim & Garten > Dekoration > Kränze & Girlanden','de-DE'),(1590,'Heim & Garten > Dekoration > Kunst','de-DE'),(1591,'Heim & Garten > Dekoration > Kunst > Figuren, Skulpturen & Statuen','de-DE'),(1592,'Heim & Garten > Dekoration > Kunst > Poster & Bildende Kunst','de-DE'),(1593,'Heim & Garten > Dekoration > Kunst > Wandteppiche','de-DE'),(1594,'Heim & Garten > Dekoration > Körbe','de-DE'),(1595,'Heim & Garten > Dekoration > Kühlschrankmagnete','de-DE'),(1596,'Heim & Garten > Dekoration > Künstliche Pflanzen','de-DE'),(1597,'Heim & Garten > Dekoration > Lebensmittel-Attrappen','de-DE'),(1598,'Heim & Garten > Dekoration > Niederschlags-Messgeräte','de-DE'),(1599,'Heim & Garten > Dekoration > Quadratische Sitzkissen','de-DE'),(1600,'Heim & Garten > Dekoration > Raumduft-Zubehör','de-DE'),(1601,'Heim & Garten > Dekoration > Raumduft-Zubehör > Kerzenlöscher','de-DE'),(1602,'Heim & Garten > Dekoration > Raumduft-Zubehör > Kerzenständer','de-DE'),(1603,'Heim & Garten > Dekoration > Raumduft-Zubehör > Räuchermittelhalter','de-DE'),(1604,'Heim & Garten > Dekoration > Raumduft-Zubehör > Wachs- & Ölwärmer','de-DE'),(1605,'Heim & Garten > Dekoration > Raumdüfte','de-DE'),(1606,'Heim & Garten > Dekoration > Raumdüfte > Duftwachs','de-DE'),(1607,'Heim & Garten > Dekoration > Raumdüfte > Duftöle','de-DE'),(1608,'Heim & Garten > Dekoration > Raumdüfte > Kerzen','de-DE'),(1609,'Heim & Garten > Dekoration > Raumdüfte > Lufterfrischer','de-DE'),(1610,'Heim & Garten > Dekoration > Raumdüfte > Potpourri','de-DE'),(1611,'Heim & Garten > Dekoration > Raumdüfte > Räuchermittel','de-DE'),(1612,'Heim & Garten > Dekoration > Regenketten','de-DE'),(1613,'Heim & Garten > Dekoration > Rückenstützkissen','de-DE'),(1614,'Heim & Garten > Dekoration > Sanduhren','de-DE'),(1615,'Heim & Garten > Dekoration > Schalen','de-DE'),(1616,'Heim & Garten > Dekoration > Schaukästen','de-DE'),(1617,'Heim & Garten > Dekoration > Schneekugeln','de-DE'),(1618,'Heim & Garten > Dekoration > Schonbezüge','de-DE'),(1619,'Heim & Garten > Dekoration > Serviettenringe','de-DE'),(1620,'Heim & Garten > Dekoration > Sitzpolster','de-DE'),(1621,'Heim & Garten > Dekoration > Sonnenuhren','de-DE'),(1622,'Heim & Garten > Dekoration > Sparschweine & -Dosen','de-DE'),(1623,'Heim & Garten > Dekoration > Spaßschilder','de-DE'),(1624,'Heim & Garten > Dekoration > Spiegel','de-DE'),(1625,'Heim & Garten > Dekoration > Spieluhren','de-DE'),(1626,'Heim & Garten > Dekoration > Tabletts','de-DE'),(1627,'Heim & Garten > Dekoration > Tapeten','de-DE'),(1628,'Heim & Garten > Dekoration > Teppiche','de-DE'),(1629,'Heim & Garten > Dekoration > Traumfänger','de-DE'),(1630,'Heim & Garten > Dekoration > Trockenblumen','de-DE'),(1631,'Heim & Garten > Dekoration > Truhen','de-DE'),(1632,'Heim & Garten > Dekoration > Uhrbauteile','de-DE'),(1633,'Heim & Garten > Dekoration > Uhren','de-DE'),(1634,'Heim & Garten > Dekoration > Uhren > Standuhren','de-DE'),(1635,'Heim & Garten > Dekoration > Uhren > Tisch- und Regaluhren','de-DE'),(1636,'Heim & Garten > Dekoration > Uhren > Wanduhren','de-DE'),(1637,'Heim & Garten > Dekoration > Uhren > Wecker','de-DE'),(1638,'Heim & Garten > Dekoration > Vasen','de-DE'),(1639,'Heim & Garten > Dekoration > Vasenfüller & Streudeko','de-DE'),(1640,'Heim & Garten > Dekoration > Vogel- und Tierhäuschen','de-DE'),(1641,'Heim & Garten > Dekoration > Vogel- und Tierhäuschen > Fledermaushäuschen','de-DE'),(1642,'Heim & Garten > Dekoration > Vogel- und Tierhäuschen > Schmetterlingshäuschen','de-DE'),(1643,'Heim & Garten > Dekoration > Vogel- und Tierhäuschen > Vogelhäuschen','de-DE'),(1644,'Heim & Garten > Dekoration > Vogelhaus-Zubehör','de-DE'),(1645,'Heim & Garten > Dekoration > Vogeltränken','de-DE'),(1646,'Heim & Garten > Dekoration > Wetterfahnen & Dachdekoration','de-DE'),(1647,'Heim & Garten > Dekoration > Windräder','de-DE'),(1648,'Heim & Garten > Dekoration > Windspiele','de-DE'),(1649,'Heim & Garten > Dekoration > Zierglocken','de-DE'),(1650,'Heim & Garten > Dekoration > Zierkissen','de-DE'),(1651,'Heim & Garten > Dekoration > Ziertafeln','de-DE'),(1652,'Heim & Garten > Dekoration > Zubehör für Fahnen & Windsäcke','de-DE'),(1653,'Heim & Garten > Dekoration > Zubehör für Fahnen & Windsäcke > Befestigungsvorrichtungen & -sets für Fahnen- & Windsackstangen','de-DE'),(1654,'Heim & Garten > Dekoration > Zubehör für Fahnen & Windsäcke > Beleuchtung für Fahnen- & Windsackstangen','de-DE'),(1655,'Heim & Garten > Dekoration > Zubehör für Fahnen & Windsäcke > Stangen für Fahnen & Windsäcke','de-DE'),(1656,'Heim & Garten > Dekoration > Zubehör für Futterspender','de-DE'),(1657,'Heim & Garten > Dekoration > Zubehör zur Fensterdekoration','de-DE'),(1658,'Heim & Garten > Dekoration > Zubehör zur Fensterdekoration > Ersatzteile für Vorhänge & Jalousien','de-DE'),(1659,'Heim & Garten > Dekoration > Zubehör zur Fensterdekoration > Gardinen- & Vorhangringe','de-DE'),(1660,'Heim & Garten > Dekoration > Zubehör zur Fensterdekoration > Gardinen- & Vorhangstangen','de-DE'),(1661,'Heim & Garten > Dekoration > Zubehör zur Fensterdekoration > Gardinenhalter & -quasten','de-DE'),(1662,'Heim & Garten > Feuer- & Gasschutz','de-DE'),(1663,'Heim & Garten > Feuer- & Gasschutz > Feuerlöscher','de-DE'),(1664,'Heim & Garten > Feuer- & Gasschutz > Feuermelder','de-DE'),(1665,'Heim & Garten > Feuer- & Gasschutz > Feuermelder-Steuerungen','de-DE'),(1666,'Heim & Garten > Feuer- & Gasschutz > Hitzemelder','de-DE'),(1667,'Heim & Garten > Feuer- & Gasschutz > Kästen & Halterungen für Feuerlöscher','de-DE'),(1668,'Heim & Garten > Feuer- & Gasschutz > Rauch- & Kohlenmonoxidmelder','de-DE'),(1669,'Heim & Garten > Feuer- & Gasschutz > Sprinkleranlagen','de-DE'),(1670,'Heim & Garten > Feuer- & Gasschutz > Wassermelder','de-DE'),(1671,'Heim & Garten > Haushaltsbedarf','de-DE'),(1672,'Heim & Garten > Haushaltsbedarf > Abfallbehälter','de-DE'),(1673,'Heim & Garten > Haushaltsbedarf > Abfallbehälter > Müllcontainer','de-DE'),(1674,'Heim & Garten > Haushaltsbedarf > Abfallbehälter > Mülltonnen & Abfalleimer','de-DE'),(1675,'Heim & Garten > Haushaltsbedarf > Abfallbehälter > Recycling-Behälter','de-DE'),(1676,'Heim & Garten > Haushaltsbedarf > Abfallbehälter > Sondermüllbehälter','de-DE'),(1677,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör','de-DE'),(1678,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör > Abfallbehälter-Verkleidungen','de-DE'),(1679,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör > Abfallbehälterdeckel','de-DE'),(1680,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör > Abfallbehälterrollen','de-DE'),(1681,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör > Abfallbehälterwagen','de-DE'),(1682,'Heim & Garten > Haushaltsbedarf > Abfallbehälterzubehör > Beschriftungen & Etiketten für Abfallbehälter','de-DE'),(1683,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme','de-DE'),(1684,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungsbehälter','de-DE'),(1685,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungsbeutel','de-DE'),(1686,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungshaken & Regale','de-DE'),(1687,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungshaken & Regale > Bügelbrettaufhänger und -ablagen','de-DE'),(1688,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungshaken & Regale > Mehrzweckhaken','de-DE'),(1689,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Aufbewahrungshaken & Regale > Schirmständer','de-DE'),(1690,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Fotoaufbewahrung','de-DE'),(1691,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Fotoaufbewahrung > Fotoalben','de-DE'),(1692,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Fotoaufbewahrung > Fotoboxen','de-DE'),(1693,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Haushalts-Ordnungshelfer','de-DE'),(1694,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung','de-DE'),(1695,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Herrendiener','de-DE'),(1696,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Hutschachteln','de-DE'),(1697,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Kleiderbügel','de-DE'),(1698,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Kleiderständer','de-DE'),(1699,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Ladestationen','de-DE'),(1700,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Kleider- & Wandschrankaufbewahrung > Schuhregale & -schränke','de-DE'),(1701,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Schubladeneinsätze','de-DE'),(1702,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Schubladensysteme','de-DE'),(1703,'Heim & Garten > Haushaltsbedarf > Aufbewahrung & Ordnungssysteme > Tischbesteckkommoden','de-DE'),(1704,'Heim & Garten > Haushaltsbedarf > Auskleidung für Schubladen & Regale','de-DE'),(1705,'Heim & Garten > Haushaltsbedarf > Fußbodenschutzfolien & -läufer','de-DE'),(1706,'Heim & Garten > Haushaltsbedarf > Garagenmatten','de-DE'),(1707,'Heim & Garten > Haushaltsbedarf > Haushaltsthermometer','de-DE'),(1708,'Heim & Garten > Haushaltsbedarf > Hygienepapiere','de-DE'),(1709,'Heim & Garten > Haushaltsbedarf > Hygienepapiere > Küchenrollen & Papierhandtücher','de-DE'),(1710,'Heim & Garten > Haushaltsbedarf > Hygienepapiere > Papierservietten','de-DE'),(1711,'Heim & Garten > Haushaltsbedarf > Hygienepapiere > Papiertaschentücher','de-DE'),(1712,'Heim & Garten > Haushaltsbedarf > Hygienepapiere > Toilettenpapier','de-DE'),(1713,'Heim & Garten > Haushaltsbedarf > Möbelgleiter','de-DE'),(1714,'Heim & Garten > Haushaltsbedarf > Müllbeutel','de-DE'),(1715,'Heim & Garten > Haushaltsbedarf > Müllpressezubehör','de-DE'),(1716,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien','de-DE'),(1717,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Abzieher','de-DE'),(1718,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Besen','de-DE'),(1719,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Besen- & Bodenwischerstiele','de-DE'),(1720,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Besenköpfe','de-DE'),(1721,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Bodenwischeraufsätze','de-DE'),(1722,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Eimer','de-DE'),(1723,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Ersatz-Wischmops','de-DE'),(1724,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Gewebe- & Polsterschutz','de-DE'),(1725,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger','de-DE'),(1726,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Allzweckreiniger','de-DE'),(1727,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Backofen- & Grillreiniger','de-DE'),(1728,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Bodenreiniger','de-DE'),(1729,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Edelstahlreiniger & -polituren','de-DE'),(1730,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Entkalkungsmittel','de-DE'),(1731,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Geschirrspülmittel & -seifen','de-DE'),(1732,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Glas- & Oberflächenreiniger','de-DE'),(1733,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Haushaltsdesinfektion','de-DE'),(1734,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Klarspüler','de-DE'),(1735,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Möbelreiniger & -Politur','de-DE'),(1736,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Spülmaschinenreiniger','de-DE'),(1737,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Teppichreiniger','de-DE'),(1738,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Textil- & Polsterreiniger','de-DE'),(1739,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Tiergeruchs- & Fleckenentferner','de-DE'),(1740,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Toilettenreiniger','de-DE'),(1741,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Wannen- & Kachelreiniger','de-DE'),(1742,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Haushaltsreiniger > Waschmaschinenreiniger','de-DE'),(1743,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Kehrschaufeln','de-DE'),(1744,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Reinigungshandschuhe','de-DE'),(1745,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Reinigungstücher','de-DE'),(1746,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Scheuerbürsten','de-DE'),(1747,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Schwämme & Topfreiniger','de-DE'),(1748,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Staubwedel & -Tücher','de-DE'),(1749,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Staubwedel-Ersatzköpfe','de-DE'),(1750,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Teppichkehrer','de-DE'),(1751,'Heim & Garten > Haushaltsbedarf > Reinigungsutensilien > Wischmops & Bodenwischer','de-DE'),(1752,'Heim & Garten > Haushaltsbedarf > Schuhpflege','de-DE'),(1753,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhabstreifer','de-DE'),(1754,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhanzieher','de-DE'),(1755,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhbeutel','de-DE'),(1756,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhbürsten','de-DE'),(1757,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhpflege- & Färbemittel','de-DE'),(1758,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhpflegesets','de-DE'),(1759,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhpolierer','de-DE'),(1760,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhpolituren & -wachse','de-DE'),(1761,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhspanner','de-DE'),(1762,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Schuhtrockner','de-DE'),(1763,'Heim & Garten > Haushaltsbedarf > Schuhpflege > Stiefelknechte','de-DE'),(1764,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung','de-DE'),(1765,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Fallen','de-DE'),(1766,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Fliegenklatschen','de-DE'),(1767,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Insektenschutz','de-DE'),(1768,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Insektenschutz > Mittel gegen Haushaltsinsekten','de-DE'),(1769,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Insektenschutz > Tierabwehr','de-DE'),(1770,'Heim & Garten > Haushaltsbedarf > Schädlingsbekämpfung > Schädlingsbekämpfungsmittel','de-DE'),(1771,'Heim & Garten > Haushaltsbedarf > Stufenteppiche','de-DE'),(1772,'Heim & Garten > Haushaltsbedarf > Teppichunterlagen','de-DE'),(1773,'Heim & Garten > Haushaltsbedarf > Trocknungsmittel','de-DE'),(1774,'Heim & Garten > Haushaltsbedarf > Wäschepflege','de-DE'),(1775,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Bleichmittel','de-DE'),(1776,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Bügelbretter','de-DE'),(1777,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Bügelbrettunterlagen & -bezüge','de-DE'),(1778,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Bügeleisenhalter','de-DE'),(1779,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Ersatzteile für Bügeleisen','de-DE'),(1780,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Fleckenentferner für Stoffe','de-DE'),(1781,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Fusselrasierer','de-DE'),(1782,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Fusselrollen','de-DE'),(1783,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Mittel gegen Falten & statische Aufladung','de-DE'),(1784,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Schweißabsorbierungspads','de-DE'),(1785,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Textilerfrischer','de-DE'),(1786,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Trockenreinigungssets','de-DE'),(1787,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Waschbälle','de-DE'),(1788,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Waschpulver','de-DE'),(1789,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Weichspüler & Trocknertücher','de-DE'),(1790,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Wäscheklammern','de-DE'),(1791,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Wäschekörbe','de-DE'),(1792,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Wäscheständer','de-DE'),(1793,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Wäschestärke','de-DE'),(1794,'Heim & Garten > Haushaltsbedarf > Wäschepflege > Wäschesäcke & Waschkörbe','de-DE'),(1795,'Heim & Garten > Haushaltsgeräte','de-DE'),(1796,'Heim & Garten > Haushaltsgeräte > Boden- & Teppichtrockner','de-DE'),(1797,'Heim & Garten > Haushaltsgeräte > Bohner- & Poliermaschinen','de-DE'),(1798,'Heim & Garten > Haushaltsgeräte > Dampf-Tapetenlöser','de-DE'),(1799,'Heim & Garten > Haushaltsgeräte > Futontrockner','de-DE'),(1800,'Heim & Garten > Haushaltsgeräte > Garagentorantrieb','de-DE'),(1801,'Heim & Garten > Haushaltsgeräte > Garagentoröffner','de-DE'),(1802,'Heim & Garten > Haushaltsgeräte > Heißwasserboiler','de-DE'),(1803,'Heim & Garten > Haushaltsgeräte > Klimatisierung','de-DE'),(1804,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Fog-Anlagen für den Außenbereich','de-DE'),(1805,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Kanalheizer','de-DE'),(1806,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Klimaanlagen','de-DE'),(1807,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Luftbefeuchter','de-DE'),(1808,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Luftentfeuchter','de-DE'),(1809,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Luftreiniger','de-DE'),(1810,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Radiatoren','de-DE'),(1811,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Raumheizgeräte','de-DE'),(1812,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Terrassenstrahler','de-DE'),(1813,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren','de-DE'),(1814,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren > Deckenventilatoren','de-DE'),(1815,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren > Handventilatoren','de-DE'),(1816,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren > Lüftungsventilatoren','de-DE'),(1817,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren > Tisch- & Standventilatoren','de-DE'),(1818,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Ventilatoren > Wandventilatoren','de-DE'),(1819,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Verdunstungskühler','de-DE'),(1820,'Heim & Garten > Haushaltsgeräte > Klimatisierung > Öfen & Kessel','de-DE'),(1821,'Heim & Garten > Haushaltsgeräte > Staubsauger','de-DE'),(1822,'Heim & Garten > Haushaltsgeräte > Teppich- & Dampfreinigungsgeräte','de-DE'),(1823,'Heim & Garten > Haushaltsgeräte > Ultraschallreiniger','de-DE'),(1824,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen','de-DE'),(1825,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Bügeleisen & -systeme','de-DE'),(1826,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Dampfglätter für Bekleidung','de-DE'),(1827,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Dampfpressen','de-DE'),(1828,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Waschmaschinen','de-DE'),(1829,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Waschtrockner','de-DE'),(1830,'Heim & Garten > Haushaltsgeräte > Waschen & Trocknen > Wäschetrockner','de-DE'),(1831,'Heim & Garten > Haushaltsgeräte-Zubehör','de-DE'),(1832,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör','de-DE'),(1833,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Abgasrohre','de-DE'),(1834,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Ausgleichsgefäß für Warmwasserbereiter','de-DE'),(1835,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Boiler','de-DE'),(1836,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Boilerwannen','de-DE'),(1837,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Heizelemente','de-DE'),(1838,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Heizungslüftung','de-DE'),(1839,'Heim & Garten > Haushaltsgeräte-Zubehör > Boiler-Zubehör > Opferanoden','de-DE'),(1840,'Heim & Garten > Haushaltsgeräte-Zubehör > Entfeuchterzubehör','de-DE'),(1841,'Heim & Garten > Haushaltsgeräte-Zubehör > Heizkessel- & Boilerzubehör','de-DE'),(1842,'Heim & Garten > Haushaltsgeräte-Zubehör > Heizkörperzubehör','de-DE'),(1843,'Heim & Garten > Haushaltsgeräte-Zubehör > Heizkörperzubehör > Heizkörperreflexionsfolie','de-DE'),(1844,'Heim & Garten > Haushaltsgeräte-Zubehör > Heizpilz-Zubehör','de-DE'),(1845,'Heim & Garten > Haushaltsgeräte-Zubehör > Heizpilz-Zubehör > Heizpilz-Abdeckungen','de-DE'),(1846,'Heim & Garten > Haushaltsgeräte-Zubehör > Klimaanlagen-Zubehör','de-DE'),(1847,'Heim & Garten > Haushaltsgeräte-Zubehör > Klimaanlagen-Zubehör > Abdeckungen für Klimaanlagen','de-DE'),(1848,'Heim & Garten > Haushaltsgeräte-Zubehör > Klimaanlagen-Zubehör > Klimaanlagenfilter','de-DE'),(1849,'Heim & Garten > Haushaltsgeräte-Zubehör > Luftbefeuchter-Zubehör','de-DE'),(1850,'Heim & Garten > Haushaltsgeräte-Zubehör > Luftbefeuchter-Zubehör > Luftbefeuchterfilter','de-DE'),(1851,'Heim & Garten > Haushaltsgeräte-Zubehör > Luftreinigerzubehör','de-DE'),(1852,'Heim & Garten > Haushaltsgeräte-Zubehör > Luftreinigerzubehör > Luftreinigerfilter','de-DE'),(1853,'Heim & Garten > Haushaltsgeräte-Zubehör > Staubsaugerzubehör','de-DE'),(1854,'Heim & Garten > Haushaltsgeräte-Zubehör > Teppich- & Dampfreinigerzubehör','de-DE'),(1855,'Heim & Garten > Haushaltsgeräte-Zubehör > Ventilatorenzubehör','de-DE'),(1856,'Heim & Garten > Haushaltsgeräte-Zubehör > Wasch-Zubehör','de-DE'),(1857,'Heim & Garten > Haushaltsgeräte-Zubehör > Wasch-Zubehör > Bügeleisenzubehör','de-DE'),(1858,'Heim & Garten > Haushaltsgeräte-Zubehör > Wasch-Zubehör > Zubehör für Dampfmaschinen','de-DE'),(1859,'Heim & Garten > Haushaltsgeräte-Zubehör > Wasch-Zubehör > Zubehör für Dampfpressen','de-DE'),(1860,'Heim & Garten > Haushaltsgeräte-Zubehör > Wasch-Zubehör > Zubehör für Waschmaschinen und Wäschetrockner','de-DE'),(1861,'Heim & Garten > Haussicherheit','de-DE'),(1862,'Heim & Garten > Haussicherheit > Bewegungsmelder','de-DE'),(1863,'Heim & Garten > Haussicherheit > Hausalarmsysteme','de-DE'),(1864,'Heim & Garten > Haussicherheit > Safe-Zubehör','de-DE'),(1865,'Heim & Garten > Haussicherheit > Safes & Tresore','de-DE'),(1866,'Heim & Garten > Haussicherheit > Sensoren für Sicherheitssysteme','de-DE'),(1867,'Heim & Garten > Haussicherheit > Sicherheitsleuchten','de-DE'),(1868,'Heim & Garten > Haussicherheit > Sicherheitsspiegel','de-DE'),(1869,'Heim & Garten > Haussicherheit > Überwachungskamera-Attrappen','de-DE'),(1870,'Heim & Garten > Haussicherheit > Überwachungsmonitore & -rekorder','de-DE'),(1871,'Heim & Garten > Holzöfen','de-DE'),(1872,'Heim & Garten > Kamine','de-DE'),(1873,'Heim & Garten > Küche & Esszimmer','de-DE'),(1874,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien','de-DE'),(1875,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Absinth-Fontänen','de-DE'),(1876,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Bierzapfhähne','de-DE'),(1877,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktail- & Barzubehörsets','de-DE'),(1878,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör','de-DE'),(1879,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör > Bar-Eispickel','de-DE'),(1880,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör > Barsiebe','de-DE'),(1881,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör > Cocktailshaker','de-DE'),(1882,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör > Cocktailstößel','de-DE'),(1883,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Cocktailshaker & Zubehör > Flaschenöffner','de-DE'),(1884,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Dekanter','de-DE'),(1885,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Flaschenstöpsel & -verschlüsse','de-DE'),(1886,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Flaschenverschlüsse','de-DE'),(1887,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Folienschneider','de-DE'),(1888,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Getränkewannen & -kühler','de-DE'),(1889,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Glasuntersetzer & Bierdeckel','de-DE'),(1890,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Korkenzieher','de-DE'),(1891,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Kühlsteine & -Sticks für Getränke','de-DE'),(1892,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Untersetzerhalter','de-DE'),(1893,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Weindekantierer','de-DE'),(1894,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Weinflaschenhalter','de-DE'),(1895,'Heim & Garten > Küche & Esszimmer > Bar-Utensilien > Weinglasanhänger','de-DE'),(1896,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter','de-DE'),(1897,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Brotdosen & -taschen','de-DE'),(1898,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Feldflaschen','de-DE'),(1899,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Flachmänner','de-DE'),(1900,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Getränkedeckel','de-DE'),(1901,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Getränkehüllen','de-DE'),(1902,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Getränkehüllen > Dosen- und Flaschenhüllen','de-DE'),(1903,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Getränkehüllen > Getränkebehälterhüllen','de-DE'),(1904,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Isolierbehälter','de-DE'),(1905,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Kühlboxen','de-DE'),(1906,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Kühltaschen','de-DE'),(1907,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Picknickkörbe','de-DE'),(1908,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Thermosflaschen','de-DE'),(1909,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Wasserflaschen','de-DE'),(1910,'Heim & Garten > Küche & Esszimmer > Essens- & Getränkebehälter > Weinflaschentaschen','de-DE'),(1911,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung','de-DE'),(1912,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung - Zubehör','de-DE'),(1913,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung - Zubehör > Etiketten für Lebensmittel und Getränke','de-DE'),(1914,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung - Zubehör > Sauerstoffabsorber','de-DE'),(1915,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung - Zubehör > Spender für Frischhaltefolie','de-DE'),(1916,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung - Zubehör > Verschlussstreifen & Verschlussclips','de-DE'),(1917,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Brotkästen & -taschen','de-DE'),(1918,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Frischhaltebeutel','de-DE'),(1919,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Honiggläser','de-DE'),(1920,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Kecksdosen & -behälter','de-DE'),(1921,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittel-Abdeckhauben','de-DE'),(1922,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelbehälter','de-DE'),(1923,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelverpackungsmaterial','de-DE'),(1924,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelverpackungsmaterial > Alufolien','de-DE'),(1925,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelverpackungsmaterial > Frischhaltefolien','de-DE'),(1926,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelverpackungsmaterial > Pergamentpapier','de-DE'),(1927,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Lebensmittelverpackungsmaterial > Wachspapier','de-DE'),(1928,'Heim & Garten > Küche & Esszimmer > Essensaufbewahrung > Nascheimer','de-DE'),(1929,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen','de-DE'),(1930,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen','de-DE'),(1931,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Auflaufförmchen & Souffléförmchen','de-DE'),(1932,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Back- & Plätzchenbleche','de-DE'),(1933,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Backzubehörsets','de-DE'),(1934,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Brotbackformen','de-DE'),(1935,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Bräter','de-DE'),(1936,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Grillbleche mit Fettpfannen','de-DE'),(1937,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Kuchen- & Quichebackformen','de-DE'),(1938,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Kuchenbackformen','de-DE'),(1939,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Muffin- & Gebäckformen','de-DE'),(1940,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Pizzableche','de-DE'),(1941,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backformen > Pizzasteine','de-DE'),(1942,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backzubehör','de-DE'),(1943,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backzubehör > Backgewichte','de-DE'),(1944,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backzubehör > Backmatten & -formen','de-DE'),(1945,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Backzubehör > Brätereinsätze','de-DE'),(1946,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr','de-DE'),(1947,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr & Backformen (Kombisets)','de-DE'),(1948,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Auflaufformen & Kasserollen','de-DE'),(1949,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Grillpfannen & -aufsätze','de-DE'),(1950,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Grillpressen','de-DE'),(1951,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Kochgeschirrsets','de-DE'),(1952,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Paellapfannen','de-DE'),(1953,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Pfannen für Crêpes und Pfannkuchen','de-DE'),(1954,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Rum- & Einmachtöpfe','de-DE'),(1955,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Sautépfannen','de-DE'),(1956,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Schmortöpfe','de-DE'),(1957,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Schnellkochtöpfe','de-DE'),(1958,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Stiel- & Bratpfannen','de-DE'),(1959,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Stieltöpfe','de-DE'),(1960,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Suppentöpfe','de-DE'),(1961,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Tajines & Tonkochtöpfe','de-DE'),(1962,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Wasserbadtöpfe','de-DE'),(1963,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Wasserkessel','de-DE'),(1964,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirr > Woks','de-DE'),(1965,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör','de-DE'),(1966,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Dampfkörbe','de-DE'),(1967,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Schnellkochtopfzubehör','de-DE'),(1968,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Topf- & Pfannendeckel','de-DE'),(1969,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Topf- & Pfannengriffe','de-DE'),(1970,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Wokzubehör','de-DE'),(1971,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Wokzubehör > Wokbürsten','de-DE'),(1972,'Heim & Garten > Küche & Esszimmer > Kochgeschirr & Backformen > Kochgeschirrzubehör > Wokzubehör > Wokringe','de-DE'),(1973,'Heim & Garten > Küche & Esszimmer > Küchenblöcke & Pantryküchen','de-DE'),(1974,'Heim & Garten > Küche & Esszimmer > Küchengeräte','de-DE'),(1975,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Abfallzerkleinerer','de-DE'),(1976,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Abzugshauben','de-DE'),(1977,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Aufschnittmaschine','de-DE'),(1978,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Außengrills','de-DE'),(1979,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Backöfen','de-DE'),(1980,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Brotbackautomaten','de-DE'),(1981,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Campingkocher','de-DE'),(1982,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Dörrautomaten','de-DE'),(1983,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Eis-Crusher & Eis-Shaver','de-DE'),(1984,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Eismaschinen','de-DE'),(1985,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Elektrische Pfannen & Woks','de-DE'),(1986,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Elektrogrills & -bratplatten','de-DE'),(1987,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Entsafter','de-DE'),(1988,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Fonduetöpfe & -Sets','de-DE'),(1989,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Fritteusen','de-DE'),(1990,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Gasgrillplatten','de-DE'),(1991,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Gefrierschränke & -truhen','de-DE'),(1992,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Geschirrspüler','de-DE'),(1993,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Getränkewärmer','de-DE'),(1994,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Grillöfen & Mini-Backöfen','de-DE'),(1995,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Heißgetränkebereiter','de-DE'),(1996,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Joghurtmaschinen','de-DE'),(1997,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen','de-DE'),(1998,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Espressokannen','de-DE'),(1999,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Espressomaschinen','de-DE'),(2000,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Filterkaffeemaschinen','de-DE'),(2001,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Perkolatoren & Kaffeebrüher','de-DE'),(2002,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Pressstempelkannen','de-DE'),(2003,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kaffee- & Espressomaschinen > Vakuumbereiter','de-DE'),(2004,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochfelder','de-DE'),(2005,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochplatten','de-DE'),(2006,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe','de-DE'),(2007,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Dampfgarer','de-DE'),(2008,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Eierkocher','de-DE'),(2009,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Reiskocher','de-DE'),(2010,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Schongarer','de-DE'),(2011,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Thermokocher','de-DE'),(2012,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kochtöpfe & Dampfkochtöpfe > Öfen zum Vakuumgaren','de-DE'),(2013,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Küchenherde','de-DE'),(2014,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Kühlschränke','de-DE'),(2015,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Lebensmittel-Räucheröfen','de-DE'),(2016,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Lebensmittelmühlen','de-DE'),(2017,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Messerschärfer','de-DE'),(2018,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Mikrowellenherde','de-DE'),(2019,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Milchaufschäumer','de-DE'),(2020,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Mixer & Pürierstäbe','de-DE'),(2021,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Mochi-Maschinen','de-DE'),(2022,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Müllpressen','de-DE'),(2023,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Nudelmaschinen','de-DE'),(2024,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Popcornmaschinen','de-DE'),(2025,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Slush-Eis-Maschinen','de-DE'),(2026,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Sojamilchbereiter','de-DE'),(2027,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speiseeismaschinen','de-DE'),(2028,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speisewärmer','de-DE'),(2029,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speisewärmer > Buffetwärmer','de-DE'),(2030,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speisewärmer > Reiswärmer','de-DE'),(2031,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speisewärmer > Speisewärmelampen','de-DE'),(2032,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Speisewärmer > Warmhaltetische','de-DE'),(2033,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Teekocher','de-DE'),(2034,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Temperiermaschinen für Schokolade','de-DE'),(2035,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills','de-DE'),(2036,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Brezelbackautomat','de-DE'),(2037,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Donutmaker','de-DE'),(2038,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Mini- & Toastöfen','de-DE'),(2039,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Muffin- & Cupcake-Maker','de-DE'),(2040,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Pizzaöfen','de-DE'),(2041,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Pizzelle-Eisen','de-DE'),(2042,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Quesadilla- & Tortilla-Maker','de-DE'),(2043,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Sandwichtoaster','de-DE'),(2044,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Toaster','de-DE'),(2045,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Toaster & Grills > Waffeleisen','de-DE'),(2046,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Trinkwasserspender','de-DE'),(2047,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Vakuumierer','de-DE'),(2048,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Wasserfilter','de-DE'),(2049,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Wasserkocher','de-DE'),(2050,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Wassersprudler','de-DE'),(2051,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Weinkühlschränke','de-DE'),(2052,'Heim & Garten > Küche & Esszimmer > Küchengeräte > Zuckerwattemaschinen','de-DE'),(2053,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien','de-DE'),(2054,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Abkühlgitter','de-DE'),(2055,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Abtropf- & Küchensiebe','de-DE'),(2056,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Allespicker & Spieße','de-DE'),(2057,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Ausstechförmchen','de-DE'),(2058,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Backpinsel','de-DE'),(2059,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Backschaufeln','de-DE'),(2060,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Bratenspritzen','de-DE'),(2061,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Bratschläuche','de-DE'),(2062,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Dampfgarbeutel','de-DE'),(2063,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Dessertformen','de-DE'),(2064,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Dosenpressen','de-DE'),(2065,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Dosenöffner','de-DE'),(2066,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Dressing-Shaker','de-DE'),(2067,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Eiswürfelformen','de-DE'),(2068,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Elektromesser','de-DE'),(2069,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Elektromesserzubehör','de-DE'),(2070,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Elektromesserzubehör > Elektromesser-Ersatzklingen','de-DE'),(2071,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Essig- & Ölspender','de-DE'),(2072,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Flambierbrenner','de-DE'),(2073,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Fleischgabeln','de-DE'),(2074,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Fleischklopfer','de-DE'),(2075,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Fleischpistolen','de-DE'),(2076,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Geschirrständer & Abtropfflächen','de-DE'),(2077,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Getränkespender','de-DE'),(2078,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Gewürzmühlen','de-DE'),(2079,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Kartoffelpressen','de-DE'),(2080,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Keksmaschine','de-DE'),(2081,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Kellen','de-DE'),(2082,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Knoblauchpressen','de-DE'),(2083,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Kochthermometer','de-DE'),(2084,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Kuchen-Dekorationsbedarf','de-DE'),(2085,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Kurzzeitmesser & Eieruhren','de-DE'),(2086,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenformen','de-DE'),(2087,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenmesser','de-DE'),(2088,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer','de-DE'),(2089,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Besteckkästen','de-DE'),(2090,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Gewürzregale & -ständer','de-DE'),(2091,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Halter für Küchenutensilien','de-DE'),(2092,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Konservenregal','de-DE'),(2093,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Küchenrollenhalter & -spender','de-DE'),(2094,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Küchenschranksysteme','de-DE'),(2095,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Messerblöcke & -halter','de-DE'),(2096,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Organizer für Küchenutensilien','de-DE'),(2097,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Serviettenhalter & -spender','de-DE'),(2098,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Topfregale','de-DE'),(2099,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Trinkgefäßhalter','de-DE'),(2100,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Trinkhalmhalter & -spender','de-DE'),(2101,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Zahnstocherbehälter & -spender','de-DE'),(2102,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenorganizer > Zuckertütenhalter','de-DE'),(2103,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenschaber','de-DE'),(2104,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenschaber > Grillschaber','de-DE'),(2105,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenschaber > Teigschaber','de-DE'),(2106,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenschaber > Teigspatel','de-DE'),(2107,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenscheren','de-DE'),(2108,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenschneidegeräte','de-DE'),(2109,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenthermometer-Zubehör','de-DE'),(2110,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchentrichter','de-DE'),(2111,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenutensilien-Sets','de-DE'),(2112,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Küchenzangen','de-DE'),(2113,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Lebensmittelschablonen','de-DE'),(2114,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Löffelablagen','de-DE'),(2115,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Mehlsiebe','de-DE'),(2116,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Messbecher & Dosierlöffel','de-DE'),(2117,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Mörser & Stößel','de-DE'),(2118,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Nahrungsmittelspender','de-DE'),(2119,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Pastaförmchen','de-DE'),(2120,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Pfannenwender','de-DE'),(2121,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Pizzaschneider','de-DE'),(2122,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Pizzaschneider-Zubehör','de-DE'),(2123,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Portionierer','de-DE'),(2124,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Portionierer > Eiscremeportionierer','de-DE'),(2125,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Portionierer > Eisportionierer','de-DE'),(2126,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Portionierer > Kugelausstecher','de-DE'),(2127,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Portionierer > Popcorn- & Pommesschaufeln','de-DE'),(2128,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Reiben','de-DE'),(2129,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Rührschüsseln','de-DE'),(2130,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Salatschleudern','de-DE'),(2131,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Saucenspender','de-DE'),(2132,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Schaumlöffel','de-DE'),(2133,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Schneebesen','de-DE'),(2134,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Schneidebretter','de-DE'),(2135,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Schäler & Entkerner','de-DE'),(2136,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Schürzen','de-DE'),(2137,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spezialbesteck & Nussknacker','de-DE'),(2138,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spezialbesteck & Nussknacker > Hummer- & Krebszangen','de-DE'),(2139,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spezialbesteck & Nussknacker > Nussknacker','de-DE'),(2140,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spezialbesteck & Nussknacker > Nussknacker > Dekorative Nussknacker','de-DE'),(2141,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spülbeckenkörbe','de-DE'),(2142,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Spülbeckenmatten','de-DE'),(2143,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Stampfer','de-DE'),(2144,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Sushi-Matten','de-DE'),(2145,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teesiebe','de-DE'),(2146,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigmischer','de-DE'),(2147,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigrollen','de-DE'),(2148,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigrollenzubehör','de-DE'),(2149,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigrollenzubehör > Abstandsringe für Teigrollen','de-DE'),(2150,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigrollenzubehör > Teigrollenhüllen & -überzüge','de-DE'),(2151,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigräder','de-DE'),(2152,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Teigtücher','de-DE'),(2153,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Topfhandschuhe & Topflappen','de-DE'),(2154,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Tortenheber','de-DE'),(2155,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Ziseliermesser','de-DE'),(2156,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Zubehör für Gewürzmühlen','de-DE'),(2157,'Heim & Garten > Küche & Esszimmer > Küchenhelfer & -utensilien > Zuckerspender','de-DE'),(2158,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr','de-DE'),(2159,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Geschirr','de-DE'),(2160,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Geschirr > Geschirrsets','de-DE'),(2161,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Geschirr > Schüsseln','de-DE'),(2162,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Geschirr > Teller','de-DE'),(2163,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Kaffee- & Teekannen','de-DE'),(2164,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Kaffee- & Teeservices','de-DE'),(2165,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Klemmen & Gewichte für Tischdecken','de-DE'),(2166,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Salz- & Pfefferstreuer','de-DE'),(2167,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierbesteck','de-DE'),(2168,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierbesteck > Bowlenschüsseluntersatz','de-DE'),(2169,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierbesteck > Terrinendeckel','de-DE'),(2170,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierbesteck > Terrinenuntersatz','de-DE'),(2171,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware','de-DE'),(2172,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Bowleschüsseln','de-DE'),(2173,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Butterdosen','de-DE'),(2174,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Eierbecher','de-DE'),(2175,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Karaffen','de-DE'),(2176,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Kuchenplatten','de-DE'),(2177,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Saucièren','de-DE'),(2178,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Servierplatten','de-DE'),(2179,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Serviertabletts','de-DE'),(2180,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Terrinen','de-DE'),(2181,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Tortenständer','de-DE'),(2182,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Servierware > Zuckerdosen & Milchkännchen','de-DE'),(2183,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke','de-DE'),(2184,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Besteck-Sets','de-DE'),(2185,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Essstäbchen','de-DE'),(2186,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Essstäbchenzubehör','de-DE'),(2187,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Gabeln','de-DE'),(2188,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Löffel','de-DE'),(2189,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Tischbestecke > Tafelmesser','de-DE'),(2190,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Topfuntersetzer','de-DE'),(2191,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße','de-DE'),(2192,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Biergläser','de-DE'),(2193,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Kaffee- & Teebecher','de-DE'),(2194,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Kaffee- und Teetassen','de-DE'),(2195,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Kaffee- und Teeuntertassen','de-DE'),(2196,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Schnapsgläser','de-DE'),(2197,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Stielgläser','de-DE'),(2198,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Trinkbehältersets','de-DE'),(2199,'Heim & Garten > Küche & Esszimmer > Tafelgeschirr > Trinkgefäße > Trinkgläser','de-DE'),(2200,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte','de-DE'),(2201,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör','de-DE'),(2202,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Anzündkamine','de-DE'),(2203,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Außengrillabdeckungen','de-DE'),(2204,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Außengrillroste & -auflagen','de-DE'),(2205,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Außengrillspieße & -körbe','de-DE'),(2206,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Ersatzteile für Außengrills','de-DE'),(2207,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Grillbretter','de-DE'),(2208,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Grillwagen','de-DE'),(2209,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Holzkohle','de-DE'),(2210,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Außengrillzubehör > Räucherchips & -Pellets','de-DE'),(2211,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Dunstabzugshauben-Zubehör','de-DE'),(2212,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Dörrautomatenzubehör','de-DE'),(2213,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Dörrautomatenzubehör > Dörrautomatenbleche','de-DE'),(2214,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Dörrautomatenzubehör > Dörrautomatentabletts','de-DE'),(2215,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Entsafterzubehör','de-DE'),(2216,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Fonduesetzubehör','de-DE'),(2217,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Fonduesetzubehör > Chafing Dish- & Fonduebrennpasten','de-DE'),(2218,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Fonduesetzubehör > Fonduegabeln','de-DE'),(2219,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Fonduesetzubehör > Fonduetopfständer','de-DE'),(2220,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Fritteusenzubehör','de-DE'),(2221,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Küchenabfallzerkleinerer-Zubehör','de-DE'),(2222,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Kühlschrankzubehör','de-DE'),(2223,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Mikrowellenzubehör','de-DE'),(2224,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Nudelmaschinenzubehör','de-DE'),(2225,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Speiseeismaschinenzubehör','de-DE'),(2226,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Speiseeismaschinenzubehör > Gefrierschüsseln für Speiseeismaschinen','de-DE'),(2227,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Spülmaschinenzubehör','de-DE'),(2228,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Toasterzubehör','de-DE'),(2229,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Vakuumiererzubehör','de-DE'),(2230,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Vakuumiererzubehör > Vakuumierer-Beutel','de-DE'),(2231,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Wasserspenderzubehör','de-DE'),(2232,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Wasserspenderzubehör > Flaschen für Wasserspender','de-DE'),(2233,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Weinkühlschrank-Zubehör','de-DE'),(2234,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Brotbackautomaten','de-DE'),(2235,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Campingöfen','de-DE'),(2236,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Eis-Crusher & Eis-Shaver','de-DE'),(2237,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Eismaschinen','de-DE'),(2238,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Gefrierschränke','de-DE'),(2239,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Herdplatten, Backöfen und Küchenherde','de-DE'),(2240,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Joghurtmaschinen','de-DE'),(2241,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen','de-DE'),(2242,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Aufschäumer','de-DE'),(2243,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Ersatzteile für Espresso- & Kaffeemaschinen','de-DE'),(2244,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeefilter','de-DE'),(2245,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeefilterkörbe','de-DE'),(2246,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeekannen','de-DE'),(2247,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeekannenwarmhalter','de-DE'),(2248,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeemühlen','de-DE'),(2249,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Kaffeemühlenzubehör','de-DE'),(2250,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Siebträger','de-DE'),(2251,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Kaffee- & Espressomaschinen > Wasserfilter für Kaffeemaschinen','de-DE'),(2252,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Lebensmittelmühlen','de-DE'),(2253,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Mixer & Pürierstäbe','de-DE'),(2254,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Popcornmaschinen','de-DE'),(2255,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Trinkwassersprudler','de-DE'),(2256,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Waffeleisen','de-DE'),(2257,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Warmhaltetheken','de-DE'),(2258,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Warmhaltetheken > Behälter für Warmhaltetheken','de-DE'),(2259,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Warmhaltetheken > Deckel für Warmhaltebehälter','de-DE'),(2260,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Wasserkocher','de-DE'),(2261,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für Zuckerwattemaschinen','de-DE'),(2262,'Heim & Garten > Küche & Esszimmer > Zubehör für Küchengeräte > Zubehör für elektrische Pfannen & Woks','de-DE'),(2263,'Heim & Garten > Notfallvorsorge','de-DE'),(2264,'Heim & Garten > Notfallvorsorge > Erdbebenmelder','de-DE'),(2265,'Heim & Garten > Notfallvorsorge > Möbelanker','de-DE'),(2266,'Heim & Garten > Notfallvorsorge > Notfalldecken','de-DE'),(2267,'Heim & Garten > Notfallvorsorge > Notfallwerkzeuge','de-DE'),(2268,'Heim & Garten > Notfallvorsorge > Notvorräte','de-DE'),(2269,'Heim & Garten > Pflanzen','de-DE'),(2270,'Heim & Garten > Pflanzen > Blumen','de-DE'),(2271,'Heim & Garten > Pflanzen > Bäume','de-DE'),(2272,'Heim & Garten > Pflanzen > Grünpflanzen, Büsche & Sträucher','de-DE'),(2273,'Heim & Garten > Pflanzen > Pflanzen- & Kräuteranbausets','de-DE'),(2274,'Heim & Garten > Pflanzen > Saatgut','de-DE'),(2275,'Heim & Garten > Pflanzen > Wasserpflanzen','de-DE'),(2276,'Heim & Garten > Pool & Spa','de-DE'),(2277,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör','de-DE'),(2278,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Badeinseln & Schwimmliegen','de-DE'),(2279,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Badespielzeug','de-DE'),(2280,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Chlorgeneratoren für Pools und Whirlpools','de-DE'),(2281,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Mechanische & Chemische Poolreiniger','de-DE'),(2282,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Pool- & Whirlpool-Filter','de-DE'),(2283,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolabdeckungen & -unterlagen','de-DE'),(2284,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolbürsten','de-DE'),(2285,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolfolien','de-DE'),(2286,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolleitern, -treppen & -rampen','de-DE'),(2287,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolreinigungsgeräte','de-DE'),(2288,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Poolskimmer','de-DE'),(2289,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Schläuche für Poolreiniger','de-DE'),(2290,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Sonnendecks','de-DE'),(2291,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Sprungbretter','de-DE'),(2292,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Swimmingpoolheizungen','de-DE'),(2293,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Wartungssets für Pools & Whirlpools','de-DE'),(2294,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Wasserrutschen','de-DE'),(2295,'Heim & Garten > Pool & Spa > Pool- & Whirlpool-Zubehör > Zubehör für Poolabdeckungen','de-DE'),(2296,'Heim & Garten > Pool & Spa > Pools','de-DE'),(2297,'Heim & Garten > Pool & Spa > Saunen','de-DE'),(2298,'Heim & Garten > Pool & Spa > Spa-Becken','de-DE'),(2299,'Heim & Garten > Rasen & Garten','de-DE'),(2300,'Heim & Garten > Rasen & Garten > Bewässerungssysteme','de-DE'),(2301,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Gartenschlauchsprühköpfe','de-DE'),(2302,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Gartenschlauchzubehör & -ventile','de-DE'),(2303,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Gartenschläuche','de-DE'),(2304,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Gießkannen','de-DE'),(2305,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Sprinkler & -köpfe','de-DE'),(2306,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Sprinklersysteme','de-DE'),(2307,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Sprinklersysteme > Sprinklerventile','de-DE'),(2308,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Sprinklersysteme > Steuerelemente für Sprinkleranlagen','de-DE'),(2309,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Wasserspender für Pflanzen','de-DE'),(2310,'Heim & Garten > Rasen & Garten > Bewässerungssysteme > Zubehör für Gießkannen','de-DE'),(2311,'Heim & Garten > Rasen & Garten > Garten & Balkon','de-DE'),(2312,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten','de-DE'),(2313,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Bögen, Gitter, Laubengänge & Pergolen','de-DE'),(2314,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Gartenbrücken','de-DE'),(2315,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör','de-DE'),(2316,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör > Dächer für Pavillions','de-DE'),(2317,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör > Gewichte für Sonnendächer','de-DE'),(2318,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör > Rahmen für Pavillons','de-DE'),(2319,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör > Seitenwand-Sets für Pavillons','de-DE'),(2320,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillon-Zubehör > Stangen für Sonnendächer','de-DE'),(2321,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Pavillons & Gartenlauben','de-DE'),(2322,'Heim & Garten > Rasen & Garten > Garten & Balkon > Gartenhäuschen & Gartenbauten > Schuppen, Garagen & Carports','de-DE'),(2323,'Heim & Garten > Rasen & Garten > Garten & Balkon > Hollywoodschaukeln','de-DE'),(2324,'Heim & Garten > Rasen & Garten > Garten & Balkon > Hängematten','de-DE'),(2325,'Heim & Garten > Rasen & Garten > Garten & Balkon > Hängemattenzubehör','de-DE'),(2326,'Heim & Garten > Rasen & Garten > Garten & Balkon > Markisen','de-DE'),(2327,'Heim & Garten > Rasen & Garten > Garten & Balkon > Markisen-Zubehör','de-DE'),(2328,'Heim & Garten > Rasen & Garten > Garten & Balkon > Outdoor-Decken','de-DE'),(2329,'Heim & Garten > Rasen & Garten > Garten & Balkon > Outdoor-Decken > Picknickdecken','de-DE'),(2330,'Heim & Garten > Rasen & Garten > Garten & Balkon > Outdoor-Decken > Poncholiner','de-DE'),(2331,'Heim & Garten > Rasen & Garten > Garten & Balkon > Outdoor-Decken > Strandmatten','de-DE'),(2332,'Heim & Garten > Rasen & Garten > Garten & Balkon > Sonnenschirme','de-DE'),(2333,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Hollywoodschaukeln','de-DE'),(2334,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme','de-DE'),(2335,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme > Sonnenschirmabdeckungen','de-DE'),(2336,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme > Sonnenschirmbeleuchtung','de-DE'),(2337,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme > Sonnenschirmschutzhüllen','de-DE'),(2338,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme > Sonnenschirmstoff','de-DE'),(2339,'Heim & Garten > Rasen & Garten > Garten & Balkon > Zubehör für Sonnenschirme > Sonnenschirmständer','de-DE'),(2340,'Heim & Garten > Rasen & Garten > Gartenbau','de-DE'),(2341,'Heim & Garten > Rasen & Garten > Gartenbau > Blumenkäfige & Zubehör','de-DE'),(2342,'Heim & Garten > Rasen & Garten > Gartenbau > Blumentöpfe & Pflanzgefäße','de-DE'),(2343,'Heim & Garten > Rasen & Garten > Gartenbau > Dünger','de-DE'),(2344,'Heim & Garten > Rasen & Garten > Gartenbau > Gartentopfuntersetzer und Trays','de-DE'),(2345,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge','de-DE'),(2346,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Astsägen','de-DE'),(2347,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Baumscheren','de-DE'),(2348,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Gartensicheln & Macheten','de-DE'),(2349,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Geräte zum Pflanzen von Knollen','de-DE'),(2350,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Mistgabeln','de-DE'),(2351,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Pflanzkellen','de-DE'),(2352,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Pflanzwerkzeuge','de-DE'),(2353,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Rasen- & Gartenspritzgeräte','de-DE'),(2354,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Rasenwalzen','de-DE'),(2355,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Rechen','de-DE'),(2356,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Schaufeln & Spaten','de-DE'),(2357,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Schubkarren','de-DE'),(2358,'Heim & Garten > Rasen & Garten > Gartenbau > Gartenwerkzeuge > Streugeräte','de-DE'),(2359,'Heim & Garten > Rasen & Garten > Gartenbau > Gewächshäuser','de-DE'),(2360,'Heim & Garten > Rasen & Garten > Gartenbau > Herbizide','de-DE'),(2361,'Heim & Garten > Rasen & Garten > Gartenbau > Kompostieren','de-DE'),(2362,'Heim & Garten > Rasen & Garten > Gartenbau > Kompostieren > Kompost','de-DE'),(2363,'Heim & Garten > Rasen & Garten > Gartenbau > Kompostieren > Komposter','de-DE'),(2364,'Heim & Garten > Rasen & Garten > Gartenbau > Kompostieren > Kompostlüfter','de-DE'),(2365,'Heim & Garten > Rasen & Garten > Gartenbau > Krankheitsbekämpfung','de-DE'),(2366,'Heim & Garten > Rasen & Garten > Gartenbau > Mulch','de-DE'),(2367,'Heim & Garten > Rasen & Garten > Gartenbau > Pflanzeinsätze für Blumentöpfe und -kübel','de-DE'),(2368,'Heim & Garten > Rasen & Garten > Gartenbau > Pflanzenständer','de-DE'),(2369,'Heim & Garten > Rasen & Garten > Gartenbau > Regenfässer','de-DE'),(2370,'Heim & Garten > Rasen & Garten > Gartenbau > Sand & Gartenerde','de-DE'),(2371,'Heim & Garten > Rasen & Garten > Gartenbau > Unkrautvlies','de-DE'),(2372,'Heim & Garten > Rasen & Garten > Gartenbau > Unkrautvlies-Zubehör','de-DE'),(2373,'Heim & Garten > Rasen & Garten > Gartenbau > Unkrautvlies-Zubehör > Erdanker & -nägel','de-DE'),(2374,'Heim & Garten > Rasen & Garten > Gartenbau > Unkrautvlies-Zubehör > Garten - Gewebeband','de-DE'),(2375,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartenarbeit','de-DE'),(2376,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartenarbeit > Gartentaschen','de-DE'),(2377,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartenarbeit > Rollsitze, Sitzhilfen & Kniekissen für Gartenarbeit','de-DE'),(2378,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartenarbeit > Umtopftische','de-DE'),(2379,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartengeräte','de-DE'),(2380,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartengeräte > Aufsätze für Gartengeräte','de-DE'),(2381,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartengeräte > Griffe für Gartengeräte','de-DE'),(2382,'Heim & Garten > Rasen & Garten > Gartenbau > Zubehör für Gartengeräte > Schubkarrenteile','de-DE'),(2383,'Heim & Garten > Rasen & Garten > Gartenmaschinen','de-DE'),(2384,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Basiseinheiten für elektrische Gartengeräte','de-DE'),(2385,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Bodenbearbeitungsmaschinen','de-DE'),(2386,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Elektrische Heckenscheren','de-DE'),(2387,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Elektrische Kombi-Gartenmaschinen-Sets','de-DE'),(2388,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Hochdruckreiniger','de-DE'),(2389,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Kehrmaschine','de-DE'),(2390,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Kettensägen','de-DE'),(2391,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Laubbläser','de-DE'),(2392,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Laubsauger','de-DE'),(2393,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenkantentrimmer','de-DE'),(2394,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenlüfter und Vertikutierer','de-DE'),(2395,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenmäher','de-DE'),(2396,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenmäher > Aufsitzrasenmäher','de-DE'),(2397,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenmäher > Handrasenmäher','de-DE'),(2398,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenmäher > Mähroboter','de-DE'),(2399,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasenmäher > Quad-Anhänger','de-DE'),(2400,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Rasentrimmer & Freischneider','de-DE'),(2401,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Schneefräsen','de-DE'),(2402,'Heim & Garten > Rasen & Garten > Gartenmaschinen > Traktoren','de-DE'),(2403,'Heim & Garten > Rasen & Garten > Schnee- und Eisbeseitigung','de-DE'),(2404,'Heim & Garten > Rasen & Garten > Schnee- und Eisbeseitigung > Eiskratzer & Schneebesen','de-DE'),(2405,'Heim & Garten > Rasen & Garten > Schnee- und Eisbeseitigung > Schneeschaufeln','de-DE'),(2406,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen','de-DE'),(2407,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen','de-DE'),(2408,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Fräsen- und Grubber-Aufsätze','de-DE'),(2409,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Heckenscheren-Aufsätze','de-DE'),(2410,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Laubbläser-Aufsätze','de-DE'),(2411,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Rasentrimmer-Aufsätze','de-DE'),(2412,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Stangensägen-Aufsätze','de-DE'),(2413,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Aufsätze für elektrische Kombi-Gartenmaschinen > Unkrauttrimmer-Aufsätze','de-DE'),(2414,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Batterien für elektrische Kombi-Gartenmaschinen','de-DE'),(2415,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Heckenscheren-Zubehör','de-DE'),(2416,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Hochdruckreiniger-Zubehör','de-DE'),(2417,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Kettensägenzubehör','de-DE'),(2418,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Kettensägenzubehör > Kettensägenketten','de-DE'),(2419,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Kettensägenzubehör > Kettensägenschwerter','de-DE'),(2420,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Laubbläser-Zubehör','de-DE'),(2421,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Laubbläser-Zubehör > Laubbläser-Rohre','de-DE'),(2422,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör','de-DE'),(2423,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Grasauffangbehälter','de-DE'),(2424,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Mulchkits für Rasenmäher','de-DE'),(2425,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Mulchstopfen für Rasenmäher','de-DE'),(2426,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenkehrmaschinen','de-DE'),(2427,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Antriebsrollen','de-DE'),(2428,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Keilriemen','de-DE'),(2429,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Reifen','de-DE'),(2430,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Reifenschläuche','de-DE'),(2431,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Riemenscheiben','de-DE'),(2432,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäher-Räder','de-DE'),(2433,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmäherabdeckungen','de-DE'),(2434,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Rasenmähermesser','de-DE'),(2435,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasenmäher-Zubehör > Wiesenmäher-Zusatzteile','de-DE'),(2436,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Rasentrimmer-Zubehör','de-DE'),(2437,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Schneefräsenzubehör','de-DE'),(2438,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Traktorteile & Zubehör','de-DE'),(2439,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Traktorteile & Zubehör > Traktorreifen','de-DE'),(2440,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Traktorteile & Zubehör > Traktorräder','de-DE'),(2441,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Unkrauttrimmer-Zubehör','de-DE'),(2442,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Unkrauttrimmer-Zubehör > Abdeckungen für Rasentrimmer-Kabelrollen','de-DE'),(2443,'Heim & Garten > Rasen & Garten > Zubehör für Gartenmaschinen > Unkrauttrimmer-Zubehör > Messer & Kabelrollen für Rasentrimmer','de-DE'),(2444,'Heim & Garten > Rauchzubehör','de-DE'),(2445,'Heim & Garten > Rauchzubehör > Aschenbecher','de-DE'),(2446,'Heim & Garten > Rauchzubehör > Humidore','de-DE'),(2447,'Heim & Garten > Rauchzubehör > Humidorzubehör','de-DE'),(2448,'Heim & Garten > Rauchzubehör > Zigarettenhalter','de-DE'),(2449,'Heim & Garten > Rauchzubehör > Zigarettenkisten','de-DE'),(2450,'Heim & Garten > Rauchzubehör > Zigarrenkisten','de-DE'),(2451,'Heim & Garten > Rauchzubehör > Zigarrenschneider & -locher','de-DE'),(2452,'Heim & Garten > Schutzhüllen für Sonnenschirme','de-DE'),(2453,'Heim & Garten > Sonnen- & Regenschirme','de-DE'),(2454,'Heim & Garten > Zubehör für Kamine & Holzöfen','de-DE'),(2455,'Heim & Garten > Zubehör für Kamine & Holzöfen > Blasebälge','de-DE'),(2456,'Heim & Garten > Zubehör für Kamine & Holzöfen > Feuerböcke','de-DE'),(2457,'Heim & Garten > Zubehör für Kamine & Holzöfen > Feuerholz & Brennstoffe','de-DE'),(2458,'Heim & Garten > Zubehör für Kamine & Holzöfen > Feuerholz-Aufbewahrung','de-DE'),(2459,'Heim & Garten > Zubehör für Kamine & Holzöfen > Holzofenventilatoren & -gebläse','de-DE'),(2460,'Heim & Garten > Zubehör für Kamine & Holzöfen > Kamin- & Holzofenroste','de-DE'),(2461,'Heim & Garten > Zubehör für Kamine & Holzöfen > Kaminbodenplatten','de-DE'),(2462,'Heim & Garten > Zubehör für Kamine & Holzöfen > Kamingitter','de-DE'),(2463,'Heim & Garten > Zubehör für Kamine & Holzöfen > Kaminreflektoren','de-DE'),(2464,'Heim & Garten > Zubehör für Kamine & Holzöfen > Kaminwerkzeug','de-DE'),(2465,'Heim & Garten > Zubehör für Kamine & Holzöfen > Zubehör für Feuerholz-Aufbewahrung','de-DE'),(2466,'Heimwerkerbedarf','de-DE'),(2467,'Heimwerkerbedarf > Baumaterial','de-DE'),(2468,'Heimwerkerbedarf > Baumaterial > Chemikalien','de-DE'),(2469,'Heimwerkerbedarf > Baumaterial > Chemikalien > Abflussreiniger','de-DE'),(2470,'Heimwerkerbedarf > Baumaterial > Chemikalien > Ammonium','de-DE'),(2471,'Heimwerkerbedarf > Baumaterial > Chemikalien > Anzünderflüssigkeit','de-DE'),(2472,'Heimwerkerbedarf > Baumaterial > Chemikalien > Beton- & Mauerreiniger','de-DE'),(2473,'Heimwerkerbedarf > Baumaterial > Chemikalien > Enteiser','de-DE'),(2474,'Heimwerkerbedarf > Baumaterial > Chemikalien > Holzterrassen- & -zaunreiniger','de-DE'),(2475,'Heimwerkerbedarf > Baumaterial > Chemikalien > Kaminreiniger','de-DE'),(2476,'Heimwerkerbedarf > Baumaterial > Chemikalien > Kältespray für Elektronik','de-DE'),(2477,'Heimwerkerbedarf > Baumaterial > Chemikalien > Reiniger für Abwassertanks & Senkgruben','de-DE'),(2478,'Heimwerkerbedarf > Baumaterial > Chemikalien > Säureneutralisierer','de-DE'),(2479,'Heimwerkerbedarf > Baumaterial > Klebebänder','de-DE'),(2480,'Heimwerkerbedarf > Baumaterial > Kraftklebstoffe & -leime','de-DE'),(2481,'Heimwerkerbedarf > Baumaterial > Lösungsmittel, Abbeizmittel & Verdünner','de-DE'),(2482,'Heimwerkerbedarf > Baumaterial > Lötmetall & Flussmittel','de-DE'),(2483,'Heimwerkerbedarf > Baumaterial > Malermaterial','de-DE'),(2484,'Heimwerkerbedarf > Baumaterial > Malermaterial > Farbe','de-DE'),(2485,'Heimwerkerbedarf > Baumaterial > Malermaterial > Farbenbindemittel','de-DE'),(2486,'Heimwerkerbedarf > Baumaterial > Malermaterial > Farbstoffe','de-DE'),(2487,'Heimwerkerbedarf > Baumaterial > Malermaterial > Grundierungen','de-DE'),(2488,'Heimwerkerbedarf > Baumaterial > Malermaterial > Lacke & Beschichtungen','de-DE'),(2489,'Heimwerkerbedarf > Baumaterial > Maurermaterial','de-DE'),(2490,'Heimwerkerbedarf > Baumaterial > Maurermaterial > Mauersteine & Betonblöcke','de-DE'),(2491,'Heimwerkerbedarf > Baumaterial > Maurermaterial > Mörtel','de-DE'),(2492,'Heimwerkerbedarf > Baumaterial > Maurermaterial > Zement, Mörtel & Beton','de-DE'),(2493,'Heimwerkerbedarf > Baumaterial > Primer für Rohrverbindungen','de-DE'),(2494,'Heimwerkerbedarf > Baumaterial > Schmiermittel','de-DE'),(2495,'Heimwerkerbedarf > Baumaterial > Schutzbeschichtungen & Dichtmittel','de-DE'),(2496,'Heimwerkerbedarf > Baumaterial > Wandausbesserungsmaterial & Gips','de-DE'),(2497,'Heimwerkerbedarf > Baumaterialien','de-DE'),(2498,'Heimwerkerbedarf > Baumaterialien > Arbeitsplatten','de-DE'),(2499,'Heimwerkerbedarf > Baumaterialien > Bauholz','de-DE'),(2500,'Heimwerkerbedarf > Baumaterialien > Bedachung','de-DE'),(2501,'Heimwerkerbedarf > Baumaterialien > Bedachung > Dachrinnen','de-DE'),(2502,'Heimwerkerbedarf > Baumaterialien > Bedachung > Dachschindeln & -pfannen','de-DE'),(2503,'Heimwerkerbedarf > Baumaterialien > Bedachung > Kehlbleche','de-DE'),(2504,'Heimwerkerbedarf > Baumaterialien > Bedachung > Zubehör für Dachrinnen','de-DE'),(2505,'Heimwerkerbedarf > Baumaterialien > Betonstahl & -gitter','de-DE'),(2506,'Heimwerkerbedarf > Baumaterialien > Fenster','de-DE'),(2507,'Heimwerkerbedarf > Baumaterialien > Fensterbauteile','de-DE'),(2508,'Heimwerkerbedarf > Baumaterialien > Fensterbauteile > Fensterhebel','de-DE'),(2509,'Heimwerkerbedarf > Baumaterialien > Fensterbauteile > Fensterrahmen','de-DE'),(2510,'Heimwerkerbedarf > Baumaterialien > Fensterläden','de-DE'),(2511,'Heimwerkerbedarf > Baumaterialien > Fußböden & Teppichböden','de-DE'),(2512,'Heimwerkerbedarf > Baumaterialien > Gipskartonplatten','de-DE'),(2513,'Heimwerkerbedarf > Baumaterialien > Glas','de-DE'),(2514,'Heimwerkerbedarf > Baumaterialien > Handläufe und Geländersysteme','de-DE'),(2515,'Heimwerkerbedarf > Baumaterialien > Hausverkleidung','de-DE'),(2516,'Heimwerkerbedarf > Baumaterialien > Isolierung','de-DE'),(2517,'Heimwerkerbedarf > Baumaterialien > Leisten','de-DE'),(2518,'Heimwerkerbedarf > Baumaterialien > Luken','de-DE'),(2519,'Heimwerkerbedarf > Baumaterialien > Schalldämpfende Materialien','de-DE'),(2520,'Heimwerkerbedarf > Baumaterialien > Treppen','de-DE'),(2521,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln','de-DE'),(2522,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Schlossfallen','de-DE'),(2523,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Schlüssellochverzierungen für Türen','de-DE'),(2524,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türdruckplatten','de-DE'),(2525,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türklingeln','de-DE'),(2526,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türklopfer','de-DE'),(2527,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türknäufe & -klinken','de-DE'),(2528,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türrahmen','de-DE'),(2529,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türschließer','de-DE'),(2530,'Heimwerkerbedarf > Baumaterialien > Türbeschläge & -klingeln > Türstopper','de-DE'),(2531,'Heimwerkerbedarf > Baumaterialien > Türen','de-DE'),(2532,'Heimwerkerbedarf > Baumaterialien > Türen > Garagentore','de-DE'),(2533,'Heimwerkerbedarf > Baumaterialien > Türen > Haustüren','de-DE'),(2534,'Heimwerkerbedarf > Baumaterialien > Wand- & Deckenfliesen','de-DE'),(2535,'Heimwerkerbedarf > Baumaterialien > Wandverkleidung','de-DE'),(2536,'Heimwerkerbedarf > Baumaterialien > Zugluftstopper, Fenster- & Türdichtungen','de-DE'),(2537,'Heimwerkerbedarf > Bauzubehör','de-DE'),(2538,'Heimwerkerbedarf > Bauzubehör > Abdeckfolien','de-DE'),(2539,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente','de-DE'),(2540,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Dübel','de-DE'),(2541,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Gewindestangen','de-DE'),(2542,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Nieten','de-DE'),(2543,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Nägel','de-DE'),(2544,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Schrauben','de-DE'),(2545,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Schrauben & Muttern','de-DE'),(2546,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Schraubverbinder','de-DE'),(2547,'Heimwerkerbedarf > Bauzubehör > Befestigungselemente > Unterlegscheiben','de-DE'),(2548,'Heimwerkerbedarf > Bauzubehör > Betonformen','de-DE'),(2549,'Heimwerkerbedarf > Bauzubehör > Bodenspieße','de-DE'),(2550,'Heimwerkerbedarf > Bauzubehör > Federn','de-DE'),(2551,'Heimwerkerbedarf > Bauzubehör > Filter & Siebe','de-DE'),(2552,'Heimwerkerbedarf > Bauzubehör > Gasschläuche','de-DE'),(2553,'Heimwerkerbedarf > Bauzubehör > Haken, Schnallen & Verschlüsse','de-DE'),(2554,'Heimwerkerbedarf > Bauzubehör > Haken, Schnallen & Verschlüsse > Gear Tie-Universalkabelbinder','de-DE'),(2555,'Heimwerkerbedarf > Bauzubehör > Haken, Schnallen & Verschlüsse > Kettenverbinder & -glieder','de-DE'),(2556,'Heimwerkerbedarf > Bauzubehör > Haken, Schnallen & Verschlüsse > Lasthaken, Trageklemmen & Schäkel','de-DE'),(2557,'Heimwerkerbedarf > Bauzubehör > Haken, Schnallen & Verschlüsse > Schnallen- & Steckschnallen','de-DE'),(2558,'Heimwerkerbedarf > Bauzubehör > Halterungen','de-DE'),(2559,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile','de-DE'),(2560,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Bindegarne','de-DE'),(2561,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Draht','de-DE'),(2562,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Ketten','de-DE'),(2563,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Seile','de-DE'),(2564,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Spanngummis','de-DE'),(2565,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Spanngurte','de-DE'),(2566,'Heimwerkerbedarf > Bauzubehör > Ketten, Drähte & Seile > Zugschalterketten und -kordeln','de-DE'),(2567,'Heimwerkerbedarf > Bauzubehör > Laufrollen','de-DE'),(2568,'Heimwerkerbedarf > Bauzubehör > Luftschläuche','de-DE'),(2569,'Heimwerkerbedarf > Bauzubehör > Metallgussformen','de-DE'),(2570,'Heimwerkerbedarf > Bauzubehör > Planen','de-DE'),(2571,'Heimwerkerbedarf > Bauzubehör > Richtstützen','de-DE'),(2572,'Heimwerkerbedarf > Bauzubehör > Scharniere','de-DE'),(2573,'Heimwerkerbedarf > Bauzubehör > Schmierschläuche','de-DE'),(2574,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile','de-DE'),(2575,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile > Schlüssellochverzierungen für Schränke','de-DE'),(2576,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile > Schrankbeschläge','de-DE'),(2577,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile > Schrankknäufe & -griffe','de-DE'),(2578,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile > Schrankscharniere','de-DE'),(2579,'Heimwerkerbedarf > Bauzubehör > Schrankbauteile > Schranktüren','de-DE'),(2580,'Heimwerkerbedarf > Bauzubehör > Schubladenschienen','de-DE'),(2581,'Heimwerkerbedarf > Bauzubehör > Spulen','de-DE'),(2582,'Heimwerkerbedarf > Bauzubehör > Standfüße für Pfosten','de-DE'),(2583,'Heimwerkerbedarf > Bauzubehör > Transport- und Schallschutzabdeckungen','de-DE'),(2584,'Heimwerkerbedarf > Bauzubehör > Warnklebeband','de-DE'),(2585,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme','de-DE'),(2586,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Dienst- & Werkzeuggürtel','de-DE'),(2587,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Einsätze zur Werkzeugaufbewahrung','de-DE'),(2588,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Gartenschlauchhalterungen','de-DE'),(2589,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Werkbänke','de-DE'),(2590,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Werkzeugetuis','de-DE'),(2591,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Werkzeugkästen','de-DE'),(2592,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Werkzeugschränke','de-DE'),(2593,'Heimwerkerbedarf > Bauzubehör > Werkzeugaufbewahrung & Ordnungssysteme > Werkzeugtaschen','de-DE'),(2594,'Heimwerkerbedarf > Bauzubehör > Zylinderstifte & Dübelstangen','de-DE'),(2595,'Heimwerkerbedarf > Brennstoffbehälter & -tanks','de-DE'),(2596,'Heimwerkerbedarf > Elektrobedarf','de-DE'),(2597,'Heimwerkerbedarf > Elektrobedarf > Anker, Rotoren und Statoren','de-DE'),(2598,'Heimwerkerbedarf > Elektrobedarf > Anschlussdosen & Halterungen','de-DE'),(2599,'Heimwerkerbedarf > Elektrobedarf > Drahtbindemaschinen','de-DE'),(2600,'Heimwerkerbedarf > Elektrobedarf > Elektrische Leitungen','de-DE'),(2601,'Heimwerkerbedarf > Elektrobedarf > Elektromotoren','de-DE'),(2602,'Heimwerkerbedarf > Elektrobedarf > Elektroschalter','de-DE'),(2603,'Heimwerkerbedarf > Elektrobedarf > Elektroschalter > Lichtschalter','de-DE'),(2604,'Heimwerkerbedarf > Elektrobedarf > Elektroschalter > Spezielle elektrische Schalter','de-DE'),(2605,'Heimwerkerbedarf > Elektrobedarf > Generatoren','de-DE'),(2606,'Heimwerkerbedarf > Elektrobedarf > Gerätestecker','de-DE'),(2607,'Heimwerkerbedarf > Elektrobedarf > Heim- & Gebäudeautomatisierung','de-DE'),(2608,'Heimwerkerbedarf > Elektrobedarf > Kabelanschlüsse & Steckverbinder','de-DE'),(2609,'Heimwerkerbedarf > Elektrobedarf > Kohlebürsten','de-DE'),(2610,'Heimwerkerbedarf > Elektrobedarf > Leitungen & Gehäuse','de-DE'),(2611,'Heimwerkerbedarf > Elektrobedarf > Leitungen & Gehäuse > Kabelkanäle','de-DE'),(2612,'Heimwerkerbedarf > Elektrobedarf > Leitungen & Gehäuse > Schrumpfschläuche','de-DE'),(2613,'Heimwerkerbedarf > Elektrobedarf > Schaltnetzteile','de-DE'),(2614,'Heimwerkerbedarf > Elektrobedarf > Solarenergie-Kits','de-DE'),(2615,'Heimwerkerbedarf > Elektrobedarf > Solarpaneele','de-DE'),(2616,'Heimwerkerbedarf > Elektrobedarf > Spannungswandler & -regler','de-DE'),(2617,'Heimwerkerbedarf > Elektrobedarf > Steckdosen','de-DE'),(2618,'Heimwerkerbedarf > Elektrobedarf > Steckdosen-Zeitschaltuhren & -Sensoren','de-DE'),(2619,'Heimwerkerbedarf > Elektrobedarf > Steckdosenabdeckungen','de-DE'),(2620,'Heimwerkerbedarf > Elektrobedarf > Telefon- & Internetbuchsen','de-DE'),(2621,'Heimwerkerbedarf > Elektrobedarf > Verlängerungskabel','de-DE'),(2622,'Heimwerkerbedarf > Elektrobedarf > Verlängerungskabelzubehör','de-DE'),(2623,'Heimwerkerbedarf > Elektrobedarf > Verteilerkästen','de-DE'),(2624,'Heimwerkerbedarf > Elektrobedarf > Vorschaltgeräte & Starter','de-DE'),(2625,'Heimwerkerbedarf > Elektrobedarf > Wandplatten','de-DE'),(2626,'Heimwerkerbedarf > Elektrobedarf > Wechselrichter','de-DE'),(2627,'Heimwerkerbedarf > Elektrobedarf > Zubehör für Generatoren','de-DE'),(2628,'Heimwerkerbedarf > Hauseinzäunung','de-DE'),(2629,'Heimwerkerbedarf > Hauseinzäunung > Absperrungen','de-DE'),(2630,'Heimwerkerbedarf > Hauseinzäunung > Beeteinfassungen','de-DE'),(2631,'Heimwerkerbedarf > Hauseinzäunung > Tore','de-DE'),(2632,'Heimwerkerbedarf > Hauseinzäunung > Zaunfelder','de-DE'),(2633,'Heimwerkerbedarf > Hauseinzäunung > Zaungitter','de-DE'),(2634,'Heimwerkerbedarf > Hauseinzäunung > Zaunlatten','de-DE'),(2635,'Heimwerkerbedarf > Hauseinzäunung > Zaunpfosten & -querlatten','de-DE'),(2636,'Heimwerkerbedarf > Hauseinzäunung > Zubehör für Zäune & Gartentore','de-DE'),(2637,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen','de-DE'),(2638,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Filtertrockner','de-DE'),(2639,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Luftdurchlässe & Abzugsrohre','de-DE'),(2640,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Luftkanäle','de-DE'),(2641,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Steuerungen','de-DE'),(2642,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Steuerungen > Feuchtigkeitsregler','de-DE'),(2643,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Steuerungen > Schalt- & Bedienungstafeln','de-DE'),(2644,'Heimwerkerbedarf > Heizen, Belüftung & Klimaanlagen > Steuerungen > Thermostate','de-DE'),(2645,'Heimwerkerbedarf > Kleinmotoren','de-DE'),(2646,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen','de-DE'),(2647,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Brunnenbedarf','de-DE'),(2648,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Installationsrohre','de-DE'),(2649,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen','de-DE'),(2650,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Dichtungen & O-Ringe','de-DE'),(2651,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Druckminderer','de-DE'),(2652,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Düsen','de-DE'),(2653,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > In der Wand verbaute Trägerleisten','de-DE'),(2654,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Rohranschlüsse & Reduzierstücke','de-DE'),(2655,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Rohrflansche','de-DE'),(2656,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Rohrkappen & -verschlüsse','de-DE'),(2657,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Rohrschellen','de-DE'),(2658,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Rohrverbinder','de-DE'),(2659,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Rohrverbindungsstücke & -halterungen > Ventile','de-DE'),(2660,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitär-Reparatursätze','de-DE'),(2661,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen','de-DE'),(2662,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Armaturen','de-DE'),(2663,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Badewannen','de-DE'),(2664,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Badezimmerausstattungen','de-DE'),(2665,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Duschkabinen','de-DE'),(2666,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Toiletten & Bidets','de-DE'),(2667,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Toiletten & Bidets > Bidets','de-DE'),(2668,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Toiletten & Bidets > Toiletten','de-DE'),(2669,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Toiletten & Bidets > Urinale','de-DE'),(2670,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Waschbecken & Spülen','de-DE'),(2671,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Waschbecken & Spülen > Badezimmerwaschbecken','de-DE'),(2672,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Sanitärkeramik & Armaturen > Waschbecken & Spülen > Küchenspülen & Spülbecken','de-DE'),(2673,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Schläuche & Leitungen','de-DE'),(2674,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter','de-DE'),(2675,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Salz zur Wasserenthärtung','de-DE'),(2676,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserdestillationsgeräte','de-DE'),(2677,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserenthärter','de-DE'),(2678,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserleitungsfilter','de-DE'),(2679,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserspender','de-DE'),(2680,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserspender > Trinkbrunnen','de-DE'),(2681,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Wasserspender > Wasserkühler','de-DE'),(2682,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Zubehör für Wasserfilter','de-DE'),(2683,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Zubehör für Wasserfilter > Wasserfiltergehäuse','de-DE'),(2684,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Trinkwasserspender & Filter > Zubehör für Wasserfilter > Wasserfilterkartuschen','de-DE'),(2685,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Wasserschaltuhren','de-DE'),(2686,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Wasserstandsregler','de-DE'),(2687,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen','de-DE'),(2688,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten','de-DE'),(2689,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Abflussauskleidung bzw. -Abdichtung','de-DE'),(2690,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Abflussgitter','de-DE'),(2691,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Abflussreinigungswerkzeug','de-DE'),(2692,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Abflussstöpsel & -filter','de-DE'),(2693,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Geruchsverschlüsse','de-DE'),(2694,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Kanal- & Abflussstäbe','de-DE'),(2695,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflusskomponenten > Sanitärabläufe','de-DE'),(2696,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Abflüsse','de-DE'),(2697,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen','de-DE'),(2698,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Badewannen- & Duschdüsen','de-DE'),(2699,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duscharme & Verbindungsteile','de-DE'),(2700,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duschkabinen & -türen','de-DE'),(2701,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duschköpfe','de-DE'),(2702,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duschpaneele','de-DE'),(2703,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duschwannen','de-DE'),(2704,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Duschwände','de-DE'),(2705,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Elektrische & Powerduschen','de-DE'),(2706,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Duscharmaturen > Wasserfilter für Duschen','de-DE'),(2707,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Halterungsplatten','de-DE'),(2708,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör','de-DE'),(2709,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Bidet-Hähne & -Sprüher','de-DE'),(2710,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Kugelhähne & Verschlüsse','de-DE'),(2711,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Spülkastenabdeckungen','de-DE'),(2712,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Spülkästen','de-DE'),(2713,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Toilettendeckel','de-DE'),(2714,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Toilettensitze','de-DE'),(2715,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > Toilettenverkleidung','de-DE'),(2716,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > WC-Papiersitze','de-DE'),(2717,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Toiletten- und Bidetzubehör > WC-Spülkastengriffe','de-DE'),(2718,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Waschbecken- & Spülenzubehör','de-DE'),(2719,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Waschbecken- & Spülenzubehör > Waschbeckenfüße','de-DE'),(2720,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Armaturen','de-DE'),(2721,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Armaturen > Armaturen-Griffe','de-DE'),(2722,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Armaturen > Strahlregler','de-DE'),(2723,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Badewannen','de-DE'),(2724,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Badewannen > Badewanneneinläufe','de-DE'),(2725,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Badewannen > Badewannenunterbau & -füße','de-DE'),(2726,'Heimwerkerbedarf > Küchen- und Sanitärinstallationen > Zubehör für sanitäre Anlagen > Zubehör für Badewannen > Badewannenverkleidungen','de-DE'),(2727,'Heimwerkerbedarf > Metallpumpen','de-DE'),(2728,'Heimwerkerbedarf > Metallpumpen > Bewässerungs-, Sprinkler- und Boosterpumpen','de-DE'),(2729,'Heimwerkerbedarf > Metallpumpen > Brunnenpumpen und -systeme','de-DE'),(2730,'Heimwerkerbedarf > Metallpumpen > Haushaltsgerätepumpen','de-DE'),(2731,'Heimwerkerbedarf > Metallpumpen > Pool-, Brunnen- und Teichpumpen','de-DE'),(2732,'Heimwerkerbedarf > Metallpumpen > Pumpen zur Entwässerung und Wasserleitung','de-DE'),(2733,'Heimwerkerbedarf > Metallpumpen > Sickergruben-, Abwasser- und Abflusspumpen','de-DE'),(2734,'Heimwerkerbedarf > Schlösser & Schlüssel','de-DE'),(2735,'Heimwerkerbedarf > Schlösser & Schlüssel > Kartenschließsysteme','de-DE'),(2736,'Heimwerkerbedarf > Schlösser & Schlüssel > Schlösser & Riegel','de-DE'),(2737,'Heimwerkerbedarf > Schlösser & Schlüssel > Schlüsselkappen','de-DE'),(2738,'Heimwerkerbedarf > Schlösser & Schlüssel > Schlüsselrohlinge','de-DE'),(2739,'Heimwerkerbedarf > Vorratsbehälter','de-DE'),(2740,'Heimwerkerbedarf > Werkzeuge','de-DE'),(2741,'Heimwerkerbedarf > Werkzeuge > Ambosse','de-DE'),(2742,'Heimwerkerbedarf > Werkzeuge > Arbeitslampen','de-DE'),(2743,'Heimwerkerbedarf > Werkzeuge > Arbeitsscheinwerfer','de-DE'),(2744,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge','de-DE'),(2745,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Betonmischer','de-DE'),(2746,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Fugenkellen','de-DE'),(2747,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Fugenschwamm','de-DE'),(2748,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Glättkellen','de-DE'),(2749,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Glättmaschinen','de-DE'),(2750,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Kanten- & Schneidwerkzeuge','de-DE'),(2751,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Maurerkellen','de-DE'),(2752,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Maurerschnüre','de-DE'),(2753,'Heimwerkerbedarf > Werkzeuge > Bauwerkzeuge > Maurerwerkzeuge','de-DE'),(2754,'Heimwerkerbedarf > Werkzeuge > Betonbesen','de-DE'),(2755,'Heimwerkerbedarf > Werkzeuge > Biegewerkzeuge für Rohre & Stangen','de-DE'),(2756,'Heimwerkerbedarf > Werkzeuge > Bodenverdichter','de-DE'),(2757,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen','de-DE'),(2758,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen > Druckluftbohrer','de-DE'),(2759,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen > Elektrische Handbohrmaschinen','de-DE'),(2760,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen > Schneckenbohrer','de-DE'),(2761,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen > Stemmmaschinen','de-DE'),(2762,'Heimwerkerbedarf > Werkzeuge > Bohrmaschinen > Ständerbohrmaschinen','de-DE'),(2763,'Heimwerkerbedarf > Werkzeuge > Brecheisen','de-DE'),(2764,'Heimwerkerbedarf > Werkzeuge > Drehmaschinen','de-DE'),(2765,'Heimwerkerbedarf > Werkzeuge > Einziehhilfen','de-DE'),(2766,'Heimwerkerbedarf > Werkzeuge > Elektrohobel','de-DE'),(2767,'Heimwerkerbedarf > Werkzeuge > Entgrater','de-DE'),(2768,'Heimwerkerbedarf > Werkzeuge > Fettpressen','de-DE'),(2769,'Heimwerkerbedarf > Werkzeuge > Feuerzeuge & Streichhölzer','de-DE'),(2770,'Heimwerkerbedarf > Werkzeuge > Gewindebohrer','de-DE'),(2771,'Heimwerkerbedarf > Werkzeuge > Gewindeschneidmaschinen','de-DE'),(2772,'Heimwerkerbedarf > Werkzeuge > Glühbirnenwechsler','de-DE'),(2773,'Heimwerkerbedarf > Werkzeuge > Griffe','de-DE'),(2774,'Heimwerkerbedarf > Werkzeuge > Hacken & Spitzhacken','de-DE'),(2775,'Heimwerkerbedarf > Werkzeuge > Handmischmaschinen','de-DE'),(2776,'Heimwerkerbedarf > Werkzeuge > Handwerkzeuge für Drähte und Kabel','de-DE'),(2777,'Heimwerkerbedarf > Werkzeuge > Heißluftpistole','de-DE'),(2778,'Heimwerkerbedarf > Werkzeuge > Hobel','de-DE'),(2779,'Heimwerkerbedarf > Werkzeuge > Holzspalter','de-DE'),(2780,'Heimwerkerbedarf > Werkzeuge > Hämmer','de-DE'),(2781,'Heimwerkerbedarf > Werkzeuge > Hämmer > Manuelle Hämmer','de-DE'),(2782,'Heimwerkerbedarf > Werkzeuge > Hämmer > Maschinenbetriebene Hämmer','de-DE'),(2783,'Heimwerkerbedarf > Werkzeuge > Industrievibratoren','de-DE'),(2784,'Heimwerkerbedarf > Werkzeuge > Kaminbürste','de-DE'),(2785,'Heimwerkerbedarf > Werkzeuge > Kittmesser & -spachtel','de-DE'),(2786,'Heimwerkerbedarf > Werkzeuge > Kompressoren','de-DE'),(2787,'Heimwerkerbedarf > Werkzeuge > Kontrollspiegel','de-DE'),(2788,'Heimwerkerbedarf > Werkzeuge > Lasthebemagnete','de-DE'),(2789,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste','de-DE'),(2790,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste > Arbeitsplattformen','de-DE'),(2791,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste > Gerüste','de-DE'),(2792,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste > Leitern','de-DE'),(2793,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste > Leiterwagen','de-DE'),(2794,'Heimwerkerbedarf > Werkzeuge > Leitern & Gerüste > Tritthocker','de-DE'),(2795,'Heimwerkerbedarf > Werkzeuge > Locheisen & Ahlen','de-DE'),(2796,'Heimwerkerbedarf > Werkzeuge > Lochschaufeln','de-DE'),(2797,'Heimwerkerbedarf > Werkzeuge > Lötkolben','de-DE'),(2798,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug','de-DE'),(2799,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Airbrushpistolen','de-DE'),(2800,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Farbrollen','de-DE'),(2801,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Farbrüttler','de-DE'),(2802,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Farbsiebe','de-DE'),(2803,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Farbspritzpistolen','de-DE'),(2804,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Farbwannen','de-DE'),(2805,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Kantenmaler','de-DE'),(2806,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Malerpinsel','de-DE'),(2807,'Heimwerkerbedarf > Werkzeuge > Malerwerkzeug > Malschwämme','de-DE'),(2808,'Heimwerkerbedarf > Werkzeuge > Markierwerkzeuge','de-DE'),(2809,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber','de-DE'),(2810,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Balkensucher','de-DE'),(2811,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Barometer','de-DE'),(2812,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Durchflussmesser','de-DE'),(2813,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Elektrische Prüfgeräte','de-DE'),(2814,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Entfernungsmesser','de-DE'),(2815,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Feuchtigkeitsmesser','de-DE'),(2816,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Gasdetektoren','de-DE'),(2817,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Geigerzähler','de-DE'),(2818,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Haarlineale','de-DE'),(2819,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Hygrometer','de-DE'),(2820,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Höhenmesser','de-DE'),(2821,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Infrarotthermometer','de-DE'),(2822,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Kluppen','de-DE'),(2823,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Lautstärkemesser','de-DE'),(2824,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Maßbänder','de-DE'),(2825,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Messerführungen','de-DE'),(2826,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Messinstrumente','de-DE'),(2827,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Messräder','de-DE'),(2828,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Messschieber','de-DE'),(2829,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Raumluftmessgeräte','de-DE'),(2830,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Richtwaagen','de-DE'),(2831,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Richtwaagen > Laser-Wasserwaagen','de-DE'),(2832,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Richtwaagen > Schaugläser','de-DE'),(2833,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Richtwaagen > Wasserwaagen','de-DE'),(2834,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Schwingungsmesser','de-DE'),(2835,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Seismographen','de-DE'),(2836,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Sonden & Suchgeräte','de-DE'),(2837,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Stahlbewehrungssucher','de-DE'),(2838,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Stangenzirkel','de-DE'),(2839,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Theodolite','de-DE'),(2840,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Thermoelemente & -säulen','de-DE'),(2841,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Transducer & Messumformer','de-DE'),(2842,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > UV-Lichtmesser','de-DE'),(2843,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Waagen','de-DE'),(2844,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Wetterstationen','de-DE'),(2845,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Windgeschwindigkeitsmesser','de-DE'),(2846,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Winkel','de-DE'),(2847,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Winkelmesser','de-DE'),(2848,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Wärmekameras','de-DE'),(2849,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > Zollstöcke','de-DE'),(2850,'Heimwerkerbedarf > Werkzeuge > Messwerkzeuge & Messwertgeber > pH-Meter','de-DE'),(2851,'Heimwerkerbedarf > Werkzeuge > Multifunktionales Elektrowerkzeug','de-DE'),(2852,'Heimwerkerbedarf > Werkzeuge > Mühlen','de-DE'),(2853,'Heimwerkerbedarf > Werkzeuge > Müll- & Papierkrallen','de-DE'),(2854,'Heimwerkerbedarf > Werkzeuge > Nageleisen','de-DE'),(2855,'Heimwerkerbedarf > Werkzeuge > Nagler & Tacker','de-DE'),(2856,'Heimwerkerbedarf > Werkzeuge > Nietwerkzeuge','de-DE'),(2857,'Heimwerkerbedarf > Werkzeuge > Nietwerkzeuge > Nietpistolen','de-DE'),(2858,'Heimwerkerbedarf > Werkzeuge > Nietwerkzeuge > Nietzangen','de-DE'),(2859,'Heimwerkerbedarf > Werkzeuge > Oberfräsen','de-DE'),(2860,'Heimwerkerbedarf > Werkzeuge > Reibahlen','de-DE'),(2861,'Heimwerkerbedarf > Werkzeuge > Rohrbürsten','de-DE'),(2862,'Heimwerkerbedarf > Werkzeuge > Rohrreiniger','de-DE'),(2863,'Heimwerkerbedarf > Werkzeuge > Rollwagen & Sackkarren','de-DE'),(2864,'Heimwerkerbedarf > Werkzeuge > Sandstrahler','de-DE'),(2865,'Heimwerkerbedarf > Werkzeuge > Saugglocken','de-DE'),(2866,'Heimwerkerbedarf > Werkzeuge > Schlagschrauber','de-DE'),(2867,'Heimwerkerbedarf > Werkzeuge > Schleifblöcke','de-DE'),(2868,'Heimwerkerbedarf > Werkzeuge > Schleifer & Poliermaschinen','de-DE'),(2869,'Heimwerkerbedarf > Werkzeuge > Schleifmaschinen','de-DE'),(2870,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte','de-DE'),(2871,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Betonstahlschneider','de-DE'),(2872,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Bolzenschneider','de-DE'),(2873,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Cutter','de-DE'),(2874,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Fliesen-, Ziegel- & Schindelschneider','de-DE'),(2875,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Glasschneider','de-DE'),(2876,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Metallscheren & Nibbelmaschinen','de-DE'),(2877,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Rohrschneider','de-DE'),(2878,'Heimwerkerbedarf > Werkzeuge > Schneidegeräte > Zwickzangen','de-DE'),(2879,'Heimwerkerbedarf > Werkzeuge > Schnitzwerkzeuge & Hohlmeißel','de-DE'),(2880,'Heimwerkerbedarf > Werkzeuge > Schraubendreher','de-DE'),(2881,'Heimwerkerbedarf > Werkzeuge > Schraubenschlüssel','de-DE'),(2882,'Heimwerkerbedarf > Werkzeuge > Schraubzwingen & -stöcke','de-DE'),(2883,'Heimwerkerbedarf > Werkzeuge > Schweißwerkzeuge & Plasmaschneider','de-DE'),(2884,'Heimwerkerbedarf > Werkzeuge > Schwingschleifer','de-DE'),(2885,'Heimwerkerbedarf > Werkzeuge > Schärfgeräte','de-DE'),(2886,'Heimwerkerbedarf > Werkzeuge > Steckschlüssel','de-DE'),(2887,'Heimwerkerbedarf > Werkzeuge > Stemmwerkzeuge','de-DE'),(2888,'Heimwerkerbedarf > Werkzeuge > Stoßmaschinen','de-DE'),(2889,'Heimwerkerbedarf > Werkzeuge > Sägeböcke','de-DE'),(2890,'Heimwerkerbedarf > Werkzeuge > Sägen','de-DE'),(2891,'Heimwerkerbedarf > Werkzeuge > Sägen > Bandsägen','de-DE'),(2892,'Heimwerkerbedarf > Werkzeuge > Sägen > Dekupiersägen','de-DE'),(2893,'Heimwerkerbedarf > Werkzeuge > Sägen > Fliesensägen','de-DE'),(2894,'Heimwerkerbedarf > Werkzeuge > Sägen > Gehrungssägen','de-DE'),(2895,'Heimwerkerbedarf > Werkzeuge > Sägen > Handkreissägen','de-DE'),(2896,'Heimwerkerbedarf > Werkzeuge > Sägen > Handsägen','de-DE'),(2897,'Heimwerkerbedarf > Werkzeuge > Sägen > Plattensägen','de-DE'),(2898,'Heimwerkerbedarf > Werkzeuge > Sägen > Stichsägen','de-DE'),(2899,'Heimwerkerbedarf > Werkzeuge > Sägen > Säbelsägen','de-DE'),(2900,'Heimwerkerbedarf > Werkzeuge > Sägen > Tischkreissägen','de-DE'),(2901,'Heimwerkerbedarf > Werkzeuge > Sägen > Trennsägen','de-DE'),(2902,'Heimwerkerbedarf > Werkzeuge > Taschenlampen & Stirnlampen','de-DE'),(2903,'Heimwerkerbedarf > Werkzeuge > Tischlerbänke','de-DE'),(2904,'Heimwerkerbedarf > Werkzeuge > Wasseranschluss-Nachschleifwerkzeuge','de-DE'),(2905,'Heimwerkerbedarf > Werkzeuge > Werkzeugfeilen','de-DE'),(2906,'Heimwerkerbedarf > Werkzeuge > Werkzeugmesser','de-DE'),(2907,'Heimwerkerbedarf > Werkzeuge > Werkzeugschlüssel','de-DE'),(2908,'Heimwerkerbedarf > Werkzeuge > Werkzeugsets','de-DE'),(2909,'Heimwerkerbedarf > Werkzeuge > Werkzeugsets > Elektrowerkzeug-Combo-Sets','de-DE'),(2910,'Heimwerkerbedarf > Werkzeuge > Werkzeugsets > Handwerkzeugsets','de-DE'),(2911,'Heimwerkerbedarf > Werkzeuge > Zangen','de-DE'),(2912,'Heimwerkerbedarf > Werkzeuge > Äxte','de-DE'),(2913,'Heimwerkerbedarf > Werkzeuge > Ölfilterabfluss','de-DE'),(2914,'Heimwerkerbedarf > Werkzeugzubehör','de-DE'),(2915,'Heimwerkerbedarf > Werkzeugzubehör > Anstreichzubehör','de-DE'),(2916,'Heimwerkerbedarf > Werkzeugzubehör > Anstreichzubehör > Airbrushzubehör','de-DE'),(2917,'Heimwerkerbedarf > Werkzeugzubehör > Anstreichzubehör > Anstreichrollenzubehör','de-DE'),(2918,'Heimwerkerbedarf > Werkzeugzubehör > Anstreichzubehör > Pinselreiniger','de-DE'),(2919,'Heimwerkerbedarf > Werkzeugzubehör > Axtzubehör','de-DE'),(2920,'Heimwerkerbedarf > Werkzeugzubehör > Axtzubehör > Axtgriffe','de-DE'),(2921,'Heimwerkerbedarf > Werkzeugzubehör > Axtzubehör > Axtköpfe','de-DE'),(2922,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör','de-DE'),(2923,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Bohrer & Bits','de-DE'),(2924,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Bohrerschleifgeräte','de-DE'),(2925,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Bohrerverlängerungen','de-DE'),(2926,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Bohrfutter','de-DE'),(2927,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Bohrständer & -führungen','de-DE'),(2928,'Heimwerkerbedarf > Werkzeugzubehör > Bohrzubehör > Lochsägen','de-DE'),(2929,'Heimwerkerbedarf > Werkzeugzubehör > Drehmaschinenzubehör','de-DE'),(2930,'Heimwerkerbedarf > Werkzeugzubehör > Elektrowerkzeug-Akkus','de-DE'),(2931,'Heimwerkerbedarf > Werkzeugzubehör > Hammerzubehör','de-DE'),(2932,'Heimwerkerbedarf > Werkzeugzubehör > Hammerzubehör > Drucklufthammerzubehör','de-DE'),(2933,'Heimwerkerbedarf > Werkzeugzubehör > Hammerzubehör > Hammerköpfe','de-DE'),(2934,'Heimwerkerbedarf > Werkzeugzubehör > Hammerzubehör > Hammerstiele','de-DE'),(2935,'Heimwerkerbedarf > Werkzeugzubehör > Keile für Werkzeuggriffe','de-DE'),(2936,'Heimwerkerbedarf > Werkzeugzubehör > Keilwerkzeuge','de-DE'),(2937,'Heimwerkerbedarf > Werkzeugzubehör > Klammern','de-DE'),(2938,'Heimwerkerbedarf > Werkzeugzubehör > Ladegeräte für Elektrowerkzeuge','de-DE'),(2939,'Heimwerkerbedarf > Werkzeugzubehör > Magnetisierer & Entmagnetisierer','de-DE'),(2940,'Heimwerkerbedarf > Werkzeugzubehör > Mischwerkzeuge','de-DE'),(2941,'Heimwerkerbedarf > Werkzeugzubehör > Sandstrahler-Zubehör','de-DE'),(2942,'Heimwerkerbedarf > Werkzeugzubehör > Sandstrahler-Zubehör > Sandstrahlkabinen','de-DE'),(2943,'Heimwerkerbedarf > Werkzeugzubehör > Schleifmaschinenzubehör','de-DE'),(2944,'Heimwerkerbedarf > Werkzeugzubehör > Schleifmaschinenzubehör > Schleifscheiben & -stifte','de-DE'),(2945,'Heimwerkerbedarf > Werkzeugzubehör > Schleifzubehör','de-DE'),(2946,'Heimwerkerbedarf > Werkzeugzubehör > Schleifzubehör > Schleifpapier & Schleifschwämme','de-DE'),(2947,'Heimwerkerbedarf > Werkzeugzubehör > Schneidwerkzeug-Zubehör','de-DE'),(2948,'Heimwerkerbedarf > Werkzeugzubehör > Schneidwerkzeug-Zubehör > Nibbelmaschinenstempel','de-DE'),(2949,'Heimwerkerbedarf > Werkzeugzubehör > Schweißzubehör','de-DE'),(2950,'Heimwerkerbedarf > Werkzeugzubehör > Spannvorrichtungen','de-DE'),(2951,'Heimwerkerbedarf > Werkzeugzubehör > Steckschlüsseleinsätze','de-DE'),(2952,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör','de-DE'),(2953,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör > Bandsägenzubehör','de-DE'),(2954,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör > Handkreissägen-Zubehör','de-DE'),(2955,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör > Kreissägenzubehör','de-DE'),(2956,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör > Laubsägenzubehör','de-DE'),(2957,'Heimwerkerbedarf > Werkzeugzubehör > Sägenzubehör > Tischsägenzubehör','de-DE'),(2958,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugklingen & -blätter','de-DE'),(2959,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugklingen & -blätter > Cutter-, Schaber- & Spachtelklingen','de-DE'),(2960,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugklingen & -blätter > Sägeblätter','de-DE'),(2961,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugsicherungen','de-DE'),(2962,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugständer','de-DE'),(2963,'Heimwerkerbedarf > Werkzeugzubehör > Werkzeugständer > Sägeständer','de-DE'),(2964,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Hacken & Pickel','de-DE'),(2965,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Hacken & Pickel > Griffe für Hacken & Pickel','de-DE'),(2966,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Lötkolben','de-DE'),(2967,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Lötkolben > Lötkolbenspitzen','de-DE'),(2968,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Lötkolben > Lötkolbenständer','de-DE'),(2969,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Messwerkzeuge & Messwertgeber','de-DE'),(2970,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Messwerkzeuge & Messwertgeber > Multimeter-Zubehör','de-DE'),(2971,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Messwerkzeuge & Messwertgeber > Zubehör für Gasdetektoren','de-DE'),(2972,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Messwerkzeuge & Messwertgeber > Zubehör für Messskalen','de-DE'),(2973,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Messwerkzeuge & Messwertgeber > Zubehör für Spannungsmesser','de-DE'),(2974,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Oberfräsen','de-DE'),(2975,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Oberfräsen > Oberfräsenteile','de-DE'),(2976,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Oberfräsen > Oberfräsentische','de-DE'),(2977,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Stoßmaschinen','de-DE'),(2978,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Stoßmaschinen > Stoßmaschinenwerkzeuge','de-DE'),(2979,'Heimwerkerbedarf > Werkzeugzubehör > Zubehör für Taschenlampen','de-DE'),(2980,'Kameras & Optik','de-DE'),(2981,'Kameras & Optik > Fotografie','de-DE'),(2982,'Kameras & Optik > Fotografie > Aufbewahrung für Negative & Kontaktbögen','de-DE'),(2983,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf','de-DE'),(2984,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Belichtungsmesser','de-DE'),(2985,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Lichtsteuerung','de-DE'),(2986,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Lichtsteuerung > Blitzdiffusoren','de-DE'),(2987,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Lichtsteuerung > Blitzreflektoren','de-DE'),(2988,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Lichtsteuerung > Lichtfilter & Filterfolien','de-DE'),(2989,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Lichtsteuerung > Softboxen','de-DE'),(2990,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Studio-Halterungen','de-DE'),(2991,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Studiohintergründe','de-DE'),(2992,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Studioscheinwerfer & -blitzgeräte','de-DE'),(2993,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Zubehör für Belichtungsmesser','de-DE'),(2994,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Zubehör für Studiobeleuchtung & Blitzgeräte','de-DE'),(2995,'Kameras & Optik > Fotografie > Beleuchtung & Studiobedarf > Zubehör für Studioständer & -halterungen','de-DE'),(2996,'Kameras & Optik > Fotografie > Dunkelkammer','de-DE'),(2997,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung','de-DE'),(2998,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung > Dunkelkammerbecken','de-DE'),(2999,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung > Entwicklungsschalen, Wascher & Trockner','de-DE'),(3000,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung > Entwicklungstanks & -spiralen','de-DE'),(3001,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung > Reprostative','de-DE'),(3002,'Kameras & Optik > Fotografie > Dunkelkammer > Ausrüstung, Entwicklung & Verarbeitung > Retuschierbedarf & -zubehör','de-DE'),(3003,'Kameras & Optik > Fotografie > Dunkelkammer > Dunkelkammerleuchten','de-DE'),(3004,'Kameras & Optik > Fotografie > Dunkelkammer > Fotochemikalien','de-DE'),(3005,'Kameras & Optik > Fotografie > Dunkelkammer > Fotopapier','de-DE'),(3006,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör','de-DE'),(3007,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör > Dunkelkammer-Timer','de-DE'),(3008,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör > Dunkelkammerstaffeleien','de-DE'),(3009,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör > Fokussierhilfen','de-DE'),(3010,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör > Fotovergrößerer','de-DE'),(3011,'Kameras & Optik > Fotografie > Dunkelkammer > Vergrößerungszubehör > Lichtmesser','de-DE'),(3012,'Kameras & Optik > Fotografie > Passepartouts & Aufziehmaterialien','de-DE'),(3013,'Kameras & Optik > Kamera- & Optisches Zubehör','de-DE'),(3014,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamera- & Video-Objektive','de-DE'),(3015,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamera- & Video-Objektive > Kameraobjektive','de-DE'),(3016,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamera- & Video-Objektive > Objektive für Überwachungskameras','de-DE'),(3017,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamera- & Video-Objektive > Videokamera-Objektive','de-DE'),(3018,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamera-Ersatzkabel','de-DE'),(3019,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör','de-DE'),(3020,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Bildsensoren','de-DE'),(3021,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Blitzhaltesysteme','de-DE'),(3022,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Digitale Rückteile','de-DE'),(3023,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Ersatzbildschirme & -Displays','de-DE'),(3024,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Ersatzgehäuseteile & -klappen','de-DE'),(3025,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Ersatztasten & -knöpfe','de-DE'),(3026,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Fokusvorrichtungen für Kameras','de-DE'),(3027,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamera-Blitzgeräte','de-DE'),(3028,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamera-Blitzlichtzubehör','de-DE'),(3029,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamera-Fernbedienungen','de-DE'),(3030,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kameraausrüstungen','de-DE'),(3031,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamerafilme','de-DE'),(3032,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kameragurte','de-DE'),(3033,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamerahaltegriffe','de-DE'),(3034,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kameramonitore','de-DE'),(3035,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamerastabilisatoren und -stützen','de-DE'),(3036,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamerataschen & -koffer','de-DE'),(3037,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Kamerazubehör-Sets','de-DE'),(3038,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Schalldämmung & Sound Blimps für Kameras','de-DE'),(3039,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Sonnenschutz für Kameras & Sucheraufsätze','de-DE'),(3040,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Unterwassergehäuse für Kameras und Videokameras','de-DE'),(3041,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Videokameraleuchten','de-DE'),(3042,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Zoomkomponenten für Objektive','de-DE'),(3043,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Zubehör für Unterwasserkameragehäuse','de-DE'),(3044,'Kameras & Optik > Kamera- & Optisches Zubehör > Kamerazubehör > Überwachungskamera-Zubehör','de-DE'),(3045,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör','de-DE'),(3046,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Fernglas- & Fernrohrzubehör','de-DE'),(3047,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Taschen & Koffer für optische Instrumente','de-DE'),(3048,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Wärmebildzubehör','de-DE'),(3049,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Zubehör für Entferungsmesser','de-DE'),(3050,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Zubehör für Spektive','de-DE'),(3051,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Zubehör für Teleskope','de-DE'),(3052,'Kameras & Optik > Kamera- & Optisches Zubehör > Optisches Zubehör > Zubehör für Zielfernrohre','de-DE'),(3053,'Kameras & Optik > Kamera- & Optisches Zubehör > Stative','de-DE'),(3054,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive','de-DE'),(3055,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Objektiv- & Filteradapter','de-DE'),(3056,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Objektivabdeckungen','de-DE'),(3057,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Objektivfilter','de-DE'),(3058,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Objektivkonverter','de-DE'),(3059,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Objektivtaschen','de-DE'),(3060,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Kameraobjektive > Streulichtblenden','de-DE'),(3061,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative','de-DE'),(3062,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative > Schellen & Halterungen für Stative','de-DE'),(3063,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative > Stativaufbewahrung','de-DE'),(3064,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative > Stativgriffe','de-DE'),(3065,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative > Stativköpfe','de-DE'),(3066,'Kameras & Optik > Kamera- & Optisches Zubehör > Zubehör für Stative > Stativspinnen','de-DE'),(3067,'Kameras & Optik > Kameras','de-DE'),(3068,'Kameras & Optik > Kameras > Analogkameras','de-DE'),(3069,'Kameras & Optik > Kameras > Boroskope','de-DE'),(3070,'Kameras & Optik > Kameras > Digitalkameras','de-DE'),(3071,'Kameras & Optik > Kameras > Einwegkameras','de-DE'),(3072,'Kameras & Optik > Kameras > Videokameras','de-DE'),(3073,'Kameras & Optik > Kameras > Webcams','de-DE'),(3074,'Kameras & Optik > Kameras > Wildkameras','de-DE'),(3075,'Kameras & Optik > Kameras > Überwachungskameras','de-DE'),(3076,'Kameras & Optik > Optische Geräte','de-DE'),(3077,'Kameras & Optik > Optische Geräte > Ferngläser','de-DE'),(3078,'Kameras & Optik > Optische Geräte > Fernrohre','de-DE'),(3079,'Kameras & Optik > Optische Geräte > Fernrohre > Spektive','de-DE'),(3080,'Kameras & Optik > Optische Geräte > Fernrohre > Teleskope','de-DE'),(3081,'Kameras & Optik > Optische Geräte > Fernrohre > Waffenspektive & Zielfernrohre','de-DE'),(3082,'Kameras & Optik > Optische Geräte > Monokulare','de-DE'),(3083,'Kameras & Optik > Optische Geräte > Optische Entfernungsmesser','de-DE'),(3084,'Kunst & Unterhaltung','de-DE'),(3085,'Kunst & Unterhaltung > Eintrittskarten','de-DE'),(3086,'Kunst & Unterhaltung > Hobby & Kunst','de-DE'),(3087,'Kunst & Unterhaltung > Hobby & Kunst > Jonglieren','de-DE'),(3088,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby','de-DE'),(3089,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Aufbewahrung für Kunst- & Bastelmaterial','de-DE'),(3090,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Aufbewahrung für Kunst- & Bastelmaterial > Arbeitssets für Näh- und Textilkunstarbeiten','de-DE'),(3091,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Aufbewahrung für Kunst- & Bastelmaterial > Aufbewahrung für Fäden & Garne','de-DE'),(3092,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Aufbewahrung für Kunst- & Bastelmaterial > Aufbewahrung für Näh-, Strick- & Häkelnadeln','de-DE'),(3093,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien','de-DE'),(3094,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Basteldraht','de-DE'),(3095,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Basteldraht > Blumendraht','de-DE'),(3096,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Basteldraht > Pfeifenreiniger','de-DE'),(3097,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Basteldraht > Schmuck- & Perlendraht','de-DE'),(3098,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke','de-DE'),(3099,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Fixative','de-DE'),(3100,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Färbemittel für Kunstarbeiten','de-DE'),(3101,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Keramik- & Tonglasuren','de-DE'),(3102,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Kunst- & Bastelfarben','de-DE'),(3103,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Malgründe','de-DE'),(3104,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Stempelkissen','de-DE'),(3105,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelfarben, -tinten & -lacke > Tinte für Kunstarbeiten','de-DE'),(3106,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete','de-DE'),(3107,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete > Aufbügelbänder','de-DE'),(3108,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete > Bastel- & Büroklebstoff','de-DE'),(3109,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete > Bastelmagnete','de-DE'),(3110,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete > Blumenklebeband','de-DE'),(3111,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelklebstoffe & -magnete > Deko-Klebeband','de-DE'),(3112,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelwerkstoffe','de-DE'),(3113,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelwerkstoffe > Garne','de-DE'),(3114,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelwerkstoffe > Rohwolle','de-DE'),(3115,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelwerkstoffe > Schmuck- & Perlenband','de-DE'),(3116,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Bastelwerkstoffe > Zwirn','de-DE'),(3117,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse','de-DE'),(3118,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Klettverschlüsse','de-DE'),(3119,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Knöpfe','de-DE'),(3120,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Reißverschlussziehgriffe','de-DE'),(3121,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Reißverschlüsse','de-DE'),(3122,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Schnallen & Haken','de-DE'),(3123,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Befestigungen & Verschlüsse > Ösen & Tüllen','de-DE'),(3124,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Dochte','de-DE'),(3125,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Dochthalter','de-DE'),(3126,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Formen & Rohlinge für Kunstarbeiten','de-DE'),(3127,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Formen & Rohlinge für Kunstarbeiten > Holz & Formen für Kunstarbeiten','de-DE'),(3128,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Formen & Rohlinge für Kunstarbeiten > Kranz- & Gesteckunterlagen','de-DE'),(3129,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Formen & Rohlinge für Kunstarbeiten > Moosgummi & Styropor','de-DE'),(3130,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Formen & Rohlinge für Kunstarbeiten > Pappmaschee-Formen','de-DE'),(3131,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Füllmaterial','de-DE'),(3132,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Füllmaterial > Füllgranulate','de-DE'),(3133,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Füllmaterial > Kissenformen','de-DE'),(3134,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Füllmaterial > Wattierung & Füllung','de-DE'),(3135,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Leder & Vinyl','de-DE'),(3136,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten','de-DE'),(3137,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Bastelfolie','de-DE'),(3138,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Bastelpapier','de-DE'),(3139,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Kartenkarton & Scrapbooking-Papier','de-DE'),(3140,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Origami-Papier','de-DE'),(3141,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Pergament','de-DE'),(3142,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Transferpapier','de-DE'),(3143,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Papier für Kunstarbeiten > Zeichen- & Malpapier','de-DE'),(3144,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Prägepuder','de-DE'),(3145,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Rohes Kerzenwachs','de-DE'),(3146,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien','de-DE'),(3147,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Bastelleinwände','de-DE'),(3148,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Bastelleinwände > Leinwände & Keilrahmen','de-DE'),(3149,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Bastelleinwände > Plastiksegeltuch','de-DE'),(3150,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Bastelleinwände > Stickleinwände','de-DE'),(3151,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Bedruckbare Gewebe','de-DE'),(3152,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Stoffe','de-DE'),(3153,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Textilien > Vlieseline','de-DE'),(3154,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Töpferei & Bildhauerei','de-DE'),(3155,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Töpferei & Bildhauerei > Engoben','de-DE'),(3156,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Töpferei & Bildhauerei > Gipsgewebe','de-DE'),(3157,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Töpferei & Bildhauerei > Modellierton & Modelliermasse','de-DE'),(3158,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Töpferei & Bildhauerei > Pappmaschee-Mischungen','de-DE'),(3159,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen','de-DE'),(3160,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Aufnäher','de-DE'),(3161,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Bänder & Einfassungen','de-DE'),(3162,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Deko-Federn','de-DE'),(3163,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Dekorative Aufkleber','de-DE'),(3164,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Edelsteine','de-DE'),(3165,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Elastikbund','de-DE'),(3166,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Pailletten & Glitzer','de-DE'),(3167,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Perlen','de-DE'),(3168,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Schleifen & Rosetten','de-DE'),(3169,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Schmuck-Basisteile','de-DE'),(3170,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Strass & Deko-Elemente','de-DE'),(3171,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelmaterialien > Verzierungen & Trimmungen > Textilaufnäher & -aufbügler','de-DE'),(3172,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets','de-DE'),(3173,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Bastelsets','de-DE'),(3174,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Flicksets','de-DE'),(3175,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Kerzenherstellungssets','de-DE'),(3176,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Mosaikbausätze','de-DE'),(3177,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Schmuckherstellungssets','de-DE'),(3178,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Scrapbooking- & Stempelsets','de-DE'),(3179,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Sets für die Räucherwerkherstellung','de-DE'),(3180,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Sticksets','de-DE'),(3181,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelsets > Zeichen- & Malsets','de-DE'),(3182,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge','de-DE'),(3183,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Dekorationswerkzeuge für Kunstarbeiten','de-DE'),(3184,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Farbmischwerkzeuge','de-DE'),(3185,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Farbmischwerkzeuge > Farbpaletten','de-DE'),(3186,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Farbmischwerkzeuge > Palettenmesser','de-DE'),(3187,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Filzpolster & -matten','de-DE'),(3188,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Fingerhüte','de-DE'),(3189,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Klebepistolen','de-DE'),(3190,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Leuchtkästen','de-DE'),(3191,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten','de-DE'),(3192,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten > Filznadeln & -maschinen','de-DE'),(3193,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten > Handwebstühle','de-DE'),(3194,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten > Mechanische Webstühle','de-DE'),(3195,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten > Nähmaschinen','de-DE'),(3196,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Maschinen für Textilarbeiten > Spinnräder','de-DE'),(3197,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten','de-DE'),(3198,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Handroller','de-DE'),(3199,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Holzbrennwerkzeuge','de-DE'),(3200,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Künstlerpinsel','de-DE'),(3201,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Maschenmarkierer & -zähler','de-DE'),(3202,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Motivstempel','de-DE'),(3203,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Schablonen & Matrizen','de-DE'),(3204,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Schablonendruckmaschinen','de-DE'),(3205,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Siebdruck-Rakel','de-DE'),(3206,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Textilkunst-Messgeräte','de-DE'),(3207,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Mess- & Markierwerkzeuge für Kunstarbeiten > Zeichenzirkel','de-DE'),(3208,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln','de-DE'),(3209,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln > Häkelnadeln','de-DE'),(3210,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln > Knüpfhaken','de-DE'),(3211,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln > Nähmaschinennadeln','de-DE'),(3212,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln > Nähnadeln','de-DE'),(3213,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Näh-, Strick- & Häkelnadeln > Stricknadeln','de-DE'),(3214,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Rahmen, Reifen & Spannvorrichtungen','de-DE'),(3215,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Schneidematten','de-DE'),(3216,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Schneiderpuppen','de-DE'),(3217,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Sicherheitsnadeln','de-DE'),(3218,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Spanndrähte','de-DE'),(3219,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Spannmatten','de-DE'),(3220,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten','de-DE'),(3221,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Bastel- & Büroscheren','de-DE'),(3222,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Bastelmesser','de-DE'),(3223,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Fadenabschneider','de-DE'),(3224,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Heißluftgeräte','de-DE'),(3225,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Nahttrenner','de-DE'),(3226,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Prägestifte','de-DE'),(3227,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Rill- & Perforiergeräte für Papier','de-DE'),(3228,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stanz- & Prägewerkzeuge für Kunstarbeiten > Stanzer & Präger für Kunstarbeiten','de-DE'),(3229,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Stecknadeln','de-DE'),(3230,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung','de-DE'),(3231,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Faden- & Garnführer','de-DE'),(3232,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Faden- & Garnspulen','de-DE'),(3233,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Faden- & Garnwickler','de-DE'),(3234,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Handspindeln','de-DE'),(3235,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Kardierer','de-DE'),(3236,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Nadeleinfädler','de-DE'),(3237,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Webschlagkämme','de-DE'),(3238,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Kunst- & Bastelwerkzeuge > Werkzeuge für die Faden- & Garnverarbeitung > Webschützen','de-DE'),(3239,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten','de-DE'),(3240,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten > Filzformen','de-DE'),(3241,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten > Gießformen','de-DE'),(3242,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten > Nähmuster','de-DE'),(3243,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten > Stick-, Strick- & Häkelmuster','de-DE'),(3244,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Muster & Formen für Kunstarbeiten > Vorlagen für Perlenarbeiten','de-DE'),(3245,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge','de-DE'),(3246,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Ersatzteile für Nähmaschinen','de-DE'),(3247,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Klingen für Bastelmesser','de-DE'),(3248,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Nähmaschinenfüße','de-DE'),(3249,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Nähmaschinengehäuse & -abdeckungen','de-DE'),(3250,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Spinnzubehör','de-DE'),(3251,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Stempelblöcke','de-DE'),(3252,'Kunst & Unterhaltung > Hobby & Kunst > Kunsthandwerk & Hobby > Zubehör für Kunst- & Bastelwerkzeuge > Verlängerungstische für Nähmaschinen','de-DE'),(3253,'Kunst & Unterhaltung > Hobby & Kunst > Modellbau','de-DE'),(3254,'Kunst & Unterhaltung > Hobby & Kunst > Modellbau > Modellbausätze','de-DE'),(3255,'Kunst & Unterhaltung > Hobby & Kunst > Modellbau > Modelleisenbahn & Eisenbahnsets','de-DE'),(3256,'Kunst & Unterhaltung > Hobby & Kunst > Modellbau > Modelleisenbahnzubehör','de-DE'),(3257,'Kunst & Unterhaltung > Hobby & Kunst > Modellbau > Modellraketen','de-DE'),(3258,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente','de-DE'),(3259,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Akkordeons & Konzertinas','de-DE'),(3260,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente','de-DE'),(3261,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Alt- & Baritonhörner','de-DE'),(3262,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Euphonien','de-DE'),(3263,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Posaunen','de-DE'),(3264,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Trompeten & Kornetts','de-DE'),(3265,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Tubas','de-DE'),(3266,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Blechblasinstrumente > Waldhörner','de-DE'),(3267,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Dudelsäcke','de-DE'),(3268,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Elektronische Musikinstrumente','de-DE'),(3269,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Elektronische Musikinstrumente > Audio-Sampler','de-DE'),(3270,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Elektronische Musikinstrumente > MIDI-Controller','de-DE'),(3271,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Elektronische Musikinstrumente > Musik-Keyboards','de-DE'),(3272,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Elektronische Musikinstrumente > Synthesizer','de-DE'),(3273,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente','de-DE'),(3274,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Blechflöten','de-DE'),(3275,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Blockflöten','de-DE'),(3276,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Fagotte','de-DE'),(3277,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Flöten','de-DE'),(3278,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Kinderflöten','de-DE'),(3279,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Klarinetten','de-DE'),(3280,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Längsflöten & Panflöten','de-DE'),(3281,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Maultrommeln','de-DE'),(3282,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Melodicas','de-DE'),(3283,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Mundharmonikas','de-DE'),(3284,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Oboen','de-DE'),(3285,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Okarinas','de-DE'),(3286,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Saxophone','de-DE'),(3287,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Holzblasinstrumente > Zugpfeife','de-DE'),(3288,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Klaviere','de-DE'),(3289,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente','de-DE'),(3290,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Bratschen','de-DE'),(3291,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Cellos','de-DE'),(3292,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Gitarren','de-DE'),(3293,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Harfen','de-DE'),(3294,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Kontrabässe','de-DE'),(3295,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Saiteninstrumente > Violinen','de-DE'),(3296,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente','de-DE'),(3297,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Basstrommeln','de-DE'),(3298,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Becken','de-DE'),(3299,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Elektronische Schlagzeuge','de-DE'),(3300,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Glockenspiele & Xylophone','de-DE'),(3301,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Gongs','de-DE'),(3302,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente','de-DE'),(3303,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Finger- & Handzimbeln','de-DE'),(3304,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handschellen & -glocken','de-DE'),(3305,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln','de-DE'),(3306,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Beckentrommeln','de-DE'),(3307,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Bongos','de-DE'),(3308,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Cajons','de-DE'),(3309,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Congas','de-DE'),(3310,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Rahmentrommeln','de-DE'),(3311,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Sprechtrommeln','de-DE'),(3312,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Handtrommeln > Tablas','de-DE'),(3313,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Holzblöcke','de-DE'),(3314,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Kastagnetten','de-DE'),(3315,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Kuhglocken','de-DE'),(3316,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Rasseln','de-DE'),(3317,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Scraper & Schnarren','de-DE'),(3318,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Tamburine','de-DE'),(3319,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Triangeln','de-DE'),(3320,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Handperkussionsinstrumente > Vibraslaps','de-DE'),(3321,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Hi-Hats','de-DE'),(3322,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Schlagzeuge','de-DE'),(3323,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Snaredrums','de-DE'),(3324,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Tom-Toms','de-DE'),(3325,'Kunst & Unterhaltung > Hobby & Kunst > Musikinstrumente > Schlaginstrumente > Übungspads','de-DE'),(3326,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke','de-DE'),(3327,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Autogramme','de-DE'),(3328,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Briefmarken','de-DE'),(3329,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Maßstabsmodelle','de-DE'),(3330,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Modellbau-Zubehör','de-DE'),(3331,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Münzen & Währungen','de-DE'),(3332,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Retro-Werbung','de-DE'),(3333,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammelkarten','de-DE'),(3334,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammlerwaffen','de-DE'),(3335,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammlerwaffen > Dekowaffen','de-DE'),(3336,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammlerwaffen > Sammlermesser','de-DE'),(3337,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammlerwaffen > Schwerter','de-DE'),(3338,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sammlerwaffen > Schwertständer & Schwerthalter','de-DE'),(3339,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte','de-DE'),(3340,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel','de-DE'),(3341,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > American Football-Fanartikel','de-DE'),(3342,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Baseball- & Softball-Fanartikel','de-DE'),(3343,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Basketball-Fanartikel','de-DE'),(3344,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Fußball-Fanartikel','de-DE'),(3345,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Hockey-Fanartikel','de-DE'),(3346,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Rennsport-Fanartikel','de-DE'),(3347,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sport-Fanartikel > Tennis-Fanzubehör','de-DE'),(3348,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm','de-DE'),(3349,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > American Football-Artikel mit Autogramm','de-DE'),(3350,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Baseball- & Softballartikel mit Autogramm','de-DE'),(3351,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Basketballartikel mit Autogramm','de-DE'),(3352,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Boxartikel mit Autogramm','de-DE'),(3353,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Fußballartikel mit Autogramm','de-DE'),(3354,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Hockeyartikel mit Autogramm','de-DE'),(3355,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Rennsportartikel mit Autogramm','de-DE'),(3356,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Sport-Sammelobjekte > Sportartikel mit Autogramm > Tennisartikel mit Autogramm','de-DE'),(3357,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Steine & Fossilien','de-DE'),(3358,'Kunst & Unterhaltung > Hobby & Kunst > Sammlerstücke > Stempelsiegel','de-DE'),(3359,'Kunst & Unterhaltung > Hobby & Kunst > Zauberbedarf','de-DE'),(3360,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Bier- & Weinherstellung','de-DE'),(3361,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Bier- & Weinherstellung > Abfüllflaschen','de-DE'),(3362,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Bier- & Weinherstellung > Brauzutaten','de-DE'),(3363,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Bier- & Weinherstellung > Sets zum Selbstherstellen von Bier & Wein','de-DE'),(3364,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Bier- & Weinherstellung > Weinherstellung','de-DE'),(3365,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente','de-DE'),(3366,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Keyboardzubehör','de-DE'),(3367,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Keyboardzubehör > Keyboardständer','de-DE'),(3368,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Keyboardzubehör > Keyboardtaschen','de-DE'),(3369,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Keyboardzubehör > Sustain-Pedale','de-DE'),(3370,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Klavierbänke & Musikerhocker','de-DE'),(3371,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Marschgabeln und Notenhalter','de-DE'),(3372,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Metronome','de-DE'),(3373,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Notenständer','de-DE'),(3374,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör','de-DE'),(3375,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Dämpfer für Schlagzeug & Becken','de-DE'),(3376,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Module für elektronische Schlagzeuge','de-DE'),(3377,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeug-Hardware','de-DE'),(3378,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeug-Hardware > Beater','de-DE'),(3379,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeug-Hardware > Fußmaschinen','de-DE'),(3380,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeug-Hardware > Schlagzeughalterungen','de-DE'),(3381,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeugfelle','de-DE'),(3382,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Schlagzeugkoffer','de-DE'),(3383,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Sticks & Besen','de-DE'),(3384,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Stimmschlüssel','de-DE'),(3385,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Ständer für Perkussionsinstrumente','de-DE'),(3386,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Trommelschlägel','de-DE'),(3387,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Zubehör für Handperkussionsinstrumente','de-DE'),(3388,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Zubehör für Handperkussionsinstrumente > Ständer für Handperkussionsinstrumente','de-DE'),(3389,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Zubehör für Handperkussionsinstrumente > Taschen für Handperkussionsinstrumente','de-DE'),(3390,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Zubehör für Sticks & Besen','de-DE'),(3391,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Schlagzeugzubehör > Zubehör für Sticks & Besen > Taschen für Sticks & Besen','de-DE'),(3392,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Stimmgeräte','de-DE'),(3393,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Ständer für Musikinstrumente','de-DE'),(3394,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Ständer für Musikinstrumente > Beleuchtung für Instrumentenständer','de-DE'),(3395,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Ständer für Musikinstrumente > Notenklemmen','de-DE'),(3396,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Ständer für Musikinstrumente > Taschen für Instrumentenständer','de-DE'),(3397,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Taktstöcke','de-DE'),(3398,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärker für Musikinstrumente','de-DE'),(3399,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör','de-DE'),(3400,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Ständer für Verstärker','de-DE'),(3401,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Verstärker-Fußschalter','de-DE'),(3402,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Verstärkerabdeckungen','de-DE'),(3403,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Verstärkergehäuse','de-DE'),(3404,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Verstärkerknöpfe','de-DE'),(3405,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Verstärkerzubehör > Verstärkerröhren','de-DE'),(3406,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente','de-DE'),(3407,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Aufhängungen & Ständer für Blechinstrumente','de-DE'),(3408,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung','de-DE'),(3409,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Klappenöl für Blechblasinstrumente','de-DE'),(3410,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Pflegesets für Blechblasinstrumente','de-DE'),(3411,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Poliertücher für Blechblasinstrumente','de-DE'),(3412,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Reinigungs- & Desinfektionsmittel für Blechblasinstrumente','de-DE'),(3413,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Reinigungswerkzeug für Blechblasinstrumente','de-DE'),(3414,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Blechblasinstrumentenpflege &-reinigung > Schutzvorrichtungen für Blechblasinstrumente','de-DE'),(3415,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Dämpfer für Blechinstrumente','de-DE'),(3416,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Ersatzteile für Blechblasinstrumente','de-DE'),(3417,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Koffer & Gigbags für Blechinstrumente','de-DE'),(3418,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Blechblasinstrumente > Mundstücke für Blechinstrumente','de-DE'),(3419,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente','de-DE'),(3420,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Blockflötenzubehör','de-DE'),(3421,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Blockflötenzubehör > Blockflötenkoffer','de-DE'),(3422,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Blockflötenzubehör > Blockflötenteile','de-DE'),(3423,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Blockflötenzubehör > Pflege- & Reinigungsmittel für Blockflöten','de-DE'),(3424,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Blätteretui für Holzblasinstrumente','de-DE'),(3425,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottblattmesser','de-DE'),(3426,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör','de-DE'),(3427,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottblätter','de-DE'),(3428,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottpflege & -reinigung','de-DE'),(3429,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottpflege & -reinigung > Fagottreinigungstücher','de-DE'),(3430,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottriemen & -stützen','de-DE'),(3431,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottständer','de-DE'),(3432,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottteile','de-DE'),(3433,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottteile > Fagott-S-Bögen','de-DE'),(3434,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Fagottteile > Kleinere Fagottzubehörteile','de-DE'),(3435,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Fagottzubehör > Koffer & Transporttaschen für Fagotte','de-DE'),(3436,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör','de-DE'),(3437,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenhalter & -ständer','de-DE'),(3438,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenpflege & -reinigung','de-DE'),(3439,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenpflege & -reinigung > Flötenpflegesets','de-DE'),(3440,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenpflege & -reinigung > Flötenreinigungsstab','de-DE'),(3441,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenpflege & -reinigung > Flötenreinigungstücher','de-DE'),(3442,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenteile','de-DE'),(3443,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenteile > Flötenkopfstücke','de-DE'),(3444,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Flötenteile > Kleinere Flötenzubehörteile','de-DE'),(3445,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Flötenzubehör > Koffer & Transporttaschen für Flöten','de-DE'),(3446,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör','de-DE'),(3447,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Blattschrauben & Kappen für Klarinetten','de-DE'),(3448,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenblätter','de-DE'),(3449,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenhalter/-ständer','de-DE'),(3450,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenpflege &-reinigung','de-DE'),(3451,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenpflege &-reinigung > Klarinettenklappenschutz','de-DE'),(3452,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenpflege &-reinigung > Klarinettenpflegesets','de-DE'),(3453,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenpflege &-reinigung > Klarinettenreinigungstücher','de-DE'),(3454,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenriemen & -stützen','de-DE'),(3455,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenteile','de-DE'),(3456,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenteile > Klarinettenbirnen','de-DE'),(3457,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenteile > Klarinettenmundstücke','de-DE'),(3458,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenteile > Klarinettentrichter','de-DE'),(3459,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Klarinettenteile > Kleinere Klarinettenzubehörteile','de-DE'),(3460,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Klarinettenzubehör > Koffer & Transporttaschen für Klarinetten','de-DE'),(3461,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Korkfett für Holzblasinstrumente','de-DE'),(3462,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Mundharmonikazubehör','de-DE'),(3463,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Mundharmonikazubehör > Mundharmonika-Etuis','de-DE'),(3464,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Mundharmonikazubehör > Mundharmonikahalter','de-DE'),(3465,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör','de-DE'),(3466,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Koffer & Transporttaschen für Oboen','de-DE'),(3467,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenblätter','de-DE'),(3468,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenhalter & -ständer','de-DE'),(3469,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenpflege & -reinigung','de-DE'),(3470,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenpflege & -reinigung > Oboenpflegesets','de-DE'),(3471,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenpflege & -reinigung > Oboenreinigungstücher','de-DE'),(3472,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenriemen & -stützen','de-DE'),(3473,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenteile','de-DE'),(3474,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Oboenzubehör > Oboenteile > Kleinere Oboenzubehörteile','de-DE'),(3475,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Poliertücher für Holzblasinstrumente','de-DE'),(3476,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone','de-DE'),(3477,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Blattschrauben & Kappen für Saxophone','de-DE'),(3478,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Koffer & Transporttaschen für Saxophone','de-DE'),(3479,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Rohrblätter für Saxophone','de-DE'),(3480,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonhalter & -ständer','de-DE'),(3481,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonpflege &-reinigung','de-DE'),(3482,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonpflege &-reinigung > Saxophonklappenschutz','de-DE'),(3483,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonpflege &-reinigung > Saxophonpflegesets','de-DE'),(3484,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonpflege &-reinigung > Saxophonreinigungstücher','de-DE'),(3485,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonriemen/-stützen','de-DE'),(3486,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonteile','de-DE'),(3487,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonteile > Kleinere Saxophonzubehörteile','de-DE'),(3488,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonteile > Mundstücke für Saxophone','de-DE'),(3489,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Holzblasinstrumente > Zubehör für Saxophone > Saxophonteile > Saxophonhälse','de-DE'),(3490,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente','de-DE'),(3491,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör','de-DE'),(3492,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarren-Slides','de-DE'),(3493,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenbefeuchter','de-DE'),(3494,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrengurte','de-DE'),(3495,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenkoffer & -taschen','de-DE'),(3496,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenplektren','de-DE'),(3497,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrensaiten','de-DE'),(3498,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrensaitenspanner','de-DE'),(3499,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenstimmwirbel','de-DE'),(3500,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenständer','de-DE'),(3501,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Gitarrenzubehör & -teile','de-DE'),(3502,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Kapodaster','de-DE'),(3503,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Tonabnehmer für Akustikgitarren','de-DE'),(3504,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Gitarrenzubehör > Tonabnehmer für E-Gitarren','de-DE'),(3505,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Saiteninstrumentenpflege &-reinigung','de-DE'),(3506,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Saiteninstrumentenpflege &-reinigung > Bogenharz','de-DE'),(3507,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Saiteninstrumentenpflege &-reinigung > Politur für Saiteninstrumente','de-DE'),(3508,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Saiteninstrumentenpflege &-reinigung > Reinigungstücher für Saiteninstrumente','de-DE'),(3509,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen','de-DE'),(3510,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Bogenkästen für Streichinstrumente','de-DE'),(3511,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Bögen für Saiteninstrumente','de-DE'),(3512,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Dämpfer für Saiteninstrumente','de-DE'),(3513,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Koffer für Saiteninstrumente','de-DE'),(3514,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Saiten für Saiteninstrumente','de-DE'),(3515,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Ständer für Saiteninstrumente','de-DE'),(3516,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Tonabnehmer für Saiteninstrumente','de-DE'),(3517,'Kunst & Unterhaltung > Hobby & Kunst > Zubehör für Musikinstrumente > Zubehör für Saiteninstrumente > Zubehör für Streichinstrumente & Harfen > Zubehör & Ersatzteile für Saiteninstrumente','de-DE'),(3518,'Kunst & Unterhaltung > Party & Feiern','de-DE'),(3519,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör','de-DE'),(3520,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Antwortkarten','de-DE'),(3521,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Aufblasbare Partydeko','de-DE'),(3522,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Ballon-Sets','de-DE'),(3523,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Banner','de-DE'),(3524,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Briefsiegel','de-DE'),(3525,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Cocktaildekorationen','de-DE'),(3526,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Dekorative Pompons','de-DE'),(3527,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Einladungskarten','de-DE'),(3528,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Eventprogramme','de-DE'),(3529,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Feuerwerkskörper','de-DE'),(3530,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Geburtstagskerzen','de-DE'),(3531,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Halter für Karten zu besonderen Anlässen','de-DE'),(3532,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Konfetti','de-DE'),(3533,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Luftballons','de-DE'),(3534,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Luftschlangenspray','de-DE'),(3535,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partyartikel','de-DE'),(3536,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partyartikel > Kleine Geschenke für Hochzeitsgäste','de-DE'),(3537,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partygirlanden & -vorhänge','de-DE'),(3538,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partyhüte','de-DE'),(3539,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partyspiele','de-DE'),(3540,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Partyzubehörsets','de-DE'),(3541,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Piñatas','de-DE'),(3542,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Platzkarten','de-DE'),(3543,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Platzkartenhalter','de-DE'),(3544,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Spruchkarten','de-DE'),(3545,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Stuhlbezüge','de-DE'),(3546,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Trinkhalme & Rührer','de-DE'),(3547,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Trinkspiele','de-DE'),(3548,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Trinkspiele > Bierpong','de-DE'),(3549,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Trinkspiele > Bierpong > Bierpong-Tische','de-DE'),(3550,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Tröten, Luftrüssel & Krachmacher','de-DE'),(3551,'Kunst & Unterhaltung > Party & Feiern > Partyzubehör > Wunderkerzen','de-DE'),(3552,'Kunst & Unterhaltung > Party & Feiern > Schenken','de-DE'),(3553,'Kunst & Unterhaltung > Party & Feiern > Schenken > Anstecksträußchen','de-DE'),(3554,'Kunst & Unterhaltung > Party & Feiern > Schenken > Befestigungsnadeln für Anstecksträußchen','de-DE'),(3555,'Kunst & Unterhaltung > Party & Feiern > Schenken > Frische Schnittblumen','de-DE'),(3556,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkgutscheine','de-DE'),(3557,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen','de-DE'),(3558,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen > Geschenkanhänger','de-DE'),(3559,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen > Geschenkboxen & -dosen','de-DE'),(3560,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen > Geschenkpapier','de-DE'),(3561,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen > Geschenktaschen','de-DE'),(3562,'Kunst & Unterhaltung > Party & Feiern > Schenken > Geschenkverpackungen > Seidenpapier','de-DE'),(3563,'Kunst & Unterhaltung > Party & Feiern > Schenken > Grußkarten','de-DE'),(3564,'Kunst & Unterhaltung > Party & Feiern > Trophäen & Preise','de-DE'),(3565,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte','de-DE'),(3566,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte > Diskokugeln','de-DE'),(3567,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte > Lichteffektbeleuchtung','de-DE'),(3568,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte > Lichtmischpulte','de-DE'),(3569,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte > Nebelmaschinen','de-DE'),(3570,'Kunst & Unterhaltung > Party & Feiern > Visuelle Effekte > Ständer für Lichteffektbeleuchtung','de-DE'),(3571,'Medien','de-DE'),(3572,'Medien > Baupläne für Tischler- und Holzarbeiten','de-DE'),(3573,'Medien > Bücher','de-DE'),(3574,'Medien > DVDs & Videos','de-DE'),(3575,'Medien > Musik & Tonaufnahmen','de-DE'),(3576,'Medien > Notenblätter','de-DE'),(3577,'Medien > Produkthandbücher & Gebrauchsanleitungen','de-DE'),(3578,'Medien > Produkthandbücher & Gebrauchsanleitungen > Bürobedarf-Handbücher','de-DE'),(3579,'Medien > Produkthandbücher & Gebrauchsanleitungen > Handbücher für Elektrogeräte','de-DE'),(3580,'Medien > Produkthandbücher & Gebrauchsanleitungen > Handbücher für Elektrowerkzeuge','de-DE'),(3581,'Medien > Produkthandbücher & Gebrauchsanleitungen > Handbücher für Haushaltsgeräte','de-DE'),(3582,'Medien > Produkthandbücher & Gebrauchsanleitungen > Handbücher für Küchengeräte','de-DE'),(3583,'Medien > Produkthandbücher & Gebrauchsanleitungen > Handbücher für Modellbau und Spielzeuge','de-DE'),(3584,'Medien > Produkthandbücher & Gebrauchsanleitungen > Kamera- & Optikhandbücher','de-DE'),(3585,'Medien > Produkthandbücher & Gebrauchsanleitungen > Kfz-Handbücher','de-DE'),(3586,'Medien > Produkthandbücher & Gebrauchsanleitungen > Sport- & Freizeithandbücher','de-DE'),(3587,'Medien > Zeitschriften & Zeitungen','de-DE'),(3588,'Möbel','de-DE'),(3589,'Möbel > Baby- & Kleinkindmöbel','de-DE'),(3590,'Möbel > Baby- & Kleinkindmöbel > Gitter- & Kinderbettzubehör','de-DE'),(3591,'Möbel > Baby- & Kleinkindmöbel > Gitter- & Kinderbettzubehör > Bettnestchen & Randschutz für Gitterbetten','de-DE'),(3592,'Möbel > Baby- & Kleinkindmöbel > Gitter- & Kinderbettzubehör > Umbausätze für Gitterbetten','de-DE'),(3593,'Möbel > Baby- & Kleinkindmöbel > Gitterbetten & Kleinkinderbetten','de-DE'),(3594,'Möbel > Baby- & Kleinkindmöbel > Hochstühle & Sitzerhöhungen','de-DE'),(3595,'Möbel > Baby- & Kleinkindmöbel > Möbelgarnituren für Babies & Kleinkinder','de-DE'),(3596,'Möbel > Baby- & Kleinkindmöbel > Wickeltische','de-DE'),(3597,'Möbel > Baby- & Kleinkindmöbel > Wiegen & Stubenwagen','de-DE'),(3598,'Möbel > Baby- & Kleinkindmöbel > Wiegen- & Stubenwagenzubehör','de-DE'),(3599,'Möbel > Baby- & Kleinkindmöbel > Zubehör für Hochstühle und Sitzerhöhungen','de-DE'),(3600,'Möbel > Betten & Zubehör','de-DE'),(3601,'Möbel > Betten & Zubehör > Bett- & Bettrahmenzubehör','de-DE'),(3602,'Möbel > Betten & Zubehör > Betten & Bettgestelle','de-DE'),(3603,'Möbel > Betten & Zubehör > Kopf- & Fußenden','de-DE'),(3604,'Möbel > Betten & Zubehör > Matratzen','de-DE'),(3605,'Möbel > Betten & Zubehör > Matratzen-Untergestelle','de-DE'),(3606,'Möbel > Büromöbel','de-DE'),(3607,'Möbel > Büromöbel > Arbeitsplätze im Großraumbüro','de-DE'),(3608,'Möbel > Büromöbel > Arbeitstische','de-DE'),(3609,'Möbel > Büromöbel > Arbeitstische > Konferenztische','de-DE'),(3610,'Möbel > Büromöbel > Arbeitstische > Verstellbare Zeichentische','de-DE'),(3611,'Möbel > Büromöbel > Büro- & Schreibtischstühle','de-DE'),(3612,'Möbel > Büromöbel > Büromöbelgarnituren','de-DE'),(3613,'Möbel > Büromöbel > Schreibtische','de-DE'),(3614,'Möbel > Futonauflagen','de-DE'),(3615,'Möbel > Futonrahmen','de-DE'),(3616,'Möbel > Futons','de-DE'),(3617,'Möbel > Gartenmöbel','de-DE'),(3618,'Möbel > Gartenmöbel > Aufbewahrungsbehälter für draußen','de-DE'),(3619,'Möbel > Gartenmöbel > Gartenbetten','de-DE'),(3620,'Möbel > Gartenmöbel > Gartenhocker','de-DE'),(3621,'Möbel > Gartenmöbel > Gartenmöbelgarnituren','de-DE'),(3622,'Möbel > Gartenmöbel > Gartensitzmöbel','de-DE'),(3623,'Möbel > Gartenmöbel > Gartensitzmöbel > Gartenbänke','de-DE'),(3624,'Möbel > Gartenmöbel > Gartensitzmöbel > Gartensofaelemente','de-DE'),(3625,'Möbel > Gartenmöbel > Gartensitzmöbel > Gartensofas','de-DE'),(3626,'Möbel > Gartenmöbel > Gartensitzmöbel > Gartenstühle','de-DE'),(3627,'Möbel > Gartenmöbel > Gartensitzmöbel > Sonnenliegen','de-DE'),(3628,'Möbel > Gartenmöbel > Gartentische','de-DE'),(3629,'Möbel > Gartenmöbelzubehör','de-DE'),(3630,'Möbel > Gartenmöbelzubehör > Abdeckungen für Gartenmöbel','de-DE'),(3631,'Möbel > Kücheninseln & Küchenwagen','de-DE'),(3632,'Möbel > Kücheninseln & Küchenwagen > Kücheninseln','de-DE'),(3633,'Möbel > Kücheninseln & Küchenwagen > Küchenwagen','de-DE'),(3634,'Möbel > Möbel für Unterhaltungselektronik','de-DE'),(3635,'Möbel > Möbelgarnituren','de-DE'),(3636,'Möbel > Möbelgarnituren > Badezimmergarnituren','de-DE'),(3637,'Möbel > Möbelgarnituren > Küchen- & Esszimmergarnituren','de-DE'),(3638,'Möbel > Möbelgarnituren > Schlafzimmergarnituren','de-DE'),(3639,'Möbel > Möbelgarnituren > Wohnzimmergarnituren','de-DE'),(3640,'Möbel > Polsterhocker','de-DE'),(3641,'Möbel > Raumteiler','de-DE'),(3642,'Möbel > Raumteilerzubehör','de-DE'),(3643,'Möbel > Regalsysteme','de-DE'),(3644,'Möbel > Regalsysteme > Bücherregale & Bücherschränke','de-DE'),(3645,'Möbel > Regalsysteme > Wandregale & Simse','de-DE'),(3646,'Möbel > Regalzubehör','de-DE'),(3647,'Möbel > Regalzubehör > Ersatzregale','de-DE'),(3648,'Möbel > Schränke','de-DE'),(3649,'Möbel > Schränke > Aktenschränke','de-DE'),(3650,'Möbel > Schränke > Aufbewahrungstruhen','de-DE'),(3651,'Möbel > Schränke > Aufbewahrungstruhen > Aussteuertruhen','de-DE'),(3652,'Möbel > Schränke > Aufbewahrungstruhen > Spielzeugtruhen','de-DE'),(3653,'Möbel > Schränke > Buffets & Sideboards','de-DE'),(3654,'Möbel > Schränke > Bügelcenter','de-DE'),(3655,'Möbel > Schränke > Büroschränke','de-DE'),(3656,'Möbel > Schränke > Geschirrschränke','de-DE'),(3657,'Möbel > Schränke > Kleiderschränke','de-DE'),(3658,'Möbel > Schränke > Kommoden','de-DE'),(3659,'Möbel > Schränke > Küchenschränke','de-DE'),(3660,'Möbel > Schränke > Mediaaufbewahrung','de-DE'),(3661,'Möbel > Schränke > Spirituosenschränke','de-DE'),(3662,'Möbel > Schränke > Wasch- und Schminktische','de-DE'),(3663,'Möbel > Schränke > Wasch- und Schminktische > Badezimmerwaschtische','de-DE'),(3664,'Möbel > Schränke > Wasch- und Schminktische > Schminktische','de-DE'),(3665,'Möbel > Schränke > Weinregale','de-DE'),(3666,'Möbel > Schränke > Zeitschriftenständer','de-DE'),(3667,'Möbel > Sitzbänke','de-DE'),(3668,'Möbel > Sitzbänke > Küchen- & Eckbänke','de-DE'),(3669,'Möbel > Sitzbänke > Schminktischhocker','de-DE'),(3670,'Möbel > Sitzbänke > Truhen- & Flurbänke','de-DE'),(3671,'Möbel > Sofa-Zubehör','de-DE'),(3672,'Möbel > Sofa-Zubehör > Anbausofas','de-DE'),(3673,'Möbel > Sofa-Zubehör > Sitzverstärkung für Stühle & Sofas','de-DE'),(3674,'Möbel > Sofas','de-DE'),(3675,'Möbel > Stuhlzubehör','de-DE'),(3676,'Möbel > Stuhlzubehör > Ersatzteile für Hängesessel','de-DE'),(3677,'Möbel > Stühle','de-DE'),(3678,'Möbel > Stühle > Bodenstühle','de-DE'),(3679,'Möbel > Stühle > Elektrische Massagesessel','de-DE'),(3680,'Möbel > Stühle > Hocker & Barhocker','de-DE'),(3681,'Möbel > Stühle > Hängesessel','de-DE'),(3682,'Möbel > Stühle > Klappstühle & Holzhocker','de-DE'),(3683,'Möbel > Stühle > Küchen- und Esszimmerstühle','de-DE'),(3684,'Möbel > Stühle > Liegemöbel','de-DE'),(3685,'Möbel > Stühle > Multimediasessel','de-DE'),(3686,'Möbel > Stühle > Schaukelstühle','de-DE'),(3687,'Möbel > Stühle > Sessel','de-DE'),(3688,'Möbel > Stühle > Sessel ohne Armlehnen','de-DE'),(3689,'Möbel > Stühle > Sitzsäcke','de-DE'),(3690,'Möbel > Tische','de-DE'),(3691,'Möbel > Tische > Kinderspieltische','de-DE'),(3692,'Möbel > Tische > Klapptische','de-DE'),(3693,'Möbel > Tische > Kotatsu','de-DE'),(3694,'Möbel > Tische > Küchen- & Esszimmertische','de-DE'),(3695,'Möbel > Tische > Nachttische','de-DE'),(3696,'Möbel > Tische > Nähmaschinentische','de-DE'),(3697,'Möbel > Tische > Poker- & Spieltische','de-DE'),(3698,'Möbel > Tische > Ziertische','de-DE'),(3699,'Möbel > Tische > Ziertische > Beistelltische','de-DE'),(3700,'Möbel > Tische > Ziertische > Couchtische','de-DE'),(3701,'Möbel > Tische > Ziertische > Konsolentische','de-DE'),(3702,'Möbel > Tischzubehör','de-DE'),(3703,'Möbel > Tischzubehör > Tischbeine','de-DE'),(3704,'Möbel > Tischzubehör > Tischplatten','de-DE'),(3705,'Möbel > Zubehör für Büromöbel','de-DE'),(3706,'Möbel > Zubehör für Büromöbel > Bürostuhl-Zubehör','de-DE'),(3707,'Möbel > Zubehör für Büromöbel > Schreibtischteile & -zubehör','de-DE'),(3708,'Möbel > Zubehör für Büromöbel > Zubehör für Arbeitsplätze im Großraumbüro','de-DE'),(3709,'Nahrungsmittel, Getränke & Tabak','de-DE'),(3710,'Nahrungsmittel, Getränke & Tabak > Getränke','de-DE'),(3711,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke','de-DE'),(3712,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Alkopops','de-DE'),(3713,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Bier','de-DE'),(3714,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Cidre','de-DE'),(3715,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Cocktail-Bitter','de-DE'),(3716,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Cocktail-Premix','de-DE'),(3717,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen','de-DE'),(3718,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Absinth','de-DE'),(3719,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Gin','de-DE'),(3720,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Liköre','de-DE'),(3721,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Rum','de-DE'),(3722,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Shochu & Soju','de-DE'),(3723,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Tequila','de-DE'),(3724,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Weinbrand','de-DE'),(3725,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Whiskey','de-DE'),(3726,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Liköre & Spirituosen > Wodka','de-DE'),(3727,'Nahrungsmittel, Getränke & Tabak > Getränke > Alkoholische Getränke > Wein','de-DE'),(3728,'Nahrungsmittel, Getränke & Tabak > Getränke > Buttermilch','de-DE'),(3729,'Nahrungsmittel, Getränke & Tabak > Getränke > Eierlikör','de-DE'),(3730,'Nahrungsmittel, Getränke & Tabak > Getränke > Essighaltige Getränke','de-DE'),(3731,'Nahrungsmittel, Getränke & Tabak > Getränke > Getränke mit Fruchtgeschmack','de-DE'),(3732,'Nahrungsmittel, Getränke & Tabak > Getränke > Getränkepulver','de-DE'),(3733,'Nahrungsmittel, Getränke & Tabak > Getränke > Kaffee','de-DE'),(3734,'Nahrungsmittel, Getränke & Tabak > Getränke > Kakao','de-DE'),(3735,'Nahrungsmittel, Getränke & Tabak > Getränke > Limonaden','de-DE'),(3736,'Nahrungsmittel, Getränke & Tabak > Getränke > Milch','de-DE'),(3737,'Nahrungsmittel, Getränke & Tabak > Getränke > Nicht-tierische Milch','de-DE'),(3738,'Nahrungsmittel, Getränke & Tabak > Getränke > Saft','de-DE'),(3739,'Nahrungsmittel, Getränke & Tabak > Getränke > Sportgetränke & Energy Drinks','de-DE'),(3740,'Nahrungsmittel, Getränke & Tabak > Getränke > Tees & Aufgüsse','de-DE'),(3741,'Nahrungsmittel, Getränke & Tabak > Getränke > Wasser','de-DE'),(3742,'Nahrungsmittel, Getränke & Tabak > Lebensmittel','de-DE'),(3743,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren','de-DE'),(3744,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Backwaren-Mischungen','de-DE'),(3745,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Bagels','de-DE'),(3746,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Brot & Brötchen','de-DE'),(3747,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Cupcakes','de-DE'),(3748,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Donuts','de-DE'),(3749,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Eistüten','de-DE'),(3750,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Feingebäck','de-DE'),(3751,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Karamell-Fudge','de-DE'),(3752,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Kuchen','de-DE'),(3753,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Kuchen zum Kaffee','de-DE'),(3754,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Muffins','de-DE'),(3755,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Pasteten & Torten','de-DE'),(3756,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Plätzchen','de-DE'),(3757,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Tacoschalen','de-DE'),(3758,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Backwaren > Tortillas & Wraps','de-DE'),(3759,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Delikatessen Präsentkörbe','de-DE'),(3760,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche','de-DE'),(3761,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Apfelbutter','de-DE'),(3762,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Frischkäse','de-DE'),(3763,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Gemüsedip','de-DE'),(3764,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Guacamole','de-DE'),(3765,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Hummus','de-DE'),(3766,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Käse-Dips & -aufstriche','de-DE'),(3767,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Marmeladen & Gelees','de-DE'),(3768,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Nussbutter','de-DE'),(3769,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Salsa-Saucen','de-DE'),(3770,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Dips & Brotaufstriche > Tapenade','de-DE'),(3771,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fertiggerichte','de-DE'),(3772,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fertiggerichte > Fertige Mahlzeiten und Hauptgerichte','de-DE'),(3773,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fertiggerichte > Fertige Vorspeisen und Beilagen','de-DE'),(3774,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier','de-DE'),(3775,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Eier','de-DE'),(3776,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fisch & Meeresfrüchte','de-DE'),(3777,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fisch & Meeresfrüchte > Fisch- & Meeresfrüchtekonserven','de-DE'),(3778,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fisch & Meeresfrüchte > Frische(r) & tiefgefrorene(r) Fisch/Meeresfrüchte','de-DE'),(3779,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fleisch','de-DE'),(3780,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fleisch > Fleisch- & Wurstwaren','de-DE'),(3781,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fleisch > Fleischkonserven','de-DE'),(3782,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Fleisch, Fisch, Meeresfrüchte & Eier > Fleisch > Frisches & Tiefgefrorenes Fleisch','de-DE'),(3783,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten','de-DE'),(3784,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backaromen','de-DE'),(3785,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backfett & Schmalz','de-DE'),(3786,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backmischungen','de-DE'),(3787,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backmischungen für Waffeln und Pfannkuchen','de-DE'),(3788,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backpulver','de-DE'),(3789,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backsoda','de-DE'),(3790,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Backwaren-Deko-Sets','de-DE'),(3791,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Blockschokoloade','de-DE'),(3792,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Bohnenpasten & -saucen','de-DE'),(3793,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Dosen- und Trockenmilch','de-DE'),(3794,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Essbare Backdekoration','de-DE'),(3795,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Essig','de-DE'),(3796,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Gemahlene Getreideprodukte','de-DE'),(3797,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Geschmacksneutrale Gelatine','de-DE'),(3798,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Hefe','de-DE'),(3799,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Kochwein','de-DE'),(3800,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Kuchen- & Pastetenfüllungen','de-DE'),(3801,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Lebensmittelfarben','de-DE'),(3802,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Maissirup','de-DE'),(3803,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Maisstärke','de-DE'),(3804,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Marshmallows','de-DE'),(3805,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Mehl','de-DE'),(3806,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Melasse','de-DE'),(3807,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Paniermehl','de-DE'),(3808,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Raspeln, Flocken & Tröpfchen','de-DE'),(3809,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Speiseöle','de-DE'),(3810,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Starterkulturen','de-DE'),(3811,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Stärkemehl & Paniermischungen','de-DE'),(3812,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Tapiokaperlen','de-DE'),(3813,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Teig','de-DE'),(3814,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Teig > Brot- & Gebäckteig','de-DE'),(3815,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Teig > Pastetenteig','de-DE'),(3816,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Teig > Plätzchen- & Brownieteig','de-DE'),(3817,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Tomatenmark','de-DE'),(3818,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Zitronen- und Limettensaft','de-DE'),(3819,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Zucker & Süßstoffe','de-DE'),(3820,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Zuckerguss & Glasur','de-DE'),(3821,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Koch- & Backzutaten > Zuckerwatte','de-DE'),(3822,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide','de-DE'),(3823,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Amarant','de-DE'),(3824,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Buchweizen','de-DE'),(3825,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Couscous','de-DE'),(3826,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Frühstücksflocken & Müsli','de-DE'),(3827,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Gerste','de-DE'),(3828,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Haferflocken, Grütze & Grieß','de-DE'),(3829,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Hirse','de-DE'),(3830,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Quinoa','de-DE'),(3831,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Reis','de-DE'),(3832,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Roggen','de-DE'),(3833,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Körner, Reis & Getreide > Weizen','de-DE'),(3834,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte','de-DE'),(3835,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Butter & Margarine','de-DE'),(3836,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Hüttenkäse','de-DE'),(3837,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Joghurt','de-DE'),(3838,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Kaffeeweißer','de-DE'),(3839,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Käse','de-DE'),(3840,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Sahne','de-DE'),(3841,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Sauerrahm','de-DE'),(3842,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Milchprodukte > Schlagsahne','de-DE'),(3843,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Nüsse & Samen','de-DE'),(3844,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse','de-DE'),(3845,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Dosenbohnen','de-DE'),(3846,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse','de-DE'),(3847,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Arakachas','de-DE'),(3848,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Artischocken','de-DE'),(3849,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Auberginen','de-DE'),(3850,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse','de-DE'),(3851,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Choi Sum','de-DE'),(3852,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Gartensalat','de-DE'),(3853,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Grünkohl','de-DE'),(3854,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Mangold','de-DE'),(3855,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Pak Choi','de-DE'),(3856,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Rauke','de-DE'),(3857,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Rübenblätter','de-DE'),(3858,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Salatmischungen','de-DE'),(3859,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Spinat','de-DE'),(3860,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Wasserspinat','de-DE'),(3861,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Wegwarte','de-DE'),(3862,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blattgemüse > Yu Choy','de-DE'),(3863,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Blumenkohl','de-DE'),(3864,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Bohnen','de-DE'),(3865,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Borretsch','de-DE'),(3866,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Brokkoli','de-DE'),(3867,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Chinesischer Brokkoli','de-DE'),(3868,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Erbsen','de-DE'),(3869,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Farnspitzen','de-DE'),(3870,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Fenchelknollen','de-DE'),(3871,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Gemüsemischungen','de-DE'),(3872,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Gobo-Wurzel','de-DE'),(3873,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Gurken','de-DE'),(3874,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Ingwer','de-DE'),(3875,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Kaktusblätter','de-DE'),(3876,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Kartoffeln','de-DE'),(3877,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Knoblauch','de-DE'),(3878,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Kohl','de-DE'),(3879,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Kohlrabi','de-DE'),(3880,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Kürbisse','de-DE'),(3881,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Lotoswurzel','de-DE'),(3882,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Mais','de-DE'),(3883,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Maniok','de-DE'),(3884,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Möhren','de-DE'),(3885,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Okra','de-DE'),(3886,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Paprikaschoten','de-DE'),(3887,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Pastinaken','de-DE'),(3888,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Petersilienwurzeln','de-DE'),(3889,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Pilze','de-DE'),(3890,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Porree','de-DE'),(3891,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Radieschen','de-DE'),(3892,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Rettich','de-DE'),(3893,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Rhabarber','de-DE'),(3894,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Rosenkohl','de-DE'),(3895,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Rutenkohl','de-DE'),(3896,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Rüben','de-DE'),(3897,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Schalotten','de-DE'),(3898,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Sellerie','de-DE'),(3899,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Sellerieknollen','de-DE'),(3900,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Spanische Artischocken','de-DE'),(3901,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Spargel','de-DE'),(3902,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Sprossen','de-DE'),(3903,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Steckrüben & Kohlrüben','de-DE'),(3904,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Süßkartoffeln','de-DE'),(3905,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Tamarillos','de-DE'),(3906,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Tannias','de-DE'),(3907,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Tarowurzeln','de-DE'),(3908,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Tomaten','de-DE'),(3909,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Topinambur','de-DE'),(3910,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Wasserkastanien','de-DE'),(3911,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Wasserkresse','de-DE'),(3912,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Weizengras','de-DE'),(3913,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Yambohnen','de-DE'),(3914,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Yams','de-DE'),(3915,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Zuckerrohr','de-DE'),(3916,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Gemüse > Zwiebeln','de-DE'),(3917,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst','de-DE'),(3918,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Ananas','de-DE'),(3919,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Atemoyas','de-DE'),(3920,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Avocados','de-DE'),(3921,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Bananen','de-DE'),(3922,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Beeren','de-DE'),(3923,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Berg-Papayas','de-DE'),(3924,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Birnen','de-DE'),(3925,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Brasilianische Guaven','de-DE'),(3926,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Breiäpfel','de-DE'),(3927,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Brotfrucht','de-DE'),(3928,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Cherimoyas','de-DE'),(3929,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Datteln','de-DE'),(3930,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Feigen','de-DE'),(3931,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Granatäpfel','de-DE'),(3932,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Große Sapoten','de-DE'),(3933,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Guaven','de-DE'),(3934,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Homli-Früchte','de-DE'),(3935,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Kaktusfeigen','de-DE'),(3936,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Kiwis','de-DE'),(3937,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Kokosnüsse','de-DE'),(3938,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Longan','de-DE'),(3939,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Loquats','de-DE'),(3940,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Lychees','de-DE'),(3941,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Madrono-Früchte','de-DE'),(3942,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Mangostanfrüchte','de-DE'),(3943,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Melonen','de-DE'),(3944,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Obstmischungen','de-DE'),(3945,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Papayas','de-DE'),(3946,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Passionsfrüchte','de-DE'),(3947,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Persimonen','de-DE'),(3948,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Physalis','de-DE'),(3949,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Pitahayas','de-DE'),(3950,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Quitten','de-DE'),(3951,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Rambutans','de-DE'),(3952,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Sapoten','de-DE'),(3953,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Stachelannonen','de-DE'),(3954,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte','de-DE'),(3955,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Aprikosen','de-DE'),(3956,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Kirschen','de-DE'),(3957,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Mangos','de-DE'),(3958,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Pfirsiche & Nektarinen','de-DE'),(3959,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Pflaumen','de-DE'),(3960,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Steinfrüchte > Plumcots','de-DE'),(3961,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Sternfrüchte','de-DE'),(3962,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Tamarinden','de-DE'),(3963,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Trauben','de-DE'),(3964,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zimtäpfel','de-DE'),(3965,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte','de-DE'),(3966,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Grapefruits','de-DE'),(3967,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Kumquats','de-DE'),(3968,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Limequats','de-DE'),(3969,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Limetten','de-DE'),(3970,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Orangen','de-DE'),(3971,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Tangelos','de-DE'),(3972,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Zitrusfrüchte > Zitronen','de-DE'),(3973,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Frisches & Tiefgefrorenes Obst > Äpfel','de-DE'),(3974,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Fruchtsoßen','de-DE'),(3975,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Gemüsekonserven','de-DE'),(3976,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Getrocknete Bohnen','de-DE'),(3977,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Getrocknete Früchte','de-DE'),(3978,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Obstkonserven','de-DE'),(3979,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Obst & Gemüse > Trockengemüse','de-DE'),(3980,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Pasta & Nudeln','de-DE'),(3981,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Schokofrüchte','de-DE'),(3982,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Suppen & Brühen','de-DE'),(3983,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Süßigkeiten & Schokolade','de-DE'),(3984,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tiefkühl-Desserts & -Neuheiten','de-DE'),(3985,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tiefkühl-Desserts & -Neuheiten > Eissnacks','de-DE'),(3986,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tiefkühl-Desserts & -Neuheiten > Speiseeis und gefrorener Joghurt','de-DE'),(3987,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tiefkühl-Desserts & -Neuheiten > Stieleis','de-DE'),(3988,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte','de-DE'),(3989,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte > Fleischalternativen','de-DE'),(3990,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte > Käsealternativen','de-DE'),(3991,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte > Seitan','de-DE'),(3992,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte > Tempeh','de-DE'),(3993,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Tofu- & Soja-Produkte > Tofu','de-DE'),(3994,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks','de-DE'),(3995,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Brezeln','de-DE'),(3996,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Chips','de-DE'),(3997,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Croûtons','de-DE'),(3998,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Dessertküchlein','de-DE'),(3999,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Fruchtsnacks','de-DE'),(4000,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Getreide- & Müsliriegel','de-DE'),(4001,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Grissini','de-DE'),(4002,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Kräcker','de-DE'),(4003,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Käse-Flips','de-DE'),(4004,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Popcorn','de-DE'),(4005,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Pudding & Gelatine-Snacks','de-DE'),(4006,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Reiskuchen','de-DE'),(4007,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Reiswaffeln','de-DE'),(4008,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Salatgarnituren','de-DE'),(4009,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Schweineschwarten','de-DE'),(4010,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Sesamsticks','de-DE'),(4011,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Studentenfutter','de-DE'),(4012,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Vorspeisen & Snacks > Trockenfleisch','de-DE'),(4013,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzen & Verfeinern','de-DE'),(4014,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzen & Verfeinern > Kräuter & Gewürze','de-DE'),(4015,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzen & Verfeinern > Mononatriumglutamat','de-DE'),(4016,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzen & Verfeinern > Pfeffer','de-DE'),(4017,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzen & Verfeinern > Salz','de-DE'),(4018,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen','de-DE'),(4019,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Bratensoße','de-DE'),(4020,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Chilisauce','de-DE'),(4021,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Cocktailsaucen','de-DE'),(4022,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Currysauce','de-DE'),(4023,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Dessertsaucen','de-DE'),(4024,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Dessertsaucen > Eissaucen','de-DE'),(4025,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Dessertsaucen > Fruchttopping','de-DE'),(4026,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Eingelegtes Obst und Gemüse','de-DE'),(4027,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Fischsauce','de-DE'),(4028,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Honig','de-DE'),(4029,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Ketchup','de-DE'),(4030,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Marinaden und Grillsoßen','de-DE'),(4031,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Mayonnaise','de-DE'),(4032,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Meerrettichsaucen','de-DE'),(4033,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Oliven & Kapern','de-DE'),(4034,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Pastasoßen','de-DE'),(4035,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Pizzasoße','de-DE'),(4036,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Salatdressing','de-DE'),(4037,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Sataysauce','de-DE'),(4038,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Sauce tartare','de-DE'),(4039,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Senf','de-DE'),(4040,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Sirup','de-DE'),(4041,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Sojasauce','de-DE'),(4042,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Süßsaure Soßen','de-DE'),(4043,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Tahini','de-DE'),(4044,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Weiße Soßen und Rahmsoßen','de-DE'),(4045,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Worcestershiresauce','de-DE'),(4046,'Nahrungsmittel, Getränke & Tabak > Lebensmittel > Würzmittel & Saucen > Würzsoße und Chutney','de-DE'),(4047,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte','de-DE'),(4048,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Kautabak','de-DE'),(4049,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Pfeifen','de-DE'),(4050,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Tabak','de-DE'),(4051,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Vaporizer & Rauchlose Zigaretten','de-DE'),(4052,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Zigaretten','de-DE'),(4053,'Nahrungsmittel, Getränke & Tabak > Tabakprodukte > Zigarren','de-DE'),(4054,'Religion & Feierlichkeiten','de-DE'),(4055,'Religion & Feierlichkeiten > Artikel für Gedenkzeremonien','de-DE'),(4056,'Religion & Feierlichkeiten > Artikel für Gedenkzeremonien > Urnen','de-DE'),(4057,'Religion & Feierlichkeiten > Artikel für Hochzeitszeremonien','de-DE'),(4058,'Religion & Feierlichkeiten > Artikel für Hochzeitszeremonien > Hochzeitsläufer','de-DE'),(4059,'Religion & Feierlichkeiten > Artikel für Hochzeitszeremonien > Körbe für Blumenmädchen','de-DE'),(4060,'Religion & Feierlichkeiten > Artikel für Hochzeitszeremonien > Ringkissen','de-DE'),(4061,'Religion & Feierlichkeiten > Religiöse Artikel','de-DE'),(4062,'Religion & Feierlichkeiten > Religiöse Artikel > Altare','de-DE'),(4063,'Religion & Feierlichkeiten > Religiöse Artikel > Gebetskarten','de-DE'),(4064,'Religion & Feierlichkeiten > Religiöse Artikel > Gebetsketten','de-DE'),(4065,'Religion & Feierlichkeiten > Religiöse Artikel > Religiöse Schleier','de-DE'),(4066,'Religion & Feierlichkeiten > Religiöse Artikel > Tarotkarten','de-DE'),(4067,'Software','de-DE'),(4068,'Software > Computersoftware','de-DE'),(4069,'Software > Computersoftware > Antiviren- & Sicherheitssoftware','de-DE'),(4070,'Software > Computersoftware > Betriebssysteme','de-DE'),(4071,'Software > Computersoftware > Büroanwendungssoftware','de-DE'),(4072,'Software > Computersoftware > Compiler & Programmierungstools','de-DE'),(4073,'Software > Computersoftware > Computerdienstprogramme & -wartung','de-DE'),(4074,'Software > Computersoftware > GPS-Karten & -Software','de-DE'),(4075,'Software > Computersoftware > Handheld- & PDA-Software','de-DE'),(4076,'Software > Computersoftware > Lernsoftware','de-DE'),(4077,'Software > Computersoftware > Netzwerksoftware','de-DE'),(4078,'Software > Computersoftware > Software für Multimedia & Design','de-DE'),(4079,'Software > Computersoftware > Software für Multimedia & Design > Animationsbearbeitungssoftware','de-DE'),(4080,'Software > Computersoftware > Software für Multimedia & Design > Graphic-Design-Software','de-DE'),(4081,'Software > Computersoftware > Software für Multimedia & Design > Home-Publishing-Software','de-DE'),(4082,'Software > Computersoftware > Software für Multimedia & Design > Software für Musikkomposition','de-DE'),(4083,'Software > Computersoftware > Software für Multimedia & Design > Software zur Erstellung von 3D-Modellen','de-DE'),(4084,'Software > Computersoftware > Software für Multimedia & Design > Software zur Innenraumgestaltung','de-DE'),(4085,'Software > Computersoftware > Software für Multimedia & Design > Software zur Medienwiedergabe','de-DE'),(4086,'Software > Computersoftware > Software für Multimedia & Design > Tonbearbeitungssoftware','de-DE'),(4087,'Software > Computersoftware > Software für Multimedia & Design > Videobearbeitungssoftware','de-DE'),(4088,'Software > Computersoftware > Software für Multimedia & Design > Web-Design-Software','de-DE'),(4089,'Software > Computersoftware > Steuer- & Buchhaltungssoftware','de-DE'),(4090,'Software > Computersoftware > Unternehmens- & Produktivitätssoftware','de-DE'),(4091,'Software > Computersoftware > Wiederherstellungsdatenträger','de-DE'),(4092,'Software > Computersoftware > Wörterbuch- & Übersetzungssoftware','de-DE'),(4093,'Software > Digital-Content-Software','de-DE'),(4094,'Software > Digital-Content-Software > Computer-Icons','de-DE'),(4095,'Software > Digital-Content-Software > Desktop-Hintergrundbilder','de-DE'),(4096,'Software > Digital-Content-Software > Digitales Bildmaterial','de-DE'),(4097,'Software > Digital-Content-Software > Dokumentvorlagen','de-DE'),(4098,'Software > Digital-Content-Software > Fonts','de-DE'),(4099,'Software > Digital-Content-Software > Stock-Fotografie & Videoclips','de-DE'),(4100,'Software > Digital-Content-Software > Virtuelles Geld','de-DE'),(4101,'Software > PC- & Videospiele','de-DE'),(4102,'Spielzeuge & Spiele','de-DE'),(4103,'Spielzeuge & Spiele > Puzzles & Geduldspiele','de-DE'),(4104,'Spielzeuge & Spiele > Puzzles & Geduldspiele > Holzsteckpuzzle','de-DE'),(4105,'Spielzeuge & Spiele > Puzzles & Geduldspiele > Mechanische Geduldspiele','de-DE'),(4106,'Spielzeuge & Spiele > Puzzles & Geduldspiele > Puzzle-Zubehör','de-DE'),(4107,'Spielzeuge & Spiele > Puzzles & Geduldspiele > Puzzles','de-DE'),(4108,'Spielzeuge & Spiele > Spiel-Timer','de-DE'),(4109,'Spielzeuge & Spiele > Spiele','de-DE'),(4110,'Spielzeuge & Spiele > Spiele > Battle Tops','de-DE'),(4111,'Spielzeuge & Spiele > Spiele > Bingo-Spiele','de-DE'),(4112,'Spielzeuge & Spiele > Spiele > Blackjack- & Würfelspiel-Sets','de-DE'),(4113,'Spielzeuge & Spiele > Spiele > Brettspiele','de-DE'),(4114,'Spielzeuge & Spiele > Spiele > Geschicklichkeitsspiele','de-DE'),(4115,'Spielzeuge & Spiele > Spiele > Glücksspielautomaten','de-DE'),(4116,'Spielzeuge & Spiele > Spiele > Kampfkreiselzubehör','de-DE'),(4117,'Spielzeuge & Spiele > Spiele > Kartenspiele','de-DE'),(4118,'Spielzeuge & Spiele > Spiele > Kartenspielzubehör','de-DE'),(4119,'Spielzeuge & Spiele > Spiele > Legespiele','de-DE'),(4120,'Spielzeuge & Spiele > Spiele > Pokerchip-Zubehör','de-DE'),(4121,'Spielzeuge & Spiele > Spiele > Pokerchip-Zubehör > Behälter für Pokerchips','de-DE'),(4122,'Spielzeuge & Spiele > Spiele > Pokerchips & -sets','de-DE'),(4123,'Spielzeuge & Spiele > Spiele > Rouletteräder & -zubehör','de-DE'),(4124,'Spielzeuge & Spiele > Spiele > Tragbare elektronische Spiele','de-DE'),(4125,'Spielzeuge & Spiele > Spiele > Würfelsets & -spiele','de-DE'),(4126,'Spielzeuge & Spiele > Spielzeug für draußen','de-DE'),(4127,'Spielzeuge & Spiele > Spielzeug für draußen > Hüpfburg-Zubehör','de-DE'),(4128,'Spielzeuge & Spiele > Spielzeug für draußen > Hüpfburgen','de-DE'),(4129,'Spielzeuge & Spiele > Spielzeug für draußen > Rutschen','de-DE'),(4130,'Spielzeuge & Spiele > Spielzeug für draußen > Sandkästen','de-DE'),(4131,'Spielzeuge & Spiele > Spielzeug für draußen > Schaukeln','de-DE'),(4132,'Spielzeuge & Spiele > Spielzeug für draußen > Schaukeln & Spielplatzgeräte','de-DE'),(4133,'Spielzeuge & Spiele > Spielzeug für draußen > Spielhäuser','de-DE'),(4134,'Spielzeuge & Spiele > Spielzeug für draußen > Spielzelte & -tunnel','de-DE'),(4135,'Spielzeuge & Spiele > Spielzeug für draußen > Springstöcke','de-DE'),(4136,'Spielzeuge & Spiele > Spielzeug für draußen > Stelzen','de-DE'),(4137,'Spielzeuge & Spiele > Spielzeug für draußen > Trampoline','de-DE'),(4138,'Spielzeuge & Spiele > Spielzeug für draußen > Trampolinzubehör','de-DE'),(4139,'Spielzeuge & Spiele > Spielzeug für draußen > Wasserspielgeräte','de-DE'),(4140,'Spielzeuge & Spiele > Spielzeug für draußen > Wasserspielgeräte > Planschbecken und Wasserrutschen','de-DE'),(4141,'Spielzeuge & Spiele > Spielzeug für draußen > Wasserspielgeräte > Wassersprenger für Kinder','de-DE'),(4142,'Spielzeuge & Spiele > Spielzeug für draußen > Wasserspielgeräte > Wassertische','de-DE'),(4143,'Spielzeuge & Spiele > Spielzeug für draußen > Wippen','de-DE'),(4144,'Spielzeuge & Spiele > Spielzeug für draußen > Zubehör für Schaukeln & Spielplatzgeräte','de-DE'),(4145,'Spielzeuge & Spiele > Spielzeuge','de-DE'),(4146,'Spielzeuge & Spiele > Spielzeuge > Aufziehspielzeug','de-DE'),(4147,'Spielzeuge & Spiele > Spielzeuge > Bad-Spielzeug','de-DE'),(4148,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug','de-DE'),(4149,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug > Baukästen','de-DE'),(4150,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug > Holzbausteine','de-DE'),(4151,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug > Murmelbahnen','de-DE'),(4152,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug > Schaumstoffbausteine','de-DE'),(4153,'Spielzeuge & Spiele > Spielzeuge > Bausteine & Bauspielzeug > Steckbausteine','de-DE'),(4154,'Spielzeuge & Spiele > Spielzeuge > Bällebad-Zubehör','de-DE'),(4155,'Spielzeuge & Spiele > Spielzeuge > Bällebad-Zubehör > Bälle für Bällebad','de-DE'),(4156,'Spielzeuge & Spiele > Spielzeuge > Bällebäder','de-DE'),(4157,'Spielzeuge & Spiele > Spielzeuge > Bürospielzeug','de-DE'),(4158,'Spielzeuge & Spiele > Spielzeuge > Bürospielzeug > Magnetspielzeug','de-DE'),(4159,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug','de-DE'),(4160,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug > Elektrische Kinderfahrzeuge','de-DE'),(4161,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug > Hand- & Bollerwagen','de-DE'),(4162,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug > Schiebe- & Pedalfahrzeuge','de-DE'),(4163,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug > Steckenpferde','de-DE'),(4164,'Spielzeuge & Spiele > Spielzeuge > Fahr, Wipp- & Schaukelspielzeug > Wipp- & Schaukelspielzeug','de-DE'),(4165,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug','de-DE'),(4166,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Autos','de-DE'),(4167,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Boote','de-DE'),(4168,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Flugzeuge','de-DE'),(4169,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Hubschrauber','de-DE'),(4170,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Motorräder','de-DE'),(4171,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Panzer','de-DE'),(4172,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Roboter','de-DE'),(4173,'Spielzeuge & Spiele > Spielzeuge > Ferngesteuertes Spielzeug > Ferngesteuerte Zeppeline','de-DE'),(4174,'Spielzeuge & Spiele > Spielzeuge > Fliegendes Spielzeug','de-DE'),(4175,'Spielzeuge & Spiele > Spielzeuge > Fliegendes Spielzeug > Drachen','de-DE'),(4176,'Spielzeuge & Spiele > Spielzeuge > Fliegendes Spielzeug > Luft- & Wasserraketen','de-DE'),(4177,'Spielzeuge & Spiele > Spielzeuge > Fliegendes Spielzeug > Spielzeug-Fallschirme','de-DE'),(4178,'Spielzeuge & Spiele > Spielzeuge > Fliegendes Spielzeug > Spielzeug-Segelflugzeuge','de-DE'),(4179,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug','de-DE'),(4180,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Ball- & Becherspiele','de-DE'),(4181,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Flummis','de-DE'),(4182,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Hampelmänner','de-DE'),(4183,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Jo-Jos','de-DE'),(4184,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Kreisel','de-DE'),(4185,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Murmeln','de-DE'),(4186,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Paddleball-Spiele','de-DE'),(4187,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Seifenblasen','de-DE'),(4188,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Seifenblasen-Spielzeug','de-DE'),(4189,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Spiele mit Bändern','de-DE'),(4190,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Springspirale','de-DE'),(4191,'Spielzeuge & Spiele > Spielzeuge > Interaktives Spielzeug > Teile und Zubehör für Jo-Jos','de-DE'),(4192,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele','de-DE'),(4193,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Berufespielzeug & Rollenspiele','de-DE'),(4194,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Einkaufsladen','de-DE'),(4195,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Elektronisches Rollenspielzeug','de-DE'),(4196,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Gartengeräte für Kinder','de-DE'),(4197,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Haushaltsspielzeug','de-DE'),(4198,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Spielgeld & Banken','de-DE'),(4199,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Spielwerkzeug','de-DE'),(4200,'Spielzeuge & Spiele > Spielzeuge > Kinder-Rollenspiele > Spielzeugküchen & Spielzeuglebensmittel','de-DE'),(4201,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug','de-DE'),(4202,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Ameisenfarmen','de-DE'),(4203,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Astronomisches Spielzeug und astronomische Modelle','de-DE'),(4204,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Insektensammlung','de-DE'),(4205,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Lernkarten','de-DE'),(4206,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Lesespiele','de-DE'),(4207,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Schieberechner','de-DE'),(4208,'Spielzeuge & Spiele > Spielzeuge > Lernspielzeug > Wissenschaftssets','de-DE'),(4209,'Spielzeuge & Spiele > Spielzeuge > Musikspielzeuge','de-DE'),(4210,'Spielzeuge & Spiele > Spielzeuge > Musikspielzeuge > Spielzeuginstrumente','de-DE'),(4211,'Spielzeuge & Spiele > Spielzeuge > Optische Spielzeuge','de-DE'),(4212,'Spielzeuge & Spiele > Spielzeuge > Optische Spielzeuge > Kaleidoskope','de-DE'),(4213,'Spielzeuge & Spiele > Spielzeuge > Optische Spielzeuge > Prismen','de-DE'),(4214,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren','de-DE'),(4215,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Action- & Spielzeugfiguren','de-DE'),(4216,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Marionetten','de-DE'),(4217,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Papier- & Magnetpuppen','de-DE'),(4218,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Puppen','de-DE'),(4219,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Puppenhaus-Zubehör','de-DE'),(4220,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Puppenhäuser','de-DE'),(4221,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Puppentheater','de-DE'),(4222,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Spielzeugsets','de-DE'),(4223,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Stofftiere','de-DE'),(4224,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Wackelfiguren','de-DE'),(4225,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Zubehör für Puppen & Actionfiguren','de-DE'),(4226,'Spielzeuge & Spiele > Spielzeuge > Puppen, Spielkombinationen & Spielzeugfiguren > Zubehör für Puppen & Puppentheater','de-DE'),(4227,'Spielzeuge & Spiele > Spielzeuge > Roboter','de-DE'),(4228,'Spielzeuge & Spiele > Spielzeuge > Spielfahrzeug-Zubehör','de-DE'),(4229,'Spielzeuge & Spiele > Spielzeuge > Spielzeug-Geschenkkörbe','de-DE'),(4230,'Spielzeuge & Spiele > Spielzeuge > Spielzeuge zum Malen & Zeichnen','de-DE'),(4231,'Spielzeuge & Spiele > Spielzeuge > Spielzeuge zum Malen & Zeichnen > Spielteig & Knetmasse','de-DE'),(4232,'Spielzeuge & Spiele > Spielzeuge > Spielzeuge zum Malen & Zeichnen > Zeichentafeln','de-DE'),(4233,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge','de-DE'),(4234,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Rennbahnen','de-DE'),(4235,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeug-LKWs & -Baumaschinen','de-DE'),(4236,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeugautos','de-DE'),(4237,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeugboote','de-DE'),(4238,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeugflugzeuge','de-DE'),(4239,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeughubschrauber','de-DE'),(4240,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeugmotorräder','de-DE'),(4241,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Spielzeugraumschiffe','de-DE'),(4242,'Spielzeuge & Spiele > Spielzeuge > Spielzeugfahrzeuge > Züge & Eisenbahnsets','de-DE'),(4243,'Spielzeuge & Spiele > Spielzeuge > Spielzeugwaffen','de-DE'),(4244,'Spielzeuge & Spiele > Spielzeuge > Spielzeugwaffenzubehör','de-DE'),(4245,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeug-Zubehör','de-DE'),(4246,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeug-Zubehör > Fitnessspielzeug-Zubehör','de-DE'),(4247,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeug-Zubehör > Fitnessspielzeug-Zubehör > Hula-Hoop-Zubehör','de-DE'),(4248,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge','de-DE'),(4249,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Angelspielzeug','de-DE'),(4250,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Baseball für Kinder','de-DE'),(4251,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Basketball für Kinder','de-DE'),(4252,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Bowling für Kinder','de-DE'),(4253,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Bumerangs','de-DE'),(4254,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Fingerboards & Fingerboard-Sets','de-DE'),(4255,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Fitness-Spielzeug','de-DE'),(4256,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Fitness-Spielzeug > Hula-Hoop-Reifen','de-DE'),(4257,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Footbags','de-DE'),(4258,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Frisbees','de-DE'),(4259,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Fußball für Kinder','de-DE'),(4260,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Golf für Kinder','de-DE'),(4261,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Hockey für Kinder','de-DE'),(4262,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Kinderspielbälle','de-DE'),(4263,'Spielzeuge & Spiele > Spielzeuge > Sportspielzeuge > Spielzeugschläger','de-DE'),(4264,'Spielzeuge & Spiele > Spielzeuge > Strand- & Sandspielzeug','de-DE'),(4265,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Flugspielzeug','de-DE'),(4266,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Flugspielzeug > Zubehör für Drachen','de-DE'),(4267,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Flugspielzeug > Zubehör für Drachen > Wickelspulen für Drachen','de-DE'),(4268,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Spielzeugfahrzeuge','de-DE'),(4269,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Spielzeugfahrzeuge > Autorennbahn-Zubehör','de-DE'),(4270,'Spielzeuge & Spiele > Spielzeuge > Zubehör für Spielzeugfahrzeuge > Zubehör für Spielzeugeisenbahn','de-DE'),(4271,'Spielzeuge & Spiele > Spielzeuge > Zubehör für ferngesteuerte Fahrzeuge','de-DE'),(4272,'Sportartikel','de-DE'),(4273,'Sportartikel > Athletik','de-DE'),(4274,'Sportartikel > Athletik > Allgemeine Sportartikel','de-DE'),(4275,'Sportartikel > Athletik > Allgemeine Sportartikel > Ablagen & Transportwagen für Gymnastikmatten','de-DE'),(4276,'Sportartikel > Athletik > Allgemeine Sportartikel > Ballpumpen','de-DE'),(4277,'Sportartikel > Athletik > Allgemeine Sportartikel > Ballpumpenzubehör','de-DE'),(4278,'Sportartikel > Athletik > Allgemeine Sportartikel > Ballpumpenzubehör > Ballpumpenaufsätze','de-DE'),(4279,'Sportartikel > Athletik > Allgemeine Sportartikel > Balltaschen & -wagen','de-DE'),(4280,'Sportartikel > Athletik > Allgemeine Sportartikel > Chalk','de-DE'),(4281,'Sportartikel > Athletik > Allgemeine Sportartikel > Gymnastikmatten','de-DE'),(4282,'Sportartikel > Athletik > Allgemeine Sportartikel > Leitern & Hürden für Geschwindigkeits- & Koordinationstraining','de-DE'),(4283,'Sportartikel > Athletik > Allgemeine Sportartikel > Markierungshütchen','de-DE'),(4284,'Sportartikel > Athletik > Allgemeine Sportartikel > Masken für Höhentraining','de-DE'),(4285,'Sportartikel > Athletik > Allgemeine Sportartikel > Megaphone für Sportveranstaltungen','de-DE'),(4286,'Sportartikel > Athletik > Allgemeine Sportartikel > Sport-Mundschutz','de-DE'),(4287,'Sportartikel > Athletik > Allgemeine Sportartikel > Stadionsitze und Polster','de-DE'),(4288,'Sportartikel > Athletik > Allgemeine Sportartikel > Suspensorien für Athleten','de-DE'),(4289,'Sportartikel > Athletik > Allgemeine Sportartikel > Übungsnetze','de-DE'),(4290,'Sportartikel > Athletik > American Football','de-DE'),(4291,'Sportartikel > Athletik > American Football > American Football-Handschuhe','de-DE'),(4292,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung','de-DE'),(4293,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Girdle Shorts','de-DE'),(4294,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helme','de-DE'),(4295,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helmzubehör','de-DE'),(4296,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helmzubehör > American Football-Facemasks','de-DE'),(4297,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helmzubehör > American Football-Helmpolster','de-DE'),(4298,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helmzubehör > American Football-Helmvisiere','de-DE'),(4299,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Helmzubehör > American Football-Kinnriemen','de-DE'),(4300,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Nackenschutz','de-DE'),(4301,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > American Football-Schulterpads','de-DE'),(4302,'Sportartikel > Athletik > American Football > American Football-Schutzbekleidung > Schutz-Shirts und -Hemden','de-DE'),(4303,'Sportartikel > Athletik > American Football > American Football-Torstangen','de-DE'),(4304,'Sportartikel > Athletik > American Football > American Football-Trainingsausrüstung','de-DE'),(4305,'Sportartikel > Athletik > American Football > American Football-Trainingsausrüstung > Dummys & Schlitten','de-DE'),(4306,'Sportartikel > Athletik > American Football > Football-Bälle','de-DE'),(4307,'Sportartikel > Athletik > American Football > Kicking Tees & Halter für Fußbälle','de-DE'),(4308,'Sportartikel > Athletik > Baseball & Softball','de-DE'),(4309,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Bases','de-DE'),(4310,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schlaghandschuhe','de-DE'),(4311,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung','de-DE'),(4312,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung > Ausrüstung für Fänger','de-DE'),(4313,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung > Baseball- & Softball-Brustpanzer','de-DE'),(4314,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung > Baseball- & Softball-Knie- & Schienbeinschoner','de-DE'),(4315,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung > Baseball- & Softballhelme','de-DE'),(4316,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Schutzkleidung > Schutzhelme für Fänger','de-DE'),(4317,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Wurfhügel','de-DE'),(4318,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softball-Wurfmale','de-DE'),(4319,'Sportartikel > Athletik > Baseball & Softball > Baseball- & Softballhandschuhe','de-DE'),(4320,'Sportartikel > Athletik > Baseball & Softball > Baseball-Bälle','de-DE'),(4321,'Sportartikel > Athletik > Baseball & Softball > Baseballschläger','de-DE'),(4322,'Sportartikel > Athletik > Baseball & Softball > Softball-Bälle','de-DE'),(4323,'Sportartikel > Athletik > Baseball & Softball > Softballschläger','de-DE'),(4324,'Sportartikel > Athletik > Baseball & Softball > Wurfmaschinen','de-DE'),(4325,'Sportartikel > Athletik > Basketball','de-DE'),(4326,'Sportartikel > Athletik > Basketball > Basketball-Trainingshilfen','de-DE'),(4327,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör','de-DE'),(4328,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör > Basketball-Korbbretter','de-DE'),(4329,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör > Basketballnetze','de-DE'),(4330,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör > Basketballringe','de-DE'),(4331,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör > Basketballständer','de-DE'),(4332,'Sportartikel > Athletik > Basketball > Basketballkorbteile & -zubehör > Schutzverkleidung für Basketballkörbe','de-DE'),(4333,'Sportartikel > Athletik > Basketball > Basketballkörbe','de-DE'),(4334,'Sportartikel > Athletik > Basketball > Basketbälle','de-DE'),(4335,'Sportartikel > Athletik > Boxen & Kampfsport','de-DE'),(4336,'Sportartikel > Athletik > Boxen & Kampfsport > Boxringe','de-DE'),(4337,'Sportartikel > Athletik > Boxen & Kampfsport > Boxringelemente','de-DE'),(4338,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung','de-DE'),(4339,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Armschutz','de-DE'),(4340,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Boxhandschuhe','de-DE'),(4341,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Handbandagen','de-DE'),(4342,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Kopfschutz','de-DE'),(4343,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Körperschutz','de-DE'),(4344,'Sportartikel > Athletik > Boxen & Kampfsport > Boxschutzbekleidung > Schienbeinschoner','de-DE'),(4345,'Sportartikel > Athletik > Boxen & Kampfsport > Kampfsportgürtel','de-DE'),(4346,'Sportartikel > Athletik > Boxen & Kampfsport > Kampfsportwaffen','de-DE'),(4347,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport','de-DE'),(4348,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport > Box- & Trainingssackzubehör','de-DE'),(4349,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport > Box- & Trainingssäcke','de-DE'),(4350,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport > Boxpratzen','de-DE'),(4351,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport > Schlagpolster','de-DE'),(4352,'Sportartikel > Athletik > Boxen & Kampfsport > Trainingsausrüstung für Boxen & Kampfsport > Training-Dummys','de-DE'),(4353,'Sportartikel > Athletik > Broomball-Ausrüstung','de-DE'),(4354,'Sportartikel > Athletik > Cheerleading','de-DE'),(4355,'Sportartikel > Athletik > Cheerleading > Cheerleader-Pompons','de-DE'),(4356,'Sportartikel > Athletik > Cricket','de-DE'),(4357,'Sportartikel > Athletik > Cricket > Cricket-Aussrüstungssets','de-DE'),(4358,'Sportartikel > Athletik > Cricket > Cricket-Schutzkleidung','de-DE'),(4359,'Sportartikel > Athletik > Cricket > Cricket-Schutzkleidung > Cricket-Beinschutz','de-DE'),(4360,'Sportartikel > Athletik > Cricket > Cricket-Schutzkleidung > Crickethandschuhe','de-DE'),(4361,'Sportartikel > Athletik > Cricket > Cricket-Schutzkleidung > Crickethelme','de-DE'),(4362,'Sportartikel > Athletik > Cricket > Cricketbälle','de-DE'),(4363,'Sportartikel > Athletik > Cricket > Cricketschläger','de-DE'),(4364,'Sportartikel > Athletik > Cricket > Cricketschläger-Zubehör','de-DE'),(4365,'Sportartikel > Athletik > Cricket > Cricketschläger-Zubehör > Cricketschläger-Griffe','de-DE'),(4366,'Sportartikel > Athletik > Cricket > Cricketstäbe','de-DE'),(4367,'Sportartikel > Athletik > Eiskunstlauf & Hockey','de-DE'),(4368,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung','de-DE'),(4369,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Ausrüstungssets für Torwarte','de-DE'),(4370,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Eishockeyhosenträger und -gürtel','de-DE'),(4371,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockey-Ellenbogenschutz','de-DE'),(4372,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockey-Schienbeinschoner & -Beinschutz','de-DE'),(4373,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockey-Schulterpolster & -Brustpolster','de-DE'),(4374,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockeyhandschuhe','de-DE'),(4375,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockeyhelme','de-DE'),(4376,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockey-Schutzausrüstung > Hockeyhosen','de-DE'),(4377,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeybälle & Pucks','de-DE'),(4378,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschlitten','de-DE'),(4379,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschläger','de-DE'),(4380,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschlägerpflege','de-DE'),(4381,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschlägerteile','de-DE'),(4382,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschlägerteile > Hockey-Schlägerschäfte','de-DE'),(4383,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeyschlägerteile > Hockeyschlägerkellen','de-DE'),(4384,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Hockeytore','de-DE'),(4385,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhe','de-DE'),(4386,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör','de-DE'),(4387,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör > Eiskunstlaufstiefel','de-DE'),(4388,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör > Kufenschoner','de-DE'),(4389,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör > Schlittschuhkufen','de-DE'),(4390,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör > Schlittschuhschleifer','de-DE'),(4391,'Sportartikel > Athletik > Eiskunstlauf & Hockey > Schlittschuhzubehör > Schnürhilfen','de-DE'),(4392,'Sportartikel > Athletik > Fechten','de-DE'),(4393,'Sportartikel > Athletik > Fechten > Fechtschutzbekleidung','de-DE'),(4394,'Sportartikel > Athletik > Fechten > Fechtschutzbekleidung > Fechthandschuhe','de-DE'),(4395,'Sportartikel > Athletik > Fechten > Fechtschutzbekleidung > Fechtjacken & -E-Westen','de-DE'),(4396,'Sportartikel > Athletik > Fechten > Fechtschutzbekleidung > Fechtmasken','de-DE'),(4397,'Sportartikel > Athletik > Fechten > Sportfechtwaffen','de-DE'),(4398,'Sportartikel > Athletik > Feldhockey & Lacrosse','de-DE'),(4399,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockey- & Lacrosse-Schutzkleidung','de-DE'),(4400,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockey- & Lacrosse-Schutzkleidung > Feldhockey- & Lacrosse-Handschuhe','de-DE'),(4401,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockey- & Lacrosse-Schutzkleidung > Feldhockey- & Lacrosse-Pads','de-DE'),(4402,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockey- & Lacrosse-Schutzkleidung > Hockey- & Lacrosse-Helme','de-DE'),(4403,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockey- & Lacrosse-Schutzkleidung > Masken & Schutzbrillen','de-DE'),(4404,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockeybälle','de-DE'),(4405,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockeyschläger','de-DE'),(4406,'Sportartikel > Athletik > Feldhockey & Lacrosse > Feldhockeytore','de-DE'),(4407,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Ausrüstungen','de-DE'),(4408,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Bälle','de-DE'),(4409,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Schläger','de-DE'),(4410,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Schlägerteile','de-DE'),(4411,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Schlägerteile > Lacrosse-Schlägerköpfe','de-DE'),(4412,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Schlägerteile > Lacrosse-Schlägernetze & Strings','de-DE'),(4413,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Schlägerteile > Lacrosse-Schlägerschäfte','de-DE'),(4414,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Tore','de-DE'),(4415,'Sportartikel > Athletik > Feldhockey & Lacrosse > Lacrosse-Trainingszubehör','de-DE'),(4416,'Sportartikel > Athletik > Fußball','de-DE'),(4417,'Sportartikel > Athletik > Fußball > Eckfahnen','de-DE'),(4418,'Sportartikel > Athletik > Fußball > Fußball-Schutzkleidung','de-DE'),(4419,'Sportartikel > Athletik > Fußball > Fußball-Schutzkleidung > Fußballschienbeinschützer','de-DE'),(4420,'Sportartikel > Athletik > Fußball > Fußballtore & -netze','de-DE'),(4421,'Sportartikel > Athletik > Fußball > Fußbälle','de-DE'),(4422,'Sportartikel > Athletik > Fußball > Torwarthandschuhe','de-DE'),(4423,'Sportartikel > Athletik > Fußball > Zubehör für Fußballtore','de-DE'),(4424,'Sportartikel > Athletik > Handball','de-DE'),(4425,'Sportartikel > Athletik > Handball > Handbälle','de-DE'),(4426,'Sportartikel > Athletik > Leichtathletik','de-DE'),(4427,'Sportartikel > Athletik > Leichtathletik > Diskusscheiben','de-DE'),(4428,'Sportartikel > Athletik > Leichtathletik > Hochsprunglatten','de-DE'),(4429,'Sportartikel > Athletik > Leichtathletik > Hochsprungmatten','de-DE'),(4430,'Sportartikel > Athletik > Leichtathletik > Hürden','de-DE'),(4431,'Sportartikel > Athletik > Leichtathletik > Kugelstoß-Kugeln','de-DE'),(4432,'Sportartikel > Athletik > Leichtathletik > Speere','de-DE'),(4433,'Sportartikel > Athletik > Leichtathletik > Stabhochsprungmatten','de-DE'),(4434,'Sportartikel > Athletik > Leichtathletik > Stabhochsprungstäbe','de-DE'),(4435,'Sportartikel > Athletik > Leichtathletik > Staffelstäbe','de-DE'),(4436,'Sportartikel > Athletik > Leichtathletik > Startblöcke','de-DE'),(4437,'Sportartikel > Athletik > Leichtathletik > Startpistolen','de-DE'),(4438,'Sportartikel > Athletik > Leichtathletik > Wurfhämmer','de-DE'),(4439,'Sportartikel > Athletik > Racquetball & Squash','de-DE'),(4440,'Sportartikel > Athletik > Racquetball & Squash > Racquetball- & Squash-Bälle','de-DE'),(4441,'Sportartikel > Athletik > Racquetball & Squash > Racquetball-Schläger','de-DE'),(4442,'Sportartikel > Athletik > Racquetball & Squash > Squash- & Racquetball-Handschuhe','de-DE'),(4443,'Sportartikel > Athletik > Racquetball & Squash > Squash- & Racquetball-Schutzbrillen','de-DE'),(4444,'Sportartikel > Athletik > Racquetball & Squash > Squashschläger','de-DE'),(4445,'Sportartikel > Athletik > Ringen','de-DE'),(4446,'Sportartikel > Athletik > Ringen > Schutzbekleidung für Ringer','de-DE'),(4447,'Sportartikel > Athletik > Ringen > Schutzbekleidung für Ringer > Ringer-Kniepolster','de-DE'),(4448,'Sportartikel > Athletik > Ringen > Schutzbekleidung für Ringer > Ringer-Kopfschutz','de-DE'),(4449,'Sportartikel > Athletik > Rounders','de-DE'),(4450,'Sportartikel > Athletik > Rounders > Rounders-Handschuhe','de-DE'),(4451,'Sportartikel > Athletik > Rounders > Rounders-Schläger','de-DE'),(4452,'Sportartikel > Athletik > Rugby','de-DE'),(4453,'Sportartikel > Athletik > Rugby > Rugby-Bälle','de-DE'),(4454,'Sportartikel > Athletik > Rugby > Rugby-Handschuhe','de-DE'),(4455,'Sportartikel > Athletik > Rugby > Rugby-Schutzkleidung','de-DE'),(4456,'Sportartikel > Athletik > Rugby > Rugby-Schutzkleidung > Rugby-Helme','de-DE'),(4457,'Sportartikel > Athletik > Rugby > Rugby-Tore','de-DE'),(4458,'Sportartikel > Athletik > Rugby > Rugby-Trainingsausrüstung','de-DE'),(4459,'Sportartikel > Athletik > Tanzen','de-DE'),(4460,'Sportartikel > Athletik > Tanzen > Ballettstangen','de-DE'),(4461,'Sportartikel > Athletik > Tennis','de-DE'),(4462,'Sportartikel > Athletik > Tennis > Tennisballdosen','de-DE'),(4463,'Sportartikel > Athletik > Tennis > Tennisballkörbe & -wagen','de-DE'),(4464,'Sportartikel > Athletik > Tennis > Tennisballwurfmaschinen','de-DE'),(4465,'Sportartikel > Athletik > Tennis > Tennisbälle','de-DE'),(4466,'Sportartikel > Athletik > Tennis > Tennisnetze','de-DE'),(4467,'Sportartikel > Athletik > Tennis > Tennisschläger','de-DE'),(4468,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör','de-DE'),(4469,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör > Griffbänder','de-DE'),(4470,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör > Schlägerdämpfer','de-DE'),(4471,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör > Tennissaiten','de-DE'),(4472,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör > Tennistaschen','de-DE'),(4473,'Sportartikel > Athletik > Tennis > Tennisschlägerzubehör > Ösenbänder für Tennisschläger','de-DE'),(4474,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung','de-DE'),(4475,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Anzeigetafeln','de-DE'),(4476,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Begrenzungsmarkierungen für Spielfelder','de-DE'),(4477,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Handzähler','de-DE'),(4478,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Kapitänsbinden','de-DE'),(4479,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Linienrichterfahnen','de-DE'),(4480,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Pitch Counter','de-DE'),(4481,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Schiedsrichter- & Trainerpfeifen','de-DE'),(4482,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Schiedsrichter-Münzen','de-DE'),(4483,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Schiedsrichtermappen','de-DE'),(4484,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Schiedsrichterstände & -stühle','de-DE'),(4485,'Sportartikel > Athletik > Trainer- & Schiedsrichterausrüstung > Strafkarten & -flaggen','de-DE'),(4486,'Sportartikel > Athletik > Turnen','de-DE'),(4487,'Sportartikel > Athletik > Turnen > Pauschenpferde','de-DE'),(4488,'Sportartikel > Athletik > Turnen > Schutzausrüstung','de-DE'),(4489,'Sportartikel > Athletik > Turnen > Schutzausrüstung > Turner-Handbandagen','de-DE'),(4490,'Sportartikel > Athletik > Turnen > Sprungpferde','de-DE'),(4491,'Sportartikel > Athletik > Turnen > Turnringe','de-DE'),(4492,'Sportartikel > Athletik > Turnen > Turnsprungbretter','de-DE'),(4493,'Sportartikel > Athletik > Turnen > Turnstangen & Schwebebalken','de-DE'),(4494,'Sportartikel > Athletik > Volleyball','de-DE'),(4495,'Sportartikel > Athletik > Volleyball > Volleyball-Schutzkleidung','de-DE'),(4496,'Sportartikel > Athletik > Volleyball > Volleyball-Schutzkleidung > Volleyball-Knieschoner','de-DE'),(4497,'Sportartikel > Athletik > Volleyball > Volleyball-Trainingshilfen','de-DE'),(4498,'Sportartikel > Athletik > Volleyball > Volleyballnetze','de-DE'),(4499,'Sportartikel > Athletik > Volleyball > Volleybälle','de-DE'),(4500,'Sportartikel > Athletik > Wallyball-Ausrüstung','de-DE'),(4501,'Sportartikel > Athletik > Wasserball','de-DE'),(4502,'Sportartikel > Athletik > Wasserball > Wasserballkappen','de-DE'),(4503,'Sportartikel > Athletik > Wasserball > Wasserballtore','de-DE'),(4504,'Sportartikel > Athletik > Wasserball > Wasserbälle','de-DE'),(4505,'Sportartikel > Fitness','de-DE'),(4506,'Sportartikel > Fitness > Balancetrainer','de-DE'),(4507,'Sportartikel > Fitness > Bauchtrainer','de-DE'),(4508,'Sportartikel > Fitness > Cardio','de-DE'),(4509,'Sportartikel > Fitness > Cardio > Cardiogeräte','de-DE'),(4510,'Sportartikel > Fitness > Cardio > Cardiogeräte > Crosstrainer','de-DE'),(4511,'Sportartikel > Fitness > Cardio > Cardiogeräte > Heimtrainer','de-DE'),(4512,'Sportartikel > Fitness > Cardio > Cardiogeräte > Laufbänder','de-DE'),(4513,'Sportartikel > Fitness > Cardio > Cardiogeräte > Rudergeräte','de-DE'),(4514,'Sportartikel > Fitness > Cardio > Cardiogeräte > Stepper','de-DE'),(4515,'Sportartikel > Fitness > Cardio > Springseile','de-DE'),(4516,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte','de-DE'),(4517,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte > Crosstrainer-Zubehör','de-DE'),(4518,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte > Heimtrainer-Zubehör','de-DE'),(4519,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte > Laufbandzubehör','de-DE'),(4520,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte > Rudergerät-Zubehör','de-DE'),(4521,'Sportartikel > Fitness > Cardio > Zubehör für Cardiogeräte > Stepper-Zubehör','de-DE'),(4522,'Sportartikel > Fitness > Fitnessbänder','de-DE'),(4523,'Sportartikel > Fitness > Fitnessgeräte-Sets','de-DE'),(4524,'Sportartikel > Fitness > Gewichtheben','de-DE'),(4525,'Sportartikel > Fitness > Gewichtheben > Gewichthebergürtel','de-DE'),(4526,'Sportartikel > Fitness > Gewichtheben > Gewichtheberhandschuhe & Handgelenkschoner','de-DE'),(4527,'Sportartikel > Fitness > Gewichtheben > Hanteln','de-DE'),(4528,'Sportartikel > Fitness > Gewichtheben > Hantelzubehör','de-DE'),(4529,'Sportartikel > Fitness > Gewichtheben > Hantelzubehör > Hantelstangen','de-DE'),(4530,'Sportartikel > Fitness > Gewichtheben > Hantelzubehör > Hantelstangen-Feststellringe','de-DE'),(4531,'Sportartikel > Fitness > Gewichtheben > Hantelzubehör > Hantelständer','de-DE'),(4532,'Sportartikel > Fitness > Gewichtheben > Krafttrainingsgeräte','de-DE'),(4533,'Sportartikel > Fitness > Gewichtheben > Zubehör für Krafttrainingsgeräte','de-DE'),(4534,'Sportartikel > Fitness > Gewichtswesten & -manschetten','de-DE'),(4535,'Sportartikel > Fitness > Gymnastikbälle','de-DE'),(4536,'Sportartikel > Fitness > Handtrainer','de-DE'),(4537,'Sportartikel > Fitness > Inversionstische','de-DE'),(4538,'Sportartikel > Fitness > Keilmatten','de-DE'),(4539,'Sportartikel > Fitness > Klimmzugstangen','de-DE'),(4540,'Sportartikel > Fitness > Matten für Heimtrainer','de-DE'),(4541,'Sportartikel > Fitness > Medizinbälle','de-DE'),(4542,'Sportartikel > Fitness > Power Tower','de-DE'),(4543,'Sportartikel > Fitness > Reaktionsbälle','de-DE'),(4544,'Sportartikel > Fitness > Schaumroller','de-DE'),(4545,'Sportartikel > Fitness > Schaumroller-Zubehör','de-DE'),(4546,'Sportartikel > Fitness > Schaumroller-Zubehör > Aufbewahrungstaschen für Schaumroller','de-DE'),(4547,'Sportartikel > Fitness > Sicherheitslichter & -reflektoren für Sport','de-DE'),(4548,'Sportartikel > Fitness > Steppbretter','de-DE'),(4549,'Sportartikel > Fitness > Stoppuhren','de-DE'),(4550,'Sportartikel > Fitness > Suspension Trainer','de-DE'),(4551,'Sportartikel > Fitness > Trainings- & Bremsschirme','de-DE'),(4552,'Sportartikel > Fitness > Trainingsbänke','de-DE'),(4553,'Sportartikel > Fitness > Vibrationstrainer','de-DE'),(4554,'Sportartikel > Fitness > Yoga & Pilates','de-DE'),(4555,'Sportartikel > Fitness > Yoga & Pilates > Beutel für Yogamatten','de-DE'),(4556,'Sportartikel > Fitness > Yoga & Pilates > Pilates-Geräte','de-DE'),(4557,'Sportartikel > Fitness > Yoga & Pilates > Yoga- & Pilatesblöcke','de-DE'),(4558,'Sportartikel > Fitness > Yoga & Pilates > Yoga- & Pilatesmatten','de-DE'),(4559,'Sportartikel > Fitness > Yoga & Pilates > Yoga- & Pilatestücher','de-DE'),(4560,'Sportartikel > Indoor - Aktivitäten','de-DE'),(4561,'Sportartikel > Indoor - Aktivitäten > Air-Hockey','de-DE'),(4562,'Sportartikel > Indoor - Aktivitäten > Air-Hockey > Air-Hockey-Ausrüstung','de-DE'),(4563,'Sportartikel > Indoor - Aktivitäten > Air-Hockey > Air-Hockey-Tische','de-DE'),(4564,'Sportartikel > Indoor - Aktivitäten > Air-Hockey > Air-Hockey-Tischzubehör','de-DE'),(4565,'Sportartikel > Indoor - Aktivitäten > Billard','de-DE'),(4566,'Sportartikel > Indoor - Aktivitäten > Billard > Billarddreiecke','de-DE'),(4567,'Sportartikel > Indoor - Aktivitäten > Billard > Billardhandschuhe','de-DE'),(4568,'Sportartikel > Indoor - Aktivitäten > Billard > Billardkugeln','de-DE'),(4569,'Sportartikel > Indoor - Aktivitäten > Billard > Billardqueues & Queuebrücken','de-DE'),(4570,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Beleuchtung','de-DE'),(4571,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Teile & Zubehör','de-DE'),(4572,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Teile & Zubehör > Ballfangtaschen','de-DE'),(4573,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Teile & Zubehör > Billardtisch-Bürsten','de-DE'),(4574,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Teile & Zubehör > Billardtücher','de-DE'),(4575,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtisch-Teile & Zubehör > Billiardtischabdeckungen','de-DE'),(4576,'Sportartikel > Indoor - Aktivitäten > Billard > Billardtische','de-DE'),(4577,'Sportartikel > Indoor - Aktivitäten > Billard > Queuezubehör','de-DE'),(4578,'Sportartikel > Indoor - Aktivitäten > Billard > Queuezubehör > Billiardkoffer','de-DE'),(4579,'Sportartikel > Indoor - Aktivitäten > Billard > Queuezubehör > Billiardkreide','de-DE'),(4580,'Sportartikel > Indoor - Aktivitäten > Billard > Queuezubehör > Queueständer','de-DE'),(4581,'Sportartikel > Indoor - Aktivitäten > Bowling','de-DE'),(4582,'Sportartikel > Indoor - Aktivitäten > Bowling > Bowling-Handgelenkstützen','de-DE'),(4583,'Sportartikel > Indoor - Aktivitäten > Bowling > Bowlinghandschuhe','de-DE'),(4584,'Sportartikel > Indoor - Aktivitäten > Bowling > Bowlingkegel','de-DE'),(4585,'Sportartikel > Indoor - Aktivitäten > Bowling > Bowlingkugeln','de-DE'),(4586,'Sportartikel > Indoor - Aktivitäten > Bowling > Bowlingtaschen','de-DE'),(4587,'Sportartikel > Indoor - Aktivitäten > Dartspiele','de-DE'),(4588,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dart-Rückwände','de-DE'),(4589,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartpfeile','de-DE'),(4590,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartscheiben','de-DE'),(4591,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartteile','de-DE'),(4592,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartteile > Dartflights','de-DE'),(4593,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartteile > Dartschäfte','de-DE'),(4594,'Sportartikel > Indoor - Aktivitäten > Dartspiele > Dartteile > Dartspitzen','de-DE'),(4595,'Sportartikel > Indoor - Aktivitäten > Jakkolo','de-DE'),(4596,'Sportartikel > Indoor - Aktivitäten > Jakkolo > Jakkolo-Pulver','de-DE'),(4597,'Sportartikel > Indoor - Aktivitäten > Jakkolo > Jakkolo-Spielsteine','de-DE'),(4598,'Sportartikel > Indoor - Aktivitäten > Jakkolo > Shuffleboard-Tische','de-DE'),(4599,'Sportartikel > Indoor - Aktivitäten > Multispieltische','de-DE'),(4600,'Sportartikel > Indoor - Aktivitäten > Tischfußball','de-DE'),(4601,'Sportartikel > Indoor - Aktivitäten > Tischfußball > Tischfußball-Bälle','de-DE'),(4602,'Sportartikel > Indoor - Aktivitäten > Tischfußball > Tischfußball-Tische','de-DE'),(4603,'Sportartikel > Indoor - Aktivitäten > Tischfußball > Zubehör für Tischfußballtische','de-DE'),(4604,'Sportartikel > Indoor - Aktivitäten > Tischtennis','de-DE'),(4605,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Tischtennis-Roboter','de-DE'),(4606,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Tischtennisbälle','de-DE'),(4607,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Tischtennisnetze und -pfosten','de-DE'),(4608,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Tischtennisplatten','de-DE'),(4609,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Tischtennisschläger & -sets','de-DE'),(4610,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Zubehör für Tischtennis-Roboter','de-DE'),(4611,'Sportartikel > Indoor - Aktivitäten > Tischtennis > Zubehör für Tischtennisschläger','de-DE'),(4612,'Sportartikel > Outdoor-Aktivitäten','de-DE'),(4613,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen','de-DE'),(4614,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte','de-DE'),(4615,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte > Angelblei','de-DE'),(4616,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte > Angelhaken','de-DE'),(4617,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte > Karabiner & Wirbel','de-DE'),(4618,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte > Kunstköder','de-DE'),(4619,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelgeräte > Schwimmer','de-DE'),(4620,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelkästen & Angeltaschen','de-DE'),(4621,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelleinen & -wirbel','de-DE'),(4622,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelrollen','de-DE'),(4623,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelrollen-Zubehör','de-DE'),(4624,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelrollen-Zubehör > Ersatzspulen','de-DE'),(4625,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelrollen-Zubehör > Schmierstoffe','de-DE'),(4626,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelrollen-Zubehör > Taschen & Behälter','de-DE'),(4627,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelruten','de-DE'),(4628,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelruten-Zubehör','de-DE'),(4629,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelruten-Zubehör > Angelrutenhalter und -ständer','de-DE'),(4630,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Angelruten-Zubehör > Taschen & Behälter für Angelruten','de-DE'),(4631,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Bissanzeiger','de-DE'),(4632,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Fallen für den Angelsport','de-DE'),(4633,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Fischernetze','de-DE'),(4634,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Gaffs','de-DE'),(4635,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Harpunen für den Angelsport','de-DE'),(4636,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Köderbefestigung','de-DE'),(4637,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Köderbefestigung > Angelschnur','de-DE'),(4638,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Köderbefestigung > Pop-Up-Kugeln','de-DE'),(4639,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Köderbehälter','de-DE'),(4640,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Lebendköder','de-DE'),(4641,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Wathosen für Angler & Jäger','de-DE'),(4642,'Sportartikel > Outdoor-Aktivitäten > Angeln & Fischen > Werkzeuge zum Entfernen des Angelhakens','de-DE'),(4643,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport','de-DE'),(4644,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Ablagen für Wasserfahrzeuge','de-DE'),(4645,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Ablagen für Wasserfahrzeuge > Halterungen für Boards','de-DE'),(4646,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Ablagen für Wasserfahrzeuge > Halterungen für Boote','de-DE'),(4647,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung','de-DE'),(4648,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Neoprenanzugteile','de-DE'),(4649,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Neoprenanzugteile > Kappen, Handschuhe & Stiefel für Neoprenanzüge','de-DE'),(4650,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Neoprenanzugteile > Neopren-Oberteile','de-DE'),(4651,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Neoprenanzugteile > Neopren-Unterteile','de-DE'),(4652,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Neoprenanzüge','de-DE'),(4653,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Rashguards & Schwimmshirts','de-DE'),(4654,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Rettungswesten','de-DE'),(4655,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Schwimmwestenzubehör','de-DE'),(4656,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Trockenanzüge','de-DE'),(4657,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Boots- & Wassersportkleidung > Wassersporthelme','de-DE'),(4658,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport','de-DE'),(4659,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Handschuhe für den Bootssport','de-DE'),(4660,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Kajaks','de-DE'),(4661,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Kajakzubehör','de-DE'),(4662,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Kanus','de-DE'),(4663,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Kanuzubehör','de-DE'),(4664,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Paddel & Ruder','de-DE'),(4665,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Paddelriemen','de-DE'),(4666,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Rafts','de-DE'),(4667,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Ruderboote','de-DE'),(4668,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Bootssport > Tretboote','de-DE'),(4669,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen','de-DE'),(4670,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen > Kiteboard-Taschen','de-DE'),(4671,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen > Kiteboards','de-DE'),(4672,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen > Kiteboardteile','de-DE'),(4673,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen > Kitesurfing-Kites','de-DE'),(4674,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Kitesurfen > Trapeze für Kite- & Windsurfen','de-DE'),(4675,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen','de-DE'),(4676,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Badekappen','de-DE'),(4677,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Gegenstromanlagen','de-DE'),(4678,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Handpaddel','de-DE'),(4679,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Nasenklammern','de-DE'),(4680,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Pull Buoys','de-DE'),(4681,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmbretter','de-DE'),(4682,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmbrillen & -masken','de-DE'),(4683,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmflossen','de-DE'),(4684,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmflossen > Monoflossen','de-DE'),(4685,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmflossen > Trainingsflossen','de-DE'),(4686,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmflügel','de-DE'),(4687,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmgewichte','de-DE'),(4688,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmgürtel','de-DE'),(4689,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Schwimmhandschuhe','de-DE'),(4690,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Schwimmen > Zubehör für Schwimmbrillen & -masken','de-DE'),(4691,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten','de-DE'),(4692,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Handschuhe für seilgebundene Wassersportarten','de-DE'),(4693,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Kneeboarding','de-DE'),(4694,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Kneeboarding > Kneeboards','de-DE'),(4695,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Tubes & Towables','de-DE'),(4696,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wakeboarding','de-DE'),(4697,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wakeboarding > Kiteboard- & Wakeboard-Bindungen','de-DE'),(4698,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wakeboarding > Wakeboard-Ersatzteile','de-DE'),(4699,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wakeboarding > Wakeboards','de-DE'),(4700,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wasserski','de-DE'),(4701,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wasserski > Hydrofoils','de-DE'),(4702,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wasserski > Wasserski-Bindungen','de-DE'),(4703,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wasserski > Wasserskier','de-DE'),(4704,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Wasserski > Wasserskikoffer & -taschen','de-DE'),(4705,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Seilgebundene Wassersportarten > Zugseile für Wassersport','de-DE'),(4706,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen','de-DE'),(4707,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Bodyboards','de-DE'),(4708,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Fußleinen für Surfbretter','de-DE'),(4709,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Handschuhe für Surfer','de-DE'),(4710,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Paddelboards','de-DE'),(4711,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Skimboards','de-DE'),(4712,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Surfboard-Taschen','de-DE'),(4713,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Surfboard-Wachs','de-DE'),(4714,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Surfbretter','de-DE'),(4715,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Surfbrettfinnen','de-DE'),(4716,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Surfen > Surfpads','de-DE'),(4717,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln','de-DE'),(4718,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Atemregler','de-DE'),(4719,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Bleigürtel','de-DE'),(4720,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Schnorchel','de-DE'),(4721,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tarierwesten','de-DE'),(4722,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tauch- & Schnorchelausrüstung','de-DE'),(4723,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tauch- & Schnorchelflossen','de-DE'),(4724,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tauch- & Schnorchelmasken','de-DE'),(4725,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tauchcomputer','de-DE'),(4726,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Tauchen & Schnorcheln > Tauchermesser & -scheren','de-DE'),(4727,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen','de-DE'),(4728,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen > Windsurfboard-Ausrüstung','de-DE'),(4729,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen > Windsurfboard-Ausrüstung > Windsurf-Finnen','de-DE'),(4730,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen > Windsurfboard-Ausrüstung > Windsurfmasten','de-DE'),(4731,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen > Windsurfbretter','de-DE'),(4732,'Sportartikel > Outdoor-Aktivitäten > Boot- & Wassersport > Windsurfen > Windsurfsegel','de-DE'),(4733,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern','de-DE'),(4734,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Camping-Töpfe & -Geschirr','de-DE'),(4735,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campinghilfsmittel','de-DE'),(4736,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campinghilfsmittel > Jagdmesser','de-DE'),(4737,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campinghilfsmittel > Multifunktionswerkzeuge & -messer','de-DE'),(4738,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campingleuchten & -laternen','de-DE'),(4739,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campingmöbel','de-DE'),(4740,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campingmöbel > Feldbetten','de-DE'),(4741,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campingmöbel > Luftbetten','de-DE'),(4742,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Campingmöbel > Zubehör für Luftmatratzen & Schlafunterlagen','de-DE'),(4743,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Innenschlafsack','de-DE'),(4744,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Isomatten','de-DE'),(4745,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Kompressionssäcke','de-DE'),(4746,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Mobile Toiletten & Duschen','de-DE'),(4747,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Mobile Toiletten & Duschen > Mobile Duschen & Sichtschutz','de-DE'),(4748,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Mobile Toiletten & Duschen > Mobile Toiletten & Urinale','de-DE'),(4749,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Moskitonetze & Fliegengitter','de-DE'),(4750,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Navigationskompasse','de-DE'),(4751,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Schlafsäcke','de-DE'),(4752,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Taschenwärmer','de-DE'),(4753,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Tragbare Wasserfilter & Wasserreiniger','de-DE'),(4754,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Trekkingstöcke','de-DE'),(4755,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Windschutz','de-DE'),(4756,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zelte','de-DE'),(4757,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zeltzubehör','de-DE'),(4758,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zeltzubehör > Innenzelte','de-DE'),(4759,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zeltzubehör > Vorzelte','de-DE'),(4760,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zeltzubehör > Zeltstangen & -Heringe','de-DE'),(4761,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zeltzubehör > Zeltunterlagen','de-DE'),(4762,'Sportartikel > Outdoor-Aktivitäten > Camping & Wandern > Zubehör für Trekkingstöcke','de-DE'),(4763,'Sportartikel > Outdoor-Aktivitäten > Drachenfliegen & Fallschirmspringen','de-DE'),(4764,'Sportartikel > Outdoor-Aktivitäten > Drachenfliegen & Fallschirmspringen > Fallschirme','de-DE'),(4765,'Sportartikel > Outdoor-Aktivitäten > Drachenfliegen & Fallschirmspringen > Fluganzüge','de-DE'),(4766,'Sportartikel > Outdoor-Aktivitäten > Drachenfliegen & Fallschirmspringen > Hängegleiter','de-DE'),(4767,'Sportartikel > Outdoor-Aktivitäten > Golf','de-DE'),(4768,'Sportartikel > Outdoor-Aktivitäten > Golf > Golf-Tees','de-DE'),(4769,'Sportartikel > Outdoor-Aktivitäten > Golf > Golf-Trainingshilfen','de-DE'),(4770,'Sportartikel > Outdoor-Aktivitäten > Golf > Golf-Zubehörsets','de-DE'),(4771,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfballmarkierungen','de-DE'),(4772,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfbälle','de-DE'),(4773,'Sportartikel > Outdoor-Aktivitäten > Golf > Golffahnen','de-DE'),(4774,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfhandschuhe','de-DE'),(4775,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfhandtücher','de-DE'),(4776,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfschläger','de-DE'),(4777,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfschläger-Teile & Zubehör','de-DE'),(4778,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfschläger-Teile & Zubehör > Golfschläger-Schutzhüllen','de-DE'),(4779,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfschläger-Teile & Zubehör > Golfschlägergriffe','de-DE'),(4780,'Sportartikel > Outdoor-Aktivitäten > Golf > Golfschläger-Teile & Zubehör > Golfschlägerschäfte','de-DE'),(4781,'Sportartikel > Outdoor-Aktivitäten > Golf > Golftaschen','de-DE'),(4782,'Sportartikel > Outdoor-Aktivitäten > Golf > Golftaschenzubehör','de-DE'),(4783,'Sportartikel > Outdoor-Aktivitäten > Golf > Golftaschenzubehör > Golftaschenhüllen','de-DE'),(4784,'Sportartikel > Outdoor-Aktivitäten > Golf > Golftaschenzubehör > Golftaschentrolleys','de-DE'),(4785,'Sportartikel > Outdoor-Aktivitäten > Golf > Pitchgabeln','de-DE'),(4786,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen','de-DE'),(4787,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen','de-DE'),(4788,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Armschutz für Bogenschützen','de-DE'),(4789,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Bogen- & Armbrustteile & -zubehör','de-DE'),(4790,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Bögen & Armbrüste','de-DE'),(4791,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Bögen & Armbrüste > Armbrüste','de-DE'),(4792,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Bögen & Armbrüste > Compoundbögen','de-DE'),(4793,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Bögen & Armbrüste > Langbögen','de-DE'),(4794,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Handschuhe & Auslöser','de-DE'),(4795,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Köcher','de-DE'),(4796,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Pfeile','de-DE'),(4797,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Pfeilelemente & Zubehör','de-DE'),(4798,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Pfeilelemente & Zubehör > Jagdspitzen & Feldspitzen','de-DE'),(4799,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Pfeilelemente & Zubehör > Nocken','de-DE'),(4800,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Pfeilelemente & Zubehör > Steuerfedern','de-DE'),(4801,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Bogenschießen > Zielscheiben für Bogenschießen','de-DE'),(4802,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen','de-DE'),(4803,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Hochsitze','de-DE'),(4804,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Jagdansitze & Tarnung','de-DE'),(4805,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Jagdhund-Ausrüstung','de-DE'),(4806,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Jagdverstärker','de-DE'),(4807,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Lockmittel für Wild','de-DE'),(4808,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Lockmittel für Wild > Geruchstarnung & Lockdüfte','de-DE'),(4809,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Lockmittel für Wild > Jagdköder','de-DE'),(4810,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Lockmittel für Wild > Köder, Futter & Mineralien','de-DE'),(4811,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Lockmittel für Wild > Lockinstrumente','de-DE'),(4812,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Tierfallen','de-DE'),(4813,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Jagen > Wildfutterautomaten','de-DE'),(4814,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft','de-DE'),(4815,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball','de-DE'),(4816,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Ersatzteile & Zubehör für Paintball-Gewehre','de-DE'),(4817,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Ersatzteile & Zubehör für Paintball-Gewehre > Paintball-Drop-Forwards','de-DE'),(4818,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Ersatzteile & Zubehör für Paintball-Gewehre > Paintball-Gewehrläufe','de-DE'),(4819,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Ersatzteile & Zubehör für Paintball-Gewehre > Paintball-Hopper','de-DE'),(4820,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Ersatzteile & Zubehör für Paintball-Gewehre > Paintball-Pressluftflaschen','de-DE'),(4821,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Paintball-Battlepacks','de-DE'),(4822,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Paintball-Granaten','de-DE'),(4823,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Paintball-Granatwerfer','de-DE'),(4824,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Paintball-Markierer','de-DE'),(4825,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball > Paintballs','de-DE'),(4826,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball- & Airsoft-Schutzkleidung','de-DE'),(4827,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball- & Airsoft-Schutzkleidung > Paintball- & Airsoft-Handschuhe','de-DE'),(4828,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball- & Airsoft-Schutzkleidung > Paintball- & Airsoft-Schutzbrillen & Masken','de-DE'),(4829,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball- & Airsoft-Schutzkleidung > Paintball- & Airsoft-Schutzpolster','de-DE'),(4830,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Paintball- & Airsoft-Schutzkleidung > Paintball- & Airsoft-Westen','de-DE'),(4831,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Softair','de-DE'),(4832,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Softair > Softairkugeln','de-DE'),(4833,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Softair > Softairwaffen','de-DE'),(4834,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Softair > Softairwaffen-Teile & -Zubehör','de-DE'),(4835,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Paintball & Airsoft > Softair > Softairwaffen-Teile & -Zubehör > Batterien für Softairwaffen','de-DE'),(4836,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schießsportzubehör','de-DE'),(4837,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schießsportzubehör > Stative & Zweibeinständer','de-DE'),(4838,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schießsportzubehör > Stützen','de-DE'),(4839,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schießsportzubehör > Zielscheiben','de-DE'),(4840,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schutzkleidung für Jagd- und Schießsport','de-DE'),(4841,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schutzkleidung für Jagd- und Schießsport > Handschuhe für Jagd- und Schießsport','de-DE'),(4842,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Schutzkleidung für Jagd- und Schießsport > Jacken für Jagd- und Schießsport','de-DE'),(4843,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Tontaubenschießen','de-DE'),(4844,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Tontaubenschießen > Tontauben','de-DE'),(4845,'Sportartikel > Outdoor-Aktivitäten > Jagen und Schießen > Tontaubenschießen > Tontauben-Wurfmaschinen','de-DE'),(4846,'Sportartikel > Outdoor-Aktivitäten > Kitebuggying','de-DE'),(4847,'Sportartikel > Outdoor-Aktivitäten > Kitebuggying > Kitebuggy-Zubehör','de-DE'),(4848,'Sportartikel > Outdoor-Aktivitäten > Kitebuggying > Kitebuggys','de-DE'),(4849,'Sportartikel > Outdoor-Aktivitäten > Klettern','de-DE'),(4850,'Sportartikel > Outdoor-Aktivitäten > Klettern > Bouldermatten','de-DE'),(4851,'Sportartikel > Outdoor-Aktivitäten > Klettern > Chalkbags','de-DE'),(4852,'Sportartikel > Outdoor-Aktivitäten > Klettern > Eiskletterausrüstung','de-DE'),(4853,'Sportartikel > Outdoor-Aktivitäten > Klettern > Eisschrauben','de-DE'),(4854,'Sportartikel > Outdoor-Aktivitäten > Klettern > Expresssets','de-DE'),(4855,'Sportartikel > Outdoor-Aktivitäten > Klettern > Gurtbänder','de-DE'),(4856,'Sportartikel > Outdoor-Aktivitäten > Klettern > Karabiner','de-DE'),(4857,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterbekleidung & -zubehör','de-DE'),(4858,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterbekleidung & -zubehör > Kletterhandschuhe','de-DE'),(4859,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterbekleidung & -zubehör > Kletterhelme','de-DE'),(4860,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterbekleidung & -zubehör > Steigeisen','de-DE'),(4861,'Sportartikel > Outdoor-Aktivitäten > Klettern > Klettergurte','de-DE'),(4862,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterschutzausrüstung','de-DE'),(4863,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterseile','de-DE'),(4864,'Sportartikel > Outdoor-Aktivitäten > Klettern > Kletterwandgriffe','de-DE'),(4865,'Sportartikel > Outdoor-Aktivitäten > Klettern > Seilsäcke','de-DE'),(4866,'Sportartikel > Outdoor-Aktivitäten > Klettern > Sicherungsgeräte','de-DE'),(4867,'Sportartikel > Outdoor-Aktivitäten > Klettern > Steigklemmen & Abseilausrüstung','de-DE'),(4868,'Sportartikel > Outdoor-Aktivitäten > Radsport','de-DE'),(4869,'Sportartikel > Outdoor-Aktivitäten > Radsport > Dreiradzubehör','de-DE'),(4870,'Sportartikel > Outdoor-Aktivitäten > Radsport > Dreiräder','de-DE'),(4871,'Sportartikel > Outdoor-Aktivitäten > Radsport > Einradzubehör','de-DE'),(4872,'Sportartikel > Outdoor-Aktivitäten > Radsport > Einräder','de-DE'),(4873,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile','de-DE'),(4874,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrrad-Groupsets','de-DE'),(4875,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradbremsenteile','de-DE'),(4876,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradbremsenteile > Bremsen-Sets','de-DE'),(4877,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradbremsenteile > Bremshebel','de-DE'),(4878,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradbremsenteile > Bremsrotoren','de-DE'),(4879,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradbremsenteile > Bremssättel','de-DE'),(4880,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradgabeln','de-DE'),(4881,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradkabel','de-DE'),(4882,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradkabelgehäuse','de-DE'),(4883,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkerverlängerungen','de-DE'),(4884,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkervorbau','de-DE'),(4885,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkkopf-Teile','de-DE'),(4886,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkkopf-Teile > Fahrradlenkkopf-Abstandsringe','de-DE'),(4887,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkkopf-Teile > Fahrradlenkkopf-Halterungen','de-DE'),(4888,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkköpfe','de-DE'),(4889,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradlenkstangen','de-DE'),(4890,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradrahmen','de-DE'),(4891,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradreifen','de-DE'),(4892,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräder','de-DE'),(4893,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör','de-DE'),(4894,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradachsen & -spanner','de-DE'),(4895,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradfelgen','de-DE'),(4896,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradfußrasten','de-DE'),(4897,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradnaben','de-DE'),(4898,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradnabenteile','de-DE'),(4899,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Fahrradspeichen','de-DE'),(4900,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Felgenbänder','de-DE'),(4901,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradräderzubehör > Speichennippel','de-DE'),(4902,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradsattelstützen','de-DE'),(4903,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradsattelstützenklemmen','de-DE'),(4904,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile','de-DE'),(4905,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradgangschaltungen','de-DE'),(4906,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradkassetten','de-DE'),(4907,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradketten','de-DE'),(4908,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradkettenkränze','de-DE'),(4909,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradkurbeln','de-DE'),(4910,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradpedale','de-DE'),(4911,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Fahrradschalthebel','de-DE'),(4912,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschaltungsteile > Tretlagergehäuse','de-DE'),(4913,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradschläuche','de-DE'),(4914,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradständer','de-DE'),(4915,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Fahrradsättel','de-DE'),(4916,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Kleinere Fahrradzubehörteile','de-DE'),(4917,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Reifenventiladapter','de-DE'),(4918,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Reifenventile','de-DE'),(4919,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbauteile > Reifenventilkappen','de-DE'),(4920,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör','de-DE'),(4921,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Fahrrad-Schutzpolster','de-DE'),(4922,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Fahrradhandschuhe','de-DE'),(4923,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Fahrradhelme','de-DE'),(4924,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Fahrradhelmteile und -zubehör','de-DE'),(4925,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Fahrradüberschuhe','de-DE'),(4926,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Schuhplatten','de-DE'),(4927,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Schuhplatten-Zubehör','de-DE'),(4928,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Schuhplatten-Zubehör > Schuhplatten-Klemmen & -Keile','de-DE'),(4929,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Schuhplatten-Zubehör > Schuhplatten-Schrauben','de-DE'),(4930,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradbekleidung & Zubehör > Schuhplatten-Zubehör > Schuhplatten-Schutzhüllen','de-DE'),(4931,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör','de-DE'),(4932,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Dämpferpumpen','de-DE'),(4933,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrrad-Fußriemen','de-DE'),(4934,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradabdeckungen','de-DE'),(4935,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradanhänger','de-DE'),(4936,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradcomputer','de-DE'),(4937,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradgepäckträger','de-DE'),(4938,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradklingeln & -hupen','de-DE'),(4939,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradkörbe','de-DE'),(4940,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradpumpen','de-DE'),(4941,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradsattelbezüge & -polster','de-DE'),(4942,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradschlösser','de-DE'),(4943,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradschutzbleche','de-DE'),(4944,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradspeichen-Reflektoren','de-DE'),(4945,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradspiegel','de-DE'),(4946,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradständer & Fahrradparksysteme','de-DE'),(4947,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradtaschen','de-DE'),(4948,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradtaschen & -koffer','de-DE'),(4949,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Fahrradwerkzeug','de-DE'),(4950,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Flaschenhalter für Fahrradrahmen','de-DE'),(4951,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Flicken & Reparatur-Sets','de-DE'),(4952,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Griffe und Dekor für Fahrradlenker','de-DE'),(4953,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Kinderfahrradsitze','de-DE'),(4954,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Stützräder','de-DE'),(4955,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Surfbretthalterungen für Fahrräder','de-DE'),(4956,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Trainingsrollen','de-DE'),(4957,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Umrüstsatz für E-Bikes','de-DE'),(4958,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Zubehör für Fahrradcomputer','de-DE'),(4959,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrradzubehör > Zubehör für Fahrradkindersitze','de-DE'),(4960,'Sportartikel > Outdoor-Aktivitäten > Radsport > Fahrräder','de-DE'),(4961,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör','de-DE'),(4962,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf','de-DE'),(4963,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Abreitdecken & Weidedecken','de-DE'),(4964,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Fliegenmasken','de-DE'),(4965,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Hufglocken & Gamaschen','de-DE'),(4966,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Leckerli für Pferde','de-DE'),(4967,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Pferdefutter','de-DE'),(4968,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Pferdehaarpflege','de-DE'),(4969,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Pferdehaarpflege > Kämme, Bürsten & Striegel','de-DE'),(4970,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Pferdehaarpflege > Pferdeschermaschinen','de-DE'),(4971,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Vitamine & Futterergänzungsmittel für Pferde','de-DE'),(4972,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Pferdebedarf > Wurmkur für Pferde','de-DE'),(4973,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Reitausrüstung','de-DE'),(4974,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Reitausrüstung > Gerten & Peitschen','de-DE'),(4975,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Reitausrüstung > Reithandschuhe','de-DE'),(4976,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Reitausrüstung > Reithelme','de-DE'),(4977,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Reitausrüstung > Reithosen','de-DE'),(4978,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug','de-DE'),(4979,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Halfter','de-DE'),(4980,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Pferdegeschirr','de-DE'),(4981,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Pferdeleinen','de-DE'),(4982,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Sattelgurte','de-DE'),(4983,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Steigbügel','de-DE'),(4984,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Sättel','de-DE'),(4985,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Trensen','de-DE'),(4986,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Zaumzeug','de-DE'),(4987,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Sattel- & Zaumzeug > Zügel','de-DE'),(4988,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug','de-DE'),(4989,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattel- & Zaumzeugbehälter','de-DE'),(4990,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattelzubehör','de-DE'),(4991,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattelzubehör > Sattelauflagen','de-DE'),(4992,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattelzubehör > Sattelbezüge und -hüllen','de-DE'),(4993,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattelzubehör > Sattelpolster & -decken','de-DE'),(4994,'Sportartikel > Outdoor-Aktivitäten > Reitsportzubehör > Zubehör für Sattel & Zaumzeug > Sattelzubehör > Satteltaschen','de-DE'),(4995,'Sportartikel > Outdoor-Aktivitäten > Roller','de-DE'),(4996,'Sportartikel > Outdoor-Aktivitäten > Skateboarding','de-DE'),(4997,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skate-Rails','de-DE'),(4998,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skate-Rampen','de-DE'),(4999,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboard-Teile','de-DE'),(5000,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboard-Teile > Skateboard-Achsen','de-DE'),(5001,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboard-Teile > Skateboard-Decks','de-DE'),(5002,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboard-Teile > Skateboard-Kleinteile','de-DE'),(5003,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboard-Teile > Skateboard-Rollen','de-DE'),(5004,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboarding-Schutzausrüstung','de-DE'),(5005,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboarding-Schutzausrüstung > Skate-Helme','de-DE'),(5006,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboarding-Schutzausrüstung > Skateboarding-Handschuhe','de-DE'),(5007,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboarding-Schutzausrüstung > Skateboarding-Protektoren','de-DE'),(5008,'Sportartikel > Outdoor-Aktivitäten > Skateboarding > Skateboards','de-DE'),(5009,'Sportartikel > Outdoor-Aktivitäten > Skaten','de-DE'),(5010,'Sportartikel > Outdoor-Aktivitäten > Skaten > Inline-Skates','de-DE'),(5011,'Sportartikel > Outdoor-Aktivitäten > Skaten > Inlineskate-Teile','de-DE'),(5012,'Sportartikel > Outdoor-Aktivitäten > Skaten > Rollerskates','de-DE'),(5013,'Sportartikel > Outdoor-Aktivitäten > Skaten > Rollschuh-Teile','de-DE'),(5014,'Sportartikel > Outdoor-Aktivitäten > Skaten > Rollskis','de-DE'),(5015,'Sportartikel > Outdoor-Aktivitäten > Skaten > Schutzausrüstung für Skater','de-DE'),(5016,'Sportartikel > Outdoor-Aktivitäten > Skaten > Schutzausrüstung für Skater > Rollschuh-Polster','de-DE'),(5017,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien','de-DE'),(5018,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Badminton','de-DE'),(5019,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Badminton > Badmintonnetze','de-DE'),(5020,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Badminton > Badmintonschläger & -sets','de-DE'),(5021,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Badminton > Federball','de-DE'),(5022,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Bälle für Paddle-Tennis','de-DE'),(5023,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Discgolf','de-DE'),(5024,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Discgolf > Discgolf-Fangkörbe','de-DE'),(5025,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Discgolf > Discgolf-Taschen','de-DE'),(5026,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Paddletennis','de-DE'),(5027,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Paddletennis > Paddletennis-Bälle','de-DE'),(5028,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Paddletennis > Paddletennis-Schläger','de-DE'),(5029,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Pickleball','de-DE'),(5030,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Pickleball > Pickleball-Bälle','de-DE'),(5031,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Pickleball > Pickleball-Schläger','de-DE'),(5032,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Rasenspiele','de-DE'),(5033,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Shuffleboard','de-DE'),(5034,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Shuffleboard > Shuffleboard-Cues','de-DE'),(5035,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Shuffleboard > Shuffleboard-Disks','de-DE'),(5036,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Tetherball','de-DE'),(5037,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Tetherball > Tetherball-Bälle','de-DE'),(5038,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Tetherball > Tetherball-Sets','de-DE'),(5039,'Sportartikel > Outdoor-Aktivitäten > Spiele im Freien > Tetherball > Tetherball-Stangen','de-DE'),(5040,'Sportartikel > Outdoor-Aktivitäten > Trinksystem-Zubehör','de-DE'),(5041,'Sportartikel > Outdoor-Aktivitäten > Trinksystemrucksäcke & -taschen','de-DE'),(5042,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten','de-DE'),(5043,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Lawinenschutz','de-DE'),(5044,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Lawinenschutz > Lawinenairbags','de-DE'),(5045,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Lawinenschutz > Lawinensonden','de-DE'),(5046,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Rodelschlitten','de-DE'),(5047,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Schneeschuhe & Zubehör','de-DE'),(5048,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Schneeschuhe & Zubehör > Schneeschuh-Bindungen','de-DE'),(5049,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Schneeschuhe & Zubehör > Schneeschuhe','de-DE'),(5050,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden','de-DE'),(5051,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ersatzteile für Skibindungen','de-DE'),(5052,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Ablagen','de-DE'),(5053,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Brillen','de-DE'),(5054,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Brillenzubehör','de-DE'),(5055,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Brillenzubehör > Ski- & Snowboard-Brillengläser','de-DE'),(5056,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Leinen','de-DE'),(5057,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Taschen','de-DE'),(5058,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboard-Wachs','de-DE'),(5059,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Ski- & Snowboardhelme','de-DE'),(5060,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skibindungen','de-DE'),(5061,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skier','de-DE'),(5062,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skier > Alpinskier','de-DE'),(5063,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skier > Langlaufskier','de-DE'),(5064,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skischuhe','de-DE'),(5065,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Skistöcke','de-DE'),(5066,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Snowboard-Bindungen','de-DE'),(5067,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Snowboards','de-DE'),(5068,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Snowboardstiefel','de-DE'),(5069,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Tuningwerkzeuge für Skis & Snowboards','de-DE'),(5070,'Sportartikel > Outdoor-Aktivitäten > Wintersport & -Aktivitäten > Skisport & Snowboarden > Zubehör Snowboard-Bindungen','de-DE'),(5071,'Taschen & Gepäck','de-DE'),(5072,'Taschen & Gepäck > Aktentaschen','de-DE'),(5073,'Taschen & Gepäck > Bauchtaschen','de-DE'),(5074,'Taschen & Gepäck > Einkaufstaschen','de-DE'),(5075,'Taschen & Gepäck > Gepäckzubehör','de-DE'),(5076,'Taschen & Gepäck > Gepäckzubehör > Folien & Einsätze für Trockenboxen','de-DE'),(5077,'Taschen & Gepäck > Gepäckzubehör > Gepäck-Organizer','de-DE'),(5078,'Taschen & Gepäck > Gepäckzubehör > Gepäckanhänger','de-DE'),(5079,'Taschen & Gepäck > Gepäckzubehör > Kofferablagen','de-DE'),(5080,'Taschen & Gepäck > Gepäckzubehör > Koffergurte','de-DE'),(5081,'Taschen & Gepäck > Gepäckzubehör > Reisebehälter','de-DE'),(5082,'Taschen & Gepäck > Gepäckzubehör > Reisedokumententaschen','de-DE'),(5083,'Taschen & Gepäck > Gepäckzubehör > Rucksack-Schutzhüllen','de-DE'),(5084,'Taschen & Gepäck > Kleidertaschen','de-DE'),(5085,'Taschen & Gepäck > Koffer','de-DE'),(5086,'Taschen & Gepäck > Kosmetikkoffer','de-DE'),(5087,'Taschen & Gepäck > Kulturtaschen','de-DE'),(5088,'Taschen & Gepäck > Kurier- & Schultertaschen','de-DE'),(5089,'Taschen & Gepäck > Rucksäcke','de-DE'),(5090,'Taschen & Gepäck > Seesäcke','de-DE'),(5091,'Taschen & Gepäck > Trockenboxen','de-DE'),(5092,'Taschen & Gepäck > Wickeltaschen','de-DE'),(5093,'Tiere & Tierbedarf','de-DE'),(5094,'Tiere & Tierbedarf > Haustierbedarf','de-DE'),(5095,'Tiere & Tierbedarf > Haustierbedarf > Agility-Ausrüstung','de-DE'),(5096,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik','de-DE'),(5097,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Aquarien','de-DE'),(5098,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Aquariumbeleuchtung','de-DE'),(5099,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Aquariumdekoration','de-DE'),(5100,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Aquariumfilter','de-DE'),(5101,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Aquariumständer','de-DE'),(5102,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Ausströmersteine & Diffusoren für Aquarien ','de-DE'),(5103,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Bodengrund für Aquarien','de-DE'),(5104,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Fischfutter','de-DE'),(5105,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Fischfutterautomaten','de-DE'),(5106,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Fischnetze für Aquarien','de-DE'),(5107,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Schläuche & Rohre für Aquarien & Teiche','de-DE'),(5108,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Temperaturregler für Aquarien','de-DE'),(5109,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Wasseraufbereitungsgeräte','de-DE'),(5110,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Wasserpflanzendünger','de-DE'),(5111,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Zubehör für Aquariumreinigung','de-DE'),(5112,'Tiere & Tierbedarf > Haustierbedarf > Aquaristik > Überlaufkästen','de-DE'),(5113,'Tiere & Tierbedarf > Haustierbedarf > Augentropfen für Haustiere','de-DE'),(5114,'Tiere & Tierbedarf > Haustierbedarf > Begrenzungssysteme','de-DE'),(5115,'Tiere & Tierbedarf > Haustierbedarf > Bügel für Haustierbekleidung','de-DE'),(5116,'Tiere & Tierbedarf > Haustierbedarf > Entsorgungssysteme & -werkzeug für Tierkot','de-DE'),(5117,'Tiere & Tierbedarf > Haustierbedarf > Erkennungsmarken','de-DE'),(5118,'Tiere & Tierbedarf > Haustierbedarf > Erste-Hilfe-Koffer für Haustiere','de-DE'),(5119,'Tiere & Tierbedarf > Haustierbedarf > Fitnessmonitor für Haustiere','de-DE'),(5120,'Tiere & Tierbedarf > Haustierbedarf > Fitnessmonitor für Haustiere > Glukosemessgeräte für Haustiere','de-DE'),(5121,'Tiere & Tierbedarf > Haustierbedarf > Fitnessmonitor für Haustiere > Schrittzähler für Haustiere','de-DE'),(5122,'Tiere & Tierbedarf > Haustierbedarf > Fitnessmonitor für Haustiere > Thermometer für Haustiere','de-DE'),(5123,'Tiere & Tierbedarf > Haustierbedarf > Floh- & Zeckenschutzmittel','de-DE'),(5124,'Tiere & Tierbedarf > Haustierbedarf > Futter- & Wasserspender','de-DE'),(5125,'Tiere & Tierbedarf > Haustierbedarf > Glocken & Anhänger','de-DE'),(5126,'Tiere & Tierbedarf > Haustierbedarf > Halsbänder & Geschirre','de-DE'),(5127,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel','de-DE'),(5128,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Düfte & Deosprays für Haustiere','de-DE'),(5129,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Feuchttücher für Haustiere','de-DE'),(5130,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Haartrockner für Haustiere','de-DE'),(5131,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Kämme & Bürsten zur Fellpflege','de-DE'),(5132,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Nagellack für Haustiere','de-DE'),(5133,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Nagelpflege für Haustiere','de-DE'),(5134,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Shampoos & Spülungen zur Fellpflege','de-DE'),(5135,'Tiere & Tierbedarf > Haustierbedarf > Haustierpflegeartikel > Tierhaarschneider','de-DE'),(5136,'Tiere & Tierbedarf > Haustierbedarf > Haustiertüren','de-DE'),(5137,'Tiere & Tierbedarf > Haustierbedarf > Hilfsmittel für Tierausbildung','de-DE'),(5138,'Tiere & Tierbedarf > Haustierbedarf > Hilfsmittel für Tierausbildung > Bodenschutz & Unterlagen','de-DE'),(5139,'Tiere & Tierbedarf > Haustierbedarf > Hilfsmittel für Tierausbildung > Clicker & Belohnungsspielzeug für Tierausbildung','de-DE'),(5140,'Tiere & Tierbedarf > Haustierbedarf > Hilfsmittel für Tierausbildung > Pad-Unterlagen für Tierausbildung','de-DE'),(5141,'Tiere & Tierbedarf > Haustierbedarf > Hilfsmittel für Tierausbildung > Sprays & Lösungen für Tierausbildung','de-DE'),(5142,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf','de-DE'),(5143,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Einlagen für Hundewindeln','de-DE'),(5144,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundebekleidung','de-DE'),(5145,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundebetten','de-DE'),(5146,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundefutter','de-DE'),(5147,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundehütten','de-DE'),(5148,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundelaufbänder','de-DE'),(5149,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundespielzeug','de-DE'),(5150,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundewindeln','de-DE'),(5151,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Hundezwinger & -ausläufe','de-DE'),(5152,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Leckerbissen für Hunde','de-DE'),(5153,'Tiere & Tierbedarf > Haustierbedarf > Hundebedarf > Zubehör für Hundezwinger & -ausläufe','de-DE'),(5154,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf','de-DE'),(5155,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Einlagen für Katzentoilette','de-DE'),(5156,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenbekleidung','de-DE'),(5157,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenbetten','de-DE'),(5158,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenfutter','de-DE'),(5159,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenmöbel','de-DE'),(5160,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenspielzeug','de-DE'),(5161,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzenstreu','de-DE'),(5162,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Katzentoiletten','de-DE'),(5163,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Leckerbissen für Katzen','de-DE'),(5164,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Vorleger für Katzentoiletten','de-DE'),(5165,'Tiere & Tierbedarf > Haustierbedarf > Katzenbedarf > Zubehör für Katzenmöbel','de-DE'),(5166,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör','de-DE'),(5167,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör > Decken & Streu für Kleintiere','de-DE'),(5168,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör > Futter für Kleintiere','de-DE'),(5169,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör > Lebensräume & Gehege für Kleintiere','de-DE'),(5170,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör > Leckerli für Kleintiere','de-DE'),(5171,'Tiere & Tierbedarf > Haustierbedarf > Kleintierzubehör > Zubehör für Lebensräume von Kleintieren','de-DE'),(5172,'Tiere & Tierbedarf > Haustierbedarf > Kotbeutel','de-DE'),(5173,'Tiere & Tierbedarf > Haustierbedarf > Leinen','de-DE'),(5174,'Tiere & Tierbedarf > Haustierbedarf > Maulkörbe','de-DE'),(5175,'Tiere & Tierbedarf > Haustierbedarf > Medizinische Halsbänder für Haustiere','de-DE'),(5176,'Tiere & Tierbedarf > Haustierbedarf > Medizinisches Klebeband & Verbandsmaterial für Haustiere','de-DE'),(5177,'Tiere & Tierbedarf > Haustierbedarf > Mundpflege für Haustiere','de-DE'),(5178,'Tiere & Tierbedarf > Haustierbedarf > Napfständer','de-DE'),(5179,'Tiere & Tierbedarf > Haustierbedarf > Napfunterlagen','de-DE'),(5180,'Tiere & Tierbedarf > Haustierbedarf > Pet-Stroller','de-DE'),(5181,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf','de-DE'),(5182,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf > Bodengrund für Reptilien & Amphibien','de-DE'),(5183,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf > Heizung & Beleuchtung für Terrarien','de-DE'),(5184,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf > Reptilien- & Amphibienfutter','de-DE'),(5185,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf > Terrarien','de-DE'),(5186,'Tiere & Tierbedarf > Haustierbedarf > Reptilien- & Amphibienbedarf > Zubehör für Terrarien','de-DE'),(5187,'Tiere & Tierbedarf > Haustierbedarf > Sonnenschutz für Haustiere','de-DE'),(5188,'Tiere & Tierbedarf > Haustierbedarf > Spender & Halterungen für Kotbeutel','de-DE'),(5189,'Tiere & Tierbedarf > Haustierbedarf > Spielgehege für Haustiere','de-DE'),(5190,'Tiere & Tierbedarf > Haustierbedarf > Tierfutterbehälter','de-DE'),(5191,'Tiere & Tierbedarf > Haustierbedarf > Tierfutterportionierer','de-DE'),(5192,'Tiere & Tierbedarf > Haustierbedarf > Tiermedikamente','de-DE'),(5193,'Tiere & Tierbedarf > Haustierbedarf > Transportboxen & -taschen','de-DE'),(5194,'Tiere & Tierbedarf > Haustierbedarf > Trennvorrichtungen für den Haustiertransport','de-DE'),(5195,'Tiere & Tierbedarf > Haustierbedarf > Treppen & Rampen für Haustiere','de-DE'),(5196,'Tiere & Tierbedarf > Haustierbedarf > Verlängerungsleinen','de-DE'),(5197,'Tiere & Tierbedarf > Haustierbedarf > Vitamine & Nahrungsergänzungsmittel für Haustiere','de-DE'),(5198,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf','de-DE'),(5199,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Snacks für Vögel','de-DE'),(5200,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Spielvorrichtungen für Vögel','de-DE'),(5201,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelfutter','de-DE'),(5202,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelkäfige & -ständer','de-DE'),(5203,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelkäfigzubehör','de-DE'),(5204,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelkäfigzubehör > Futter- & Wasserspender für Vogelkäfige','de-DE'),(5205,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelkäfigzubehör > Vogelbäder für Vogelkäfige','de-DE'),(5206,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelleitern & -sitzstangen','de-DE'),(5207,'Tiere & Tierbedarf > Haustierbedarf > Vogelbedarf > Vogelspielzeug','de-DE'),(5208,'Tiere & Tierbedarf > Haustierbedarf > Wärmekissen für Haustiere','de-DE'),(5209,'Tiere & Tierbedarf > Haustierbedarf > Zubehör für Haustier-Heizkissen','de-DE'),(5210,'Tiere & Tierbedarf > Haustierbedarf > Zubehör für Haustierbetten','de-DE'),(5211,'Tiere & Tierbedarf > Haustierbedarf > Zubehör für Haustierklappen','de-DE'),(5212,'Tiere & Tierbedarf > Haustierbedarf > Zubehör für Haustiertragetaschen und -boxen','de-DE'),(5213,'Tiere & Tierbedarf > Lebende Tiere','de-DE'),(5214,'Wirtschaft & Industrie','de-DE'),(5215,'Wirtschaft & Industrie > Arbeitsschutzausrüstung','de-DE'),(5216,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Chemikalienschutzanzüge','de-DE'),(5217,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Gasmasken- & Atemschutzmaskenzubehör','de-DE'),(5218,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Halteseile','de-DE'),(5219,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Knieschoner','de-DE'),(5220,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Kugelsichere Westen','de-DE'),(5221,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzbrillen','de-DE'),(5222,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzhandschuhe','de-DE'),(5223,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzhelme','de-DE'),(5224,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzmasken','de-DE'),(5225,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzmasken > Feuerwehr-Atemschutzmasken','de-DE'),(5226,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzmasken > Gas- & Atemschutzmasken','de-DE'),(5227,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzmasken > Medizinische Masken','de-DE'),(5228,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schutzmasken > Staubmasken','de-DE'),(5229,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Schweißhelme','de-DE'),(5230,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Sicherheitsschürzen','de-DE'),(5231,'Wirtschaft & Industrie > Arbeitsschutzausrüstung > Sicherungsgurte','de-DE'),(5232,'Wirtschaft & Industrie > Aufbewahrungszubehör für industrielle Zwecke','de-DE'),(5233,'Wirtschaft & Industrie > Automatisierungskomponenten','de-DE'),(5234,'Wirtschaft & Industrie > Automatisierungskomponenten > Antriebssysteme mit variabler Frequenz & einstellbarer Drehzahl','de-DE'),(5235,'Wirtschaft & Industrie > Automatisierungskomponenten > Speicherprogrammierbare Steuerungen','de-DE'),(5236,'Wirtschaft & Industrie > Baugewerbe','de-DE'),(5237,'Wirtschaft & Industrie > Baugewerbe > Verkehrskegel','de-DE'),(5238,'Wirtschaft & Industrie > Baugewerbe > Vermessung','de-DE'),(5239,'Wirtschaft & Industrie > Bergbau & Steinbruch','de-DE'),(5240,'Wirtschaft & Industrie > Beschilderung','de-DE'),(5241,'Wirtschaft & Industrie > Beschilderung > Digitale Schilder','de-DE'),(5242,'Wirtschaft & Industrie > Beschilderung > Einzelhandelsschilder','de-DE'),(5243,'Wirtschaft & Industrie > Beschilderung > Elektronische Schilder','de-DE'),(5244,'Wirtschaft & Industrie > Beschilderung > Elektronische Schilder > LED-Schilder','de-DE'),(5245,'Wirtschaft & Industrie > Beschilderung > Elektronische Schilder > Neonschilder','de-DE'),(5246,'Wirtschaft & Industrie > Beschilderung > Geöffnet- und Geschlossen-Schilder','de-DE'),(5247,'Wirtschaft & Industrie > Beschilderung > Hinweisschilder','de-DE'),(5248,'Wirtschaft & Industrie > Beschilderung > Notfall- & Notausgangsschilder','de-DE'),(5249,'Wirtschaft & Industrie > Beschilderung > Parkplatzschilder','de-DE'),(5250,'Wirtschaft & Industrie > Beschilderung > Sicherheitsschilder','de-DE'),(5251,'Wirtschaft & Industrie > Beschilderung > Tragbare Schilder','de-DE'),(5252,'Wirtschaft & Industrie > Beschilderung > Verkehrsschilder','de-DE'),(5253,'Wirtschaft & Industrie > Beschilderung > Warnschilder','de-DE'),(5254,'Wirtschaft & Industrie > Beschilderung > Wegweiser','de-DE'),(5255,'Wirtschaft & Industrie > Beschilderung > Öffnungszeiten-Schilder','de-DE'),(5256,'Wirtschaft & Industrie > Einzelhandel','de-DE'),(5257,'Wirtschaft & Industrie > Einzelhandel > Einkaufstüten aus Papier & Plastik','de-DE'),(5258,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung','de-DE'),(5259,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Geldscheinprüfgeräte','de-DE'),(5260,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Geldtaschen','de-DE'),(5261,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Geldwechsler','de-DE'),(5262,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Geldzählmaschinen für Münzen und Scheine','de-DE'),(5263,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Ladenkassen & POS-Terminals','de-DE'),(5264,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Münzrollenpapier & Geldscheinbanderolen','de-DE'),(5265,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Zubehör für Ladenkassen & POS-Terminals','de-DE'),(5266,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Zubehör für Ladenkassen & POS-Terminals > Kassenschubladen','de-DE'),(5267,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Zubehör für Ladenkassen & POS-Terminals > Kreditkartenterminals','de-DE'),(5268,'Wirtschaft & Industrie > Einzelhandel > Geldhandhabung > Zubehör für Ladenkassen & POS-Terminals > Unterschriftenpads','de-DE'),(5269,'Wirtschaft & Industrie > Einzelhandel > Preisauszeichnungsgeräte','de-DE'),(5270,'Wirtschaft & Industrie > Einzelhandel > Präsentationsständer für Bekleidung','de-DE'),(5271,'Wirtschaft & Industrie > Einzelhandel > Schaufensterdeko & -puppen','de-DE'),(5272,'Wirtschaft & Industrie > Einzelhandel > Schaufensterpuppen','de-DE'),(5273,'Wirtschaft & Industrie > Einzelhandel > Schaufensterpuppenteile','de-DE'),(5274,'Wirtschaft & Industrie > Einzelhandel > Vitrinen','de-DE'),(5275,'Wirtschaft & Industrie > Film & Fernsehen','de-DE'),(5276,'Wirtschaft & Industrie > Finanzwesen & Versicherung','de-DE'),(5277,'Wirtschaft & Industrie > Finanzwesen & Versicherung > Bullion','de-DE'),(5278,'Wirtschaft & Industrie > Forst- & Holzwirtschaft','de-DE'),(5279,'Wirtschaft & Industrie > Friseur- & Kosmetikgewerbe','de-DE'),(5280,'Wirtschaft & Industrie > Friseur- & Kosmetikgewerbe > Friseurumhänge & Halskrausen','de-DE'),(5281,'Wirtschaft & Industrie > Friseur- & Kosmetikgewerbe > Pedikürestuhl','de-DE'),(5282,'Wirtschaft & Industrie > Friseur- & Kosmetikgewerbe > Salonstühle','de-DE'),(5283,'Wirtschaft & Industrie > Gewerbliche Lagerung','de-DE'),(5284,'Wirtschaft & Industrie > Gewerbliche Lagerung > Frachtcontainer','de-DE'),(5285,'Wirtschaft & Industrie > Gewerbliche Lagerung > Industrieregale','de-DE'),(5286,'Wirtschaft & Industrie > Gewerbliche Lagerung > Industrieschränke','de-DE'),(5287,'Wirtschaft & Industrie > Gewerbliche Lagerung > Zäune, Einfriedungen & Türen','de-DE'),(5288,'Wirtschaft & Industrie > Herstellung','de-DE'),(5289,'Wirtschaft & Industrie > Hotels & Gaststätten','de-DE'),(5290,'Wirtschaft & Industrie > Landwirtschaft','de-DE'),(5291,'Wirtschaft & Industrie > Landwirtschaft > Viehhaltung','de-DE'),(5292,'Wirtschaft & Industrie > Landwirtschaft > Viehhaltung > Brutapparate','de-DE'),(5293,'Wirtschaft & Industrie > Landwirtschaft > Viehhaltung > Viehfutter','de-DE'),(5294,'Wirtschaft & Industrie > Landwirtschaft > Viehhaltung > Viehfutterspender','de-DE'),(5295,'Wirtschaft & Industrie > Landwirtschaft > Viehhaltung > Viehhalfter','de-DE'),(5296,'Wirtschaft & Industrie > Materialbeförderung','de-DE'),(5297,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen','de-DE'),(5298,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen > Flaschenzüge & Rollen','de-DE'),(5299,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen > Hebezüge, Kräne & Laufkatzen','de-DE'),(5300,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen > Hubwagen','de-DE'),(5301,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen > Personenaufzüge','de-DE'),(5302,'Wirtschaft & Industrie > Materialbeförderung > Aufzüge & Hebeeinrichtungen > Seilwinden','de-DE'),(5303,'Wirtschaft & Industrie > Materialbeförderung > Förderanlagen','de-DE'),(5304,'Wirtschaft & Industrie > Materialbeförderung > Paletten & Ladeflächen','de-DE'),(5305,'Wirtschaft & Industrie > Medizinischer Bereich','de-DE'),(5306,'Wirtschaft & Industrie > Medizinischer Bereich > Krankenhaus-Vorhänge','de-DE'),(5307,'Wirtschaft & Industrie > Medizinischer Bereich > Krankenhausbekleidung','de-DE'),(5308,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Bettwäsche','de-DE'),(5309,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte','de-DE'),(5310,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Automatisierte externe Defibrillatoren','de-DE'),(5311,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Medizinische Hebegürtel','de-DE'),(5312,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Otoskope & Ophthalmoskope','de-DE'),(5313,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Patientenlifter','de-DE'),(5314,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Reflexhämmer','de-DE'),(5315,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Stethoskope','de-DE'),(5316,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Tragen','de-DE'),(5317,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Vitaldatenmonitore','de-DE'),(5318,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Geräte > Zubehör für Vitaldatenmonitore','de-DE'),(5319,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Instrumente','de-DE'),(5320,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Instrumente > Chirurgische Nadeln und Fäden','de-DE'),(5321,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Instrumente > Medizinische Zangen','de-DE'),(5322,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Instrumente > Skalpelle','de-DE'),(5323,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Instrumente > Skalpellklingen','de-DE'),(5324,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel','de-DE'),(5325,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Chiropraktische Tische','de-DE'),(5326,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Krankenhaus- und Pflegebetten','de-DE'),(5327,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Medikamentenaufbewahrung','de-DE'),(5328,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Medizinische Wagen','de-DE'),(5329,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Medizinische Wagen > Infusionsständer & -wagen','de-DE'),(5330,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Medizinische Wagen > Reanimationswagen','de-DE'),(5331,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > OP-Tische','de-DE'),(5332,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Möbel > Untersuchungsstühle & -tische','de-DE'),(5333,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Schulungsgeräte','de-DE'),(5334,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinische Schulungsgeräte > HLW-Puppen','de-DE'),(5335,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf','de-DE'),(5336,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf > Einweghandschuhe','de-DE'),(5337,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf > Fingerlinge','de-DE'),(5338,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf > Mundspatel','de-DE'),(5339,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf > Nadeln & Spritzen','de-DE'),(5340,'Wirtschaft & Industrie > Medizinischer Bereich > Medizinischer Bedarf > Stomazubehör','de-DE'),(5341,'Wirtschaft & Industrie > Medizinischer Bereich > OP-Bekleidung','de-DE'),(5342,'Wirtschaft & Industrie > Medizinischer Bereich > OP-Hauben','de-DE'),(5343,'Wirtschaft & Industrie > Medizinischer Bereich > OP-Kittel','de-DE'),(5344,'Wirtschaft & Industrie > Nahrungsmittelservice','de-DE'),(5345,'Wirtschaft & Industrie > Nahrungsmittelservice > Auslagenschutz','de-DE'),(5346,'Wirtschaft & Industrie > Nahrungsmittelservice > Backwarenbehälter','de-DE'),(5347,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweg-Serviergeschirr','de-DE'),(5348,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweg-Serviergeschirr > Einwegtabletts','de-DE'),(5349,'Wirtschaft & Industrie > Nahrungsmittelservice > Einwegbehälter','de-DE'),(5350,'Wirtschaft & Industrie > Nahrungsmittelservice > Einwegdeckel','de-DE'),(5351,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweggeschirr','de-DE'),(5352,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweggeschirr > Einwegbecher','de-DE'),(5353,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweggeschirr > Einwegbesteck','de-DE'),(5354,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweggeschirr > Einwegschüsseln','de-DE'),(5355,'Wirtschaft & Industrie > Nahrungsmittelservice > Einweggeschirr > Einwegteller','de-DE'),(5356,'Wirtschaft & Industrie > Nahrungsmittelservice > Eisbehälter','de-DE'),(5357,'Wirtschaft & Industrie > Nahrungsmittelservice > Gemüseschleudern','de-DE'),(5358,'Wirtschaft & Industrie > Nahrungsmittelservice > Hot-Dog-Grills','de-DE'),(5359,'Wirtschaft & Industrie > Nahrungsmittelservice > Kippbare Industriepfannen','de-DE'),(5360,'Wirtschaft & Industrie > Nahrungsmittelservice > Lebensmittelkörbe','de-DE'),(5361,'Wirtschaft & Industrie > Nahrungsmittelservice > Scheck- & Kartenetuis','de-DE'),(5362,'Wirtschaft & Industrie > Nahrungsmittelservice > Servierwagen','de-DE'),(5363,'Wirtschaft & Industrie > Nahrungsmittelservice > Spülwannen','de-DE'),(5364,'Wirtschaft & Industrie > Nahrungsmittelservice > Takeaway-Behälter','de-DE'),(5365,'Wirtschaft & Industrie > Nahrungsmittelservice > Teller- & Speisenwärmer','de-DE'),(5366,'Wirtschaft & Industrie > Nahrungsmittelservice > Verkaufsautomaten','de-DE'),(5367,'Wirtschaft & Industrie > Piercing & Tätowieren','de-DE'),(5368,'Wirtschaft & Industrie > Piercing & Tätowieren > Piercingbedarf','de-DE'),(5369,'Wirtschaft & Industrie > Piercing & Tätowieren > Piercingbedarf > Piercingnadeln','de-DE'),(5370,'Wirtschaft & Industrie > Piercing & Tätowieren > Tätowierbedarf','de-DE'),(5371,'Wirtschaft & Industrie > Piercing & Tätowieren > Tätowierbedarf > Tattoo-Abdeckungen','de-DE'),(5372,'Wirtschaft & Industrie > Piercing & Tätowieren > Tätowierbedarf > Tätowierfarben','de-DE'),(5373,'Wirtschaft & Industrie > Piercing & Tätowieren > Tätowierbedarf > Tätowiermaschinen','de-DE'),(5374,'Wirtschaft & Industrie > Piercing & Tätowieren > Tätowierbedarf > Tätowiernadeln','de-DE'),(5375,'Wirtschaft & Industrie > Reinigungswagen','de-DE'),(5376,'Wirtschaft & Industrie > Schwermaschinen','de-DE'),(5377,'Wirtschaft & Industrie > Schwermaschinen > Häcksler','de-DE'),(5378,'Wirtschaft & Industrie > Strafverfolgung','de-DE'),(5379,'Wirtschaft & Industrie > Strafverfolgung > Metalldetektoren','de-DE'),(5380,'Wirtschaft & Industrie > Strafverfolgung > Schellen','de-DE'),(5381,'Wirtschaft & Industrie > Werbung & Marketing','de-DE'),(5382,'Wirtschaft & Industrie > Werbung & Marketing > Broschüren','de-DE'),(5383,'Wirtschaft & Industrie > Werbung & Marketing > Messestand-Displays','de-DE'),(5384,'Wirtschaft & Industrie > Werbung & Marketing > Messetheken','de-DE'),(5385,'Wirtschaft & Industrie > Wissenschaft & Labor','de-DE'),(5386,'Wirtschaft & Industrie > Wissenschaft & Labor > Biochemikalien','de-DE'),(5387,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung','de-DE'),(5388,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Autoklaven','de-DE'),(5389,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Gefriertrockenmaschinen','de-DE'),(5390,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Labor-Gefrierschränke','de-DE'),(5391,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Labor-Heizplatten','de-DE'),(5392,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Labormixer','de-DE'),(5393,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Labortrichter','de-DE'),(5394,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Laboröfen','de-DE'),(5395,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskope','de-DE'),(5396,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör','de-DE'),(5397,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör > Ersatzlampen für Mikroskope','de-DE'),(5398,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör > Mikroskop-Objektivlinsen','de-DE'),(5399,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör > Mikroskopkameras','de-DE'),(5400,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör > Mikroskopokulare & Adapter','de-DE'),(5401,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikroskopzubehör > Objektträger','de-DE'),(5402,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Mikrotome','de-DE'),(5403,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Spektrometer','de-DE'),(5404,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Trockeneismaschinen','de-DE'),(5405,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Zentrifugen','de-DE'),(5406,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborausstattung > Zubehör für Spektrometer','de-DE'),(5407,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf','de-DE'),(5408,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Bechergläse','de-DE'),(5409,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Laborkolben','de-DE'),(5410,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Messzylinder','de-DE'),(5411,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Petrischalen','de-DE'),(5412,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Pipetten','de-DE'),(5413,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Reagenzglasständer','de-DE'),(5414,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Reagenzgläser','de-DE'),(5415,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborbedarf > Spritzflaschen','de-DE'),(5416,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborchemikalien','de-DE'),(5417,'Wirtschaft & Industrie > Wissenschaft & Labor > Laborproben','de-DE'),(5418,'Wirtschaft & Industrie > Wissenschaft & Labor > Sezierinstrumente','de-DE'),(5419,'Wirtschaft & Industrie > Zahnmedizin','de-DE'),(5420,'Wirtschaft & Industrie > Zahnmedizin > Prophy-Paste','de-DE'),(5421,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente','de-DE'),(5422,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente > Dappengläser','de-DE'),(5423,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente > Dentalspiegel','de-DE'),(5424,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente > Prophy-Kelche','de-DE'),(5425,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente > Prophy-Köpfe','de-DE'),(5426,'Wirtschaft & Industrie > Zahnmedizin > Zahnmedizinische Instrumente > Zahnmedizinische Instrumentensets','de-DE'),(5427,'Wirtschaft & Industrie > Zahnmedizin > Zahnzement','de-DE'),(5428,'Animals & Pet Supplies','en-AU'),(5429,'Animals & Pet Supplies > Live Animals','en-AU'),(5430,'Animals & Pet Supplies > Pet Supplies','en-AU'),(5431,'Animals & Pet Supplies > Pet Supplies > Bird Supplies','en-AU'),(5432,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Cage Accessories','en-AU'),(5433,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Cage Accessories > Bird Cage Bird Baths','en-AU'),(5434,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Cage Accessories > Bird Cage Food & Water Dishes','en-AU'),(5435,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Cages & Stands','en-AU'),(5436,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Food','en-AU'),(5437,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Gyms & Play Stands','en-AU'),(5438,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Ladders & Perches','en-AU'),(5439,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Toys','en-AU'),(5440,'Animals & Pet Supplies > Pet Supplies > Bird Supplies > Bird Treats','en-AU'),(5441,'Animals & Pet Supplies > Pet Supplies > Cat & Dog Flaps','en-AU'),(5442,'Animals & Pet Supplies > Pet Supplies > Cat Supplies','en-AU'),(5443,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Apparel','en-AU'),(5444,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Beds','en-AU'),(5445,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Food','en-AU'),(5446,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Furniture','en-AU'),(5447,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Furniture Accessories','en-AU'),(5448,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Litter','en-AU'),(5449,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Litter Box Liners','en-AU'),(5450,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Litter Box Mats','en-AU'),(5451,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Litter Trays','en-AU'),(5452,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Toys','en-AU'),(5453,'Animals & Pet Supplies > Pet Supplies > Cat Supplies > Cat Treats','en-AU'),(5454,'Animals & Pet Supplies > Pet Supplies > Dog Supplies','en-AU'),(5455,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Apparel','en-AU'),(5456,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Beds','en-AU'),(5457,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Food','en-AU'),(5458,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Houses','en-AU'),(5459,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Kennel & Run Accessories','en-AU'),(5460,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Kennels & Runs','en-AU'),(5461,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Nappies','en-AU'),(5462,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Nappy Pads & Liners','en-AU'),(5463,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Toys','en-AU'),(5464,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Treadmills','en-AU'),(5465,'Animals & Pet Supplies > Pet Supplies > Dog Supplies > Dog Treats','en-AU'),(5466,'Animals & Pet Supplies > Pet Supplies > Fish Supplies','en-AU'),(5467,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium & Pond Tubing','en-AU'),(5468,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Air Stones & Diffusers','en-AU'),(5469,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Cleaning Supplies','en-AU'),(5470,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Decor','en-AU'),(5471,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Filters','en-AU'),(5472,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Fish Nets','en-AU'),(5473,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Gravel & Substrates','en-AU'),(5474,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Lighting','en-AU'),(5475,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Overflow Boxes','en-AU'),(5476,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Stands','en-AU'),(5477,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Temperature Controllers','en-AU'),(5478,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquarium Water Treatments','en-AU'),(5479,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquariums','en-AU'),(5480,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Aquatic Plant Fertilisers','en-AU'),(5481,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Fish Feeders','en-AU'),(5482,'Animals & Pet Supplies > Pet Supplies > Fish Supplies > Fish Food','en-AU'),(5483,'Animals & Pet Supplies > Pet Supplies > Pet Agility Equipment','en-AU'),(5484,'Animals & Pet Supplies > Pet Supplies > Pet Bed Accessories','en-AU'),(5485,'Animals & Pet Supplies > Pet Supplies > Pet Bells & Charms','en-AU'),(5486,'Animals & Pet Supplies > Pet Supplies > Pet Biometric Monitors','en-AU'),(5487,'Animals & Pet Supplies > Pet Supplies > Pet Biometric Monitors > Pet Glucose Meters','en-AU'),(5488,'Animals & Pet Supplies > Pet Supplies > Pet Biometric Monitors > Pet Pedometers','en-AU'),(5489,'Animals & Pet Supplies > Pet Supplies > Pet Biometric Monitors > Pet Thermometers','en-AU'),(5490,'Animals & Pet Supplies > Pet Supplies > Pet Bowl Mats','en-AU'),(5491,'Animals & Pet Supplies > Pet Supplies > Pet Bowl Stands','en-AU'),(5492,'Animals & Pet Supplies > Pet Supplies > Pet Bowls, Feeders & Waterers','en-AU'),(5493,'Animals & Pet Supplies > Pet Supplies > Pet Carrier & Crate Accessories','en-AU'),(5494,'Animals & Pet Supplies > Pet Supplies > Pet Carriers & Crates','en-AU'),(5495,'Animals & Pet Supplies > Pet Supplies > Pet Clothing Hangers','en-AU'),(5496,'Animals & Pet Supplies > Pet Supplies > Pet Collars & Harnesses','en-AU'),(5497,'Animals & Pet Supplies > Pet Supplies > Pet Containment Systems','en-AU'),(5498,'Animals & Pet Supplies > Pet Supplies > Pet Door Accessories','en-AU'),(5499,'Animals & Pet Supplies > Pet Supplies > Pet Eye Drops & Lubricants','en-AU'),(5500,'Animals & Pet Supplies > Pet Supplies > Pet First Aid & Emergency Kits','en-AU'),(5501,'Animals & Pet Supplies > Pet Supplies > Pet Flea & Tick Control','en-AU'),(5502,'Animals & Pet Supplies > Pet Supplies > Pet Food Containers','en-AU'),(5503,'Animals & Pet Supplies > Pet Supplies > Pet Food Scoops','en-AU'),(5504,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies','en-AU'),(5505,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Combs & Brushes','en-AU'),(5506,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Fragrances & Deodorising Sprays','en-AU'),(5507,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Hair Dryers','en-AU'),(5508,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Hair Trimmers','en-AU'),(5509,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Nail Polish','en-AU'),(5510,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Nail Tools','en-AU'),(5511,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Shampoo & Conditioner','en-AU'),(5512,'Animals & Pet Supplies > Pet Supplies > Pet Grooming Supplies > Pet Wipes','en-AU'),(5513,'Animals & Pet Supplies > Pet Supplies > Pet Heating Pad Accessories','en-AU'),(5514,'Animals & Pet Supplies > Pet Supplies > Pet Heating Pads','en-AU'),(5515,'Animals & Pet Supplies > Pet Supplies > Pet ID Tags','en-AU'),(5516,'Animals & Pet Supplies > Pet Supplies > Pet Lead Extensions','en-AU'),(5517,'Animals & Pet Supplies > Pet Supplies > Pet Leads','en-AU'),(5518,'Animals & Pet Supplies > Pet Supplies > Pet Medical Collars','en-AU'),(5519,'Animals & Pet Supplies > Pet Supplies > Pet Medical Tape & Bandages','en-AU'),(5520,'Animals & Pet Supplies > Pet Supplies > Pet Medicine','en-AU'),(5521,'Animals & Pet Supplies > Pet Supplies > Pet Muzzles','en-AU'),(5522,'Animals & Pet Supplies > Pet Supplies > Pet Oral Care Supplies','en-AU'),(5523,'Animals & Pet Supplies > Pet Supplies > Pet Playpens','en-AU'),(5524,'Animals & Pet Supplies > Pet Supplies > Pet Pushchairs & Strollers','en-AU'),(5525,'Animals & Pet Supplies > Pet Supplies > Pet Steps & Ramps','en-AU'),(5526,'Animals & Pet Supplies > Pet Supplies > Pet Sun Cream','en-AU'),(5527,'Animals & Pet Supplies > Pet Supplies > Pet Training Aids','en-AU'),(5528,'Animals & Pet Supplies > Pet Supplies > Pet Training Aids > Pet Training Clickers & Treat Dispensers','en-AU'),(5529,'Animals & Pet Supplies > Pet Supplies > Pet Training Aids > Pet Training Pad Holders','en-AU'),(5530,'Animals & Pet Supplies > Pet Supplies > Pet Training Aids > Pet Training Pads','en-AU'),(5531,'Animals & Pet Supplies > Pet Supplies > Pet Training Aids > Pet Training Sprays & Solutions','en-AU'),(5532,'Animals & Pet Supplies > Pet Supplies > Pet Vitamins & Supplements','en-AU'),(5533,'Animals & Pet Supplies > Pet Supplies > Pet Waste Bag Dispensers & Holders','en-AU'),(5534,'Animals & Pet Supplies > Pet Supplies > Pet Waste Bags','en-AU'),(5535,'Animals & Pet Supplies > Pet Supplies > Pet Waste Disposal Systems & Tools','en-AU'),(5536,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies','en-AU'),(5537,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies > Reptile & Amphibian Food','en-AU'),(5538,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies > Reptile & Amphibian Habitat Accessories','en-AU'),(5539,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies > Reptile & Amphibian Habitat Heating & Lighting','en-AU'),(5540,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies > Reptile & Amphibian Habitats','en-AU'),(5541,'Animals & Pet Supplies > Pet Supplies > Reptile & Amphibian Supplies > Reptile & Amphibian Substrates','en-AU'),(5542,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies','en-AU'),(5543,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies > Small Animal Bedding','en-AU'),(5544,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies > Small Animal Food','en-AU'),(5545,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies > Small Animal Habitat Accessories','en-AU'),(5546,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies > Small Animal Habitats & Cages','en-AU'),(5547,'Animals & Pet Supplies > Pet Supplies > Small Animal Supplies > Small Animal Treats','en-AU'),(5548,'Animals & Pet Supplies > Pet Supplies > Vehicle Pet Barriers','en-AU'),(5549,'Arts & Entertainment','en-AU'),(5550,'Arts & Entertainment > Event Tickets','en-AU'),(5551,'Arts & Entertainment > Hobbies & Creative Arts','en-AU'),(5552,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts','en-AU'),(5553,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits','en-AU'),(5554,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Candle Making Kits','en-AU'),(5555,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Drawing & Painting Kits','en-AU'),(5556,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Fabric Repair Kits','en-AU'),(5557,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Incense Making Kits','en-AU'),(5558,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Jewellery Making Kits','en-AU'),(5559,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Mosaic Kits','en-AU'),(5560,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Needlecraft Kits','en-AU'),(5561,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Scrapbooking & Stamping Kits','en-AU'),(5562,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Craft Kits > Toy Craft Kits','en-AU'),(5563,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials','en-AU'),(5564,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper','en-AU'),(5565,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Cardstock & Scrapbooking Paper','en-AU'),(5566,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Construction Paper','en-AU'),(5567,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Craft Foil','en-AU'),(5568,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Drawing & Painting Paper','en-AU'),(5569,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Origami Paper','en-AU'),(5570,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Transfer Paper','en-AU'),(5571,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Art & Craft Paper > Vellum Paper','en-AU'),(5572,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures','en-AU'),(5573,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Buttons & Snaps','en-AU'),(5574,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Clasps & Hooks','en-AU'),(5575,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Eyelets & Grommets','en-AU'),(5576,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Hook & Loop Fasteners','en-AU'),(5577,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Zip Pulls','en-AU'),(5578,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Fasteners & Closures > Zips','en-AU'),(5579,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze','en-AU'),(5580,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Art & Craft Paint','en-AU'),(5581,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Art Fixatives','en-AU'),(5582,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Art Ink','en-AU'),(5583,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Ceramic & Pottery Glazes','en-AU'),(5584,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Craft Dyes','en-AU'),(5585,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Ink Pads','en-AU'),(5586,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Paint, Ink & Glaze > Paint Mediums','en-AU'),(5587,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Shapes & Bases','en-AU'),(5588,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Shapes & Bases > Craft Foam & Polystyrene Foam','en-AU'),(5589,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Shapes & Bases > Craft Wood & Shapes','en-AU'),(5590,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Shapes & Bases > Papier Mache Shapes','en-AU'),(5591,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Craft Shapes & Bases > Wreath & Floral Frames','en-AU'),(5592,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets','en-AU'),(5593,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets > Craft & Office Glue','en-AU'),(5594,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets > Craft Magnets','en-AU'),(5595,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets > Decorative Tape','en-AU'),(5596,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets > Floral Tape','en-AU'),(5597,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Adhesives & Magnets > Fusible Tape','en-AU'),(5598,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Fibres','en-AU'),(5599,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Fibres > Jewellery & Beading Cord','en-AU'),(5600,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Fibres > Thread & Floss','en-AU'),(5601,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Fibres > Unspun Fibre','en-AU'),(5602,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Fibres > Yarn','en-AU'),(5603,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Wire','en-AU'),(5604,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Wire > Craft Pipe Cleaners','en-AU'),(5605,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Wire > Floral Wire','en-AU'),(5606,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Crafting Wire > Jewellery & Beading Wire','en-AU'),(5607,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims','en-AU'),(5608,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Appliques & Patches','en-AU'),(5609,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Beads','en-AU'),(5610,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Bows & Yo-Yos','en-AU'),(5611,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Decorative Stickers','en-AU'),(5612,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Elastic','en-AU'),(5613,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Feathers','en-AU'),(5614,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Jewellery Findings','en-AU'),(5615,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Loose Stones','en-AU'),(5616,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Rhinestones & Flatbacks','en-AU'),(5617,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Ribbons & Trim','en-AU'),(5618,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Sequins & Glitter','en-AU'),(5619,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embellishments & Trims > Sew-in Labels','en-AU'),(5620,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Embossing Powder','en-AU'),(5621,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Filling & Padding Material','en-AU'),(5622,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Filling & Padding Material > Batting & Stuffing','en-AU'),(5623,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Filling & Padding Material > Filling Pellets','en-AU'),(5624,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Filling & Padding Material > Pillow Forms','en-AU'),(5625,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Leather & Vinyl','en-AU'),(5626,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Pottery & Sculpting Materials','en-AU'),(5627,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Pottery & Sculpting Materials > Clay & Modelling Dough','en-AU'),(5628,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Pottery & Sculpting Materials > Papier Mache Mixes','en-AU'),(5629,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Pottery & Sculpting Materials > Plaster Gauze','en-AU'),(5630,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Pottery & Sculpting Materials > Pottery Slips','en-AU'),(5631,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Raw Candle Wax','en-AU'),(5632,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles','en-AU'),(5633,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Crafting Canvas','en-AU'),(5634,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Crafting Canvas > Needlecraft Canvas','en-AU'),(5635,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Crafting Canvas > Painting Canvas','en-AU'),(5636,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Crafting Canvas > Plastic Canvas','en-AU'),(5637,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Fabric','en-AU'),(5638,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Interfacing','en-AU'),(5639,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Textiles > Printable Fabric','en-AU'),(5640,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Wick Tabs','en-AU'),(5641,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Materials > Wicks','en-AU'),(5642,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories','en-AU'),(5643,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Craft Knife Blades','en-AU'),(5644,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Craft Machine Cases & Covers','en-AU'),(5645,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Sewing Machine Extension Tables','en-AU'),(5646,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Sewing Machine Feet','en-AU'),(5647,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Sewing Machine Replacement Parts','en-AU'),(5648,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Spinning Wheel Accessories','en-AU'),(5649,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tool Accessories > Stamp Blocks','en-AU'),(5650,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools','en-AU'),(5651,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Blocking Mats','en-AU'),(5652,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Blocking Wires','en-AU'),(5653,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Colour Mixing Tools','en-AU'),(5654,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Colour Mixing Tools > Palette Knives','en-AU'),(5655,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Colour Mixing Tools > Palettes','en-AU'),(5656,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools','en-AU'),(5657,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Craft & Office Scissors','en-AU'),(5658,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Craft Cutters & Embossers','en-AU'),(5659,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Craft Knives','en-AU'),(5660,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Craft Scoring Tools','en-AU'),(5661,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Embossing Heat Tools','en-AU'),(5662,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Embossing Pens & Styluses','en-AU'),(5663,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Seam Rippers','en-AU'),(5664,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Cutting & Embossing Tools > Thread & Yarn Cutters','en-AU'),(5665,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Decoration Makers','en-AU'),(5666,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools','en-AU'),(5667,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Art Brushes','en-AU'),(5668,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Brayer Rollers','en-AU'),(5669,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Decorative Stamps','en-AU'),(5670,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Drafting Compasses','en-AU'),(5671,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Screen Printing Squeegees','en-AU'),(5672,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Stencil Machines','en-AU'),(5673,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Stencils & Die Cuts','en-AU'),(5674,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Stitch Markers & Counters','en-AU'),(5675,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Textile Art Gauges & Rulers','en-AU'),(5676,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Craft Measuring & Marking Tools > Wood Burning Tools','en-AU'),(5677,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Cutting Mats','en-AU'),(5678,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Dress Forms','en-AU'),(5679,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Felting Pads & Mats','en-AU'),(5680,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Frames, Hoops & Stretchers','en-AU'),(5681,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Glue Guns','en-AU'),(5682,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Light Boxes','en-AU'),(5683,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks','en-AU'),(5684,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks > Crochet Hooks','en-AU'),(5685,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks > Hand-Sewing Needles','en-AU'),(5686,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks > Knitting Needles','en-AU'),(5687,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks > Latch & Locker Hooks','en-AU'),(5688,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Needles & Hooks > Sewing Machine Needles','en-AU'),(5689,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Safety Pins','en-AU'),(5690,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Straight Pins','en-AU'),(5691,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines','en-AU'),(5692,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines > Felting Needles & Machines','en-AU'),(5693,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines > Hand Looms','en-AU'),(5694,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines > Mechanical Looms','en-AU'),(5695,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines > Sewing Machines','en-AU'),(5696,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Textile Craft Machines > Spinning Wheels','en-AU'),(5697,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thimbles & Sewing Palms','en-AU'),(5698,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools','en-AU'),(5699,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Fibre Cards & Brushes','en-AU'),(5700,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Hand Spindles','en-AU'),(5701,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Needle Threaders','en-AU'),(5702,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Thread & Yarn Guides','en-AU'),(5703,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Thread & Yarn Spools','en-AU'),(5704,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Thread, Yarn & Bobbin Winders','en-AU'),(5705,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Weaving Beaters','en-AU'),(5706,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Art & Crafting Tools > Thread & Yarn Tools > Weaving Shuttles','en-AU'),(5707,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Craft Organisation','en-AU'),(5708,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Craft Organisation > Needle, Pin & Hook Organisers','en-AU'),(5709,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Craft Organisation > Sewing & Textile Art Kits','en-AU'),(5710,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Craft Organisation > Thread & Yarn Organisers','en-AU'),(5711,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds','en-AU'),(5712,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds > Beading Patterns','en-AU'),(5713,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds > Craft Moulds','en-AU'),(5714,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds > Felting Moulds','en-AU'),(5715,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds > Needlecraft Patterns','en-AU'),(5716,'Arts & Entertainment > Hobbies & Creative Arts > Arts & Crafts > Crafting Patterns & Moulds > Sewing Patterns','en-AU'),(5717,'Arts & Entertainment > Hobbies & Creative Arts > Collectables','en-AU'),(5718,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Autographs','en-AU'),(5719,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Coins & Currency','en-AU'),(5720,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Weapons','en-AU'),(5721,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Weapons > Collectable Knives','en-AU'),(5722,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Weapons > Collectable Swords','en-AU'),(5723,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Weapons > Collectible Guns','en-AU'),(5724,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectable Weapons > Sword Stands & Displays','en-AU'),(5725,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Collectible Trading Cards','en-AU'),(5726,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Postage Stamps','en-AU'),(5727,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Rocks & Fossils','en-AU'),(5728,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Scale Model Accessories','en-AU'),(5729,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Scale Models','en-AU'),(5730,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Seal Stamps','en-AU'),(5731,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables','en-AU'),(5732,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia','en-AU'),(5733,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > American Football Autographed Paraphernalia','en-AU'),(5734,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Auto Racing Autographed Paraphernalia','en-AU'),(5735,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Baseball & Softball Autographed Paraphernalia','en-AU'),(5736,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Basketball Autographed Paraphernalia','en-AU'),(5737,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Boxing Autographed Paraphernalia','en-AU'),(5738,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Football Autographed Paraphernalia','en-AU'),(5739,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Hockey Autographed Paraphernalia','en-AU'),(5740,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Autographed Sports Paraphernalia > Tennis Autographed Sports Paraphernalia','en-AU'),(5741,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories','en-AU'),(5742,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > American Football Fan Accessories','en-AU'),(5743,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Auto Racing Fan Accessories','en-AU'),(5744,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Baseball & Softball Fan Accessories','en-AU'),(5745,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Basketball Fan Accessories','en-AU'),(5746,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Football Fan Accessories','en-AU'),(5747,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Hockey Fan Accessories','en-AU'),(5748,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Sports Collectables > Sports Fan Accessories > Tennis Fan Accessories','en-AU'),(5749,'Arts & Entertainment > Hobbies & Creative Arts > Collectables > Vintage Advertisements','en-AU'),(5750,'Arts & Entertainment > Hobbies & Creative Arts > Homebrewing & Winemaking Supplies','en-AU'),(5751,'Arts & Entertainment > Hobbies & Creative Arts > Homebrewing & Winemaking Supplies > Beer Brewing Grains & Malts','en-AU'),(5752,'Arts & Entertainment > Hobbies & Creative Arts > Homebrewing & Winemaking Supplies > Bottling Bottles','en-AU'),(5753,'Arts & Entertainment > Hobbies & Creative Arts > Homebrewing & Winemaking Supplies > Home Brewing & Winemaking Kits','en-AU'),(5754,'Arts & Entertainment > Hobbies & Creative Arts > Homebrewing & Winemaking Supplies > Wine Making','en-AU'),(5755,'Arts & Entertainment > Hobbies & Creative Arts > Juggling','en-AU'),(5756,'Arts & Entertainment > Hobbies & Creative Arts > Magic & Novelties','en-AU'),(5757,'Arts & Entertainment > Hobbies & Creative Arts > Model Making','en-AU'),(5758,'Arts & Entertainment > Hobbies & Creative Arts > Model Making > Model Rocketry','en-AU'),(5759,'Arts & Entertainment > Hobbies & Creative Arts > Model Making > Model Train Accessories','en-AU'),(5760,'Arts & Entertainment > Hobbies & Creative Arts > Model Making > Model Trains & Train Sets','en-AU'),(5761,'Arts & Entertainment > Hobbies & Creative Arts > Model Making > Scale Model Kits','en-AU'),(5762,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories','en-AU'),(5763,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories','en-AU'),(5764,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass Instrument Cases & Gigbags','en-AU'),(5765,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass Instrument Mouthpieces','en-AU'),(5766,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass Instrument Mutes','en-AU'),(5767,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass Instrument Replacement Parts','en-AU'),(5768,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass Instrument Straps & Stands','en-AU'),(5769,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning','en-AU'),(5770,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass Instrument Care Kits','en-AU'),(5771,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass Instrument Cleaners & Sanitisers','en-AU'),(5772,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass Instrument Cleaning Tools','en-AU'),(5773,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass Instrument Lubricants','en-AU'),(5774,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass Instrument Polishing Cloths','en-AU'),(5775,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Brass Instrument Accessories > Brass-Instrument Care & Cleaning > Brass-Instrument Guards','en-AU'),(5776,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Conductor Batons','en-AU'),(5777,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Electronic Tuners','en-AU'),(5778,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Metronomes','en-AU'),(5779,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Benches & Stools','en-AU'),(5780,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Lyres & Flip Folders','en-AU'),(5781,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Stand Accessories','en-AU'),(5782,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Stand Accessories > Music Stand Bags','en-AU'),(5783,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Stand Accessories > Music Stand Lights','en-AU'),(5784,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Stand Accessories > Sheet Music Clips','en-AU'),(5785,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Music Stands','en-AU'),(5786,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories','en-AU'),(5787,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Cabinets','en-AU'),(5788,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Covers','en-AU'),(5789,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Foot Switches','en-AU'),(5790,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Knobs','en-AU'),(5791,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Stands','en-AU'),(5792,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifier Accessories > Musical Instrument Amplifier Tubes','en-AU'),(5793,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Instrument Amplifiers','en-AU'),(5794,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Keyboard Accessories','en-AU'),(5795,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Keyboard Accessories > Musical Keyboard Bags & Cases','en-AU'),(5796,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Keyboard Accessories > Musical Keyboard Stands','en-AU'),(5797,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Musical Keyboard Accessories > Sustain Pedals','en-AU'),(5798,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories','en-AU'),(5799,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Cymbal & Drum Cases','en-AU'),(5800,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Cymbal & Drum Mutes','en-AU'),(5801,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Heads','en-AU'),(5802,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Keys','en-AU'),(5803,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Kit Hardware','en-AU'),(5804,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Kit Hardware > Bass Drum Beaters','en-AU'),(5805,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Kit Hardware > Drum Kit Mounting Hardware','en-AU'),(5806,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Kit Hardware > Drum Pedals','en-AU'),(5807,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Stick & Brush Accessories','en-AU'),(5808,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Stick & Brush Accessories > Drum Stick & Brush Bags & Holders','en-AU'),(5809,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Drum Sticks & Brushes','en-AU'),(5810,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Electronic Drum Modules','en-AU'),(5811,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Hand Percussion Accessories','en-AU'),(5812,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Hand Percussion Accessories > Hand Percussion Bags & Cases','en-AU'),(5813,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Hand Percussion Accessories > Hand Percussion Stands & Mounts','en-AU'),(5814,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Percussion Mallets','en-AU'),(5815,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Percussion Accessories > Percussion Stands','en-AU'),(5816,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories','en-AU'),(5817,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories','en-AU'),(5818,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Acoustic Guitar Pickups','en-AU'),(5819,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Capos','en-AU'),(5820,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Electric Guitar Pickups','en-AU'),(5821,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Cases & Gig Bags','en-AU'),(5822,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Fittings & Parts','en-AU'),(5823,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Humidifiers','en-AU'),(5824,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Picks','en-AU'),(5825,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Slides','en-AU'),(5826,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Stands','en-AU'),(5827,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Straps','en-AU'),(5828,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar String Winders','en-AU'),(5829,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Strings','en-AU'),(5830,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Guitar Accessories > Guitar Tuning Pegs','en-AU'),(5831,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories','en-AU'),(5832,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Bow Cases','en-AU'),(5833,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Bows','en-AU'),(5834,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Cases','en-AU'),(5835,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Fittings & Parts','en-AU'),(5836,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Mutes','en-AU'),(5837,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Pickups','en-AU'),(5838,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Stands','en-AU'),(5839,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > Orchestral String Instrument Accessories > Orchestral String Instrument Strings','en-AU'),(5840,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > String Instrument Care & Cleaning','en-AU'),(5841,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > String Instrument Care & Cleaning > Bow Rosin','en-AU'),(5842,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > String Instrument Care & Cleaning > String Instrument Cleaning Cloths','en-AU'),(5843,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > String Instrument Accessories > String Instrument Care & Cleaning > String Instrument Polish','en-AU'),(5844,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories','en-AU'),(5845,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories','en-AU'),(5846,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Care & Cleaning','en-AU'),(5847,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Care & Cleaning > Bassoon Swabs','en-AU'),(5848,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Cases & Gig Bags','en-AU'),(5849,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Parts','en-AU'),(5850,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Parts > Bassoon Bocals','en-AU'),(5851,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Parts > Bassoon Small Parts','en-AU'),(5852,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Reeds','en-AU'),(5853,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Stands','en-AU'),(5854,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Bassoon Accessories > Bassoon Straps & Supports','en-AU'),(5855,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories','en-AU'),(5856,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Care & Cleaning','en-AU'),(5857,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Care & Cleaning > Clarinet Care Kits','en-AU'),(5858,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Care & Cleaning > Clarinet Pad Savers','en-AU'),(5859,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Care & Cleaning > Clarinet Swabs','en-AU'),(5860,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Cases & Gig Bags','en-AU'),(5861,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Ligatures & Caps','en-AU'),(5862,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Parts','en-AU'),(5863,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Parts > Clarinet Barrels','en-AU'),(5864,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Parts > Clarinet Bells','en-AU'),(5865,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Parts > Clarinet Mouthpieces','en-AU'),(5866,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Parts > Clarinet Small Parts','en-AU'),(5867,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Pegs & Stands','en-AU'),(5868,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Reeds','en-AU'),(5869,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Clarinet Accessories > Clarinet Straps & Supports','en-AU'),(5870,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories','en-AU'),(5871,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Care & Cleaning','en-AU'),(5872,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Care & Cleaning > Flute Care Kits','en-AU'),(5873,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Care & Cleaning > Flute Cleaning Rods','en-AU'),(5874,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Care & Cleaning > Flute Swabs','en-AU'),(5875,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Cases & Gig Bags','en-AU'),(5876,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Parts','en-AU'),(5877,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Parts > Flute Head Joints','en-AU'),(5878,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Parts > Flute Small Parts','en-AU'),(5879,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Flute Accessories > Flute Pegs & Stands','en-AU'),(5880,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Harmonica Accessories','en-AU'),(5881,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Harmonica Accessories > Harmonica Cases','en-AU'),(5882,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Harmonica Accessories > Harmonica Holders','en-AU'),(5883,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories','en-AU'),(5884,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Care & Cleaning','en-AU'),(5885,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Care & Cleaning > Oboe Care Kits','en-AU'),(5886,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Care & Cleaning > Oboe Swabs','en-AU'),(5887,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Cases & Gig Bags','en-AU'),(5888,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Parts','en-AU'),(5889,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Parts > Oboe Small Parts','en-AU'),(5890,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Pegs & Stands','en-AU'),(5891,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Reeds','en-AU'),(5892,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Oboe Accessories > Oboe Straps & Supports','en-AU'),(5893,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Recorder Accessories','en-AU'),(5894,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Recorder Accessories > Recorder Care & Cleaning','en-AU'),(5895,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Recorder Accessories > Recorder Cases','en-AU'),(5896,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Recorder Accessories > Recorder Parts','en-AU'),(5897,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories','en-AU'),(5898,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Care & Cleaning','en-AU'),(5899,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Care & Cleaning > Saxophone Care Kits','en-AU'),(5900,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Care & Cleaning > Saxophone Pad Savers','en-AU'),(5901,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Care & Cleaning > Saxophone Swabs','en-AU'),(5902,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Cases & Gig Bags','en-AU'),(5903,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Ligatures & Caps','en-AU'),(5904,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Parts','en-AU'),(5905,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Parts > Saxophone Mouthpieces','en-AU'),(5906,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Parts > Saxophone Necks','en-AU'),(5907,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Parts > Saxophone Small Parts','en-AU'),(5908,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Pegs & Stands','en-AU'),(5909,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Reeds','en-AU'),(5910,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Saxophone Accessories > Saxophone Straps & Supports','en-AU'),(5911,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Woodwind Cork Grease','en-AU'),(5912,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Woodwind Polishing Cloths','en-AU'),(5913,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Woodwind Reed Cases','en-AU'),(5914,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instrument & Orchestra Accessories > Woodwind Instrument Accessories > Woodwind Reed Knives','en-AU'),(5915,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments','en-AU'),(5916,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Accordions & Concertinas','en-AU'),(5917,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Bagpipes','en-AU'),(5918,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments','en-AU'),(5919,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > Alto & Baritone Horns','en-AU'),(5920,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > Euphoniums','en-AU'),(5921,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > French Horns','en-AU'),(5922,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > Trombones','en-AU'),(5923,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > Trumpets & Cornets','en-AU'),(5924,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Brass Instruments > Tubas','en-AU'),(5925,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Electronic Musical Instruments','en-AU'),(5926,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Electronic Musical Instruments > Audio Samplers','en-AU'),(5927,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Electronic Musical Instruments > MIDI Controllers','en-AU'),(5928,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Electronic Musical Instruments > Musical Keyboards','en-AU'),(5929,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Electronic Musical Instruments > Sound Synthesizers','en-AU'),(5930,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion','en-AU'),(5931,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Bass Drums','en-AU'),(5932,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Cymbals','en-AU'),(5933,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Drum Kits','en-AU'),(5934,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Electronic Drums','en-AU'),(5935,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Glockenspiels & Xylophones','en-AU'),(5936,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Gongs','en-AU'),(5937,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion','en-AU'),(5938,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Claves & Castanets','en-AU'),(5939,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Finger & Hand Cymbals','en-AU'),(5940,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Bells & Chimes','en-AU'),(5941,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums','en-AU'),(5942,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Bongos','en-AU'),(5943,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Cajons','en-AU'),(5944,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Congas','en-AU'),(5945,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Frame Drums','en-AU'),(5946,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Goblet Drums','en-AU'),(5947,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Tablas','en-AU'),(5948,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Hand Drums > Talking Drums','en-AU'),(5949,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Musical Blocks','en-AU'),(5950,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Musical Cowbells','en-AU'),(5951,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Musical Scrapers & Ratchets','en-AU'),(5952,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Musical Shakers','en-AU'),(5953,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Musical Triangles','en-AU'),(5954,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Tambourines','en-AU'),(5955,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hand Percussion > Vibraslaps','en-AU'),(5956,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Hi-Hats','en-AU'),(5957,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Practice Pads','en-AU'),(5958,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Snare Drums','en-AU'),(5959,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Percussion > Tom-Toms','en-AU'),(5960,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Pianos','en-AU'),(5961,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments','en-AU'),(5962,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Cellos','en-AU'),(5963,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Guitars','en-AU'),(5964,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Harps','en-AU'),(5965,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Upright Basses','en-AU'),(5966,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Violas','en-AU'),(5967,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > String Instruments > Violins','en-AU'),(5968,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds','en-AU'),(5969,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Bassoons','en-AU'),(5970,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Clarinets','en-AU'),(5971,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Flutes','en-AU'),(5972,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Flutophones','en-AU'),(5973,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Harmonicas','en-AU'),(5974,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Jew\'s Harps','en-AU'),(5975,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Melodicas','en-AU'),(5976,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Musical Pipes','en-AU'),(5977,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Oboes','en-AU'),(5978,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Ocarinas','en-AU'),(5979,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Recorders','en-AU'),(5980,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Saxophones','en-AU'),(5981,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Tin Whistles','en-AU'),(5982,'Arts & Entertainment > Hobbies & Creative Arts > Musical Instruments > Woodwinds > Train Whistles','en-AU'),(5983,'Arts & Entertainment > Party & Celebration','en-AU'),(5984,'Arts & Entertainment > Party & Celebration > Gift Giving','en-AU'),(5985,'Arts & Entertainment > Party & Celebration > Gift Giving > Corsage & Boutonnière Pins','en-AU'),(5986,'Arts & Entertainment > Party & Celebration > Gift Giving > Corsages & Boutonnières','en-AU'),(5987,'Arts & Entertainment > Party & Celebration > Gift Giving > Fresh Cut Flowers','en-AU'),(5988,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Cards & Certificates','en-AU'),(5989,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping','en-AU'),(5990,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping > Gift Bags','en-AU'),(5991,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping > Gift Boxes and Tins','en-AU'),(5992,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping > Gift Tags & Labels','en-AU'),(5993,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping > Tissue Paper','en-AU'),(5994,'Arts & Entertainment > Party & Celebration > Gift Giving > Gift Wrapping > Wrapping Paper','en-AU'),(5995,'Arts & Entertainment > Party & Celebration > Gift Giving > Greeting & Note Cards','en-AU'),(5996,'Arts & Entertainment > Party & Celebration > Party Supplies','en-AU'),(5997,'Arts & Entertainment > Party & Celebration > Party Supplies > Advice Cards','en-AU'),(5998,'Arts & Entertainment > Party & Celebration > Party Supplies > Balloon Kits','en-AU'),(5999,'Arts & Entertainment > Party & Celebration > Party Supplies > Balloons','en-AU'),(6000,'Arts & Entertainment > Party & Celebration > Party Supplies > Banners','en-AU'),(6001,'Arts & Entertainment > Party & Celebration > Party Supplies > Birthday Candles','en-AU'),(6002,'Arts & Entertainment > Party & Celebration > Party Supplies > Chair Sashes','en-AU'),(6003,'Arts & Entertainment > Party & Celebration > Party Supplies > Cocktail Decorations','en-AU'),(6004,'Arts & Entertainment > Party & Celebration > Party Supplies > Confetti','en-AU'),(6005,'Arts & Entertainment > Party & Celebration > Party Supplies > Decorative Pom-Poms','en-AU'),(6006,'Arts & Entertainment > Party & Celebration > Party Supplies > Drinking Games','en-AU'),(6007,'Arts & Entertainment > Party & Celebration > Party Supplies > Drinking Games > Beer Pong','en-AU'),(6008,'Arts & Entertainment > Party & Celebration > Party Supplies > Drinking Games > Beer Pong > Beer Pong Tables','en-AU'),(6009,'Arts & Entertainment > Party & Celebration > Party Supplies > Drinking Straws & Stirrers','en-AU'),(6010,'Arts & Entertainment > Party & Celebration > Party Supplies > Envelope Seals','en-AU'),(6011,'Arts & Entertainment > Party & Celebration > Party Supplies > Event Programmes','en-AU'),(6012,'Arts & Entertainment > Party & Celebration > Party Supplies > Fireworks & Firecrackers','en-AU'),(6013,'Arts & Entertainment > Party & Celebration > Party Supplies > Inflatable Party Decorations','en-AU'),(6014,'Arts & Entertainment > Party & Celebration > Party Supplies > Invitations','en-AU'),(6015,'Arts & Entertainment > Party & Celebration > Party Supplies > Noisemakers & Party Blowers','en-AU'),(6016,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Favours','en-AU'),(6017,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Favours > Wedding Favours','en-AU'),(6018,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Games','en-AU'),(6019,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Hats','en-AU'),(6020,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Streamers & Curtains','en-AU'),(6021,'Arts & Entertainment > Party & Celebration > Party Supplies > Party Supply Kits','en-AU'),(6022,'Arts & Entertainment > Party & Celebration > Party Supplies > Piñatas','en-AU'),(6023,'Arts & Entertainment > Party & Celebration > Party Supplies > Place Card Holders','en-AU'),(6024,'Arts & Entertainment > Party & Celebration > Party Supplies > Place Cards','en-AU'),(6025,'Arts & Entertainment > Party & Celebration > Party Supplies > Response Cards','en-AU'),(6026,'Arts & Entertainment > Party & Celebration > Party Supplies > Sparklers','en-AU'),(6027,'Arts & Entertainment > Party & Celebration > Party Supplies > Special Occasion Card Boxes & Holders','en-AU'),(6028,'Arts & Entertainment > Party & Celebration > Party Supplies > Spray String','en-AU'),(6029,'Arts & Entertainment > Party & Celebration > Trophies & Awards','en-AU'),(6030,'Arts & Entertainment > Party & Celebration > Visual Effects','en-AU'),(6031,'Arts & Entertainment > Party & Celebration > Visual Effects > Disco Balls','en-AU'),(6032,'Arts & Entertainment > Party & Celebration > Visual Effects > Fog Machines','en-AU'),(6033,'Arts & Entertainment > Party & Celebration > Visual Effects > Special Effects Controllers','en-AU'),(6034,'Arts & Entertainment > Party & Celebration > Visual Effects > Special Effects Light Stands','en-AU'),(6035,'Arts & Entertainment > Party & Celebration > Visual Effects > Visual Effects Lighting','en-AU'),(6036,'Baby & Toddler','en-AU'),(6037,'Baby & Toddler > Baby Bathing','en-AU'),(6038,'Baby & Toddler > Baby Bathing > Baby Bathtubs & Bath Seats','en-AU'),(6039,'Baby & Toddler > Baby Bathing > Shampoo Eye Shield','en-AU'),(6040,'Baby & Toddler > Baby Gift Sets','en-AU'),(6041,'Baby & Toddler > Baby Health','en-AU'),(6042,'Baby & Toddler > Baby Health > Baby Health & Grooming Kits','en-AU'),(6043,'Baby & Toddler > Baby Health > Dummies & Teethers','en-AU'),(6044,'Baby & Toddler > Baby Health > Dummy Clips & Holders','en-AU'),(6045,'Baby & Toddler > Baby Health > Dummy Wipes','en-AU'),(6046,'Baby & Toddler > Baby Health > Nasal Aspirators','en-AU'),(6047,'Baby & Toddler > Baby Safety','en-AU'),(6048,'Baby & Toddler > Baby Safety > Baby & Pet Gate Accessories','en-AU'),(6049,'Baby & Toddler > Baby Safety > Baby & Pet Safety Gates','en-AU'),(6050,'Baby & Toddler > Baby Safety > Baby Monitors','en-AU'),(6051,'Baby & Toddler > Baby Safety > Baby Safety Harnesses & Reins','en-AU'),(6052,'Baby & Toddler > Baby Safety > Baby Safety Locks & Guards','en-AU'),(6053,'Baby & Toddler > Baby Safety > Baby Safety Rails','en-AU'),(6054,'Baby & Toddler > Baby Toys & Activity Equipment','en-AU'),(6055,'Baby & Toddler > Baby Toys & Activity Equipment > Alphabet Toys','en-AU'),(6056,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Activity Toys','en-AU'),(6057,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Bouncers & Rockers','en-AU'),(6058,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Jumpers & Swings','en-AU'),(6059,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Mobile Accessories','en-AU'),(6060,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Mobiles','en-AU'),(6061,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Soothers','en-AU'),(6062,'Baby & Toddler > Baby Toys & Activity Equipment > Baby Walkers & Entertainers','en-AU'),(6063,'Baby & Toddler > Baby Toys & Activity Equipment > Play Mats & Gyms','en-AU'),(6064,'Baby & Toddler > Baby Toys & Activity Equipment > Play Pens','en-AU'),(6065,'Baby & Toddler > Baby Toys & Activity Equipment > Push & Pull Toys','en-AU'),(6066,'Baby & Toddler > Baby Toys & Activity Equipment > Rattles','en-AU'),(6067,'Baby & Toddler > Baby Toys & Activity Equipment > Sorting & Stacking Toys','en-AU'),(6068,'Baby & Toddler > Baby Transport','en-AU'),(6069,'Baby & Toddler > Baby Transport > Baby & Toddler Car Seats','en-AU'),(6070,'Baby & Toddler > Baby Transport > Baby Carriers','en-AU'),(6071,'Baby & Toddler > Baby Transport > Pushchairs & Prams','en-AU'),(6072,'Baby & Toddler > Baby Transport Accessories','en-AU'),(6073,'Baby & Toddler > Baby Transport Accessories > Baby & Toddler Car Seat Accessories','en-AU'),(6074,'Baby & Toddler > Baby Transport Accessories > Baby Carrier Accessories','en-AU'),(6075,'Baby & Toddler > Baby Transport Accessories > Baby Pushchair & Pram Accessories','en-AU'),(6076,'Baby & Toddler > Baby Transport Accessories > Baby Transport Footmuffs & Snugglers','en-AU'),(6077,'Baby & Toddler > Baby Transport Accessories > Shopping Trolley & High Chair Covers','en-AU'),(6078,'Baby & Toddler > Diapering','en-AU'),(6079,'Baby & Toddler > Diapering > Baby Wipe Dispensers & Warmers','en-AU'),(6080,'Baby & Toddler > Diapering > Baby Wipes','en-AU'),(6081,'Baby & Toddler > Diapering > Changing Mat & Tray Covers','en-AU'),(6082,'Baby & Toddler > Diapering > Changing Mats & Trays','en-AU'),(6083,'Baby & Toddler > Diapering > Nappies','en-AU'),(6084,'Baby & Toddler > Diapering > Nappy Bucket Accessories','en-AU'),(6085,'Baby & Toddler > Diapering > Nappy Buckets','en-AU'),(6086,'Baby & Toddler > Diapering > Nappy Kits','en-AU'),(6087,'Baby & Toddler > Diapering > Nappy Liners','en-AU'),(6088,'Baby & Toddler > Diapering > Nappy Organisers','en-AU'),(6089,'Baby & Toddler > Diapering > Nappy Rash Treatments','en-AU'),(6090,'Baby & Toddler > Diapering > Nappy Wet Bags','en-AU'),(6091,'Baby & Toddler > Nursing & Feeding','en-AU'),(6092,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food','en-AU'),(6093,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Baby Cereal','en-AU'),(6094,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Baby Drinks','en-AU'),(6095,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Baby Food','en-AU'),(6096,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Baby Formula','en-AU'),(6097,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Baby Snacks','en-AU'),(6098,'Baby & Toddler > Nursing & Feeding > Baby & Toddler Food > Toddler Nutrition Drinks & Shakes','en-AU'),(6099,'Baby & Toddler > Nursing & Feeding > Baby Bottle Teats & Liners','en-AU'),(6100,'Baby & Toddler > Nursing & Feeding > Baby Bottles','en-AU'),(6101,'Baby & Toddler > Nursing & Feeding > Baby Care Timers','en-AU'),(6102,'Baby & Toddler > Nursing & Feeding > Bibs','en-AU'),(6103,'Baby & Toddler > Nursing & Feeding > Bottle Warmers & Sterilisers','en-AU'),(6104,'Baby & Toddler > Nursing & Feeding > Breast Milk Storage Containers','en-AU'),(6105,'Baby & Toddler > Nursing & Feeding > Breast Pump Accessories','en-AU'),(6106,'Baby & Toddler > Nursing & Feeding > Breast Pumps','en-AU'),(6107,'Baby & Toddler > Nursing & Feeding > Burp Cloths','en-AU'),(6108,'Baby & Toddler > Nursing & Feeding > Nursing Covers','en-AU'),(6109,'Baby & Toddler > Nursing & Feeding > Nursing Pads & Shields','en-AU'),(6110,'Baby & Toddler > Nursing & Feeding > Nursing Pillow Covers','en-AU'),(6111,'Baby & Toddler > Nursing & Feeding > Nursing Pillows','en-AU'),(6112,'Baby & Toddler > Nursing & Feeding > Sippy Cups','en-AU'),(6113,'Baby & Toddler > Potty Training','en-AU'),(6114,'Baby & Toddler > Potty Training > Potty Seats','en-AU'),(6115,'Baby & Toddler > Potty Training > Potty Training Kits','en-AU'),(6116,'Baby & Toddler > Swaddling & Receiving Blankets','en-AU'),(6117,'Business & Industrial','en-AU'),(6118,'Business & Industrial > Advertising & Marketing','en-AU'),(6119,'Business & Industrial > Advertising & Marketing > Brochures','en-AU'),(6120,'Business & Industrial > Advertising & Marketing > Trade Show Counters','en-AU'),(6121,'Business & Industrial > Advertising & Marketing > Trade Show Displays','en-AU'),(6122,'Business & Industrial > Agriculture','en-AU'),(6123,'Business & Industrial > Agriculture > Animal Husbandry','en-AU'),(6124,'Business & Industrial > Agriculture > Animal Husbandry > Egg Incubators','en-AU'),(6125,'Business & Industrial > Agriculture > Animal Husbandry > Livestock Feed','en-AU'),(6126,'Business & Industrial > Agriculture > Animal Husbandry > Livestock Feeders & Waterers','en-AU'),(6127,'Business & Industrial > Agriculture > Animal Husbandry > Livestock Halters','en-AU'),(6128,'Business & Industrial > Automation Control Components','en-AU'),(6129,'Business & Industrial > Automation Control Components > Programmable Logic Controllers','en-AU'),(6130,'Business & Industrial > Automation Control Components > Variable Frequency & Adjustable Speed Drives','en-AU'),(6131,'Business & Industrial > Cleaning Carts & Containers','en-AU'),(6132,'Business & Industrial > Construction','en-AU'),(6133,'Business & Industrial > Construction > Surveying','en-AU'),(6134,'Business & Industrial > Construction > Traffic Cones & Barrels','en-AU'),(6135,'Business & Industrial > Dentistry','en-AU'),(6136,'Business & Industrial > Dentistry > Dental Cement','en-AU'),(6137,'Business & Industrial > Dentistry > Dental Tools','en-AU'),(6138,'Business & Industrial > Dentistry > Dental Tools > Dappen Dishes','en-AU'),(6139,'Business & Industrial > Dentistry > Dental Tools > Dental Mirrors','en-AU'),(6140,'Business & Industrial > Dentistry > Dental Tools > Dental Tool Sets','en-AU'),(6141,'Business & Industrial > Dentistry > Dental Tools > Prophy Cups','en-AU'),(6142,'Business & Industrial > Dentistry > Dental Tools > Prophy Heads','en-AU'),(6143,'Business & Industrial > Dentistry > Prophy Paste','en-AU'),(6144,'Business & Industrial > Film & Television','en-AU'),(6145,'Business & Industrial > Finance & Insurance','en-AU'),(6146,'Business & Industrial > Finance & Insurance > Bullion','en-AU'),(6147,'Business & Industrial > Food Service','en-AU'),(6148,'Business & Industrial > Food Service > Bakery Boxes','en-AU'),(6149,'Business & Industrial > Food Service > Bill Presenters','en-AU'),(6150,'Business & Industrial > Food Service > Bus Tubs','en-AU'),(6151,'Business & Industrial > Food Service > Concession Food Containers','en-AU'),(6152,'Business & Industrial > Food Service > Disposable Lids','en-AU'),(6153,'Business & Industrial > Food Service > Disposable Serving Accessories','en-AU'),(6154,'Business & Industrial > Food Service > Disposable Serving Accessories > Disposable Serving Trays','en-AU'),(6155,'Business & Industrial > Food Service > Disposable Tableware','en-AU'),(6156,'Business & Industrial > Food Service > Disposable Tableware > Disposable Bowls','en-AU'),(6157,'Business & Industrial > Food Service > Disposable Tableware > Disposable Cups','en-AU'),(6158,'Business & Industrial > Food Service > Disposable Tableware > Disposable Cutlery','en-AU'),(6159,'Business & Industrial > Food Service > Disposable Tableware > Disposable Plates','en-AU'),(6160,'Business & Industrial > Food Service > Food Service Baskets','en-AU'),(6161,'Business & Industrial > Food Service > Food Service Carts','en-AU'),(6162,'Business & Industrial > Food Service > Food Washers & Dryers','en-AU'),(6163,'Business & Industrial > Food Service > Hot Dog Rollers','en-AU'),(6164,'Business & Industrial > Food Service > Ice Bins','en-AU'),(6165,'Business & Industrial > Food Service > Plate & Dish Warmers','en-AU'),(6166,'Business & Industrial > Food Service > Sneeze Guards','en-AU'),(6167,'Business & Industrial > Food Service > Takeaway Containers','en-AU'),(6168,'Business & Industrial > Food Service > Tilt Skillets','en-AU'),(6169,'Business & Industrial > Food Service > Vending Machines','en-AU'),(6170,'Business & Industrial > Forestry & Logging','en-AU'),(6171,'Business & Industrial > Hairdressing & Cosmetology','en-AU'),(6172,'Business & Industrial > Hairdressing & Cosmetology > Hairdressing Capes & Neck Covers','en-AU'),(6173,'Business & Industrial > Hairdressing & Cosmetology > Pedicure Chairs','en-AU'),(6174,'Business & Industrial > Hairdressing & Cosmetology > Salon Chairs','en-AU'),(6175,'Business & Industrial > Heavy Machinery','en-AU'),(6176,'Business & Industrial > Heavy Machinery > Chippers','en-AU'),(6177,'Business & Industrial > Hotel & Hospitality','en-AU'),(6178,'Business & Industrial > Industrial Storage','en-AU'),(6179,'Business & Industrial > Industrial Storage > Industrial Cabinets','en-AU'),(6180,'Business & Industrial > Industrial Storage > Industrial Shelving','en-AU'),(6181,'Business & Industrial > Industrial Storage > Shipping Containers','en-AU'),(6182,'Business & Industrial > Industrial Storage > Wire Partitions, Enclosures & Doors','en-AU'),(6183,'Business & Industrial > Industrial Storage Accessories','en-AU'),(6184,'Business & Industrial > Law Enforcement','en-AU'),(6185,'Business & Industrial > Law Enforcement > Cuffs','en-AU'),(6186,'Business & Industrial > Law Enforcement > Metal Detectors','en-AU'),(6187,'Business & Industrial > Manufacturing','en-AU'),(6188,'Business & Industrial > Material Handling','en-AU'),(6189,'Business & Industrial > Material Handling > Conveyors','en-AU'),(6190,'Business & Industrial > Material Handling > Lifts & Hoists','en-AU'),(6191,'Business & Industrial > Material Handling > Lifts & Hoists > Hoists, Cranes & Trolleys','en-AU'),(6192,'Business & Industrial > Material Handling > Lifts & Hoists > Jacks & Forklift Trucks','en-AU'),(6193,'Business & Industrial > Material Handling > Lifts & Hoists > Personnel Lifts','en-AU'),(6194,'Business & Industrial > Material Handling > Lifts & Hoists > Pulleys, Blocks & Sheaves','en-AU'),(6195,'Business & Industrial > Material Handling > Lifts & Hoists > Winches','en-AU'),(6196,'Business & Industrial > Material Handling > Pallets & Loading Platforms','en-AU'),(6197,'Business & Industrial > Medical','en-AU'),(6198,'Business & Industrial > Medical > Hospital Curtains','en-AU'),(6199,'Business & Industrial > Medical > Hospital Gowns','en-AU'),(6200,'Business & Industrial > Medical > Medical Bedding','en-AU'),(6201,'Business & Industrial > Medical > Medical Equipment','en-AU'),(6202,'Business & Industrial > Medical > Medical Equipment > Automated External Defibrillators','en-AU'),(6203,'Business & Industrial > Medical > Medical Equipment > Gait Belts','en-AU'),(6204,'Business & Industrial > Medical > Medical Equipment > Medical Reflex Hammers & Tuning Forks','en-AU'),(6205,'Business & Industrial > Medical > Medical Equipment > Medical Stretchers & Gurneys','en-AU'),(6206,'Business & Industrial > Medical > Medical Equipment > Otoscopes & Ophthalmoscopes','en-AU'),(6207,'Business & Industrial > Medical > Medical Equipment > Patient Lifts','en-AU'),(6208,'Business & Industrial > Medical > Medical Equipment > Stethoscopes','en-AU'),(6209,'Business & Industrial > Medical > Medical Equipment > Vital Sign Monitors','en-AU'),(6210,'Business & Industrial > Medical > Medical Equipment > Vital Signs Monitor Accessories','en-AU'),(6211,'Business & Industrial > Medical > Medical Furniture','en-AU'),(6212,'Business & Industrial > Medical > Medical Furniture > Chiropractic Tables','en-AU'),(6213,'Business & Industrial > Medical > Medical Furniture > Examination Chairs & Tables','en-AU'),(6214,'Business & Industrial > Medical > Medical Furniture > Homecare & Hospital Beds','en-AU'),(6215,'Business & Industrial > Medical > Medical Furniture > Medical Cabinets','en-AU'),(6216,'Business & Industrial > Medical > Medical Furniture > Medical Carts','en-AU'),(6217,'Business & Industrial > Medical > Medical Furniture > Medical Carts > Crash Carts','en-AU'),(6218,'Business & Industrial > Medical > Medical Furniture > Medical Carts > IV Poles & Carts','en-AU'),(6219,'Business & Industrial > Medical > Medical Furniture > Surgical Tables','en-AU'),(6220,'Business & Industrial > Medical > Medical Instruments','en-AU'),(6221,'Business & Industrial > Medical > Medical Instruments > Medical Forceps','en-AU'),(6222,'Business & Industrial > Medical > Medical Instruments > Scalpel Blades','en-AU'),(6223,'Business & Industrial > Medical > Medical Instruments > Scalpels','en-AU'),(6224,'Business & Industrial > Medical > Medical Instruments > Surgical Needles & Sutures','en-AU'),(6225,'Business & Industrial > Medical > Medical Supplies','en-AU'),(6226,'Business & Industrial > Medical > Medical Supplies > Finger Cots','en-AU'),(6227,'Business & Industrial > Medical > Medical Supplies > Medical Gloves','en-AU'),(6228,'Business & Industrial > Medical > Medical Supplies > Medical Needles & Syringes','en-AU'),(6229,'Business & Industrial > Medical > Medical Supplies > Ostomy Supplies','en-AU'),(6230,'Business & Industrial > Medical > Medical Supplies > Tongue Depressors','en-AU'),(6231,'Business & Industrial > Medical > Medical Teaching Equipment','en-AU'),(6232,'Business & Industrial > Medical > Medical Teaching Equipment > Medical & Emergency Response Training Mannequins','en-AU'),(6233,'Business & Industrial > Medical > Scrub Caps','en-AU'),(6234,'Business & Industrial > Medical > Scrubs','en-AU'),(6235,'Business & Industrial > Medical > Surgical Gowns','en-AU'),(6236,'Business & Industrial > Mining & Quarrying','en-AU'),(6237,'Business & Industrial > Piercing & Tattooing','en-AU'),(6238,'Business & Industrial > Piercing & Tattooing > Piercing Supplies','en-AU'),(6239,'Business & Industrial > Piercing & Tattooing > Piercing Supplies > Piercing Needles','en-AU'),(6240,'Business & Industrial > Piercing & Tattooing > Tattoo Supplies','en-AU'),(6241,'Business & Industrial > Piercing & Tattooing > Tattoo Supplies > Tattoo Cover-Ups','en-AU'),(6242,'Business & Industrial > Piercing & Tattooing > Tattoo Supplies > Tattooing Inks','en-AU'),(6243,'Business & Industrial > Piercing & Tattooing > Tattoo Supplies > Tattooing Machines','en-AU'),(6244,'Business & Industrial > Piercing & Tattooing > Tattoo Supplies > Tattooing Needles','en-AU'),(6245,'Business & Industrial > Retail','en-AU'),(6246,'Business & Industrial > Retail > Clothing Display Racks','en-AU'),(6247,'Business & Industrial > Retail > Display Mannequins','en-AU'),(6248,'Business & Industrial > Retail > Mannequin Parts','en-AU'),(6249,'Business & Industrial > Retail > Money Handling','en-AU'),(6250,'Business & Industrial > Retail > Money Handling > Banknote Verifiers','en-AU'),(6251,'Business & Industrial > Retail > Money Handling > Cash Register & POS Terminal Accessories','en-AU'),(6252,'Business & Industrial > Retail > Money Handling > Cash Register & POS Terminal Accessories > Cash Drawers & Trays','en-AU'),(6253,'Business & Industrial > Retail > Money Handling > Cash Register & POS Terminal Accessories > Credit Card Terminals','en-AU'),(6254,'Business & Industrial > Retail > Money Handling > Cash Register & POS Terminal Accessories > Signature Capture Pads','en-AU'),(6255,'Business & Industrial > Retail > Money Handling > Cash Registers & POS Terminals','en-AU'),(6256,'Business & Industrial > Retail > Money Handling > Coin & Banknote Counters','en-AU'),(6257,'Business & Industrial > Retail > Money Handling > Money Changers','en-AU'),(6258,'Business & Industrial > Retail > Money Handling > Money Deposit Bags','en-AU'),(6259,'Business & Industrial > Retail > Money Handling > Paper Coin & Banknote Wrappers','en-AU'),(6260,'Business & Industrial > Retail > Paper & Plastic Shopping Bags','en-AU'),(6261,'Business & Industrial > Retail > Pricing Guns','en-AU'),(6262,'Business & Industrial > Retail > Retail Display Cases','en-AU'),(6263,'Business & Industrial > Retail > Retail Display Props & Models','en-AU'),(6264,'Business & Industrial > Science & Laboratory','en-AU'),(6265,'Business & Industrial > Science & Laboratory > Biochemicals','en-AU'),(6266,'Business & Industrial > Science & Laboratory > Dissection Kits','en-AU'),(6267,'Business & Industrial > Science & Laboratory > Laboratory Chemicals','en-AU'),(6268,'Business & Industrial > Science & Laboratory > Laboratory Equipment','en-AU'),(6269,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Autoclaves','en-AU'),(6270,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Centrifuges','en-AU'),(6271,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Dry Ice Makers','en-AU'),(6272,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Freeze-Drying Machines','en-AU'),(6273,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Laboratory Blenders','en-AU'),(6274,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Laboratory Freezers','en-AU'),(6275,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Laboratory Funnels','en-AU'),(6276,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Laboratory Hot Plates','en-AU'),(6277,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Laboratory Ovens','en-AU'),(6278,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories','en-AU'),(6279,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories > Microscope Cameras','en-AU'),(6280,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories > Microscope Eyepieces & Adaptors','en-AU'),(6281,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories > Microscope Objective Lenses','en-AU'),(6282,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories > Microscope Replacement Bulbs','en-AU'),(6283,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscope Accessories > Microscope Slides','en-AU'),(6284,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microscopes','en-AU'),(6285,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Microtomes','en-AU'),(6286,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Spectrometer Accessories','en-AU'),(6287,'Business & Industrial > Science & Laboratory > Laboratory Equipment > Spectrometers','en-AU'),(6288,'Business & Industrial > Science & Laboratory > Laboratory Specimens','en-AU'),(6289,'Business & Industrial > Science & Laboratory > Laboratory Supplies','en-AU'),(6290,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Beakers','en-AU'),(6291,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Graduated Cylinders','en-AU'),(6292,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Laboratory Flasks','en-AU'),(6293,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Petri Dishes','en-AU'),(6294,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Pipettes','en-AU'),(6295,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Test Tube Racks','en-AU'),(6296,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Test Tubes','en-AU'),(6297,'Business & Industrial > Science & Laboratory > Laboratory Supplies > Wash Bottles','en-AU'),(6298,'Business & Industrial > Signage','en-AU'),(6299,'Business & Industrial > Signage > Business Hour Signs','en-AU'),(6300,'Business & Industrial > Signage > Digital Signs','en-AU'),(6301,'Business & Industrial > Signage > Electric Signs','en-AU'),(6302,'Business & Industrial > Signage > Electric Signs > LED Signs','en-AU'),(6303,'Business & Industrial > Signage > Electric Signs > Neon Signs','en-AU'),(6304,'Business & Industrial > Signage > Emergency & Exit Signs','en-AU'),(6305,'Business & Industrial > Signage > Facility Identification Signs','en-AU'),(6306,'Business & Industrial > Signage > Open & Closed Signs','en-AU'),(6307,'Business & Industrial > Signage > Parking Signs & Permits','en-AU'),(6308,'Business & Industrial > Signage > Pavement & Yard Signs','en-AU'),(6309,'Business & Industrial > Signage > Policy Signs','en-AU'),(6310,'Business & Industrial > Signage > Retail & Sale Signs','en-AU'),(6311,'Business & Industrial > Signage > Road & Traffic Signs','en-AU'),(6312,'Business & Industrial > Signage > Safety & Warning Signs','en-AU'),(6313,'Business & Industrial > Signage > Security Signs','en-AU'),(6314,'Business & Industrial > Work Safety Protective Equipment','en-AU'),(6315,'Business & Industrial > Work Safety Protective Equipment > Bullet Proof Vests','en-AU'),(6316,'Business & Industrial > Work Safety Protective Equipment > Gas Mask & Respirator Accessories','en-AU'),(6317,'Business & Industrial > Work Safety Protective Equipment > Hard Hats','en-AU'),(6318,'Business & Industrial > Work Safety Protective Equipment > Hazmat Suits','en-AU'),(6319,'Business & Industrial > Work Safety Protective Equipment > Protective Aprons','en-AU'),(6320,'Business & Industrial > Work Safety Protective Equipment > Protective Eyewear','en-AU'),(6321,'Business & Industrial > Work Safety Protective Equipment > Protective Masks','en-AU'),(6322,'Business & Industrial > Work Safety Protective Equipment > Protective Masks > Dust Masks','en-AU'),(6323,'Business & Industrial > Work Safety Protective Equipment > Protective Masks > Firefighter\'s Masks','en-AU'),(6324,'Business & Industrial > Work Safety Protective Equipment > Protective Masks > Gas Masks & Respirators','en-AU'),(6325,'Business & Industrial > Work Safety Protective Equipment > Protective Masks > Medical Masks','en-AU'),(6326,'Business & Industrial > Work Safety Protective Equipment > Safety Gloves','en-AU'),(6327,'Business & Industrial > Work Safety Protective Equipment > Safety Knee Pads','en-AU'),(6328,'Business & Industrial > Work Safety Protective Equipment > Welding Helmets','en-AU'),(6329,'Business & Industrial > Work Safety Protective Equipment > Work Safety Harnesses','en-AU'),(6330,'Business & Industrial > Work Safety Protective Equipment > Work Safety Tethers','en-AU'),(6331,'Cameras & Optics','en-AU'),(6332,'Cameras & Optics > Camera & Optic Accessories','en-AU'),(6333,'Cameras & Optics > Camera & Optic Accessories > Camera & Optic Replacement Cables','en-AU'),(6334,'Cameras & Optics > Camera & Optic Accessories > Camera & Video Camera Lenses','en-AU'),(6335,'Cameras & Optics > Camera & Optic Accessories > Camera & Video Camera Lenses > Camera Lenses','en-AU'),(6336,'Cameras & Optics > Camera & Optic Accessories > Camera & Video Camera Lenses > Surveillance Camera Lenses','en-AU'),(6337,'Cameras & Optics > Camera & Optic Accessories > Camera & Video Camera Lenses > Video Camera Lenses','en-AU'),(6338,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories','en-AU'),(6339,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens & Filter Adaptor Rings','en-AU'),(6340,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens Bags','en-AU'),(6341,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens Caps','en-AU'),(6342,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens Converters','en-AU'),(6343,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens Filters','en-AU'),(6344,'Cameras & Optics > Camera & Optic Accessories > Camera Lens Accessories > Lens Hoods','en-AU'),(6345,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories','en-AU'),(6346,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Accessory Sets','en-AU'),(6347,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Bags & Cases','en-AU'),(6348,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Body Replacement Panels & Doors','en-AU'),(6349,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Digital Backs','en-AU'),(6350,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Film','en-AU'),(6351,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Flash Accessories','en-AU'),(6352,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Flashes','en-AU'),(6353,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Focus Devices','en-AU'),(6354,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Gears','en-AU'),(6355,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Grips','en-AU'),(6356,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Image Sensors','en-AU'),(6357,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Lens Zoom Units','en-AU'),(6358,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Remote Controls','en-AU'),(6359,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Replacement Buttons & Knobs','en-AU'),(6360,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Replacement Screens & Displays','en-AU'),(6361,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Silencers & Sound Blimps','en-AU'),(6362,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Stabilisers & Supports','en-AU'),(6363,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Straps','en-AU'),(6364,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Camera Sun Hoods & Viewfinder Attachments','en-AU'),(6365,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Flash Brackets','en-AU'),(6366,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > On-Camera Monitors','en-AU'),(6367,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Surveillance Camera Accessories','en-AU'),(6368,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Underwater Camera Housing Accessories','en-AU'),(6369,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Underwater Camera Housings','en-AU'),(6370,'Cameras & Optics > Camera & Optic Accessories > Camera Parts & Accessories > Video Camera Lights','en-AU'),(6371,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories','en-AU'),(6372,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Binocular & Monocular Accessories','en-AU'),(6373,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Optics Bags & Cases','en-AU'),(6374,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Rangefinder Accessories','en-AU'),(6375,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Spotting Scope Accessories','en-AU'),(6376,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Telescope Accessories','en-AU'),(6377,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Thermal Optic Accessories','en-AU'),(6378,'Cameras & Optics > Camera & Optic Accessories > Optic Accessories > Weapon Scope & Sight Accessories','en-AU'),(6379,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories','en-AU'),(6380,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories > Tripod & Monopod Cases','en-AU'),(6381,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories > Tripod & Monopod Heads','en-AU'),(6382,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories > Tripod Collars & Mounts','en-AU'),(6383,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories > Tripod Handles','en-AU'),(6384,'Cameras & Optics > Camera & Optic Accessories > Tripod & Monopod Accessories > Tripod Spreaders','en-AU'),(6385,'Cameras & Optics > Camera & Optic Accessories > Tripods & Monopods','en-AU'),(6386,'Cameras & Optics > Cameras','en-AU'),(6387,'Cameras & Optics > Cameras > Borescopes','en-AU'),(6388,'Cameras & Optics > Cameras > Digital Cameras','en-AU'),(6389,'Cameras & Optics > Cameras > Disposable Cameras','en-AU'),(6390,'Cameras & Optics > Cameras > Film Cameras','en-AU'),(6391,'Cameras & Optics > Cameras > Surveillance Cameras','en-AU'),(6392,'Cameras & Optics > Cameras > Trail Cameras','en-AU'),(6393,'Cameras & Optics > Cameras > Video Cameras','en-AU'),(6394,'Cameras & Optics > Cameras > Webcams','en-AU'),(6395,'Cameras & Optics > Optics','en-AU'),(6396,'Cameras & Optics > Optics > Binoculars','en-AU'),(6397,'Cameras & Optics > Optics > Monoculars','en-AU'),(6398,'Cameras & Optics > Optics > Range Finders','en-AU'),(6399,'Cameras & Optics > Optics > Scopes','en-AU'),(6400,'Cameras & Optics > Optics > Scopes > Spotting Scopes','en-AU'),(6401,'Cameras & Optics > Optics > Scopes > Telescopes','en-AU'),(6402,'Cameras & Optics > Optics > Scopes > Weapon Scopes & Sights','en-AU'),(6403,'Cameras & Optics > Photography','en-AU'),(6404,'Cameras & Optics > Photography > Darkroom','en-AU'),(6405,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment','en-AU'),(6406,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment > Copy Stands','en-AU'),(6407,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment > Darkroom Sinks','en-AU'),(6408,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment > Developing Tanks & Reels','en-AU'),(6409,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment > Print Trays, Washers & Dryers','en-AU'),(6410,'Cameras & Optics > Photography > Darkroom > Developing & Processing Equipment > Retouching Equipment & Supplies','en-AU'),(6411,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment','en-AU'),(6412,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment > Darkroom Easels','en-AU'),(6413,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment > Darkroom Timers','en-AU'),(6414,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment > Focusing Aids','en-AU'),(6415,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment > Photographic Analysers','en-AU'),(6416,'Cameras & Optics > Photography > Darkroom > Enlarging Equipment > Photographic Enlargers','en-AU'),(6417,'Cameras & Optics > Photography > Darkroom > Photographic Chemicals','en-AU'),(6418,'Cameras & Optics > Photography > Darkroom > Photographic Paper','en-AU'),(6419,'Cameras & Optics > Photography > Darkroom > Safelights','en-AU'),(6420,'Cameras & Optics > Photography > Lighting & Studio','en-AU'),(6421,'Cameras & Optics > Photography > Lighting & Studio > Light Meter Accessories','en-AU'),(6422,'Cameras & Optics > Photography > Lighting & Studio > Light Meters','en-AU'),(6423,'Cameras & Optics > Photography > Lighting & Studio > Studio Backgrounds','en-AU'),(6424,'Cameras & Optics > Photography > Lighting & Studio > Studio Light & Flash Accessories','en-AU'),(6425,'Cameras & Optics > Photography > Lighting & Studio > Studio Lighting Controls','en-AU'),(6426,'Cameras & Optics > Photography > Lighting & Studio > Studio Lighting Controls > Flash Diffusers','en-AU'),(6427,'Cameras & Optics > Photography > Lighting & Studio > Studio Lighting Controls > Flash Reflectors','en-AU'),(6428,'Cameras & Optics > Photography > Lighting & Studio > Studio Lighting Controls > Lighting Filters & Gobos','en-AU'),(6429,'Cameras & Optics > Photography > Lighting & Studio > Studio Lighting Controls > Softboxes','en-AU'),(6430,'Cameras & Optics > Photography > Lighting & Studio > Studio Lights & Flashes','en-AU'),(6431,'Cameras & Optics > Photography > Lighting & Studio > Studio Stand & Mount Accessories','en-AU'),(6432,'Cameras & Optics > Photography > Lighting & Studio > Studio Stands & Mounts','en-AU'),(6433,'Cameras & Optics > Photography > Photo Mounting Supplies','en-AU'),(6434,'Cameras & Optics > Photography > Photo Negative & Slide Storage','en-AU'),(6435,'Clothing & Accessories','en-AU'),(6436,'Clothing & Accessories > Clothing','en-AU'),(6437,'Clothing & Accessories > Clothing > Activewear','en-AU'),(6438,'Clothing & Accessories > Clothing > Activewear > American Football Trousers','en-AU'),(6439,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear','en-AU'),(6440,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear > Bicycle Bibs','en-AU'),(6441,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear > Bicycle Jerseys','en-AU'),(6442,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear > Bicycle Shorts & Briefs','en-AU'),(6443,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear > Bicycle Skinsuits','en-AU'),(6444,'Clothing & Accessories > Clothing > Activewear > Bicycle Activewear > Bicycle Tights','en-AU'),(6445,'Clothing & Accessories > Clothing > Activewear > Boxing Shorts','en-AU'),(6446,'Clothing & Accessories > Clothing > Activewear > Dance Dresses, Skirts & Costumes','en-AU'),(6447,'Clothing & Accessories > Clothing > Activewear > Hunting Clothing','en-AU'),(6448,'Clothing & Accessories > Clothing > Activewear > Hunting Clothing > Ghillie Suits','en-AU'),(6449,'Clothing & Accessories > Clothing > Activewear > Hunting Clothing > Hunting & Fishing Vests','en-AU'),(6450,'Clothing & Accessories > Clothing > Activewear > Hunting Clothing > Hunting & Tactical Trousers','en-AU'),(6451,'Clothing & Accessories > Clothing > Activewear > Martial Arts Shorts','en-AU'),(6452,'Clothing & Accessories > Clothing > Activewear > Motorcycle Protective Clothing','en-AU'),(6453,'Clothing & Accessories > Clothing > Activewear > Motorcycle Protective Clothing > Motorcycle Jackets','en-AU'),(6454,'Clothing & Accessories > Clothing > Activewear > Motorcycle Protective Clothing > Motorcycle Suits','en-AU'),(6455,'Clothing & Accessories > Clothing > Activewear > Motorcycle Protective Clothing > Motorcycle Trousers','en-AU'),(6456,'Clothing & Accessories > Clothing > Activewear > Paintball Clothing','en-AU'),(6457,'Clothing & Accessories > Clothing > Baby & Toddler Clothing','en-AU'),(6458,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Bottoms','en-AU'),(6459,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Dresses','en-AU'),(6460,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Nappy Covers','en-AU'),(6461,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Outerwear','en-AU'),(6462,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Outfits','en-AU'),(6463,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Sleepwear','en-AU'),(6464,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Socks & Tights','en-AU'),(6465,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Swimwear','en-AU'),(6466,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Baby & Toddler Tops','en-AU'),(6467,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Babygros','en-AU'),(6468,'Clothing & Accessories > Clothing > Baby & Toddler Clothing > Toddler Underwear','en-AU'),(6469,'Clothing & Accessories > Clothing > Dresses','en-AU'),(6470,'Clothing & Accessories > Clothing > Nightwear & Loungewear','en-AU'),(6471,'Clothing & Accessories > Clothing > Nightwear & Loungewear > Loungewear','en-AU'),(6472,'Clothing & Accessories > Clothing > Nightwear & Loungewear > Night dresses','en-AU'),(6473,'Clothing & Accessories > Clothing > Nightwear & Loungewear > Pyjamas','en-AU'),(6474,'Clothing & Accessories > Clothing > Nightwear & Loungewear > Robes','en-AU'),(6475,'Clothing & Accessories > Clothing > One-Pieces','en-AU'),(6476,'Clothing & Accessories > Clothing > One-Pieces > Bodysuits & Unitards','en-AU'),(6477,'Clothing & Accessories > Clothing > One-Pieces > Dungarees','en-AU'),(6478,'Clothing & Accessories > Clothing > One-Pieces > Jumpsuits & Playsuits','en-AU'),(6479,'Clothing & Accessories > Clothing > Outerwear','en-AU'),(6480,'Clothing & Accessories > Clothing > Outerwear > Chaps','en-AU'),(6481,'Clothing & Accessories > Clothing > Outerwear > Coats & Jackets','en-AU'),(6482,'Clothing & Accessories > Clothing > Outerwear > Gilets','en-AU'),(6483,'Clothing & Accessories > Clothing > Outerwear > Snow Trousers & Suits','en-AU'),(6484,'Clothing & Accessories > Clothing > Outerwear > Waterproof Suits','en-AU'),(6485,'Clothing & Accessories > Clothing > Outerwear > Waterproof Trousers','en-AU'),(6486,'Clothing & Accessories > Clothing > Outfit Sets','en-AU'),(6487,'Clothing & Accessories > Clothing > Shirts & Tops','en-AU'),(6488,'Clothing & Accessories > Clothing > Shorts','en-AU'),(6489,'Clothing & Accessories > Clothing > Skirts','en-AU'),(6490,'Clothing & Accessories > Clothing > Skorts','en-AU'),(6491,'Clothing & Accessories > Clothing > Suits','en-AU'),(6492,'Clothing & Accessories > Clothing > Suits > Skirt Suits','en-AU'),(6493,'Clothing & Accessories > Clothing > Suits > Trouser Suits','en-AU'),(6494,'Clothing & Accessories > Clothing > Suits > Tuxedos','en-AU'),(6495,'Clothing & Accessories > Clothing > Swimwear','en-AU'),(6496,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing','en-AU'),(6497,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Dirndls','en-AU'),(6498,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Hakama Trousers','en-AU'),(6499,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Japanese Black Formal Wear','en-AU'),(6500,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Kimono Outerwear','en-AU'),(6501,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Kimonos','en-AU'),(6502,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Religious Ceremonial Clothing','en-AU'),(6503,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Religious Ceremonial Clothing > Baptism Dresses & Suits','en-AU'),(6504,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Saris','en-AU'),(6505,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Traditional Leather Trousers','en-AU'),(6506,'Clothing & Accessories > Clothing > Traditional & Ceremonial Clothing > Yukata','en-AU'),(6507,'Clothing & Accessories > Clothing > Trousers & Jeans','en-AU'),(6508,'Clothing & Accessories > Clothing > Underwear & Socks','en-AU'),(6509,'Clothing & Accessories > Clothing > Underwear & Socks > Bra Accessories','en-AU'),(6510,'Clothing & Accessories > Clothing > Underwear & Socks > Bra Accessories > Bra Strap Pads','en-AU'),(6511,'Clothing & Accessories > Clothing > Underwear & Socks > Bra Accessories > Bra Straps & Extenders','en-AU'),(6512,'Clothing & Accessories > Clothing > Underwear & Socks > Bra Accessories > Breast Enhancers','en-AU'),(6513,'Clothing & Accessories > Clothing > Underwear & Socks > Bra Accessories > Breast Petals & Concealers','en-AU'),(6514,'Clothing & Accessories > Clothing > Underwear & Socks > Bras','en-AU'),(6515,'Clothing & Accessories > Clothing > Underwear & Socks > Hosiery','en-AU'),(6516,'Clothing & Accessories > Clothing > Underwear & Socks > Jock Straps','en-AU'),(6517,'Clothing & Accessories > Clothing > Underwear & Socks > Lingerie','en-AU'),(6518,'Clothing & Accessories > Clothing > Underwear & Socks > Lingerie Accessories','en-AU'),(6519,'Clothing & Accessories > Clothing > Underwear & Socks > Lingerie Accessories > Garters','en-AU'),(6520,'Clothing & Accessories > Clothing > Underwear & Socks > Lingerie Accessories > Suspender Belts','en-AU'),(6521,'Clothing & Accessories > Clothing > Underwear & Socks > Long Johns','en-AU'),(6522,'Clothing & Accessories > Clothing > Underwear & Socks > Petticoats & Pettipants','en-AU'),(6523,'Clothing & Accessories > Clothing > Underwear & Socks > Shapewear','en-AU'),(6524,'Clothing & Accessories > Clothing > Underwear & Socks > Socks','en-AU'),(6525,'Clothing & Accessories > Clothing > Underwear & Socks > Undershirts','en-AU'),(6526,'Clothing & Accessories > Clothing > Underwear & Socks > Underwear','en-AU'),(6527,'Clothing & Accessories > Clothing > Underwear & Socks > Underwear Slips','en-AU'),(6528,'Clothing & Accessories > Clothing > Uniforms','en-AU'),(6529,'Clothing & Accessories > Clothing > Uniforms > Contractors Trousers & Coveralls','en-AU'),(6530,'Clothing & Accessories > Clothing > Uniforms > Flight Suits','en-AU'),(6531,'Clothing & Accessories > Clothing > Uniforms > Food Service Uniforms','en-AU'),(6532,'Clothing & Accessories > Clothing > Uniforms > Food Service Uniforms > Chef\'s Hats','en-AU'),(6533,'Clothing & Accessories > Clothing > Uniforms > Food Service Uniforms > Chef\'s Jackets','en-AU'),(6534,'Clothing & Accessories > Clothing > Uniforms > Food Service Uniforms > Chef\'s Trousers','en-AU'),(6535,'Clothing & Accessories > Clothing > Uniforms > Military Uniforms','en-AU'),(6536,'Clothing & Accessories > Clothing > Uniforms > School Uniforms','en-AU'),(6537,'Clothing & Accessories > Clothing > Uniforms > Security Uniforms','en-AU'),(6538,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms','en-AU'),(6539,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > American Football Uniforms','en-AU'),(6540,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Baseball Uniforms','en-AU'),(6541,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Basketball Uniforms','en-AU'),(6542,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Cheerleading Uniforms','en-AU'),(6543,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Cricket Uniforms','en-AU'),(6544,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Football Uniforms','en-AU'),(6545,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Hockey Uniforms','en-AU'),(6546,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Martial Arts Uniforms','en-AU'),(6547,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Officiating Uniforms','en-AU'),(6548,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Softball Uniforms','en-AU'),(6549,'Clothing & Accessories > Clothing > Uniforms > Sports Uniforms > Wrestling Uniforms','en-AU'),(6550,'Clothing & Accessories > Clothing > Uniforms > White Coats','en-AU'),(6551,'Clothing & Accessories > Clothing > Wedding & Bridal Party Dresses','en-AU'),(6552,'Clothing & Accessories > Clothing > Wedding & Bridal Party Dresses > Bridal Party Dresses','en-AU'),(6553,'Clothing & Accessories > Clothing > Wedding & Bridal Party Dresses > Wedding Dresses','en-AU'),(6554,'Clothing & Accessories > Clothing Accessories','en-AU'),(6555,'Clothing & Accessories > Clothing Accessories > Arm Warmers & Sleeves','en-AU'),(6556,'Clothing & Accessories > Clothing Accessories > Baby & Toddler Clothing Accessories','en-AU'),(6557,'Clothing & Accessories > Clothing Accessories > Baby & Toddler Clothing Accessories > Baby & Toddler Belts','en-AU'),(6558,'Clothing & Accessories > Clothing Accessories > Baby & Toddler Clothing Accessories > Baby & Toddler Gloves & Mittens','en-AU'),(6559,'Clothing & Accessories > Clothing Accessories > Baby & Toddler Clothing Accessories > Baby & Toddler Hats','en-AU'),(6560,'Clothing & Accessories > Clothing Accessories > Baby & Toddler Clothing Accessories > Baby Protective Wear','en-AU'),(6561,'Clothing & Accessories > Clothing Accessories > Balaclavas','en-AU'),(6562,'Clothing & Accessories > Clothing Accessories > Bandanas & Headties','en-AU'),(6563,'Clothing & Accessories > Clothing Accessories > Belt Buckles','en-AU'),(6564,'Clothing & Accessories > Clothing Accessories > Belts','en-AU'),(6565,'Clothing & Accessories > Clothing Accessories > Braces','en-AU'),(6566,'Clothing & Accessories > Clothing Accessories > Bridal Accessories','en-AU'),(6567,'Clothing & Accessories > Clothing Accessories > Bridal Accessories > Bridal Veils','en-AU'),(6568,'Clothing & Accessories > Clothing Accessories > Button Studs','en-AU'),(6569,'Clothing & Accessories > Clothing Accessories > Collar Stays','en-AU'),(6570,'Clothing & Accessories > Clothing Accessories > Cufflinks','en-AU'),(6571,'Clothing & Accessories > Clothing Accessories > Decorative Fans','en-AU'),(6572,'Clothing & Accessories > Clothing Accessories > Earmuffs','en-AU'),(6573,'Clothing & Accessories > Clothing Accessories > Gloves & Mittens','en-AU'),(6574,'Clothing & Accessories > Clothing Accessories > Hair Accessories','en-AU'),(6575,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Bun & Volume Shapers','en-AU'),(6576,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Combs','en-AU'),(6577,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Extensions','en-AU'),(6578,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Forks & Sticks','en-AU'),(6579,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Nets','en-AU'),(6580,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Pins, Claws & Clips','en-AU'),(6581,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Hair Wreaths','en-AU'),(6582,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Headbands','en-AU'),(6583,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Ponytail Holders','en-AU'),(6584,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Tiaras','en-AU'),(6585,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Wig Accessories','en-AU'),(6586,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Wig Accessories > Wig Caps','en-AU'),(6587,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Wig Accessories > Wig Glue & Tape','en-AU'),(6588,'Clothing & Accessories > Clothing Accessories > Hair Accessories > Wigs','en-AU'),(6589,'Clothing & Accessories > Clothing Accessories > Hand Muffs','en-AU'),(6590,'Clothing & Accessories > Clothing Accessories > Hats','en-AU'),(6591,'Clothing & Accessories > Clothing Accessories > Headwear','en-AU'),(6592,'Clothing & Accessories > Clothing Accessories > Headwear > Fascinators','en-AU'),(6593,'Clothing & Accessories > Clothing Accessories > Headwear > Headdresses','en-AU'),(6594,'Clothing & Accessories > Clothing Accessories > Headwear > Turbans','en-AU'),(6595,'Clothing & Accessories > Clothing Accessories > Leg Warmers','en-AU'),(6596,'Clothing & Accessories > Clothing Accessories > Leis','en-AU'),(6597,'Clothing & Accessories > Clothing Accessories > Maternity Belts & Support Bands','en-AU'),(6598,'Clothing & Accessories > Clothing Accessories > Neck Gaiters','en-AU'),(6599,'Clothing & Accessories > Clothing Accessories > Neckties','en-AU'),(6600,'Clothing & Accessories > Clothing Accessories > Pinback Buttons','en-AU'),(6601,'Clothing & Accessories > Clothing Accessories > Pocket Squares','en-AU'),(6602,'Clothing & Accessories > Clothing Accessories > Sashes','en-AU'),(6603,'Clothing & Accessories > Clothing Accessories > Scarves & Snoods','en-AU'),(6604,'Clothing & Accessories > Clothing Accessories > Sunglasses','en-AU'),(6605,'Clothing & Accessories > Clothing Accessories > Tie Clips','en-AU'),(6606,'Clothing & Accessories > Clothing Accessories > Traditional Clothing Accessories','en-AU'),(6607,'Clothing & Accessories > Clothing Accessories > Traditional Clothing Accessories > Obis','en-AU'),(6608,'Clothing & Accessories > Clothing Accessories > Traditional Clothing Accessories > Tabi Socks','en-AU'),(6609,'Clothing & Accessories > Clothing Accessories > Wristbands','en-AU'),(6610,'Clothing & Accessories > Costumes & Accessories','en-AU'),(6611,'Clothing & Accessories > Costumes & Accessories > Costume Accessories','en-AU'),(6612,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Bald Caps','en-AU'),(6613,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Accessory Sets','en-AU'),(6614,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Capes','en-AU'),(6615,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Gloves','en-AU'),(6616,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Hats','en-AU'),(6617,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Special Effects','en-AU'),(6618,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Costume Tobacco Products','en-AU'),(6619,'Clothing & Accessories > Costumes & Accessories > Costume Accessories > Pretend Jewellery','en-AU'),(6620,'Clothing & Accessories > Costumes & Accessories > Costume Shoes','en-AU'),(6621,'Clothing & Accessories > Costumes & Accessories > Costumes','en-AU'),(6622,'Clothing & Accessories > Costumes & Accessories > Masks','en-AU'),(6623,'Clothing & Accessories > Handbag & Wallet Accessories','en-AU'),(6624,'Clothing & Accessories > Handbag & Wallet Accessories > Chequebook Covers','en-AU'),(6625,'Clothing & Accessories > Handbag & Wallet Accessories > Key Chains','en-AU'),(6626,'Clothing & Accessories > Handbag & Wallet Accessories > Lanyards','en-AU'),(6627,'Clothing & Accessories > Handbag & Wallet Accessories > Wallet Chains','en-AU'),(6628,'Clothing & Accessories > Handbags, Wallets & Cases','en-AU'),(6629,'Clothing & Accessories > Handbags, Wallets & Cases > Badge & Pass Holders','en-AU'),(6630,'Clothing & Accessories > Handbags, Wallets & Cases > Business Card Cases','en-AU'),(6631,'Clothing & Accessories > Handbags, Wallets & Cases > Handbags','en-AU'),(6632,'Clothing & Accessories > Handbags, Wallets & Cases > Wallets & Money Clips','en-AU'),(6633,'Clothing & Accessories > Jewellery & Watches','en-AU'),(6634,'Clothing & Accessories > Jewellery & Watches > Anklets','en-AU'),(6635,'Clothing & Accessories > Jewellery & Watches > Body Jewellery','en-AU'),(6636,'Clothing & Accessories > Jewellery & Watches > Bracelets','en-AU'),(6637,'Clothing & Accessories > Jewellery & Watches > Brooches & Lapel Pins','en-AU'),(6638,'Clothing & Accessories > Jewellery & Watches > Charms & Pendants','en-AU'),(6639,'Clothing & Accessories > Jewellery & Watches > Earrings','en-AU'),(6640,'Clothing & Accessories > Jewellery & Watches > Jewellery Sets','en-AU'),(6641,'Clothing & Accessories > Jewellery & Watches > Necklaces','en-AU'),(6642,'Clothing & Accessories > Jewellery & Watches > Rings','en-AU'),(6643,'Clothing & Accessories > Jewellery & Watches > Watch Accessories','en-AU'),(6644,'Clothing & Accessories > Jewellery & Watches > Watch Accessories > Watch Bands','en-AU'),(6645,'Clothing & Accessories > Jewellery & Watches > Watch Accessories > Watch Stickers & Decals','en-AU'),(6646,'Clothing & Accessories > Jewellery & Watches > Watch Accessories > Watch Winders','en-AU'),(6647,'Clothing & Accessories > Jewellery & Watches > Watches','en-AU'),(6648,'Clothing & Accessories > Shoe Accessories','en-AU'),(6649,'Clothing & Accessories > Shoe Accessories > Boot Liners','en-AU'),(6650,'Clothing & Accessories > Shoe Accessories > Gaiters','en-AU'),(6651,'Clothing & Accessories > Shoe Accessories > Shoe Covers','en-AU'),(6652,'Clothing & Accessories > Shoe Accessories > Shoelaces','en-AU'),(6653,'Clothing & Accessories > Shoe Accessories > Spurs','en-AU'),(6654,'Clothing & Accessories > Shoes','en-AU'),(6655,'Electronics','en-AU'),(6656,'Electronics > Arcade Equipment','en-AU'),(6657,'Electronics > Arcade Equipment > Basketball Arcade Games','en-AU'),(6658,'Electronics > Arcade Equipment > Pinball Machine Accessories','en-AU'),(6659,'Electronics > Arcade Equipment > Pinball Machines','en-AU'),(6660,'Electronics > Arcade Equipment > Skee-Ball Machines','en-AU'),(6661,'Electronics > Arcade Equipment > Video Game Arcade Cabinet Accessories','en-AU'),(6662,'Electronics > Arcade Equipment > Video Game Arcade Cabinets','en-AU'),(6663,'Electronics > Audio','en-AU'),(6664,'Electronics > Audio > Audio Accessories','en-AU'),(6665,'Electronics > Audio > Audio Accessories > Audio & Video Receiver Accessories','en-AU'),(6666,'Electronics > Audio > Audio Accessories > Headphone & Headset Accessories','en-AU'),(6667,'Electronics > Audio > Audio Accessories > Headphone & Headset Accessories > Headphone Cushions & Tips','en-AU'),(6668,'Electronics > Audio > Audio Accessories > Karaoke System Accessories','en-AU'),(6669,'Electronics > Audio > Audio Accessories > Karaoke System Accessories > Karaoke Chips','en-AU'),(6670,'Electronics > Audio > Audio Accessories > MP3 Player Accessories','en-AU'),(6671,'Electronics > Audio > Audio Accessories > MP3 Player Accessories > MP3 Player & Mobile Phone Accessory Sets','en-AU'),(6672,'Electronics > Audio > Audio Accessories > MP3 Player Accessories > MP3 Player Cases','en-AU'),(6673,'Electronics > Audio > Audio Accessories > Microphone Accessories','en-AU'),(6674,'Electronics > Audio > Audio Accessories > Microphone Stands','en-AU'),(6675,'Electronics > Audio > Audio Accessories > Satellite Radio Accessories','en-AU'),(6676,'Electronics > Audio > Audio Accessories > Speaker Accessories','en-AU'),(6677,'Electronics > Audio > Audio Accessories > Speaker Accessories > Speaker Bags, Covers & Cases','en-AU'),(6678,'Electronics > Audio > Audio Accessories > Speaker Accessories > Speaker Components & Kits','en-AU'),(6679,'Electronics > Audio > Audio Accessories > Speaker Accessories > Speaker Stand Bags','en-AU'),(6680,'Electronics > Audio > Audio Accessories > Speaker Accessories > Speaker Stands & Mounts','en-AU'),(6681,'Electronics > Audio > Audio Accessories > Speaker Accessories > Tactile Transducers','en-AU'),(6682,'Electronics > Audio > Audio Accessories > Turntable Accessories','en-AU'),(6683,'Electronics > Audio > Audio Components','en-AU'),(6684,'Electronics > Audio > Audio Components > Audio Mixers','en-AU'),(6685,'Electronics > Audio > Audio Components > Audio Receivers','en-AU'),(6686,'Electronics > Audio > Audio Components > Audio Transmitters','en-AU'),(6687,'Electronics > Audio > Audio Components > Audio Transmitters > Bluetooth Transmitters','en-AU'),(6688,'Electronics > Audio > Audio Components > Audio Transmitters > FM Transmitters','en-AU'),(6689,'Electronics > Audio > Audio Components > Channel Strips','en-AU'),(6690,'Electronics > Audio > Audio Components > DI Units','en-AU'),(6691,'Electronics > Audio > Audio Components > Headphones & Headsets','en-AU'),(6692,'Electronics > Audio > Audio Components > Microphones','en-AU'),(6693,'Electronics > Audio > Audio Components > Power & Headphone Amplifiers','en-AU'),(6694,'Electronics > Audio > Audio Components > Power & Headphone Amplifiers > Headphone Amplifiers','en-AU'),(6695,'Electronics > Audio > Audio Components > Power & Headphone Amplifiers > Power Amplifiers','en-AU'),(6696,'Electronics > Audio > Audio Components > Signal Processors','en-AU'),(6697,'Electronics > Audio > Audio Components > Signal Processors > Crossovers','en-AU'),(6698,'Electronics > Audio > Audio Components > Signal Processors > Effects Processors','en-AU'),(6699,'Electronics > Audio > Audio Components > Signal Processors > Equalisers','en-AU'),(6700,'Electronics > Audio > Audio Components > Signal Processors > Loudspeaker Management Systems','en-AU'),(6701,'Electronics > Audio > Audio Components > Signal Processors > Microphone Preamps','en-AU'),(6702,'Electronics > Audio > Audio Components > Signal Processors > Noise Gates & Compressors','en-AU'),(6703,'Electronics > Audio > Audio Components > Signal Processors > Phono Preamps','en-AU'),(6704,'Electronics > Audio > Audio Components > Speakers','en-AU'),(6705,'Electronics > Audio > Audio Components > Studio Recording Bundles','en-AU'),(6706,'Electronics > Audio > Audio Players & Recorders','en-AU'),(6707,'Electronics > Audio > Audio Players & Recorders > Boomboxes','en-AU'),(6708,'Electronics > Audio > Audio Players & Recorders > CD Players & Recorders','en-AU'),(6709,'Electronics > Audio > Audio Players & Recorders > Cassette Players & Recorders','en-AU'),(6710,'Electronics > Audio > Audio Players & Recorders > Home Theatre Systems','en-AU'),(6711,'Electronics > Audio > Audio Players & Recorders > Jukeboxes','en-AU'),(6712,'Electronics > Audio > Audio Players & Recorders > Karaoke Systems','en-AU'),(6713,'Electronics > Audio > Audio Players & Recorders > MP3 Players','en-AU'),(6714,'Electronics > Audio > Audio Players & Recorders > MiniDisc Players & Recorders','en-AU'),(6715,'Electronics > Audio > Audio Players & Recorders > Multitrack Recorders','en-AU'),(6716,'Electronics > Audio > Audio Players & Recorders > Radios','en-AU'),(6717,'Electronics > Audio > Audio Players & Recorders > Reel-to-Reel Tape Players & Recorders','en-AU'),(6718,'Electronics > Audio > Audio Players & Recorders > Stereo Systems','en-AU'),(6719,'Electronics > Audio > Audio Players & Recorders > Turntables & Record Players','en-AU'),(6720,'Electronics > Audio > Audio Players & Recorders > Voice Recorders','en-AU'),(6721,'Electronics > Audio > DJ & Speciality Audio','en-AU'),(6722,'Electronics > Audio > DJ & Speciality Audio > DJ CD Players','en-AU'),(6723,'Electronics > Audio > DJ & Speciality Audio > DJ Systems','en-AU'),(6724,'Electronics > Audio > Megaphones','en-AU'),(6725,'Electronics > Audio > Public Address Systems','en-AU'),(6726,'Electronics > Audio > Stage Equipment','en-AU'),(6727,'Electronics > Audio > Stage Equipment > Wireless Transmitters','en-AU'),(6728,'Electronics > Circuit Boards & Components','en-AU'),(6729,'Electronics > Circuit Boards & Components > Circuit Board Accessories','en-AU'),(6730,'Electronics > Circuit Boards & Components > Circuit Prototyping','en-AU'),(6731,'Electronics > Circuit Boards & Components > Circuit Prototyping > Breadboards','en-AU'),(6732,'Electronics > Circuit Boards & Components > Decoders & Encoders','en-AU'),(6733,'Electronics > Circuit Boards & Components > Electronic Filters','en-AU'),(6734,'Electronics > Circuit Boards & Components > Passive Circuit Components','en-AU'),(6735,'Electronics > Circuit Boards & Components > Passive Circuit Components > Capacitors','en-AU'),(6736,'Electronics > Circuit Boards & Components > Passive Circuit Components > Electronic Oscillators','en-AU'),(6737,'Electronics > Circuit Boards & Components > Passive Circuit Components > Inductors','en-AU'),(6738,'Electronics > Circuit Boards & Components > Passive Circuit Components > Resistors','en-AU'),(6739,'Electronics > Circuit Boards & Components > Printed Circuit Boards','en-AU'),(6740,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Camera Circuit Boards','en-AU'),(6741,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Computer Circuit Boards','en-AU'),(6742,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Computer Circuit Boards > Computer Inverter Boards','en-AU'),(6743,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Computer Circuit Boards > Hard Drive Circuit Boards','en-AU'),(6744,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Computer Circuit Boards > Motherboards','en-AU'),(6745,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Development Boards','en-AU'),(6746,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Exercise Machine Circuit Boards','en-AU'),(6747,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Household Appliance Circuit Boards','en-AU'),(6748,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Pool & Spa Circuit Boards','en-AU'),(6749,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Printer, Copier & Fax Machine Circuit Boards','en-AU'),(6750,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Scanner Circuit Boards','en-AU'),(6751,'Electronics > Circuit Boards & Components > Printed Circuit Boards > Television Circuit Boards','en-AU'),(6752,'Electronics > Circuit Boards & Components > Semiconductors','en-AU'),(6753,'Electronics > Circuit Boards & Components > Semiconductors > Diodes','en-AU'),(6754,'Electronics > Circuit Boards & Components > Semiconductors > Integrated Circuits & Chips','en-AU'),(6755,'Electronics > Circuit Boards & Components > Semiconductors > Microcontrollers','en-AU'),(6756,'Electronics > Circuit Boards & Components > Semiconductors > Transistors','en-AU'),(6757,'Electronics > Communications','en-AU'),(6758,'Electronics > Communications > Answering Machines','en-AU'),(6759,'Electronics > Communications > Caller IDs','en-AU'),(6760,'Electronics > Communications > Communication Radio Accessories','en-AU'),(6761,'Electronics > Communications > Communication Radios','en-AU'),(6762,'Electronics > Communications > Communication Radios > CB Radios','en-AU'),(6763,'Electronics > Communications > Communication Radios > FRS Radios','en-AU'),(6764,'Electronics > Communications > Communication Radios > Radio Scanners','en-AU'),(6765,'Electronics > Communications > Intercom Accessories','en-AU'),(6766,'Electronics > Communications > Intercoms','en-AU'),(6767,'Electronics > Communications > Pagers','en-AU'),(6768,'Electronics > Communications > Telephony','en-AU'),(6769,'Electronics > Communications > Telephony > Conference Phones','en-AU'),(6770,'Electronics > Communications > Telephony > Corded Phones','en-AU'),(6771,'Electronics > Communications > Telephony > Cordless Phones','en-AU'),(6772,'Electronics > Communications > Telephony > Mobile Phone Accessories','en-AU'),(6773,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Camera Accessories','en-AU'),(6774,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Car Mounts','en-AU'),(6775,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Cases','en-AU'),(6776,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Charms & Straps','en-AU'),(6777,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Pre-Paid Cards & SIM Cards','en-AU'),(6778,'Electronics > Communications > Telephony > Mobile Phone Accessories > Mobile Phone Replacement Parts','en-AU'),(6779,'Electronics > Communications > Telephony > Mobile Phone Accessories > SIM Card Ejection Tools','en-AU'),(6780,'Electronics > Communications > Telephony > Mobile Phones','en-AU'),(6781,'Electronics > Communications > Telephony > Satellite Phones','en-AU'),(6782,'Electronics > Communications > Telephony > Telephone Accessories','en-AU'),(6783,'Electronics > Communications > Telephony > Telephone Accessories > Phone Cards','en-AU'),(6784,'Electronics > Communications > Video Conferencing','en-AU'),(6785,'Electronics > Components','en-AU'),(6786,'Electronics > Components > Accelerometers','en-AU'),(6787,'Electronics > Components > Converters','en-AU'),(6788,'Electronics > Components > Converters > Audio Converters','en-AU'),(6789,'Electronics > Components > Converters > Scan Converters','en-AU'),(6790,'Electronics > Components > Electronics Component Connectors','en-AU'),(6791,'Electronics > Components > Modulators','en-AU'),(6792,'Electronics > Components > Splitters','en-AU'),(6793,'Electronics > Computers','en-AU'),(6794,'Electronics > Computers > Barebone Computers','en-AU'),(6795,'Electronics > Computers > Computer Servers','en-AU'),(6796,'Electronics > Computers > Desktop Computers','en-AU'),(6797,'Electronics > Computers > Handheld Devices','en-AU'),(6798,'Electronics > Computers > Handheld Devices > Data Collectors','en-AU'),(6799,'Electronics > Computers > Handheld Devices > E-Readers','en-AU'),(6800,'Electronics > Computers > Handheld Devices > PDAs','en-AU'),(6801,'Electronics > Computers > Interactive Kiosks','en-AU'),(6802,'Electronics > Computers > Laptops','en-AU'),(6803,'Electronics > Computers > Smart Glasses','en-AU'),(6804,'Electronics > Computers > Tablet Computers','en-AU'),(6805,'Electronics > Computers > Thin & Zero Clients','en-AU'),(6806,'Electronics > Computers > Touch Table Computers','en-AU'),(6807,'Electronics > Electronics Accessories','en-AU'),(6808,'Electronics > Electronics Accessories > Adaptors','en-AU'),(6809,'Electronics > Electronics Accessories > Adaptors > Audio & Video Cable Adapters & Couplers','en-AU'),(6810,'Electronics > Electronics Accessories > Adaptors > Memory Card Adapters','en-AU'),(6811,'Electronics > Electronics Accessories > Adaptors > USB Adapters','en-AU'),(6812,'Electronics > Electronics Accessories > Aerials','en-AU'),(6813,'Electronics > Electronics Accessories > Antenna Accessories','en-AU'),(6814,'Electronics > Electronics Accessories > Antenna Accessories > Antenna Mounts & Brackets','en-AU'),(6815,'Electronics > Electronics Accessories > Antenna Accessories > Antenna Rotators','en-AU'),(6816,'Electronics > Electronics Accessories > Antenna Accessories > Satellite LNBs','en-AU'),(6817,'Electronics > Electronics Accessories > Audio & Video Splitters & Switches','en-AU'),(6818,'Electronics > Electronics Accessories > Audio & Video Splitters & Switches > DVI Splitters & Switches','en-AU'),(6819,'Electronics > Electronics Accessories > Audio & Video Splitters & Switches > HDMI Splitters & Switches','en-AU'),(6820,'Electronics > Electronics Accessories > Audio & Video Splitters & Switches > VGA Splitters & Switches','en-AU'),(6821,'Electronics > Electronics Accessories > Blank Media','en-AU'),(6822,'Electronics > Electronics Accessories > Cable Management','en-AU'),(6823,'Electronics > Electronics Accessories > Cable Management > Cable Clips','en-AU'),(6824,'Electronics > Electronics Accessories > Cable Management > Cable Tie Guns','en-AU'),(6825,'Electronics > Electronics Accessories > Cable Management > Cable Trays','en-AU'),(6826,'Electronics > Electronics Accessories > Cable Management > Patch Panels','en-AU'),(6827,'Electronics > Electronics Accessories > Cable Management > Wire & Cable Identification Markers','en-AU'),(6828,'Electronics > Electronics Accessories > Cable Management > Wire & Cable Sleeves','en-AU'),(6829,'Electronics > Electronics Accessories > Cable Management > Wire & Cable Ties','en-AU'),(6830,'Electronics > Electronics Accessories > Cables','en-AU'),(6831,'Electronics > Electronics Accessories > Cables > Audio & Video Cables','en-AU'),(6832,'Electronics > Electronics Accessories > Cables > KVM Cables','en-AU'),(6833,'Electronics > Electronics Accessories > Cables > Network Cables','en-AU'),(6834,'Electronics > Electronics Accessories > Cables > Storage & Data Transfer Cables','en-AU'),(6835,'Electronics > Electronics Accessories > Cables > Systems & Power Cables','en-AU'),(6836,'Electronics > Electronics Accessories > Cables > Telephone Cables','en-AU'),(6837,'Electronics > Electronics Accessories > Computer Accessories','en-AU'),(6838,'Electronics > Electronics Accessories > Computer Accessories > Computer Accessory Sets','en-AU'),(6839,'Electronics > Electronics Accessories > Computer Accessories > Computer Covers & Skins','en-AU'),(6840,'Electronics > Electronics Accessories > Computer Accessories > Computer Risers & Stands','en-AU'),(6841,'Electronics > Electronics Accessories > Computer Accessories > Handheld Device Accessories','en-AU'),(6842,'Electronics > Electronics Accessories > Computer Accessories > Handheld Device Accessories > E-Reader Accessories','en-AU'),(6843,'Electronics > Electronics Accessories > Computer Accessories > Handheld Device Accessories > E-Reader Accessories > E-Reader Cases','en-AU'),(6844,'Electronics > Electronics Accessories > Computer Accessories > Handheld Device Accessories > PDA Accessories','en-AU'),(6845,'Electronics > Electronics Accessories > Computer Accessories > Handheld Device Accessories > PDA Accessories > PDA Cases','en-AU'),(6846,'Electronics > Electronics Accessories > Computer Accessories > Keyboard & Mouse Wrist Rests','en-AU'),(6847,'Electronics > Electronics Accessories > Computer Accessories > Keyboard Trays & Platforms','en-AU'),(6848,'Electronics > Electronics Accessories > Computer Accessories > Laptop Docking Stations','en-AU'),(6849,'Electronics > Electronics Accessories > Computer Accessories > Mouse Pads','en-AU'),(6850,'Electronics > Electronics Accessories > Computer Accessories > Stylus Pen Nibs & Refills','en-AU'),(6851,'Electronics > Electronics Accessories > Computer Accessories > Stylus Pens','en-AU'),(6852,'Electronics > Electronics Accessories > Computer Accessories > Tablet Computer Docks & Stands','en-AU'),(6853,'Electronics > Electronics Accessories > Computer Components','en-AU'),(6854,'Electronics > Electronics Accessories > Computer Components > Blade Server Enclosures','en-AU'),(6855,'Electronics > Electronics Accessories > Computer Components > Computer Power Supplies','en-AU'),(6856,'Electronics > Electronics Accessories > Computer Components > Computer Processors','en-AU'),(6857,'Electronics > Electronics Accessories > Computer Components > Computer Racks & Mounts','en-AU'),(6858,'Electronics > Electronics Accessories > Computer Components > Computer Starter Kits','en-AU'),(6859,'Electronics > Electronics Accessories > Computer Components > Computer System Cooling Parts','en-AU'),(6860,'Electronics > Electronics Accessories > Computer Components > Desktop Computer & Server Cases','en-AU'),(6861,'Electronics > Electronics Accessories > Computer Components > E-Reader Parts','en-AU'),(6862,'Electronics > Electronics Accessories > Computer Components > E-Reader Parts > E-Reader Replacement Screens & Screen Digitisers','en-AU'),(6863,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors','en-AU'),(6864,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors > Audio Cards & Adaptors','en-AU'),(6865,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors > Computer Interface Cards & Adapters','en-AU'),(6866,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors > Graphics Cards & Video Adaptors','en-AU'),(6867,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors > Riser Cards','en-AU'),(6868,'Electronics > Electronics Accessories > Computer Components > I/O Cards & Adaptors > TV Tuner Cards & Adaptors','en-AU'),(6869,'Electronics > Electronics Accessories > Computer Components > Input Device Accessories','en-AU'),(6870,'Electronics > Electronics Accessories > Computer Components > Input Device Accessories > Barcode Scanner Stands','en-AU'),(6871,'Electronics > Electronics Accessories > Computer Components > Input Device Accessories > Game Controller Accessories','en-AU'),(6872,'Electronics > Electronics Accessories > Computer Components > Input Device Accessories > Keyboard Keys & Caps','en-AU'),(6873,'Electronics > Electronics Accessories > Computer Components > Input Device Accessories > Mice & Trackball Accessories','en-AU'),(6874,'Electronics > Electronics Accessories > Computer Components > Input Devices','en-AU'),(6875,'Electronics > Electronics Accessories > Computer Components > Input Devices > Barcode Scanners','en-AU'),(6876,'Electronics > Electronics Accessories > Computer Components > Input Devices > Digital Note Taking Pens','en-AU'),(6877,'Electronics > Electronics Accessories > Computer Components > Input Devices > Electronic Card Readers','en-AU'),(6878,'Electronics > Electronics Accessories > Computer Components > Input Devices > Fingerprint Readers','en-AU'),(6879,'Electronics > Electronics Accessories > Computer Components > Input Devices > Game Controllers','en-AU'),(6880,'Electronics > Electronics Accessories > Computer Components > Input Devices > Gesture Control Input Devices','en-AU'),(6881,'Electronics > Electronics Accessories > Computer Components > Input Devices > Graphics Tablets','en-AU'),(6882,'Electronics > Electronics Accessories > Computer Components > Input Devices > KVM Switches','en-AU'),(6883,'Electronics > Electronics Accessories > Computer Components > Input Devices > Keyboards','en-AU'),(6884,'Electronics > Electronics Accessories > Computer Components > Input Devices > Memory Card Readers','en-AU'),(6885,'Electronics > Electronics Accessories > Computer Components > Input Devices > Mice & Trackballs','en-AU'),(6886,'Electronics > Electronics Accessories > Computer Components > Input Devices > Numerical Keypads','en-AU'),(6887,'Electronics > Electronics Accessories > Computer Components > Input Devices > Touchpads','en-AU'),(6888,'Electronics > Electronics Accessories > Computer Components > Laptop Parts','en-AU'),(6889,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Hinges','en-AU'),(6890,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Housings & Trim','en-AU'),(6891,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Replacement Cables','en-AU'),(6892,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Replacement Keyboards','en-AU'),(6893,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Replacement Screens','en-AU'),(6894,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Replacement Speakers','en-AU'),(6895,'Electronics > Electronics Accessories > Computer Components > Laptop Parts > Laptop Screen Digitisers','en-AU'),(6896,'Electronics > Electronics Accessories > Computer Components > Storage Devices','en-AU'),(6897,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Disk Duplicators','en-AU'),(6898,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Disk Duplicators > CD/DVD Duplicators','en-AU'),(6899,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Disk Duplicators > Hard-Drive Duplicators','en-AU'),(6900,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Disk Duplicators > USB Drive Duplicators','en-AU'),(6901,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Floppy Drives','en-AU'),(6902,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drive Accessories','en-AU'),(6903,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drive Accessories > Hard Drive Carrying Cases','en-AU'),(6904,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drive Accessories > Hard Drive Docks','en-AU'),(6905,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drive Accessories > Hard Drive Enclosures & Mounts','en-AU'),(6906,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drive Arrays','en-AU'),(6907,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Hard Drives','en-AU'),(6908,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Network Storage Systems','en-AU'),(6909,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Optical Drives','en-AU'),(6910,'Electronics > Electronics Accessories > Computer Components > Storage Devices > Tape Drives','en-AU'),(6911,'Electronics > Electronics Accessories > Computer Components > Storage Devices > USB Flash Drives','en-AU'),(6912,'Electronics > Electronics Accessories > Computer Components > Tablet Computer Parts','en-AU'),(6913,'Electronics > Electronics Accessories > Computer Components > Tablet Computer Parts > Tablet Computer Housings & Trim','en-AU'),(6914,'Electronics > Electronics Accessories > Computer Components > Tablet Computer Parts > Tablet Computer Replacement Speakers','en-AU'),(6915,'Electronics > Electronics Accessories > Computer Components > Tablet Computer Parts > Tablet Computer Screens & Screen Digitizers','en-AU'),(6916,'Electronics > Electronics Accessories > Computer Components > USB & FireWire Hubs','en-AU'),(6917,'Electronics > Electronics Accessories > Computer Components > Video Card Brackets','en-AU'),(6918,'Electronics > Electronics Accessories > Electronics Cleaners','en-AU'),(6919,'Electronics > Electronics Accessories > Electronics Films & Shields','en-AU'),(6920,'Electronics > Electronics Accessories > Electronics Films & Shields > Electronics Stickers & Transfers','en-AU'),(6921,'Electronics > Electronics Accessories > Electronics Films & Shields > Keyboard Protectors','en-AU'),(6922,'Electronics > Electronics Accessories > Electronics Films & Shields > Privacy Filters','en-AU'),(6923,'Electronics > Electronics Accessories > Electronics Films & Shields > Screen Protectors','en-AU'),(6924,'Electronics > Electronics Accessories > Memory','en-AU'),(6925,'Electronics > Electronics Accessories > Memory > Cache Memory','en-AU'),(6926,'Electronics > Electronics Accessories > Memory > Flash Memory','en-AU'),(6927,'Electronics > Electronics Accessories > Memory > Flash Memory > Flash Memory Cards','en-AU'),(6928,'Electronics > Electronics Accessories > Memory > RAM','en-AU'),(6929,'Electronics > Electronics Accessories > Memory > ROM','en-AU'),(6930,'Electronics > Electronics Accessories > Memory > Video Memory','en-AU'),(6931,'Electronics > Electronics Accessories > Memory Accessories','en-AU'),(6932,'Electronics > Electronics Accessories > Memory Accessories > Memory Cases','en-AU'),(6933,'Electronics > Electronics Accessories > Mobile Phone & Tablet Tripods & Monopods','en-AU'),(6934,'Electronics > Electronics Accessories > Power','en-AU'),(6935,'Electronics > Electronics Accessories > Power > Batteries','en-AU'),(6936,'Electronics > Electronics Accessories > Power > Batteries > Camera Batteries','en-AU'),(6937,'Electronics > Electronics Accessories > Power > Batteries > Cordless Phone Batteries','en-AU'),(6938,'Electronics > Electronics Accessories > Power > Batteries > E-Reader Batteries','en-AU'),(6939,'Electronics > Electronics Accessories > Power > Batteries > General Purpose Batteries','en-AU'),(6940,'Electronics > Electronics Accessories > Power > Batteries > Laptop Batteries','en-AU'),(6941,'Electronics > Electronics Accessories > Power > Batteries > MP3 Player Batteries','en-AU'),(6942,'Electronics > Electronics Accessories > Power > Batteries > Mobile Phone Batteries','en-AU'),(6943,'Electronics > Electronics Accessories > Power > Batteries > PDA Batteries','en-AU'),(6944,'Electronics > Electronics Accessories > Power > Batteries > Tablet Computer Batteries','en-AU'),(6945,'Electronics > Electronics Accessories > Power > Batteries > UPS Batteries','en-AU'),(6946,'Electronics > Electronics Accessories > Power > Batteries > Video Camera Batteries','en-AU'),(6947,'Electronics > Electronics Accessories > Power > Batteries > Video Game Consoles & Controller Batteries','en-AU'),(6948,'Electronics > Electronics Accessories > Power > Battery Accessories','en-AU'),(6949,'Electronics > Electronics Accessories > Power > Battery Accessories > Battery Charge Controllers','en-AU'),(6950,'Electronics > Electronics Accessories > Power > Battery Accessories > Battery Holders','en-AU'),(6951,'Electronics > Electronics Accessories > Power > Battery Accessories > Camera Battery Chargers','en-AU'),(6952,'Electronics > Electronics Accessories > Power > Battery Accessories > General Purpose Battery Chargers','en-AU'),(6953,'Electronics > Electronics Accessories > Power > Battery Accessories > General Purpose Battery Testers','en-AU'),(6954,'Electronics > Electronics Accessories > Power > Fuel Cells','en-AU'),(6955,'Electronics > Electronics Accessories > Power > Power Adapter & Charger Accessories','en-AU'),(6956,'Electronics > Electronics Accessories > Power > Power Adapters & Chargers','en-AU'),(6957,'Electronics > Electronics Accessories > Power > Power Control Units','en-AU'),(6958,'Electronics > Electronics Accessories > Power > Power Strips & Surge Suppressors','en-AU'),(6959,'Electronics > Electronics Accessories > Power > Power Supply Enclosures','en-AU'),(6960,'Electronics > Electronics Accessories > Power > Surge Protection Devices','en-AU'),(6961,'Electronics > Electronics Accessories > Power > Travel Converters & Adapters','en-AU'),(6962,'Electronics > Electronics Accessories > Power > UPS','en-AU'),(6963,'Electronics > Electronics Accessories > Power > UPS Accessories','en-AU'),(6964,'Electronics > Electronics Accessories > Remote Controls','en-AU'),(6965,'Electronics > Electronics Accessories > Signal Boosters','en-AU'),(6966,'Electronics > Electronics Accessories > Signal Jammers','en-AU'),(6967,'Electronics > Electronics Accessories > Signal Jammers > GPS Jammers','en-AU'),(6968,'Electronics > Electronics Accessories > Signal Jammers > Mobile Phone Jammers','en-AU'),(6969,'Electronics > Electronics Accessories > Signal Jammers > Radar Jammers','en-AU'),(6970,'Electronics > GPS Tracking Devices','en-AU'),(6971,'Electronics > Marine Electronics','en-AU'),(6972,'Electronics > Marine Electronics > Fish Finders','en-AU'),(6973,'Electronics > Marine Electronics > Marine Audio & Video Receivers','en-AU'),(6974,'Electronics > Marine Electronics > Marine Chart Plotters & GPS','en-AU'),(6975,'Electronics > Marine Electronics > Marine Radar','en-AU'),(6976,'Electronics > Marine Electronics > Marine Radios','en-AU'),(6977,'Electronics > Marine Electronics > Marine Speakers','en-AU'),(6978,'Electronics > Networking','en-AU'),(6979,'Electronics > Networking > Bridges & Routers','en-AU'),(6980,'Electronics > Networking > Bridges & Routers > Network Bridges','en-AU'),(6981,'Electronics > Networking > Bridges & Routers > VoIP Gateways & Routers','en-AU'),(6982,'Electronics > Networking > Bridges & Routers > Wireless Access Points','en-AU'),(6983,'Electronics > Networking > Bridges & Routers > Wireless Routers','en-AU'),(6984,'Electronics > Networking > Concentrators & Multiplexers','en-AU'),(6985,'Electronics > Networking > Hubs & Switches','en-AU'),(6986,'Electronics > Networking > Modem Accessories','en-AU'),(6987,'Electronics > Networking > Modems','en-AU'),(6988,'Electronics > Networking > Network Cards & Adaptors','en-AU'),(6989,'Electronics > Networking > Network Security & Firewall Devices','en-AU'),(6990,'Electronics > Networking > Power Over Ethernet Adapters','en-AU'),(6991,'Electronics > Networking > Print Servers','en-AU'),(6992,'Electronics > Networking > Repeaters & Transceivers','en-AU'),(6993,'Electronics > Print, Copy, Scan & Fax','en-AU'),(6994,'Electronics > Print, Copy, Scan & Fax > 3D Printer Accessories','en-AU'),(6995,'Electronics > Print, Copy, Scan & Fax > 3D Printers','en-AU'),(6996,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories','en-AU'),(6997,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables','en-AU'),(6998,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Printer Drums & Drum Kits','en-AU'),(6999,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Printer Filters','en-AU'),(7000,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Printer Maintenance Kits','en-AU'),(7001,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Printer Ribbons','en-AU'),(7002,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Printheads','en-AU'),(7003,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Toner & Inkjet Cartridge Refills','en-AU'),(7004,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Consumables > Toner & Inkjet Cartridges','en-AU'),(7005,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Duplexers','en-AU'),(7006,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Memory','en-AU'),(7007,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer Stands','en-AU'),(7008,'Electronics > Print, Copy, Scan & Fax > Printer, Photocopier & Fax Machine Accessories > Printer, Photocopier & Fax Machine Replacement Parts','en-AU'),(7009,'Electronics > Print, Copy, Scan & Fax > Printers, Photocopiers & Fax Machines','en-AU'),(7010,'Electronics > Print, Copy, Scan & Fax > Scanner Accessories','en-AU'),(7011,'Electronics > Print, Copy, Scan & Fax > Scanners','en-AU'),(7012,'Electronics > Radar Detectors','en-AU'),(7013,'Electronics > Sat Nav & GPS Accessories','en-AU'),(7014,'Electronics > Sat Nav & GPS Accessories > Sat Nav & GPS Cases','en-AU'),(7015,'Electronics > Sat Nav & GPS Accessories > Sat Nav & GPS Mounts','en-AU'),(7016,'Electronics > Sat Navs & GPS Navigation Systems','en-AU'),(7017,'Electronics > Speed Radars','en-AU'),(7018,'Electronics > Toll Collection Devices','en-AU'),(7019,'Electronics > Video','en-AU'),(7020,'Electronics > Video > Computer Monitors','en-AU'),(7021,'Electronics > Video > Projectors','en-AU'),(7022,'Electronics > Video > Projectors > Multimedia Projectors','en-AU'),(7023,'Electronics > Video > Projectors > Overhead Projectors','en-AU'),(7024,'Electronics > Video > Projectors > Slide Projectors','en-AU'),(7025,'Electronics > Video > Satellite & Cable TV','en-AU'),(7026,'Electronics > Video > Satellite & Cable TV > Cable TV Receivers','en-AU'),(7027,'Electronics > Video > Satellite & Cable TV > Satellite Receivers','en-AU'),(7028,'Electronics > Video > Televisions','en-AU'),(7029,'Electronics > Video > Video Accessories','en-AU'),(7030,'Electronics > Video > Video Accessories > 3D Glasses','en-AU'),(7031,'Electronics > Video > Video Accessories > Computer Monitor Accessories','en-AU'),(7032,'Electronics > Video > Video Accessories > Computer Monitor Accessories > Colour Calibrators','en-AU'),(7033,'Electronics > Video > Video Accessories > Projector Accessories','en-AU'),(7034,'Electronics > Video > Video Accessories > Projector Accessories > Projection & Tripod Skirts','en-AU'),(7035,'Electronics > Video > Video Accessories > Projector Accessories > Projection Screen Stands','en-AU'),(7036,'Electronics > Video > Video Accessories > Projector Accessories > Projection Screens','en-AU'),(7037,'Electronics > Video > Video Accessories > Projector Accessories > Projector Mounts','en-AU'),(7038,'Electronics > Video > Video Accessories > Projector Accessories > Projector Replacement Lamps','en-AU'),(7039,'Electronics > Video > Video Accessories > Rewinders','en-AU'),(7040,'Electronics > Video > Video Accessories > Television Parts &  Accessories','en-AU'),(7041,'Electronics > Video > Video Accessories > Television Parts &  Accessories > TV & Monitor Mounts','en-AU'),(7042,'Electronics > Video > Video Accessories > Television Parts &  Accessories > TV Replacement Speakers','en-AU'),(7043,'Electronics > Video > Video Accessories > Television Parts &  Accessories > Television Replacement Lamps','en-AU'),(7044,'Electronics > Video > Video Accessories > Television Parts &  Accessories > Television Set-Top Boxes','en-AU'),(7045,'Electronics > Video > Video Editing Hardware & Production Equipment','en-AU'),(7046,'Electronics > Video > Video Multiplexers','en-AU'),(7047,'Electronics > Video > Video Players & Recorders','en-AU'),(7048,'Electronics > Video > Video Players & Recorders > DVD & Blu-ray Players','en-AU'),(7049,'Electronics > Video > Video Players & Recorders > DVD Recorders','en-AU'),(7050,'Electronics > Video > Video Players & Recorders > Digital Video Recorders','en-AU'),(7051,'Electronics > Video > Video Players & Recorders > Media Streaming Devices','en-AU'),(7052,'Electronics > Video > Video Players & Recorders > VCRs','en-AU'),(7053,'Electronics > Video > Video Servers','en-AU'),(7054,'Electronics > Video > Video Transmitters','en-AU'),(7055,'Electronics > Video Game Console Accessories','en-AU'),(7056,'Electronics > Video Game Console Accessories > Home Game Console Accessories','en-AU'),(7057,'Electronics > Video Game Console Accessories > Portable Game Console Accessories','en-AU'),(7058,'Electronics > Video Game Consoles','en-AU'),(7059,'Food, Beverages & Tobacco','en-AU'),(7060,'Food, Beverages & Tobacco > Beverages','en-AU'),(7061,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages','en-AU'),(7062,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Beer','en-AU'),(7063,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Bitters','en-AU'),(7064,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Cider','en-AU'),(7065,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Cocktail Mixes','en-AU'),(7066,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Flavoured Alcoholic Beverages','en-AU'),(7067,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits','en-AU'),(7068,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Absinthe','en-AU'),(7069,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Brandy','en-AU'),(7070,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Gin','en-AU'),(7071,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Liqueurs','en-AU'),(7072,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Rum','en-AU'),(7073,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Shochu & Soju','en-AU'),(7074,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Tequila','en-AU'),(7075,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Vodka','en-AU'),(7076,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Liquor & Spirits > Whisky','en-AU'),(7077,'Food, Beverages & Tobacco > Beverages > Alcoholic Beverages > Wine','en-AU'),(7078,'Food, Beverages & Tobacco > Beverages > Buttermilk','en-AU'),(7079,'Food, Beverages & Tobacco > Beverages > Coffee','en-AU'),(7080,'Food, Beverages & Tobacco > Beverages > Eggnog','en-AU'),(7081,'Food, Beverages & Tobacco > Beverages > Fizzy Drinks','en-AU'),(7082,'Food, Beverages & Tobacco > Beverages > Fruit-Flavoured Drinks','en-AU'),(7083,'Food, Beverages & Tobacco > Beverages > Hot Chocolate','en-AU'),(7084,'Food, Beverages & Tobacco > Beverages > Juice','en-AU'),(7085,'Food, Beverages & Tobacco > Beverages > Milk','en-AU'),(7086,'Food, Beverages & Tobacco > Beverages > Non-Dairy Milk','en-AU'),(7087,'Food, Beverages & Tobacco > Beverages > Powdered Beverage Mixes','en-AU'),(7088,'Food, Beverages & Tobacco > Beverages > Sports & Energy Drinks','en-AU'),(7089,'Food, Beverages & Tobacco > Beverages > Tea & Infusions','en-AU'),(7090,'Food, Beverages & Tobacco > Beverages > Vinegar Drinks','en-AU'),(7091,'Food, Beverages & Tobacco > Beverages > Water','en-AU'),(7092,'Food, Beverages & Tobacco > Food Items','en-AU'),(7093,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks','en-AU'),(7094,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Breadsticks','en-AU'),(7095,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Cereal & Granola Bars','en-AU'),(7096,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Cheese Puffs','en-AU'),(7097,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Chips','en-AU'),(7098,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Crackers','en-AU'),(7099,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Croutons','en-AU'),(7100,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Fruit Snacks','en-AU'),(7101,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Fruit and Nut Snacks','en-AU'),(7102,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Jerky','en-AU'),(7103,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Popcorn','en-AU'),(7104,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Pork Scratchings','en-AU'),(7105,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Pretzels','en-AU'),(7106,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Pudding & Gelatine Snacks','en-AU'),(7107,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Puffed Rice Cakes','en-AU'),(7108,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Salad Toppings','en-AU'),(7109,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Sesame Sticks','en-AU'),(7110,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Snack Cakes','en-AU'),(7111,'Food, Beverages & Tobacco > Food Items > Appetisers & Snacks > Sticky Rice Cakes','en-AU'),(7112,'Food, Beverages & Tobacco > Food Items > Bakery','en-AU'),(7113,'Food, Beverages & Tobacco > Food Items > Bakery > American Muffins','en-AU'),(7114,'Food, Beverages & Tobacco > Food Items > Bakery > Bagels','en-AU'),(7115,'Food, Beverages & Tobacco > Food Items > Bakery > Biscuits','en-AU'),(7116,'Food, Beverages & Tobacco > Food Items > Bakery > Bread & Buns','en-AU'),(7117,'Food, Beverages & Tobacco > Food Items > Bakery > Cakes & Dessert Bars','en-AU'),(7118,'Food, Beverages & Tobacco > Food Items > Bakery > Coffee Cakes','en-AU'),(7119,'Food, Beverages & Tobacco > Food Items > Bakery > Cupcakes','en-AU'),(7120,'Food, Beverages & Tobacco > Food Items > Bakery > Dessert Platters','en-AU'),(7121,'Food, Beverages & Tobacco > Food Items > Bakery > Donuts','en-AU'),(7122,'Food, Beverages & Tobacco > Food Items > Bakery > Fudge','en-AU'),(7123,'Food, Beverages & Tobacco > Food Items > Bakery > Ice Cream Cones','en-AU'),(7124,'Food, Beverages & Tobacco > Food Items > Bakery > Pastries & Scones','en-AU'),(7125,'Food, Beverages & Tobacco > Food Items > Bakery > Pies & Tarts','en-AU'),(7126,'Food, Beverages & Tobacco > Food Items > Bakery > Taco Shells','en-AU'),(7127,'Food, Beverages & Tobacco > Food Items > Bakery > Tortillas & Wraps','en-AU'),(7128,'Food, Beverages & Tobacco > Food Items > Candied & Chocolate-Covered Fruit','en-AU'),(7129,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces','en-AU'),(7130,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Cocktail Sauce','en-AU'),(7131,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Curry Sauce','en-AU'),(7132,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Dessert Toppings','en-AU'),(7133,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Dessert Toppings > Fruit Toppings','en-AU'),(7134,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Dessert Toppings > Ice Cream Syrup','en-AU'),(7135,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Fish Sauce','en-AU'),(7136,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Gravy','en-AU'),(7137,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Honey','en-AU'),(7138,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Horseradish Sauce','en-AU'),(7139,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Hot Sauce','en-AU'),(7140,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Ketchup','en-AU'),(7141,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Marinades & Barbeque Sauces','en-AU'),(7142,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Mayonnaise','en-AU'),(7143,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Mustard','en-AU'),(7144,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Olives & Capers','en-AU'),(7145,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Pasta Sauces','en-AU'),(7146,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Pickled Fruits & Vegetables','en-AU'),(7147,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Pizza Sauce','en-AU'),(7148,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Relish & Chutney','en-AU'),(7149,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Salad Dressings','en-AU'),(7150,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Satay Sauce','en-AU'),(7151,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Soy Sauce','en-AU'),(7152,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Sweet and Sour Sauces','en-AU'),(7153,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Syrup','en-AU'),(7154,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Tahini','en-AU'),(7155,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Tartar Sauce','en-AU'),(7156,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > White & Cream Sauces','en-AU'),(7157,'Food, Beverages & Tobacco > Food Items > Condiments & Sauces > Worcestershire Sauce','en-AU'),(7158,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients','en-AU'),(7159,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Chips','en-AU'),(7160,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Chocolate','en-AU'),(7161,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Flavours & Extracts','en-AU'),(7162,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Mixes','en-AU'),(7163,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Powder','en-AU'),(7164,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Baking Soda','en-AU'),(7165,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Batter & Coating Mixes','en-AU'),(7166,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Bean Pastes & Sauces','en-AU'),(7167,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Bread Crumbs','en-AU'),(7168,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Canned & Powdered Milk','en-AU'),(7169,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Cooking Oils','en-AU'),(7170,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Cooking Starch','en-AU'),(7171,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Cooking Wine','en-AU'),(7172,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Corn Syrup','en-AU'),(7173,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Dough','en-AU'),(7174,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Dough > Biscuit & Brownie Dough','en-AU'),(7175,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Dough > Bread & Pastry Dough','en-AU'),(7176,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Dough > Pie Crusts','en-AU'),(7177,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Edible Baking Decoration Kits','en-AU'),(7178,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Edible Baking Decorations','en-AU'),(7179,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Floss Sugar','en-AU'),(7180,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Flour','en-AU'),(7181,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Food Colouring','en-AU'),(7182,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Frosting & Icing','en-AU'),(7183,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Lemon & Lime Juice','en-AU'),(7184,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Marshmallows','en-AU'),(7185,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Meal','en-AU'),(7186,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Pie & Pastry Fillings','en-AU'),(7187,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Shortening & Lard','en-AU'),(7188,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Starter Cultures','en-AU'),(7189,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Sugar & Sweeteners','en-AU'),(7190,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Tapioca Pearls','en-AU'),(7191,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Tomato Paste','en-AU'),(7192,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Treacle','en-AU'),(7193,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Unflavored Gelatine','en-AU'),(7194,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Vinegar','en-AU'),(7195,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Waffle & Pancake Mixes','en-AU'),(7196,'Food, Beverages & Tobacco > Food Items > Cooking & Baking Ingredients > Yeast','en-AU'),(7197,'Food, Beverages & Tobacco > Food Items > Dairy Products','en-AU'),(7198,'Food, Beverages & Tobacco > Food Items > Dairy Products > Butter & Margarine','en-AU'),(7199,'Food, Beverages & Tobacco > Food Items > Dairy Products > Cheese','en-AU'),(7200,'Food, Beverages & Tobacco > Food Items > Dairy Products > Coffee Creamer','en-AU'),(7201,'Food, Beverages & Tobacco > Food Items > Dairy Products > Cottage Cheese','en-AU'),(7202,'Food, Beverages & Tobacco > Food Items > Dairy Products > Cream','en-AU'),(7203,'Food, Beverages & Tobacco > Food Items > Dairy Products > Sour Cream','en-AU'),(7204,'Food, Beverages & Tobacco > Food Items > Dairy Products > Whipped Cream','en-AU'),(7205,'Food, Beverages & Tobacco > Food Items > Dairy Products > Yoghurt','en-AU'),(7206,'Food, Beverages & Tobacco > Food Items > Dips & Spreads','en-AU'),(7207,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Apple Butter','en-AU'),(7208,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Cheese Dips & Spreads','en-AU'),(7209,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Cream Cheese','en-AU'),(7210,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Guacamole','en-AU'),(7211,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Houmous','en-AU'),(7212,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Jams & Preserves','en-AU'),(7213,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Nut Butters','en-AU'),(7214,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Salsa','en-AU'),(7215,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Tapenade','en-AU'),(7216,'Food, Beverages & Tobacco > Food Items > Dips & Spreads > Vegetable Dip','en-AU'),(7217,'Food, Beverages & Tobacco > Food Items > Food Gift Baskets','en-AU'),(7218,'Food, Beverages & Tobacco > Food Items > Frozen Desserts & Novelties','en-AU'),(7219,'Food, Beverages & Tobacco > Food Items > Frozen Desserts & Novelties > Ice Cream & Frozen Yoghurt','en-AU'),(7220,'Food, Beverages & Tobacco > Food Items > Frozen Desserts & Novelties > Ice Cream Novelties','en-AU'),(7221,'Food, Beverages & Tobacco > Food Items > Frozen Desserts & Novelties > Ice Pops','en-AU'),(7222,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables','en-AU'),(7223,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Canned & Jarred Vegetables','en-AU'),(7224,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Dried Beans','en-AU'),(7225,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Dried Fruit','en-AU'),(7226,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Dried Vegetables','en-AU'),(7227,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit','en-AU'),(7228,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Apples','en-AU'),(7229,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Atemoyas','en-AU'),(7230,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Avocados','en-AU'),(7231,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Babacos','en-AU'),(7232,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Bananas','en-AU'),(7233,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Berries','en-AU'),(7234,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Breadfruit','en-AU'),(7235,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Cherimoyas','en-AU'),(7236,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits','en-AU'),(7237,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Grapefruits','en-AU'),(7238,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Kumquats','en-AU'),(7239,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Lemons','en-AU'),(7240,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Limequats','en-AU'),(7241,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Limes','en-AU'),(7242,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Oranges','en-AU'),(7243,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Citrus Fruits > Tangelos','en-AU'),(7244,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Coconuts','en-AU'),(7245,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Dates','en-AU'),(7246,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Dragonfruit','en-AU'),(7247,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Feijoas','en-AU'),(7248,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Figs','en-AU'),(7249,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Fruit Mixes','en-AU'),(7250,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Grapes','en-AU'),(7251,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Guavas','en-AU'),(7252,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Homely Fruits','en-AU'),(7253,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Kiwis','en-AU'),(7254,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Longan','en-AU'),(7255,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Loquats','en-AU'),(7256,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Lychees','en-AU'),(7257,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Madroño','en-AU'),(7258,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Mamey','en-AU'),(7259,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Mangosteens','en-AU'),(7260,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Melons','en-AU'),(7261,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Papayas','en-AU'),(7262,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Passion Fruit','en-AU'),(7263,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Pears','en-AU'),(7264,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Persimmons','en-AU'),(7265,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Physalis','en-AU'),(7266,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Pineapples','en-AU'),(7267,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Pomegranates','en-AU'),(7268,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Prickly Pears','en-AU'),(7269,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Quince','en-AU'),(7270,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Rambutans','en-AU'),(7271,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Sapodillo','en-AU'),(7272,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Sapote','en-AU'),(7273,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Soursops','en-AU'),(7274,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Starfruits','en-AU'),(7275,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits','en-AU'),(7276,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Apricots','en-AU'),(7277,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Cherries','en-AU'),(7278,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Mangos','en-AU'),(7279,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Peaches & Nectarines','en-AU'),(7280,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Plumcots','en-AU'),(7281,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Stone Fruits > Plums','en-AU'),(7282,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Sugar Apples','en-AU'),(7283,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Fruit > Tamarind','en-AU'),(7284,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables','en-AU'),(7285,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Arracachas','en-AU'),(7286,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Artichokes','en-AU'),(7287,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Asparagus','en-AU'),(7288,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Aubergines','en-AU'),(7289,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Beans','en-AU'),(7290,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Beetroots','en-AU'),(7291,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Borage','en-AU'),(7292,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Broccoli','en-AU'),(7293,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Brussels Sprouts','en-AU'),(7294,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Cabbage','en-AU'),(7295,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Cactus Leaves','en-AU'),(7296,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Cardoon','en-AU'),(7297,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Carrots','en-AU'),(7298,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Cauliflower','en-AU'),(7299,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Celery','en-AU'),(7300,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Celery Roots','en-AU'),(7301,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Corn','en-AU'),(7302,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Cucumbers','en-AU'),(7303,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Fennel Bulbs','en-AU'),(7304,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Fiddlehead Ferns','en-AU'),(7305,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Gai Choi','en-AU'),(7306,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Gai Lan','en-AU'),(7307,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Garlic','en-AU'),(7308,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Ginger Root','en-AU'),(7309,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Gobo Root','en-AU'),(7310,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens','en-AU'),(7311,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Beetroot Greens','en-AU'),(7312,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Bok Choi','en-AU'),(7313,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Chard','en-AU'),(7314,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Chicory','en-AU'),(7315,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Choi Sum','en-AU'),(7316,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Kale','en-AU'),(7317,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Lettuce','en-AU'),(7318,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > On Choy','en-AU'),(7319,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Rocket','en-AU'),(7320,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Salad Mixes','en-AU'),(7321,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Spinach','en-AU'),(7322,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Greens > Yu Choy','en-AU'),(7323,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Horseradish Root','en-AU'),(7324,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Jerusalem artichokes','en-AU'),(7325,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Jicama','en-AU'),(7326,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Kohlrabi','en-AU'),(7327,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Leeks','en-AU'),(7328,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Lotus Roots','en-AU'),(7329,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Malangas','en-AU'),(7330,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Mushrooms','en-AU'),(7331,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Okra','en-AU'),(7332,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Onions','en-AU'),(7333,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Parsley Roots','en-AU'),(7334,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Parsnips','en-AU'),(7335,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Peas','en-AU'),(7336,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Peppers','en-AU'),(7337,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Potatoes','en-AU'),(7338,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Radishes','en-AU'),(7339,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Rhubarb','en-AU'),(7340,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Shallots','en-AU'),(7341,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Sprouts','en-AU'),(7342,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Squashes & Gourds','en-AU'),(7343,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Sugar Cane','en-AU'),(7344,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Sweet Potatoes','en-AU'),(7345,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Tamarillos','en-AU'),(7346,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Taro Root','en-AU'),(7347,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Tomatoes','en-AU'),(7348,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Turnips & Swedes','en-AU'),(7349,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Vegetable Mixes','en-AU'),(7350,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Water Chestnuts','en-AU'),(7351,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Watercress','en-AU'),(7352,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Wheatgrass','en-AU'),(7353,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Yams','en-AU'),(7354,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fresh & Frozen Vegetables > Yucca Root','en-AU'),(7355,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Fruit Sauces','en-AU'),(7356,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Tinned & Jarred Fruits','en-AU'),(7357,'Food, Beverages & Tobacco > Food Items > Fruit & Vegetables > Tinned Beans','en-AU'),(7358,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals','en-AU'),(7359,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Amaranth','en-AU'),(7360,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Barley','en-AU'),(7361,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Buckwheat','en-AU'),(7362,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Cereals & Granola','en-AU'),(7363,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Couscous','en-AU'),(7364,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Millet','en-AU'),(7365,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Oats, Grits & Oatmeal','en-AU'),(7366,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Quinoa','en-AU'),(7367,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Rice','en-AU'),(7368,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Rye','en-AU'),(7369,'Food, Beverages & Tobacco > Food Items > Grain, Rice & Cereals > Wheat','en-AU'),(7370,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs','en-AU'),(7371,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Eggs','en-AU'),(7372,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Meat','en-AU'),(7373,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Meat > Fresh & Frozen Meat','en-AU'),(7374,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Meat > Lunch & Deli Meats','en-AU'),(7375,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Meat > Tinned Meat','en-AU'),(7376,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Seafood','en-AU'),(7377,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Seafood > Fresh & Frozen Seafood','en-AU'),(7378,'Food, Beverages & Tobacco > Food Items > Meat, Seafood & Eggs > Seafood > Tinned Seafood','en-AU'),(7379,'Food, Beverages & Tobacco > Food Items > Nuts & Seeds','en-AU'),(7380,'Food, Beverages & Tobacco > Food Items > Pasta & Noodles','en-AU'),(7381,'Food, Beverages & Tobacco > Food Items > Prepared Food','en-AU'),(7382,'Food, Beverages & Tobacco > Food Items > Prepared Food > Prepared Appetisers & Side Dishes','en-AU'),(7383,'Food, Beverages & Tobacco > Food Items > Prepared Food > Prepared Meals & Main Courses','en-AU'),(7384,'Food, Beverages & Tobacco > Food Items > Seasonings & Spices','en-AU'),(7385,'Food, Beverages & Tobacco > Food Items > Seasonings & Spices > Herbs & Spices','en-AU'),(7386,'Food, Beverages & Tobacco > Food Items > Seasonings & Spices > MSG','en-AU'),(7387,'Food, Beverages & Tobacco > Food Items > Seasonings & Spices > Pepper','en-AU'),(7388,'Food, Beverages & Tobacco > Food Items > Seasonings & Spices > Salt','en-AU'),(7389,'Food, Beverages & Tobacco > Food Items > Soups & Broths','en-AU'),(7390,'Food, Beverages & Tobacco > Food Items > Sweets & Chocolate','en-AU'),(7391,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products','en-AU'),(7392,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products > Cheese Alternatives','en-AU'),(7393,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products > Meat Alternatives','en-AU'),(7394,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products > Seitan','en-AU'),(7395,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products > Tempeh','en-AU'),(7396,'Food, Beverages & Tobacco > Food Items > Tofu & Soy Products > Tofu','en-AU'),(7397,'Food, Beverages & Tobacco > Tobacco Products','en-AU'),(7398,'Food, Beverages & Tobacco > Tobacco Products > Chewing Tobacco','en-AU'),(7399,'Food, Beverages & Tobacco > Tobacco Products > Cigarettes','en-AU'),(7400,'Food, Beverages & Tobacco > Tobacco Products > Cigars','en-AU'),(7401,'Food, Beverages & Tobacco > Tobacco Products > Loose Tobacco','en-AU'),(7402,'Food, Beverages & Tobacco > Tobacco Products > Smoking Pipes','en-AU'),(7403,'Food, Beverages & Tobacco > Tobacco Products > Vaporisers & Electronic Cigarettes','en-AU'),(7404,'Furniture','en-AU'),(7405,'Furniture > Baby & Toddler Furniture','en-AU'),(7406,'Furniture > Baby & Toddler Furniture > Baby & Toddler Furniture Sets','en-AU'),(7407,'Furniture > Baby & Toddler Furniture > Changing Tables','en-AU'),(7408,'Furniture > Baby & Toddler Furniture > Cot & Toddler Bed Accessories','en-AU'),(7409,'Furniture > Baby & Toddler Furniture > Cot & Toddler Bed Accessories > Cot Bumpers & Liners','en-AU'),(7410,'Furniture > Baby & Toddler Furniture > Cot & Toddler Bed Accessories > Cot Conversion Kits','en-AU'),(7411,'Furniture > Baby & Toddler Furniture > Cots & Toddler Beds','en-AU'),(7412,'Furniture > Baby & Toddler Furniture > Cradle Accessories','en-AU'),(7413,'Furniture > Baby & Toddler Furniture > Cribs & Cradles','en-AU'),(7414,'Furniture > Baby & Toddler Furniture > High Chair & Booster Seat Accessories','en-AU'),(7415,'Furniture > Baby & Toddler Furniture > High Chairs & Boosters Seats','en-AU'),(7416,'Furniture > Beds & Accessories','en-AU'),(7417,'Furniture > Beds & Accessories > Bed & Bed Frame Accessories','en-AU'),(7418,'Furniture > Beds & Accessories > Beds & Bed Frames','en-AU'),(7419,'Furniture > Beds & Accessories > Headboards & Footboards','en-AU'),(7420,'Furniture > Beds & Accessories > Mattress Foundations','en-AU'),(7421,'Furniture > Beds & Accessories > Mattresses','en-AU'),(7422,'Furniture > Benches','en-AU'),(7423,'Furniture > Benches > Dressing Table Stools','en-AU'),(7424,'Furniture > Benches > Kitchen & Dining Benches','en-AU'),(7425,'Furniture > Benches > Storage & Entryway Benches','en-AU'),(7426,'Furniture > Cabinets & Storage','en-AU'),(7427,'Furniture > Cabinets & Storage > Buffets & Sideboards','en-AU'),(7428,'Furniture > Cabinets & Storage > China Cabinets & Hutches','en-AU'),(7429,'Furniture > Cabinets & Storage > Cupboards & Wardrobes','en-AU'),(7430,'Furniture > Cabinets & Storage > Dressers','en-AU'),(7431,'Furniture > Cabinets & Storage > Filing Cabinets','en-AU'),(7432,'Furniture > Cabinets & Storage > Ironing Centres','en-AU'),(7433,'Furniture > Cabinets & Storage > Kitchen Cabinets','en-AU'),(7434,'Furniture > Cabinets & Storage > Magazine Racks','en-AU'),(7435,'Furniture > Cabinets & Storage > Media Storage Cabinets & Racks','en-AU'),(7436,'Furniture > Cabinets & Storage > Storage Cabinets & Lockers','en-AU'),(7437,'Furniture > Cabinets & Storage > Storage Chests','en-AU'),(7438,'Furniture > Cabinets & Storage > Storage Chests > Hope Chests','en-AU'),(7439,'Furniture > Cabinets & Storage > Storage Chests > Toy Chests','en-AU'),(7440,'Furniture > Cabinets & Storage > Vanity Units','en-AU'),(7441,'Furniture > Cabinets & Storage > Vanity Units > Bathroom Vanity Units','en-AU'),(7442,'Furniture > Cabinets & Storage > Vanity Units > Bedroom Dressing Tables','en-AU'),(7443,'Furniture > Cabinets & Storage > Wine & Spirit Cabinets','en-AU'),(7444,'Furniture > Cabinets & Storage > Wine Racks','en-AU'),(7445,'Furniture > Chair Accessories','en-AU'),(7446,'Furniture > Chair Accessories > Hanging Chair Replacement Parts','en-AU'),(7447,'Furniture > Chairs','en-AU'),(7448,'Furniture > Chairs > Arm Chairs, Recliners & Sleeper Chairs','en-AU'),(7449,'Furniture > Chairs > Bean Bag Chairs','en-AU'),(7450,'Furniture > Chairs > Chaises Longues','en-AU'),(7451,'Furniture > Chairs > Electric Massaging Chairs','en-AU'),(7452,'Furniture > Chairs > Floor Chairs','en-AU'),(7453,'Furniture > Chairs > Folding Chairs & Stools','en-AU'),(7454,'Furniture > Chairs > Gaming Chairs','en-AU'),(7455,'Furniture > Chairs > Hanging Chairs','en-AU'),(7456,'Furniture > Chairs > Kitchen & Dining Room Chairs','en-AU'),(7457,'Furniture > Chairs > Rocking Chairs','en-AU'),(7458,'Furniture > Chairs > Slipper Chairs','en-AU'),(7459,'Furniture > Chairs > Table & Bar Stools','en-AU'),(7460,'Furniture > Entertainment Centers & TV Stands','en-AU'),(7461,'Furniture > Foot Rests','en-AU'),(7462,'Furniture > Furniture Sets','en-AU'),(7463,'Furniture > Furniture Sets > Bathroom Furniture Sets','en-AU'),(7464,'Furniture > Furniture Sets > Bedroom Furniture Sets','en-AU'),(7465,'Furniture > Furniture Sets > Kitchen & Dining Furniture Sets','en-AU'),(7466,'Furniture > Furniture Sets > Living Room Furniture Sets','en-AU'),(7467,'Furniture > Futon Frames','en-AU'),(7468,'Furniture > Futon Pads','en-AU'),(7469,'Furniture > Futons','en-AU'),(7470,'Furniture > Office Furniture','en-AU'),(7471,'Furniture > Office Furniture > Desks','en-AU'),(7472,'Furniture > Office Furniture > Office & Desk Chairs','en-AU'),(7473,'Furniture > Office Furniture > Office Furniture Sets','en-AU'),(7474,'Furniture > Office Furniture > Workspace Tables','en-AU'),(7475,'Furniture > Office Furniture > Workspace Tables > Art & Drafting Tables','en-AU'),(7476,'Furniture > Office Furniture > Workspace Tables > Conference Room Tables','en-AU'),(7477,'Furniture > Office Furniture > Workstations & Cubicles','en-AU'),(7478,'Furniture > Office Furniture Accessories','en-AU'),(7479,'Furniture > Office Furniture Accessories > Desk Parts & Accessories','en-AU'),(7480,'Furniture > Office Furniture Accessories > Office & Desk Chair Accessories','en-AU'),(7481,'Furniture > Office Furniture Accessories > Workstation & Cubicle Accessories','en-AU'),(7482,'Furniture > Outdoor Furniture','en-AU'),(7483,'Furniture > Outdoor Furniture > Outdoor Beds','en-AU'),(7484,'Furniture > Outdoor Furniture > Outdoor Foot Rests','en-AU'),(7485,'Furniture > Outdoor Furniture > Outdoor Furniture Sets','en-AU'),(7486,'Furniture > Outdoor Furniture > Outdoor Seating','en-AU'),(7487,'Furniture > Outdoor Furniture > Outdoor Seating > Outdoor Benches','en-AU'),(7488,'Furniture > Outdoor Furniture > Outdoor Seating > Outdoor Chairs','en-AU'),(7489,'Furniture > Outdoor Furniture > Outdoor Seating > Outdoor Sectional Sofa Units','en-AU'),(7490,'Furniture > Outdoor Furniture > Outdoor Seating > Outdoor Sofas','en-AU'),(7491,'Furniture > Outdoor Furniture > Outdoor Seating > Sunloungers','en-AU'),(7492,'Furniture > Outdoor Furniture > Outdoor Storage Boxes','en-AU'),(7493,'Furniture > Outdoor Furniture > Outdoor Tables','en-AU'),(7494,'Furniture > Outdoor Furniture Accessories','en-AU'),(7495,'Furniture > Outdoor Furniture Accessories > Outdoor Furniture Covers','en-AU'),(7496,'Furniture > Room Divider Accessories','en-AU'),(7497,'Furniture > Room Dividers','en-AU'),(7498,'Furniture > Shelving','en-AU'),(7499,'Furniture > Shelving > Bookcases & Standing Shelves','en-AU'),(7500,'Furniture > Shelving > Wall Shelves & Ledges','en-AU'),(7501,'Furniture > Shelving Accessories','en-AU'),(7502,'Furniture > Shelving Accessories > Replacement Shelves','en-AU'),(7503,'Furniture > Sofa Accessories','en-AU'),(7504,'Furniture > Sofa Accessories > Chair & Sofa Supports','en-AU'),(7505,'Furniture > Sofa Accessories > Sectional Sofa Units','en-AU'),(7506,'Furniture > Sofas','en-AU'),(7507,'Furniture > Table Accessories','en-AU'),(7508,'Furniture > Table Accessories > Table Legs','en-AU'),(7509,'Furniture > Table Accessories > Table Tops','en-AU'),(7510,'Furniture > Tables','en-AU'),(7511,'Furniture > Tables > Accent Tables','en-AU'),(7512,'Furniture > Tables > Accent Tables > Coffee Tables','en-AU'),(7513,'Furniture > Tables > Accent Tables > End Tables','en-AU'),(7514,'Furniture > Tables > Accent Tables > Sofa Tables','en-AU'),(7515,'Furniture > Tables > Activity Tables','en-AU'),(7516,'Furniture > Tables > Bedside Tables','en-AU'),(7517,'Furniture > Tables > Folding Tables','en-AU'),(7518,'Furniture > Tables > Kitchen & Dining Room Tables','en-AU'),(7519,'Furniture > Tables > Kotatsu','en-AU'),(7520,'Furniture > Tables > Poker & Games Tables','en-AU'),(7521,'Furniture > Tables > Sewing Machine Tables','en-AU'),(7522,'Furniture > Trolleys','en-AU'),(7523,'Furniture > Trolleys > Kitchen & Dining Trolleys','en-AU'),(7524,'Furniture > Trolleys > Kitchen Islands','en-AU'),(7525,'Hardware','en-AU'),(7526,'Hardware > Building Consumables','en-AU'),(7527,'Hardware > Building Consumables > Adhesive Tapes','en-AU'),(7528,'Hardware > Building Consumables > Chemicals','en-AU'),(7529,'Hardware > Building Consumables > Chemicals > Acid Neutralisers','en-AU'),(7530,'Hardware > Building Consumables > Chemicals > Ammonia','en-AU'),(7531,'Hardware > Building Consumables > Chemicals > Chimney Cleaners','en-AU'),(7532,'Hardware > Building Consumables > Chemicals > Concrete & Masonry Cleaners','en-AU'),(7533,'Hardware > Building Consumables > Chemicals > De-icers','en-AU'),(7534,'Hardware > Building Consumables > Chemicals > Deck & Fence Cleaners','en-AU'),(7535,'Hardware > Building Consumables > Chemicals > Drain Cleaners','en-AU'),(7536,'Hardware > Building Consumables > Chemicals > Electrical Freezer Sprays','en-AU'),(7537,'Hardware > Building Consumables > Chemicals > Lighter Fluid','en-AU'),(7538,'Hardware > Building Consumables > Chemicals > Septic Tank & Cesspool Cleaners','en-AU'),(7539,'Hardware > Building Consumables > Hardware Glue & Adhesives','en-AU'),(7540,'Hardware > Building Consumables > Lubricants','en-AU'),(7541,'Hardware > Building Consumables > Masonry Consumables','en-AU'),(7542,'Hardware > Building Consumables > Masonry Consumables > Bricks & Concrete Blocks','en-AU'),(7543,'Hardware > Building Consumables > Masonry Consumables > Cement, Mortar & Concrete Mixes','en-AU'),(7544,'Hardware > Building Consumables > Masonry Consumables > Grout','en-AU'),(7545,'Hardware > Building Consumables > Painting Consumables','en-AU'),(7546,'Hardware > Building Consumables > Painting Consumables > Paint','en-AU'),(7547,'Hardware > Building Consumables > Painting Consumables > Paint Binders','en-AU'),(7548,'Hardware > Building Consumables > Painting Consumables > Paint Stain','en-AU'),(7549,'Hardware > Building Consumables > Painting Consumables > Primers','en-AU'),(7550,'Hardware > Building Consumables > Painting Consumables > Varnishes & Finishes','en-AU'),(7551,'Hardware > Building Consumables > Plumbing Primer','en-AU'),(7552,'Hardware > Building Consumables > Protective Coatings & Sealants','en-AU'),(7553,'Hardware > Building Consumables > Solder & Flux','en-AU'),(7554,'Hardware > Building Consumables > Solvents, Strippers & Thinners','en-AU'),(7555,'Hardware > Building Consumables > Wall Patching Compounds & Plaster','en-AU'),(7556,'Hardware > Building Materials','en-AU'),(7557,'Hardware > Building Materials > Cladding','en-AU'),(7558,'Hardware > Building Materials > Door Hardware','en-AU'),(7559,'Hardware > Building Materials > Door Hardware > Door Bells','en-AU'),(7560,'Hardware > Building Materials > Door Hardware > Door Closers','en-AU'),(7561,'Hardware > Building Materials > Door Hardware > Door Frames','en-AU'),(7562,'Hardware > Building Materials > Door Hardware > Door Keyhole Escutcheons','en-AU'),(7563,'Hardware > Building Materials > Door Hardware > Door Knobs & Handles','en-AU'),(7564,'Hardware > Building Materials > Door Hardware > Door Knockers','en-AU'),(7565,'Hardware > Building Materials > Door Hardware > Door Push Plates','en-AU'),(7566,'Hardware > Building Materials > Door Hardware > Door Stops','en-AU'),(7567,'Hardware > Building Materials > Door Hardware > Door Strikes','en-AU'),(7568,'Hardware > Building Materials > Doors','en-AU'),(7569,'Hardware > Building Materials > Doors > Garage Doors','en-AU'),(7570,'Hardware > Building Materials > Doors > Home Doors','en-AU'),(7571,'Hardware > Building Materials > Drywall','en-AU'),(7572,'Hardware > Building Materials > Flooring & Carpet','en-AU'),(7573,'Hardware > Building Materials > Glass','en-AU'),(7574,'Hardware > Building Materials > Handrails & Railing Systems','en-AU'),(7575,'Hardware > Building Materials > Hatches','en-AU'),(7576,'Hardware > Building Materials > Insulation','en-AU'),(7577,'Hardware > Building Materials > Lumber & Sheet Stock','en-AU'),(7578,'Hardware > Building Materials > Moulding','en-AU'),(7579,'Hardware > Building Materials > Rebar & Remesh','en-AU'),(7580,'Hardware > Building Materials > Roofing','en-AU'),(7581,'Hardware > Building Materials > Roofing > Gutter Accessories','en-AU'),(7582,'Hardware > Building Materials > Roofing > Gutters','en-AU'),(7583,'Hardware > Building Materials > Roofing > Roof Flashing','en-AU'),(7584,'Hardware > Building Materials > Roofing > Roofing Shingles & Tiles','en-AU'),(7585,'Hardware > Building Materials > Shutters','en-AU'),(7586,'Hardware > Building Materials > Sound Dampening Panels & Foam','en-AU'),(7587,'Hardware > Building Materials > Staircases','en-AU'),(7588,'Hardware > Building Materials > Wall & Ceiling Tiles','en-AU'),(7589,'Hardware > Building Materials > Wall Panelling','en-AU'),(7590,'Hardware > Building Materials > Weather Stripping & Weatherisation Supplies','en-AU'),(7591,'Hardware > Building Materials > Window Hardware','en-AU'),(7592,'Hardware > Building Materials > Window Hardware > Window Cranks','en-AU'),(7593,'Hardware > Building Materials > Window Hardware > Window Frames','en-AU'),(7594,'Hardware > Building Materials > Windows','en-AU'),(7595,'Hardware > Building Materials > Worktops','en-AU'),(7596,'Hardware > Fencing & Barriers','en-AU'),(7597,'Hardware > Fencing & Barriers > Fence & Gate Accessories','en-AU'),(7598,'Hardware > Fencing & Barriers > Fence Panels','en-AU'),(7599,'Hardware > Fencing & Barriers > Fence Posts & Rails','en-AU'),(7600,'Hardware > Fencing & Barriers > Fencing Pickets','en-AU'),(7601,'Hardware > Fencing & Barriers > Garden Borders & Edging','en-AU'),(7602,'Hardware > Fencing & Barriers > Gates','en-AU'),(7603,'Hardware > Fencing & Barriers > Lattice','en-AU'),(7604,'Hardware > Fencing & Barriers > Safety & Crowd Control Barriers','en-AU'),(7605,'Hardware > Fuel Containers & Tanks','en-AU'),(7606,'Hardware > Hardware Accessories','en-AU'),(7607,'Hardware > Hardware Accessories > Brackets & Reinforcement Braces','en-AU'),(7608,'Hardware > Hardware Accessories > Cabinet Hardware','en-AU'),(7609,'Hardware > Hardware Accessories > Cabinet Hardware > Cabinet & Furniture Keyhole Escutcheons','en-AU'),(7610,'Hardware > Hardware Accessories > Cabinet Hardware > Cabinet Backplates','en-AU'),(7611,'Hardware > Hardware Accessories > Cabinet Hardware > Cabinet Catches','en-AU'),(7612,'Hardware > Hardware Accessories > Cabinet Hardware > Cabinet Doors','en-AU'),(7613,'Hardware > Hardware Accessories > Cabinet Hardware > Cabinet Knobs & Handles','en-AU'),(7614,'Hardware > Hardware Accessories > Castors','en-AU'),(7615,'Hardware > Hardware Accessories > Chain, Wire & Rope','en-AU'),(7616,'Hardware > Hardware Accessories > Chain, Wire & Rope > Bungee Cords','en-AU'),(7617,'Hardware > Hardware Accessories > Chain, Wire & Rope > Hardware Chains','en-AU'),(7618,'Hardware > Hardware Accessories > Chain, Wire & Rope > Pull Chains','en-AU'),(7619,'Hardware > Hardware Accessories > Chain, Wire & Rope > Ropes & Hardware Cable','en-AU'),(7620,'Hardware > Hardware Accessories > Chain, Wire & Rope > Tie Down Straps','en-AU'),(7621,'Hardware > Hardware Accessories > Chain, Wire & Rope > Twine','en-AU'),(7622,'Hardware > Hardware Accessories > Chain, Wire & Rope > Utility Wire','en-AU'),(7623,'Hardware > Hardware Accessories > Coils','en-AU'),(7624,'Hardware > Hardware Accessories > Concrete Moulds','en-AU'),(7625,'Hardware > Hardware Accessories > Dowel Pins & Rods','en-AU'),(7626,'Hardware > Hardware Accessories > Drawer Slides','en-AU'),(7627,'Hardware > Hardware Accessories > Drop Cloths','en-AU'),(7628,'Hardware > Hardware Accessories > Filters & Screens','en-AU'),(7629,'Hardware > Hardware Accessories > Flagging & Caution Tape','en-AU'),(7630,'Hardware > Hardware Accessories > Gas Hoses','en-AU'),(7631,'Hardware > Hardware Accessories > Ground Spikes','en-AU'),(7632,'Hardware > Hardware Accessories > Hardware Fasteners','en-AU'),(7633,'Hardware > Hardware Accessories > Hardware Fasteners > Drywall Anchors','en-AU'),(7634,'Hardware > Hardware Accessories > Hardware Fasteners > Nails','en-AU'),(7635,'Hardware > Hardware Accessories > Hardware Fasteners > Nuts & Bolts','en-AU'),(7636,'Hardware > Hardware Accessories > Hardware Fasteners > Rivets','en-AU'),(7637,'Hardware > Hardware Accessories > Hardware Fasteners > Screw Posts','en-AU'),(7638,'Hardware > Hardware Accessories > Hardware Fasteners > Screws','en-AU'),(7639,'Hardware > Hardware Accessories > Hardware Fasteners > Threaded Rods','en-AU'),(7640,'Hardware > Hardware Accessories > Hardware Fasteners > Washers','en-AU'),(7641,'Hardware > Hardware Accessories > Hinges','en-AU'),(7642,'Hardware > Hardware Accessories > Hooks, Buckles & Fasteners','en-AU'),(7643,'Hardware > Hardware Accessories > Hooks, Buckles & Fasteners > Chain Connectors & Links','en-AU'),(7644,'Hardware > Hardware Accessories > Hooks, Buckles & Fasteners > Gear Ties','en-AU'),(7645,'Hardware > Hardware Accessories > Hooks, Buckles & Fasteners > Lifting Hooks, Clamps & Shackles','en-AU'),(7646,'Hardware > Hardware Accessories > Hooks, Buckles & Fasteners > Utility Buckles','en-AU'),(7647,'Hardware > Hardware Accessories > Lubrication Hoses','en-AU'),(7648,'Hardware > Hardware Accessories > Metal Casting Moulds','en-AU'),(7649,'Hardware > Hardware Accessories > Moving & Soundproofing Blankets & Covers','en-AU'),(7650,'Hardware > Hardware Accessories > Pneumatic Hoses','en-AU'),(7651,'Hardware > Hardware Accessories > Post Base Plates','en-AU'),(7652,'Hardware > Hardware Accessories > Springs','en-AU'),(7653,'Hardware > Hardware Accessories > Tarps','en-AU'),(7654,'Hardware > Hardware Accessories > Tool Storage & Organisation','en-AU'),(7655,'Hardware > Hardware Accessories > Tool Storage & Organisation > Garden Hose Storage','en-AU'),(7656,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool & Duty Belts','en-AU'),(7657,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool Bags','en-AU'),(7658,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool Boxes','en-AU'),(7659,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool Cabinets','en-AU'),(7660,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool Organiser Liners & Inserts','en-AU'),(7661,'Hardware > Hardware Accessories > Tool Storage & Organisation > Tool Sheaths','en-AU'),(7662,'Hardware > Hardware Accessories > Tool Storage & Organisation > Work Benches','en-AU'),(7663,'Hardware > Hardware Accessories > Wall Jacks & Braces','en-AU'),(7664,'Hardware > Hardware Pumps','en-AU'),(7665,'Hardware > Hardware Pumps > Home Appliance Pumps','en-AU'),(7666,'Hardware > Hardware Pumps > Irrigation, Sprinkler & Booster Pumps','en-AU'),(7667,'Hardware > Hardware Pumps > Pool, Fountain & Pond Pumps','en-AU'),(7668,'Hardware > Hardware Pumps > Sump, Sewage & Effluent Pumps','en-AU'),(7669,'Hardware > Hardware Pumps > Utility Pumps','en-AU'),(7670,'Hardware > Hardware Pumps > Well Pumps & Systems','en-AU'),(7671,'Hardware > Heating, Ventilation & Air Conditioning','en-AU'),(7672,'Hardware > Heating, Ventilation & Air Conditioning > Air Ducts','en-AU'),(7673,'Hardware > Heating, Ventilation & Air Conditioning > Filter Dryers','en-AU'),(7674,'Hardware > Heating, Ventilation & Air Conditioning > HVAC Controls','en-AU'),(7675,'Hardware > Heating, Ventilation & Air Conditioning > HVAC Controls > Control Panels','en-AU'),(7676,'Hardware > Heating, Ventilation & Air Conditioning > HVAC Controls > Humidistats','en-AU'),(7677,'Hardware > Heating, Ventilation & Air Conditioning > HVAC Controls > Thermostats','en-AU'),(7678,'Hardware > Heating, Ventilation & Air Conditioning > Vents & Flues','en-AU'),(7679,'Hardware > Locks & Keys','en-AU'),(7680,'Hardware > Locks & Keys > Key Blanks','en-AU'),(7681,'Hardware > Locks & Keys > Key Caps','en-AU'),(7682,'Hardware > Locks & Keys > Key Card Entry Systems','en-AU'),(7683,'Hardware > Locks & Keys > Locks & Latches','en-AU'),(7684,'Hardware > Plumbing','en-AU'),(7685,'Hardware > Plumbing > Plumbing Fittings & Supports','en-AU'),(7686,'Hardware > Plumbing > Plumbing Fittings & Supports > Gaskets & O-Rings','en-AU'),(7687,'Hardware > Plumbing > Plumbing Fittings & Supports > In-Wall Carriers & Mounting Frames','en-AU'),(7688,'Hardware > Plumbing > Plumbing Fittings & Supports > Nozzles','en-AU'),(7689,'Hardware > Plumbing > Plumbing Fittings & Supports > Pipe Adaptors & Bushings','en-AU'),(7690,'Hardware > Plumbing > Plumbing Fittings & Supports > Pipe Caps & Plugs','en-AU'),(7691,'Hardware > Plumbing > Plumbing Fittings & Supports > Pipe Connectors','en-AU'),(7692,'Hardware > Plumbing > Plumbing Fittings & Supports > Plumbing Flanges','en-AU'),(7693,'Hardware > Plumbing > Plumbing Fittings & Supports > Plumbing Pipe Clamps','en-AU'),(7694,'Hardware > Plumbing > Plumbing Fittings & Supports > Plumbing Regulators','en-AU'),(7695,'Hardware > Plumbing > Plumbing Fittings & Supports > Plumbing Valves','en-AU'),(7696,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts','en-AU'),(7697,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Bathtub Accessories','en-AU'),(7698,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Bathtub Accessories > Bath panels','en-AU'),(7699,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Bathtub Accessories > Bathtub Bases & Feet','en-AU'),(7700,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Bathtub Accessories > Bathtub Taps','en-AU'),(7701,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components','en-AU'),(7702,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Drain Covers & Strainers','en-AU'),(7703,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Drain Frames','en-AU'),(7704,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Drain Liners','en-AU'),(7705,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Drain Openers','en-AU'),(7706,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Drain Rods','en-AU'),(7707,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Plumbing Traps','en-AU'),(7708,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drain Components > Plumbing Wastes','en-AU'),(7709,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Drains','en-AU'),(7710,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Fixture Plates','en-AU'),(7711,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts','en-AU'),(7712,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Bathtub & Shower Jets','en-AU'),(7713,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Electric & Power Showers','en-AU'),(7714,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Arms & Connectors','en-AU'),(7715,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Bases','en-AU'),(7716,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Columns','en-AU'),(7717,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Doors & Enclosures','en-AU'),(7718,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Heads','en-AU'),(7719,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Walls & Surrounds','en-AU'),(7720,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Shower Parts > Shower Water Filters','en-AU'),(7721,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Sink Accessories','en-AU'),(7722,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Sink Accessories > Sink Legs','en-AU'),(7723,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Tap Accessories','en-AU'),(7724,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Tap Accessories > Tap Aerators','en-AU'),(7725,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Tap Accessories > Tap Handles','en-AU'),(7726,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories','en-AU'),(7727,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Ballcocks & Flapper Valves','en-AU'),(7728,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Bidet Taps & Sprayers','en-AU'),(7729,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet & Bidet Seats','en-AU'),(7730,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Seat Covers','en-AU'),(7731,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Seat Lid Covers','en-AU'),(7732,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Tank Covers','en-AU'),(7733,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Tank Levers','en-AU'),(7734,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Tanks','en-AU'),(7735,'Hardware > Plumbing > Plumbing Fixture Hardware & Parts > Toilet & Bidet Accessories > Toilet Trim','en-AU'),(7736,'Hardware > Plumbing > Plumbing Fixtures','en-AU'),(7737,'Hardware > Plumbing > Plumbing Fixtures > Bathroom Suites','en-AU'),(7738,'Hardware > Plumbing > Plumbing Fixtures > Bathtubs','en-AU'),(7739,'Hardware > Plumbing > Plumbing Fixtures > Shower Stalls & Kits','en-AU'),(7740,'Hardware > Plumbing > Plumbing Fixtures > Sinks','en-AU'),(7741,'Hardware > Plumbing > Plumbing Fixtures > Sinks > Bathroom Basins','en-AU'),(7742,'Hardware > Plumbing > Plumbing Fixtures > Sinks > Kitchen & Utility Sinks','en-AU'),(7743,'Hardware > Plumbing > Plumbing Fixtures > Taps','en-AU'),(7744,'Hardware > Plumbing > Plumbing Fixtures > Toilets & Bidets','en-AU'),(7745,'Hardware > Plumbing > Plumbing Fixtures > Toilets & Bidets > Bidets','en-AU'),(7746,'Hardware > Plumbing > Plumbing Fixtures > Toilets & Bidets > Toilets','en-AU'),(7747,'Hardware > Plumbing > Plumbing Fixtures > Toilets & Bidets > Urinals','en-AU'),(7748,'Hardware > Plumbing > Plumbing Hoses & Supply Lines','en-AU'),(7749,'Hardware > Plumbing > Plumbing Pipes','en-AU'),(7750,'Hardware > Plumbing > Plumbing Repair Kits','en-AU'),(7751,'Hardware > Plumbing > Water Dispensing & Filtration','en-AU'),(7752,'Hardware > Plumbing > Water Dispensing & Filtration > In-Line Water Filters','en-AU'),(7753,'Hardware > Plumbing > Water Dispensing & Filtration > Water Dispensers','en-AU'),(7754,'Hardware > Plumbing > Water Dispensing & Filtration > Water Dispensers > Drinking Fountains','en-AU'),(7755,'Hardware > Plumbing > Water Dispensing & Filtration > Water Dispensers > Water Chillers','en-AU'),(7756,'Hardware > Plumbing > Water Dispensing & Filtration > Water Distillers','en-AU'),(7757,'Hardware > Plumbing > Water Dispensing & Filtration > Water Filtration Accessories','en-AU'),(7758,'Hardware > Plumbing > Water Dispensing & Filtration > Water Filtration Accessories > Water Filter Cartridges','en-AU'),(7759,'Hardware > Plumbing > Water Dispensing & Filtration > Water Filtration Accessories > Water Filter Housings','en-AU'),(7760,'Hardware > Plumbing > Water Dispensing & Filtration > Water Softener Salt','en-AU'),(7761,'Hardware > Plumbing > Water Dispensing & Filtration > Water Softeners','en-AU'),(7762,'Hardware > Plumbing > Water Levellers','en-AU'),(7763,'Hardware > Plumbing > Water Timers','en-AU'),(7764,'Hardware > Plumbing > Well Supplies','en-AU'),(7765,'Hardware > Power & Electrical Supplies','en-AU'),(7766,'Hardware > Power & Electrical Supplies > Armatures, Rotors & Stators','en-AU'),(7767,'Hardware > Power & Electrical Supplies > Ballasts & Starters','en-AU'),(7768,'Hardware > Power & Electrical Supplies > Carbon Brushes','en-AU'),(7769,'Hardware > Power & Electrical Supplies > Circuit Breaker Panels','en-AU'),(7770,'Hardware > Power & Electrical Supplies > Conduit & Housings','en-AU'),(7771,'Hardware > Power & Electrical Supplies > Conduit & Housings > Electrical Conduit','en-AU'),(7772,'Hardware > Power & Electrical Supplies > Conduit & Housings > Heat Shrink Tubing','en-AU'),(7773,'Hardware > Power & Electrical Supplies > Electrical Motors','en-AU'),(7774,'Hardware > Power & Electrical Supplies > Electrical Mount Boxes & Brackets','en-AU'),(7775,'Hardware > Power & Electrical Supplies > Electrical Plug Caps','en-AU'),(7776,'Hardware > Power & Electrical Supplies > Electrical Switches','en-AU'),(7777,'Hardware > Power & Electrical Supplies > Electrical Switches > Light Switches','en-AU'),(7778,'Hardware > Power & Electrical Supplies > Electrical Switches > Speciality Electrical Switches','en-AU'),(7779,'Hardware > Power & Electrical Supplies > Electrical Wires & Cable','en-AU'),(7780,'Hardware > Power & Electrical Supplies > Extension Cord Accessories','en-AU'),(7781,'Hardware > Power & Electrical Supplies > Extension Cords','en-AU'),(7782,'Hardware > Power & Electrical Supplies > Generator Accessories','en-AU'),(7783,'Hardware > Power & Electrical Supplies > Generators','en-AU'),(7784,'Hardware > Power & Electrical Supplies > Home Automation Kits','en-AU'),(7785,'Hardware > Power & Electrical Supplies > Phone & Data Jacks','en-AU'),(7786,'Hardware > Power & Electrical Supplies > Power Converters','en-AU'),(7787,'Hardware > Power & Electrical Supplies > Power Inlets','en-AU'),(7788,'Hardware > Power & Electrical Supplies > Power Inverters','en-AU'),(7789,'Hardware > Power & Electrical Supplies > Power Outlets & Sockets','en-AU'),(7790,'Hardware > Power & Electrical Supplies > Solar Energy Kits','en-AU'),(7791,'Hardware > Power & Electrical Supplies > Solar Panels','en-AU'),(7792,'Hardware > Power & Electrical Supplies > Voltage Transformers & Regulators','en-AU'),(7793,'Hardware > Power & Electrical Supplies > Wall Plates & Covers','en-AU'),(7794,'Hardware > Power & Electrical Supplies > Wall Socket Controls & Sensors','en-AU'),(7795,'Hardware > Power & Electrical Supplies > Wire Caps & Nuts','en-AU'),(7796,'Hardware > Power & Electrical Supplies > Wire Terminals & Connectors','en-AU'),(7797,'Hardware > Small Engines','en-AU'),(7798,'Hardware > Storage Tanks','en-AU'),(7799,'Hardware > Tool Accessories','en-AU'),(7800,'Hardware > Tool Accessories > Abrasive Blaster Accessories','en-AU'),(7801,'Hardware > Tool Accessories > Abrasive Blaster Accessories > Sandblasting Cabinets','en-AU'),(7802,'Hardware > Tool Accessories > Axe Accessories','en-AU'),(7803,'Hardware > Tool Accessories > Axe Accessories > Axe Handles','en-AU'),(7804,'Hardware > Tool Accessories > Axe Accessories > Axe Heads','en-AU'),(7805,'Hardware > Tool Accessories > Cutter Accessories','en-AU'),(7806,'Hardware > Tool Accessories > Cutter Accessories > Nibbler Dies','en-AU'),(7807,'Hardware > Tool Accessories > Drill & Screwdriver Accessories','en-AU'),(7808,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Drill & Screwdriver Bits','en-AU'),(7809,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Drill Bit Extensions','en-AU'),(7810,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Drill Bit Sharpeners','en-AU'),(7811,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Drill Chucks','en-AU'),(7812,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Drill Stands & Guides','en-AU'),(7813,'Hardware > Tool Accessories > Drill & Screwdriver Accessories > Hole Saws','en-AU'),(7814,'Hardware > Tool Accessories > Driver Accessories','en-AU'),(7815,'Hardware > Tool Accessories > Grinder Accessories','en-AU'),(7816,'Hardware > Tool Accessories > Grinder Accessories > Grinding Wheels & Points','en-AU'),(7817,'Hardware > Tool Accessories > Hammer Accessories','en-AU'),(7818,'Hardware > Tool Accessories > Hammer Accessories > Air Hammer Accessories','en-AU'),(7819,'Hardware > Tool Accessories > Hammer Accessories > Hammer Handles','en-AU'),(7820,'Hardware > Tool Accessories > Hammer Accessories > Hammer Heads','en-AU'),(7821,'Hardware > Tool Accessories > Industrial Staples','en-AU'),(7822,'Hardware > Tool Accessories > Jigs','en-AU'),(7823,'Hardware > Tool Accessories > Magnetisers & Demagnetisers','en-AU'),(7824,'Hardware > Tool Accessories > Mattock & Pickaxe Accessories','en-AU'),(7825,'Hardware > Tool Accessories > Mattock & Pickaxe Accessories > Mattock & Pickaxe Handles','en-AU'),(7826,'Hardware > Tool Accessories > Measuring Tool & Sensor Accessories','en-AU'),(7827,'Hardware > Tool Accessories > Measuring Tool & Sensor Accessories > Electrical Testing Tool Accessories','en-AU'),(7828,'Hardware > Tool Accessories > Measuring Tool & Sensor Accessories > Gas Detector Accessories','en-AU'),(7829,'Hardware > Tool Accessories > Measuring Tool & Sensor Accessories > Measuring Scale Accessories','en-AU'),(7830,'Hardware > Tool Accessories > Measuring Tool & Sensor Accessories > Multimeter Accessories','en-AU'),(7831,'Hardware > Tool Accessories > Mixing Paddles','en-AU'),(7832,'Hardware > Tool Accessories > Paint Tool Accessories','en-AU'),(7833,'Hardware > Tool Accessories > Paint Tool Accessories > Airbrush Accessories','en-AU'),(7834,'Hardware > Tool Accessories > Paint Tool Accessories > Paint Brush Cleaning Solutions','en-AU'),(7835,'Hardware > Tool Accessories > Paint Tool Accessories > Paint Roller Accessories','en-AU'),(7836,'Hardware > Tool Accessories > Power Tool Batteries','en-AU'),(7837,'Hardware > Tool Accessories > Power Tool Chargers','en-AU'),(7838,'Hardware > Tool Accessories > Router Accessories','en-AU'),(7839,'Hardware > Tool Accessories > Router Accessories > Router Bits','en-AU'),(7840,'Hardware > Tool Accessories > Router Accessories > Router Tables','en-AU'),(7841,'Hardware > Tool Accessories > Sanding Accessories','en-AU'),(7842,'Hardware > Tool Accessories > Sanding Accessories > Sandpaper & Sanding Sponges','en-AU'),(7843,'Hardware > Tool Accessories > Saw Accessories','en-AU'),(7844,'Hardware > Tool Accessories > Saw Accessories > Band Saw Accessories','en-AU'),(7845,'Hardware > Tool Accessories > Saw Accessories > Handheld Circular Saw Accessories','en-AU'),(7846,'Hardware > Tool Accessories > Saw Accessories > Jigsaw Accessories','en-AU'),(7847,'Hardware > Tool Accessories > Saw Accessories > Mitre Saw Accessories','en-AU'),(7848,'Hardware > Tool Accessories > Saw Accessories > Table Saw Accessories','en-AU'),(7849,'Hardware > Tool Accessories > Shaper Accessories','en-AU'),(7850,'Hardware > Tool Accessories > Shaper Accessories > Shaper Cutters','en-AU'),(7851,'Hardware > Tool Accessories > Soldering Iron Accessories','en-AU'),(7852,'Hardware > Tool Accessories > Soldering Iron Accessories > Soldering Iron Stands','en-AU'),(7853,'Hardware > Tool Accessories > Soldering Iron Accessories > Soldering Iron Tips','en-AU'),(7854,'Hardware > Tool Accessories > Tool Blades','en-AU'),(7855,'Hardware > Tool Accessories > Tool Blades > Cutter & Scraper Blades','en-AU'),(7856,'Hardware > Tool Accessories > Tool Blades > Saw Blades','en-AU'),(7857,'Hardware > Tool Accessories > Tool Handle Wedges','en-AU'),(7858,'Hardware > Tool Accessories > Tool Safety Tethers','en-AU'),(7859,'Hardware > Tool Accessories > Tool Sockets','en-AU'),(7860,'Hardware > Tool Accessories > Tool Stands','en-AU'),(7861,'Hardware > Tool Accessories > Tool Stands > Saw Stands','en-AU'),(7862,'Hardware > Tool Accessories > Torch Accessories','en-AU'),(7863,'Hardware > Tool Accessories > Wedge Tools','en-AU'),(7864,'Hardware > Tool Accessories > Welding Accessories','en-AU'),(7865,'Hardware > Tools','en-AU'),(7866,'Hardware > Tools > Abrasive Blasters','en-AU'),(7867,'Hardware > Tools > Anvils','en-AU'),(7868,'Hardware > Tools > Axes','en-AU'),(7869,'Hardware > Tools > Carpentry Jointers','en-AU'),(7870,'Hardware > Tools > Carving Chisels & Gouges','en-AU'),(7871,'Hardware > Tools > Caulking Tools','en-AU'),(7872,'Hardware > Tools > Chimney Brushes','en-AU'),(7873,'Hardware > Tools > Compactors','en-AU'),(7874,'Hardware > Tools > Compressors','en-AU'),(7875,'Hardware > Tools > Concrete Brooms','en-AU'),(7876,'Hardware > Tools > Cutters','en-AU'),(7877,'Hardware > Tools > Cutters > Bolt Cutters','en-AU'),(7878,'Hardware > Tools > Cutters > Glass Cutters','en-AU'),(7879,'Hardware > Tools > Cutters > Handheld Metal Shears & Nibblers','en-AU'),(7880,'Hardware > Tools > Cutters > Nippers','en-AU'),(7881,'Hardware > Tools > Cutters > Pipe Cutters','en-AU'),(7882,'Hardware > Tools > Cutters > Rebar Cutters','en-AU'),(7883,'Hardware > Tools > Cutters > Tile & Shingle Cutters','en-AU'),(7884,'Hardware > Tools > Cutters > Utility Knives','en-AU'),(7885,'Hardware > Tools > Deburrers','en-AU'),(7886,'Hardware > Tools > Dollies & Hand Trucks','en-AU'),(7887,'Hardware > Tools > Drills','en-AU'),(7888,'Hardware > Tools > Drills > Augers','en-AU'),(7889,'Hardware > Tools > Drills > Drill Presses','en-AU'),(7890,'Hardware > Tools > Drills > Handheld Power Drills','en-AU'),(7891,'Hardware > Tools > Drills > Mortisers','en-AU'),(7892,'Hardware > Tools > Drills > Pneumatic Drills','en-AU'),(7893,'Hardware > Tools > Electrician Fish Tape','en-AU'),(7894,'Hardware > Tools > Grease Guns','en-AU'),(7895,'Hardware > Tools > Grinders','en-AU'),(7896,'Hardware > Tools > Grips','en-AU'),(7897,'Hardware > Tools > Hammers','en-AU'),(7898,'Hardware > Tools > Hammers > Manual Hammers','en-AU'),(7899,'Hardware > Tools > Hammers > Powered Hammers','en-AU'),(7900,'Hardware > Tools > Handheld Power Mixers','en-AU'),(7901,'Hardware > Tools > Hardware Torches','en-AU'),(7902,'Hardware > Tools > Heat Guns','en-AU'),(7903,'Hardware > Tools > Impact Spanners & Drivers','en-AU'),(7904,'Hardware > Tools > Industrial Vibrators','en-AU'),(7905,'Hardware > Tools > Inspection Mirrors','en-AU'),(7906,'Hardware > Tools > Ladders & Scaffolding','en-AU'),(7907,'Hardware > Tools > Ladders & Scaffolding > Ladder Carts','en-AU'),(7908,'Hardware > Tools > Ladders & Scaffolding > Ladders','en-AU'),(7909,'Hardware > Tools > Ladders & Scaffolding > Scaffolding','en-AU'),(7910,'Hardware > Tools > Ladders & Scaffolding > Stepping Stools','en-AU'),(7911,'Hardware > Tools > Ladders & Scaffolding > Work Platforms','en-AU'),(7912,'Hardware > Tools > Lathes','en-AU'),(7913,'Hardware > Tools > Light Bulb Changers','en-AU'),(7914,'Hardware > Tools > Lighters & Matches','en-AU'),(7915,'Hardware > Tools > Log Splitters','en-AU'),(7916,'Hardware > Tools > Magnetic Sweepers','en-AU'),(7917,'Hardware > Tools > Marking Tools','en-AU'),(7918,'Hardware > Tools > Masonry Tools','en-AU'),(7919,'Hardware > Tools > Masonry Tools > Brick Tools','en-AU'),(7920,'Hardware > Tools > Masonry Tools > Cement Mixers','en-AU'),(7921,'Hardware > Tools > Masonry Tools > Construction Lines','en-AU'),(7922,'Hardware > Tools > Masonry Tools > Floats','en-AU'),(7923,'Hardware > Tools > Masonry Tools > Grout Sponges','en-AU'),(7924,'Hardware > Tools > Masonry Tools > Masonry Edgers & Groovers','en-AU'),(7925,'Hardware > Tools > Masonry Tools > Masonry Jointers','en-AU'),(7926,'Hardware > Tools > Masonry Tools > Masonry Trowels','en-AU'),(7927,'Hardware > Tools > Masonry Tools > Power Trowels','en-AU'),(7928,'Hardware > Tools > Mattocks & Pickaxes','en-AU'),(7929,'Hardware > Tools > Measuring Tools & Sensors','en-AU'),(7930,'Hardware > Tools > Measuring Tools & Sensors > Air Quality Meters','en-AU'),(7931,'Hardware > Tools > Measuring Tools & Sensors > Altimeters','en-AU'),(7932,'Hardware > Tools > Measuring Tools & Sensors > Anemometers','en-AU'),(7933,'Hardware > Tools > Measuring Tools & Sensors > Barometers','en-AU'),(7934,'Hardware > Tools > Measuring Tools & Sensors > Calipers','en-AU'),(7935,'Hardware > Tools > Measuring Tools & Sensors > Cruising Rods','en-AU'),(7936,'Hardware > Tools > Measuring Tools & Sensors > Distance Meters','en-AU'),(7937,'Hardware > Tools > Measuring Tools & Sensors > Dividers','en-AU'),(7938,'Hardware > Tools > Measuring Tools & Sensors > Electrical Testing Tools','en-AU'),(7939,'Hardware > Tools > Measuring Tools & Sensors > Flow Meters & Controllers','en-AU'),(7940,'Hardware > Tools > Measuring Tools & Sensors > Gas Detection Tools','en-AU'),(7941,'Hardware > Tools > Measuring Tools & Sensors > Gauges','en-AU'),(7942,'Hardware > Tools > Measuring Tools & Sensors > Geiger Counters','en-AU'),(7943,'Hardware > Tools > Measuring Tools & Sensors > Hygrometers','en-AU'),(7944,'Hardware > Tools > Measuring Tools & Sensors > Infrared Thermometers','en-AU'),(7945,'Hardware > Tools > Measuring Tools & Sensors > Knife Guides','en-AU'),(7946,'Hardware > Tools > Measuring Tools & Sensors > Level Sensors','en-AU'),(7947,'Hardware > Tools > Measuring Tools & Sensors > Level Sensors > Bubble Levels','en-AU'),(7948,'Hardware > Tools > Measuring Tools & Sensors > Level Sensors > Laser Levels','en-AU'),(7949,'Hardware > Tools > Measuring Tools & Sensors > Level Sensors > Sight Levels','en-AU'),(7950,'Hardware > Tools > Measuring Tools & Sensors > Measuring Scales','en-AU'),(7951,'Hardware > Tools > Measuring Tools & Sensors > Measuring Wheels','en-AU'),(7952,'Hardware > Tools > Measuring Tools & Sensors > Moisture Meters','en-AU'),(7953,'Hardware > Tools > Measuring Tools & Sensors > Probes & Finders','en-AU'),(7954,'Hardware > Tools > Measuring Tools & Sensors > Protractors','en-AU'),(7955,'Hardware > Tools > Measuring Tools & Sensors > Rebar Locators','en-AU'),(7956,'Hardware > Tools > Measuring Tools & Sensors > Rulers','en-AU'),(7957,'Hardware > Tools > Measuring Tools & Sensors > Seismometer','en-AU'),(7958,'Hardware > Tools > Measuring Tools & Sensors > Sound Meters','en-AU'),(7959,'Hardware > Tools > Measuring Tools & Sensors > Squares','en-AU'),(7960,'Hardware > Tools > Measuring Tools & Sensors > Straight Edges','en-AU'),(7961,'Hardware > Tools > Measuring Tools & Sensors > Stud Sensors','en-AU'),(7962,'Hardware > Tools > Measuring Tools & Sensors > Tape Measures','en-AU'),(7963,'Hardware > Tools > Measuring Tools & Sensors > Theodolites','en-AU'),(7964,'Hardware > Tools > Measuring Tools & Sensors > Thermal Imaging Cameras','en-AU'),(7965,'Hardware > Tools > Measuring Tools & Sensors > Thermocouples & Thermopiles','en-AU'),(7966,'Hardware > Tools > Measuring Tools & Sensors > Transducers','en-AU'),(7967,'Hardware > Tools > Measuring Tools & Sensors > UV Light Meters','en-AU'),(7968,'Hardware > Tools > Measuring Tools & Sensors > Vibration Meters','en-AU'),(7969,'Hardware > Tools > Measuring Tools & Sensors > Weather Forecasters & Stations','en-AU'),(7970,'Hardware > Tools > Measuring Tools & Sensors > pH Meters','en-AU'),(7971,'Hardware > Tools > Milling Machines','en-AU'),(7972,'Hardware > Tools > Multifunction Power Tools','en-AU'),(7973,'Hardware > Tools > Nail Pullers','en-AU'),(7974,'Hardware > Tools > Nailers & Staplers','en-AU'),(7975,'Hardware > Tools > Oil Filter Drains','en-AU'),(7976,'Hardware > Tools > Painting Tools','en-AU'),(7977,'Hardware > Tools > Painting Tools > Air Brushes','en-AU'),(7978,'Hardware > Tools > Painting Tools > Paint Brushes','en-AU'),(7979,'Hardware > Tools > Painting Tools > Paint Edgers','en-AU'),(7980,'Hardware > Tools > Painting Tools > Paint Rollers','en-AU'),(7981,'Hardware > Tools > Painting Tools > Paint Shakers','en-AU'),(7982,'Hardware > Tools > Painting Tools > Paint Sponges','en-AU'),(7983,'Hardware > Tools > Painting Tools > Paint Sprayers','en-AU'),(7984,'Hardware > Tools > Painting Tools > Paint Strainers','en-AU'),(7985,'Hardware > Tools > Painting Tools > Paint Trays','en-AU'),(7986,'Hardware > Tools > Pickup Tools','en-AU'),(7987,'Hardware > Tools > Pipe & Bar Benders','en-AU'),(7988,'Hardware > Tools > Pipe & Tube Cleaners','en-AU'),(7989,'Hardware > Tools > Pipe Brushes','en-AU'),(7990,'Hardware > Tools > Planers','en-AU'),(7991,'Hardware > Tools > Planes','en-AU'),(7992,'Hardware > Tools > Pliers','en-AU'),(7993,'Hardware > Tools > Plungers','en-AU'),(7994,'Hardware > Tools > Polishers & Buffers','en-AU'),(7995,'Hardware > Tools > Post-Hole Diggers','en-AU'),(7996,'Hardware > Tools > Pry Bars','en-AU'),(7997,'Hardware > Tools > Punches & Awls','en-AU'),(7998,'Hardware > Tools > Putty Knives & Scrapers','en-AU'),(7999,'Hardware > Tools > Ratchet Tools','en-AU'),(8000,'Hardware > Tools > Reamers','en-AU'),(8001,'Hardware > Tools > Riveting Tools','en-AU'),(8002,'Hardware > Tools > Riveting Tools > Rivet Guns','en-AU'),(8003,'Hardware > Tools > Riveting Tools > Rivet Pliers','en-AU'),(8004,'Hardware > Tools > Routing Tools','en-AU'),(8005,'Hardware > Tools > Sanders','en-AU'),(8006,'Hardware > Tools > Sanding Blocks','en-AU'),(8007,'Hardware > Tools > Saw Horses','en-AU'),(8008,'Hardware > Tools > Saws','en-AU'),(8009,'Hardware > Tools > Saws > Band Saws','en-AU'),(8010,'Hardware > Tools > Saws > Cut-Off Saws','en-AU'),(8011,'Hardware > Tools > Saws > Hand Saws','en-AU'),(8012,'Hardware > Tools > Saws > Handheld Circular Saws','en-AU'),(8013,'Hardware > Tools > Saws > Jigsaws','en-AU'),(8014,'Hardware > Tools > Saws > Masonry & Tile Saws','en-AU'),(8015,'Hardware > Tools > Saws > Mitre Saws','en-AU'),(8016,'Hardware > Tools > Saws > Panel Saws','en-AU'),(8017,'Hardware > Tools > Saws > Reciprocating Saws','en-AU'),(8018,'Hardware > Tools > Saws > Scroll Saws','en-AU'),(8019,'Hardware > Tools > Saws > Table Saws','en-AU'),(8020,'Hardware > Tools > Screwdrivers','en-AU'),(8021,'Hardware > Tools > Shapers','en-AU'),(8022,'Hardware > Tools > Sharpeners','en-AU'),(8023,'Hardware > Tools > Socket Drivers','en-AU'),(8024,'Hardware > Tools > Soldering Irons','en-AU'),(8025,'Hardware > Tools > Tap Reseaters','en-AU'),(8026,'Hardware > Tools > Taps & Dies','en-AU'),(8027,'Hardware > Tools > Threading Machines','en-AU'),(8028,'Hardware > Tools > Tool Clamps & Vices','en-AU'),(8029,'Hardware > Tools > Tool Files','en-AU'),(8030,'Hardware > Tools > Tool Keys','en-AU'),(8031,'Hardware > Tools > Tool Knives','en-AU'),(8032,'Hardware > Tools > Tool Sets','en-AU'),(8033,'Hardware > Tools > Tool Sets > Hand Tool Sets','en-AU'),(8034,'Hardware > Tools > Tool Sets > Power Tool Combo Sets','en-AU'),(8035,'Hardware > Tools > Torches & Headlamps','en-AU'),(8036,'Hardware > Tools > Welding Guns & Plasma Cutters','en-AU'),(8037,'Hardware > Tools > Wire & Cable Hand Tools','en-AU'),(8038,'Hardware > Tools > Work Lights','en-AU'),(8039,'Health & Beauty','en-AU'),(8040,'Health & Beauty > Health Care','en-AU'),(8041,'Health & Beauty > Health Care > Acupuncture','en-AU'),(8042,'Health & Beauty > Health Care > Acupuncture > Acupuncture Models','en-AU'),(8043,'Health & Beauty > Health Care > Acupuncture > Acupuncture Needles','en-AU'),(8044,'Health & Beauty > Health Care > Bed Pans','en-AU'),(8045,'Health & Beauty > Health Care > Biometric Monitor Accessories','en-AU'),(8046,'Health & Beauty > Health Care > Biometric Monitor Accessories > Activity Monitor Accessories','en-AU'),(8047,'Health & Beauty > Health Care > Biometric Monitor Accessories > Bathroom Scales Accessories','en-AU'),(8048,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Glucose Meter Accessories','en-AU'),(8049,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Glucose Meter Accessories > Blood Glucose Control Solution','en-AU'),(8050,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Glucose Meter Accessories > Blood Glucose Test Strips','en-AU'),(8051,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Glucose Meter Accessories > Lancing Devices','en-AU'),(8052,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Pressure Monitor Accessories','en-AU'),(8053,'Health & Beauty > Health Care > Biometric Monitor Accessories > Blood Pressure Monitor Accessories > Blood Pressure Monitor Cuffs','en-AU'),(8054,'Health & Beauty > Health Care > Biometric Monitors','en-AU'),(8055,'Health & Beauty > Health Care > Biometric Monitors > Activity Monitors','en-AU'),(8056,'Health & Beauty > Health Care > Biometric Monitors > Bathroom Scales','en-AU'),(8057,'Health & Beauty > Health Care > Biometric Monitors > Blood Glucose Meters','en-AU'),(8058,'Health & Beauty > Health Care > Biometric Monitors > Blood Pressure Monitors','en-AU'),(8059,'Health & Beauty > Health Care > Biometric Monitors > Body Fat Analysers','en-AU'),(8060,'Health & Beauty > Health Care > Biometric Monitors > Breathalyzers','en-AU'),(8061,'Health & Beauty > Health Care > Biometric Monitors > Cholesterol Analysers','en-AU'),(8062,'Health & Beauty > Health Care > Biometric Monitors > Fertility Monitors and Ovulation Tests','en-AU'),(8063,'Health & Beauty > Health Care > Biometric Monitors > Medical Thermometers','en-AU'),(8064,'Health & Beauty > Health Care > Biometric Monitors > Prenatal Heart Rate Monitors','en-AU'),(8065,'Health & Beauty > Health Care > Biometric Monitors > Pulse Oximeters','en-AU'),(8066,'Health & Beauty > Health Care > Condoms','en-AU'),(8067,'Health & Beauty > Health Care > Conductivity Gels & Lotions','en-AU'),(8068,'Health & Beauty > Health Care > Contraceptive Cases','en-AU'),(8069,'Health & Beauty > Health Care > First Aid','en-AU'),(8070,'Health & Beauty > Health Care > First Aid > Antiseptics & Cleaning Supplies','en-AU'),(8071,'Health & Beauty > Health Care > First Aid > Cast & Bandage Protectors','en-AU'),(8072,'Health & Beauty > Health Care > First Aid > Eye Wash Supplies','en-AU'),(8073,'Health & Beauty > Health Care > First Aid > First Aid Kits','en-AU'),(8074,'Health & Beauty > Health Care > First Aid > Hot & Cold Therapies','en-AU'),(8075,'Health & Beauty > Health Care > First Aid > Hot & Cold Therapies > Heating Pads','en-AU'),(8076,'Health & Beauty > Health Care > First Aid > Hot & Cold Therapies > Ice Packs','en-AU'),(8077,'Health & Beauty > Health Care > First Aid > Hot & Cold Therapies > Vapour Rubs','en-AU'),(8078,'Health & Beauty > Health Care > First Aid > Medical Tape & Bandages','en-AU'),(8079,'Health & Beauty > Health Care > Fitness & Nutrition','en-AU'),(8080,'Health & Beauty > Health Care > Fitness & Nutrition > Meal Replacement Drinks','en-AU'),(8081,'Health & Beauty > Health Care > Fitness & Nutrition > Nutrition Bars','en-AU'),(8082,'Health & Beauty > Health Care > Fitness & Nutrition > Nutrition Gels & Chews','en-AU'),(8083,'Health & Beauty > Health Care > Fitness & Nutrition > Nutritional Food Purées','en-AU'),(8084,'Health & Beauty > Health Care > Fitness & Nutrition > Tube Feeding Supplements','en-AU'),(8085,'Health & Beauty > Health Care > Fitness & Nutrition > Vitamins & Supplements','en-AU'),(8086,'Health & Beauty > Health Care > Hearing Aids','en-AU'),(8087,'Health & Beauty > Health Care > Incontinence Aids','en-AU'),(8088,'Health & Beauty > Health Care > Light Therapy Lamps','en-AU'),(8089,'Health & Beauty > Health Care > Medical Alarm Systems','en-AU'),(8090,'Health & Beauty > Health Care > Medical Identification Tags & Jewellery','en-AU'),(8091,'Health & Beauty > Health Care > Medical Tests','en-AU'),(8092,'Health & Beauty > Health Care > Medical Tests > Allergy Test Kits','en-AU'),(8093,'Health & Beauty > Health Care > Medical Tests > Blood Typing Test Kits','en-AU'),(8094,'Health & Beauty > Health Care > Medical Tests > Drugs Tests','en-AU'),(8095,'Health & Beauty > Health Care > Medical Tests > HIV Tests','en-AU'),(8096,'Health & Beauty > Health Care > Medical Tests > Pregnancy Tests','en-AU'),(8097,'Health & Beauty > Health Care > Medical Tests > Urinary Tract Infection Tests','en-AU'),(8098,'Health & Beauty > Health Care > Medicines & Drugs','en-AU'),(8099,'Health & Beauty > Health Care > Mobility & Accessibility','en-AU'),(8100,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment','en-AU'),(8101,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment > Mobility Scooters','en-AU'),(8102,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment > Stair Lifts','en-AU'),(8103,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment > Transfer Boards & Sheets','en-AU'),(8104,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment > Wheelchairs','en-AU'),(8105,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Equipment Accessories','en-AU'),(8106,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Furniture & Fixtures','en-AU'),(8107,'Health & Beauty > Health Care > Mobility & Accessibility > Accessibility Furniture & Fixtures > Shower Benches & Seats','en-AU'),(8108,'Health & Beauty > Health Care > Mobility & Accessibility > Walking Aid Accessories','en-AU'),(8109,'Health & Beauty > Health Care > Mobility & Accessibility > Walking Aids','en-AU'),(8110,'Health & Beauty > Health Care > Mobility & Accessibility > Walking Aids > Canes & Walking Sticks','en-AU'),(8111,'Health & Beauty > Health Care > Mobility & Accessibility > Walking Aids > Crutches','en-AU'),(8112,'Health & Beauty > Health Care > Mobility & Accessibility > Walking Aids > Walkers','en-AU'),(8113,'Health & Beauty > Health Care > Physical Therapy Equipment','en-AU'),(8114,'Health & Beauty > Health Care > Physical Therapy Equipment > Electrical Muscle Stimulators','en-AU'),(8115,'Health & Beauty > Health Care > Physical Therapy Equipment > Therapeutic Swings','en-AU'),(8116,'Health & Beauty > Health Care > Pill Boxes','en-AU'),(8117,'Health & Beauty > Health Care > Respiratory Care','en-AU'),(8118,'Health & Beauty > Health Care > Respiratory Care > CPAP Machines','en-AU'),(8119,'Health & Beauty > Health Care > Respiratory Care > CPAP Masks','en-AU'),(8120,'Health & Beauty > Health Care > Respiratory Care > Nebulisers','en-AU'),(8121,'Health & Beauty > Health Care > Respiratory Care > Oxygen Tanks','en-AU'),(8122,'Health & Beauty > Health Care > Respiratory Care > Steam Inhalers','en-AU'),(8123,'Health & Beauty > Health Care > Specimen Cups','en-AU'),(8124,'Health & Beauty > Health Care > Spermicides','en-AU'),(8125,'Health & Beauty > Health Care > Stump Shrinkers','en-AU'),(8126,'Health & Beauty > Health Care > Supports & Braces','en-AU'),(8127,'Health & Beauty > Health Care > Surgical Lubricants','en-AU'),(8128,'Health & Beauty > Jewellery Cleaning & Care','en-AU'),(8129,'Health & Beauty > Jewellery Cleaning & Care > Jewellery Cleaning Solutions & Polishes','en-AU'),(8130,'Health & Beauty > Jewellery Cleaning & Care > Jewellery Cleaning Tools','en-AU'),(8131,'Health & Beauty > Jewellery Cleaning & Care > Jewellery Holders','en-AU'),(8132,'Health & Beauty > Jewellery Cleaning & Care > Jewellery Steam Cleaners','en-AU'),(8133,'Health & Beauty > Jewellery Cleaning & Care > Watch Repair Kits','en-AU'),(8134,'Health & Beauty > Personal Care','en-AU'),(8135,'Health & Beauty > Personal Care > Back Care','en-AU'),(8136,'Health & Beauty > Personal Care > Back Care > Back & Lumbar Support Cushions','en-AU'),(8137,'Health & Beauty > Personal Care > Cosmetics','en-AU'),(8138,'Health & Beauty > Personal Care > Cosmetics > Bath & Body','en-AU'),(8139,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Adult Hygienic Wipes','en-AU'),(8140,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Bar Soap','en-AU'),(8141,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Bath Additives','en-AU'),(8142,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Bath Brushes','en-AU'),(8143,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Bath Sponges & Loofahs','en-AU'),(8144,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Body Wash','en-AU'),(8145,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Hand Sanitisers','en-AU'),(8146,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Liquid Hand Soap','en-AU'),(8147,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Powdered Hand Soap','en-AU'),(8148,'Health & Beauty > Personal Care > Cosmetics > Bath & Body > Shower Caps','en-AU'),(8149,'Health & Beauty > Personal Care > Cosmetics > Bath & Body Gift Baskets','en-AU'),(8150,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tool Cleaners','en-AU'),(8151,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools','en-AU'),(8152,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools','en-AU'),(8153,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Double Eyelid Glue & Tape','en-AU'),(8154,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Eyebrow Stencils','en-AU'),(8155,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Eyelash Curler Refills','en-AU'),(8156,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Eyelash Curlers','en-AU'),(8157,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Face Mirrors','en-AU'),(8158,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Facial Blotting Paper','en-AU'),(8159,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > False Eyelash Accessories','en-AU'),(8160,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > False Eyelash Accessories > False Eyelash Applicators','en-AU'),(8161,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > False Eyelash Accessories > False Eyelash Glue','en-AU'),(8162,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > False Eyelash Accessories > False Eyelash Remover','en-AU'),(8163,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Makeup Brushes','en-AU'),(8164,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Makeup Sponges','en-AU'),(8165,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Makeup Tools > Refillable Makeup Palettes & Cases','en-AU'),(8166,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools','en-AU'),(8167,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Cuticle Pushers','en-AU'),(8168,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Cuticle Scissors','en-AU'),(8169,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Manicure & Pedicure Spacers','en-AU'),(8170,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Manicure Tool Sets','en-AU'),(8171,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Buffers','en-AU'),(8172,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Clippers','en-AU'),(8173,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Drill Accessories','en-AU'),(8174,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Drills','en-AU'),(8175,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Dryers','en-AU'),(8176,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Nail Tools > Nail Files & Emery Boards','en-AU'),(8177,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools','en-AU'),(8178,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Facial Saunas','en-AU'),(8179,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Foot Files','en-AU'),(8180,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Lotion & Sun Cream Applicators','en-AU'),(8181,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Pumice Stones','en-AU'),(8182,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Skin Care Extractors','en-AU'),(8183,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Skin Care Rollers','en-AU'),(8184,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Skin Cleansing Brush Heads','en-AU'),(8185,'Health & Beauty > Personal Care > Cosmetics > Cosmetic Tools > Skin Care Tools > Skin Cleansing Brushes & Systems','en-AU'),(8186,'Health & Beauty > Personal Care > Cosmetics > Makeup','en-AU'),(8187,'Health & Beauty > Personal Care > Cosmetics > Makeup > Body Makeup','en-AU'),(8188,'Health & Beauty > Personal Care > Cosmetics > Makeup > Body Makeup > Body & Hair Glitter','en-AU'),(8189,'Health & Beauty > Personal Care > Cosmetics > Makeup > Body Makeup > Body Paint & Foundation','en-AU'),(8190,'Health & Beauty > Personal Care > Cosmetics > Makeup > Costume & Stage Makeup','en-AU'),(8191,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup','en-AU'),(8192,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Eye Shadow','en-AU'),(8193,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Eye Shadow Primer','en-AU'),(8194,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Eyebrow Enhancers','en-AU'),(8195,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Eyeliner','en-AU'),(8196,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > False Eyelashes','en-AU'),(8197,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Lash & Brow Growth Treatments','en-AU'),(8198,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Mascara','en-AU'),(8199,'Health & Beauty > Personal Care > Cosmetics > Makeup > Eye Makeup > Mascara Primer','en-AU'),(8200,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup','en-AU'),(8201,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup > Blushes & Bronzers','en-AU'),(8202,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup > Face Powders','en-AU'),(8203,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup > Face Primer','en-AU'),(8204,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup > Foundations & Concealers','en-AU'),(8205,'Health & Beauty > Personal Care > Cosmetics > Makeup > Face Makeup > Highlighters & Luminizers','en-AU'),(8206,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup','en-AU'),(8207,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup > Lip & Cheek Stains','en-AU'),(8208,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup > Lip Gloss','en-AU'),(8209,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup > Lip Liner','en-AU'),(8210,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup > Lip Primer','en-AU'),(8211,'Health & Beauty > Personal Care > Cosmetics > Makeup > Lip Makeup > Lipstick','en-AU'),(8212,'Health & Beauty > Personal Care > Cosmetics > Makeup > Makeup Finishing Sprays','en-AU'),(8213,'Health & Beauty > Personal Care > Cosmetics > Makeup > Temporary Tattoos','en-AU'),(8214,'Health & Beauty > Personal Care > Cosmetics > Makeup Sets','en-AU'),(8215,'Health & Beauty > Personal Care > Cosmetics > Nail Care','en-AU'),(8216,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Cuticle Creams & Oils','en-AU'),(8217,'Health & Beauty > Personal Care > Cosmetics > Nail Care > False Nails','en-AU'),(8218,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Manicure Glue','en-AU'),(8219,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Nail Art Kits & Accessories','en-AU'),(8220,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Nail Polish Drying Drops & Sprays','en-AU'),(8221,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Nail Polish Removers','en-AU'),(8222,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Nail Polish Thinners','en-AU'),(8223,'Health & Beauty > Personal Care > Cosmetics > Nail Care > Nail Polishes','en-AU'),(8224,'Health & Beauty > Personal Care > Cosmetics > Perfume & Cologne','en-AU'),(8225,'Health & Beauty > Personal Care > Cosmetics > Skin Care','en-AU'),(8226,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Acne Treatments & Kits','en-AU'),(8227,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Anti-Aging Skin Care Kits','en-AU'),(8228,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Body Oils','en-AU'),(8229,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Body Powder','en-AU'),(8230,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Compressed Skin Care Mask Sheets','en-AU'),(8231,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Facial Cleansers','en-AU'),(8232,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Facial Cleansing Kits','en-AU'),(8233,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Facial Pore Strips','en-AU'),(8234,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Lip Balms & Treatments','en-AU'),(8235,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Lotions & Moisturisers','en-AU'),(8236,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Makeup Removers','en-AU'),(8237,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Petroleum Jelly','en-AU'),(8238,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Skin Care Masks & Peels','en-AU'),(8239,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Skin Insect Repellent','en-AU'),(8240,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Sunscreen','en-AU'),(8241,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Tanning Products','en-AU'),(8242,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Tanning Products > Self Tanners','en-AU'),(8243,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Tanning Products > Tanning Oils & Lotions','en-AU'),(8244,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Toners & Astringents','en-AU'),(8245,'Health & Beauty > Personal Care > Cosmetics > Skin Care > Wart Removers','en-AU'),(8246,'Health & Beauty > Personal Care > Cotton Buds','en-AU'),(8247,'Health & Beauty > Personal Care > Cotton Wool Balls','en-AU'),(8248,'Health & Beauty > Personal Care > Deodorants & Anti-Perspirants','en-AU'),(8249,'Health & Beauty > Personal Care > Ear Care','en-AU'),(8250,'Health & Beauty > Personal Care > Ear Care > Ear Candles','en-AU'),(8251,'Health & Beauty > Personal Care > Ear Care > Ear Drops','en-AU'),(8252,'Health & Beauty > Personal Care > Ear Care > Ear Dryers','en-AU'),(8253,'Health & Beauty > Personal Care > Ear Care > Ear Picks & Spoons','en-AU'),(8254,'Health & Beauty > Personal Care > Ear Care > Ear Syringes','en-AU'),(8255,'Health & Beauty > Personal Care > Ear Care > Ear Wax Removal Kits','en-AU'),(8256,'Health & Beauty > Personal Care > Ear Care > Earplug Dispensers','en-AU'),(8257,'Health & Beauty > Personal Care > Ear Care > Earplugs','en-AU'),(8258,'Health & Beauty > Personal Care > Enema Kits & Supplies','en-AU'),(8259,'Health & Beauty > Personal Care > Feminine Sanitary Supplies','en-AU'),(8260,'Health & Beauty > Personal Care > Feminine Sanitary Supplies > Feminine Deodorant','en-AU'),(8261,'Health & Beauty > Personal Care > Feminine Sanitary Supplies > Feminine Douches & Washes','en-AU'),(8262,'Health & Beauty > Personal Care > Feminine Sanitary Supplies > Feminine Pads & Protectors','en-AU'),(8263,'Health & Beauty > Personal Care > Feminine Sanitary Supplies > Menstrual Cups','en-AU'),(8264,'Health & Beauty > Personal Care > Feminine Sanitary Supplies > Tampons','en-AU'),(8265,'Health & Beauty > Personal Care > Foot Care','en-AU'),(8266,'Health & Beauty > Personal Care > Foot Care > Bunion Care Supplies','en-AU'),(8267,'Health & Beauty > Personal Care > Foot Care > Corn & Callus Care Supplies','en-AU'),(8268,'Health & Beauty > Personal Care > Foot Care > Foot Odour Removers','en-AU'),(8269,'Health & Beauty > Personal Care > Foot Care > Insoles & Inserts','en-AU'),(8270,'Health & Beauty > Personal Care > Foot Care > Toe Spacers','en-AU'),(8271,'Health & Beauty > Personal Care > Hair Care','en-AU'),(8272,'Health & Beauty > Personal Care > Hair Care > Hair Care Kits','en-AU'),(8273,'Health & Beauty > Personal Care > Hair Care > Hair Colour Removers','en-AU'),(8274,'Health & Beauty > Personal Care > Hair Care > Hair Colouring','en-AU'),(8275,'Health & Beauty > Personal Care > Hair Care > Hair Colouring Accessories','en-AU'),(8276,'Health & Beauty > Personal Care > Hair Care > Hair Loss Concealers','en-AU'),(8277,'Health & Beauty > Personal Care > Hair Care > Hair Loss Treatments','en-AU'),(8278,'Health & Beauty > Personal Care > Hair Care > Hair Permanents & Straighteners','en-AU'),(8279,'Health & Beauty > Personal Care > Hair Care > Hair Scissors','en-AU'),(8280,'Health & Beauty > Personal Care > Hair Care > Hair Steamers & Heat Caps','en-AU'),(8281,'Health & Beauty > Personal Care > Hair Care > Hair Styling Products','en-AU'),(8282,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tool Accessories','en-AU'),(8283,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tool Accessories > Hair Curler Clips & Pins','en-AU'),(8284,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tool Accessories > Hair Dryer Accessories','en-AU'),(8285,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tool Accessories > Hair Iron Accessories','en-AU'),(8286,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools','en-AU'),(8287,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Combs & Brushes','en-AU'),(8288,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Curling Irons','en-AU'),(8289,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Hair Curlers','en-AU'),(8290,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Hair Dryers','en-AU'),(8291,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Hair Straighteners','en-AU'),(8292,'Health & Beauty > Personal Care > Hair Care > Hair Styling Tools > Hair-Styling Tool Sets','en-AU'),(8293,'Health & Beauty > Personal Care > Hair Care > Shampoo & Conditioner','en-AU'),(8294,'Health & Beauty > Personal Care > Massage & Relaxation','en-AU'),(8295,'Health & Beauty > Personal Care > Massage & Relaxation > Back Scratchers','en-AU'),(8296,'Health & Beauty > Personal Care > Massage & Relaxation > Eye Pillows','en-AU'),(8297,'Health & Beauty > Personal Care > Massage & Relaxation > Massage Chairs','en-AU'),(8298,'Health & Beauty > Personal Care > Massage & Relaxation > Massage Oils','en-AU'),(8299,'Health & Beauty > Personal Care > Massage & Relaxation > Massage Stone Warmers','en-AU'),(8300,'Health & Beauty > Personal Care > Massage & Relaxation > Massage Stones','en-AU'),(8301,'Health & Beauty > Personal Care > Massage & Relaxation > Massage Tables','en-AU'),(8302,'Health & Beauty > Personal Care > Massage & Relaxation > Massagers','en-AU'),(8303,'Health & Beauty > Personal Care > Oral Care','en-AU'),(8304,'Health & Beauty > Personal Care > Oral Care > Breath Spray','en-AU'),(8305,'Health & Beauty > Personal Care > Oral Care > Dental Floss','en-AU'),(8306,'Health & Beauty > Personal Care > Oral Care > Dental Mouthguards','en-AU'),(8307,'Health & Beauty > Personal Care > Oral Care > Dental Water Jet Replacement Tips','en-AU'),(8308,'Health & Beauty > Personal Care > Oral Care > Dental Water Jets','en-AU'),(8309,'Health & Beauty > Personal Care > Oral Care > Denture Adhesives','en-AU'),(8310,'Health & Beauty > Personal Care > Oral Care > Denture Cleaners','en-AU'),(8311,'Health & Beauty > Personal Care > Oral Care > Denture Repair Kits','en-AU'),(8312,'Health & Beauty > Personal Care > Oral Care > Dentures','en-AU'),(8313,'Health & Beauty > Personal Care > Oral Care > Gum Stimulators','en-AU'),(8314,'Health & Beauty > Personal Care > Oral Care > Mouthwash','en-AU'),(8315,'Health & Beauty > Personal Care > Oral Care > Orthodontic Appliance Cases','en-AU'),(8316,'Health & Beauty > Personal Care > Oral Care > Power Flossers','en-AU'),(8317,'Health & Beauty > Personal Care > Oral Care > Teeth Whiteners','en-AU'),(8318,'Health & Beauty > Personal Care > Oral Care > Tongue Scrapers','en-AU'),(8319,'Health & Beauty > Personal Care > Oral Care > Toothbrush Accessories','en-AU'),(8320,'Health & Beauty > Personal Care > Oral Care > Toothbrush Accessories > Toothbrush Covers','en-AU'),(8321,'Health & Beauty > Personal Care > Oral Care > Toothbrush Accessories > Toothbrush Replacement Heads','en-AU'),(8322,'Health & Beauty > Personal Care > Oral Care > Toothbrush Accessories > Toothbrush Sanitisers','en-AU'),(8323,'Health & Beauty > Personal Care > Oral Care > Toothbrushes','en-AU'),(8324,'Health & Beauty > Personal Care > Oral Care > Toothpaste','en-AU'),(8325,'Health & Beauty > Personal Care > Oral Care > Toothpaste Squeezers & Dispensers','en-AU'),(8326,'Health & Beauty > Personal Care > Oral Care > Toothpicks','en-AU'),(8327,'Health & Beauty > Personal Care > Personal Lubricants','en-AU'),(8328,'Health & Beauty > Personal Care > Shaving & Grooming','en-AU'),(8329,'Health & Beauty > Personal Care > Shaving & Grooming > Aftershave','en-AU'),(8330,'Health & Beauty > Personal Care > Shaving & Grooming > Body & Facial Hair Bleach','en-AU'),(8331,'Health & Beauty > Personal Care > Shaving & Grooming > Electric Razor Accessories','en-AU'),(8332,'Health & Beauty > Personal Care > Shaving & Grooming > Electric Razors','en-AU'),(8333,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Clipper & Trimmer Accessories','en-AU'),(8334,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Clippers & Trimmers','en-AU'),(8335,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal','en-AU'),(8336,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Depilatories','en-AU'),(8337,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Electrolysis Devices','en-AU'),(8338,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Epilators','en-AU'),(8339,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Hair Removal Wax Warmers','en-AU'),(8340,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Laser & IPL Hair Removal Devices','en-AU'),(8341,'Health & Beauty > Personal Care > Shaving & Grooming > Hair Removal > Waxing Kits & Supplies','en-AU'),(8342,'Health & Beauty > Personal Care > Shaving & Grooming > Razors & Razor Blades','en-AU'),(8343,'Health & Beauty > Personal Care > Shaving & Grooming > Shaving Bowls & Mugs','en-AU'),(8344,'Health & Beauty > Personal Care > Shaving & Grooming > Shaving Brushes','en-AU'),(8345,'Health & Beauty > Personal Care > Shaving & Grooming > Shaving Cream','en-AU'),(8346,'Health & Beauty > Personal Care > Shaving & Grooming > Shaving Kits','en-AU'),(8347,'Health & Beauty > Personal Care > Shaving & Grooming > Styptic Pencils','en-AU'),(8348,'Health & Beauty > Personal Care > Sleeping Aids','en-AU'),(8349,'Health & Beauty > Personal Care > Sleeping Aids > Eye Masks','en-AU'),(8350,'Health & Beauty > Personal Care > Sleeping Aids > Snoring & Sleep Apnea Aids','en-AU'),(8351,'Health & Beauty > Personal Care > Sleeping Aids > Travel Pillows','en-AU'),(8352,'Health & Beauty > Personal Care > Sleeping Aids > White Noise Machines','en-AU'),(8353,'Health & Beauty > Personal Care > Spray Tanning Tents','en-AU'),(8354,'Health & Beauty > Personal Care > Tanning Beds','en-AU'),(8355,'Health & Beauty > Personal Care > Tweezers','en-AU'),(8356,'Health & Beauty > Personal Care > Vision Care','en-AU'),(8357,'Health & Beauty > Personal Care > Vision Care > Contact Lens Care','en-AU'),(8358,'Health & Beauty > Personal Care > Vision Care > Contact Lens Care > Contact Lens Care Kits','en-AU'),(8359,'Health & Beauty > Personal Care > Vision Care > Contact Lens Care > Contact Lens Cases','en-AU'),(8360,'Health & Beauty > Personal Care > Vision Care > Contact Lens Care > Contact Lens Solution','en-AU'),(8361,'Health & Beauty > Personal Care > Vision Care > Contact Lenses','en-AU'),(8362,'Health & Beauty > Personal Care > Vision Care > Eye Drops & Lubricants','en-AU'),(8363,'Health & Beauty > Personal Care > Vision Care > Eyeglass Lenses','en-AU'),(8364,'Health & Beauty > Personal Care > Vision Care > Eyeglasses','en-AU'),(8365,'Health & Beauty > Personal Care > Vision Care > Eyewear Accessories','en-AU'),(8366,'Health & Beauty > Personal Care > Vision Care > Eyewear Accessories > Eyewear Cases & Holders','en-AU'),(8367,'Health & Beauty > Personal Care > Vision Care > Eyewear Accessories > Eyewear Lens Cleaning Solutions','en-AU'),(8368,'Health & Beauty > Personal Care > Vision Care > Eyewear Accessories > Eyewear Straps & Chains','en-AU'),(8369,'Health & Beauty > Personal Care > Vision Care > Sunglass Lenses','en-AU'),(8370,'Home & Garden','en-AU'),(8371,'Home & Garden > Bathroom Accessories','en-AU'),(8372,'Home & Garden > Bathroom Accessories > Bath Caddies','en-AU'),(8373,'Home & Garden > Bathroom Accessories > Bath Mats & Rugs','en-AU'),(8374,'Home & Garden > Bathroom Accessories > Bath Pillows','en-AU'),(8375,'Home & Garden > Bathroom Accessories > Bathroom Accessory Mounts','en-AU'),(8376,'Home & Garden > Bathroom Accessories > Bathroom Accessory Sets','en-AU'),(8377,'Home & Garden > Bathroom Accessories > Dressing Gown Hooks','en-AU'),(8378,'Home & Garden > Bathroom Accessories > Facial Tissue Holders','en-AU'),(8379,'Home & Garden > Bathroom Accessories > Hand Dryer Accessories','en-AU'),(8380,'Home & Garden > Bathroom Accessories > Hand Dryers','en-AU'),(8381,'Home & Garden > Bathroom Accessories > Medicine Cabinets','en-AU'),(8382,'Home & Garden > Bathroom Accessories > Safety Grab Rails','en-AU'),(8383,'Home & Garden > Bathroom Accessories > Shower Curtain Rings','en-AU'),(8384,'Home & Garden > Bathroom Accessories > Shower Curtains','en-AU'),(8385,'Home & Garden > Bathroom Accessories > Shower Rods','en-AU'),(8386,'Home & Garden > Bathroom Accessories > Soap & Lotion Dispensers','en-AU'),(8387,'Home & Garden > Bathroom Accessories > Soap Dishes & Holders','en-AU'),(8388,'Home & Garden > Bathroom Accessories > Toilet Brush Replacement Heads','en-AU'),(8389,'Home & Garden > Bathroom Accessories > Toilet Brushes & Holders','en-AU'),(8390,'Home & Garden > Bathroom Accessories > Toilet Paper Holders','en-AU'),(8391,'Home & Garden > Bathroom Accessories > Toothbrush Holders','en-AU'),(8392,'Home & Garden > Bathroom Accessories > Towel Racks & Holders','en-AU'),(8393,'Home & Garden > Business & Home Security','en-AU'),(8394,'Home & Garden > Business & Home Security > Dummy Surveillance Cameras','en-AU'),(8395,'Home & Garden > Business & Home Security > Home Alarm Systems','en-AU'),(8396,'Home & Garden > Business & Home Security > Motion Sensors','en-AU'),(8397,'Home & Garden > Business & Home Security > Safety & Security Mirrors','en-AU'),(8398,'Home & Garden > Business & Home Security > Security Lights','en-AU'),(8399,'Home & Garden > Business & Home Security > Security Monitors & Recorders','en-AU'),(8400,'Home & Garden > Business & Home Security > Security Safe Accessories','en-AU'),(8401,'Home & Garden > Business & Home Security > Security Safes','en-AU'),(8402,'Home & Garden > Business & Home Security > Security System Sensors','en-AU'),(8403,'Home & Garden > Decor','en-AU'),(8404,'Home & Garden > Decor > Address Signs','en-AU'),(8405,'Home & Garden > Decor > Artificial Flora','en-AU'),(8406,'Home & Garden > Decor > Artificial Food','en-AU'),(8407,'Home & Garden > Decor > Artwork','en-AU'),(8408,'Home & Garden > Decor > Artwork > Decorative Tapestries','en-AU'),(8409,'Home & Garden > Decor > Artwork > Figurines, Sculptures & Statues','en-AU'),(8410,'Home & Garden > Decor > Artwork > Posters, Prints & Visual Artwork','en-AU'),(8411,'Home & Garden > Decor > Backrest Pillows','en-AU'),(8412,'Home & Garden > Decor > Baskets','en-AU'),(8413,'Home & Garden > Decor > Bird & Wildlife Feeder Accessories','en-AU'),(8414,'Home & Garden > Decor > Bird & Wildlife Feeders','en-AU'),(8415,'Home & Garden > Decor > Bird & Wildlife Feeders > Bird Feeders','en-AU'),(8416,'Home & Garden > Decor > Bird & Wildlife Feeders > Butterfly Feeders','en-AU'),(8417,'Home & Garden > Decor > Bird & Wildlife Feeders > Squirrel Feeders','en-AU'),(8418,'Home & Garden > Decor > Bird & Wildlife Houses','en-AU'),(8419,'Home & Garden > Decor > Bird & Wildlife Houses > Bat Houses','en-AU'),(8420,'Home & Garden > Decor > Bird & Wildlife Houses > Birdhouses','en-AU'),(8421,'Home & Garden > Decor > Bird & Wildlife Houses > Butterfly Houses','en-AU'),(8422,'Home & Garden > Decor > Bird Baths','en-AU'),(8423,'Home & Garden > Decor > Birdhouse Accessories','en-AU'),(8424,'Home & Garden > Decor > Bookends','en-AU'),(8425,'Home & Garden > Decor > Bottle Gardens','en-AU'),(8426,'Home & Garden > Decor > Candles & Home Fragrances','en-AU'),(8427,'Home & Garden > Decor > Candles & Home Fragrances > Air Fresheners','en-AU'),(8428,'Home & Garden > Decor > Candles & Home Fragrances > Candles','en-AU'),(8429,'Home & Garden > Decor > Candles & Home Fragrances > Fragrance Oils','en-AU'),(8430,'Home & Garden > Decor > Candles & Home Fragrances > Incense','en-AU'),(8431,'Home & Garden > Decor > Candles & Home Fragrances > Potpourri','en-AU'),(8432,'Home & Garden > Decor > Candles & Home Fragrances > Wax Tarts','en-AU'),(8433,'Home & Garden > Decor > Cardboard Cut-Outs','en-AU'),(8434,'Home & Garden > Decor > Chair & Sofa Cushions','en-AU'),(8435,'Home & Garden > Decor > Clock Parts','en-AU'),(8436,'Home & Garden > Decor > Clocks','en-AU'),(8437,'Home & Garden > Decor > Clocks > Alarm Clocks','en-AU'),(8438,'Home & Garden > Decor > Clocks > Desk & Shelf Clocks','en-AU'),(8439,'Home & Garden > Decor > Clocks > Floor & Grandfather Clocks','en-AU'),(8440,'Home & Garden > Decor > Clocks > Wall Clocks','en-AU'),(8441,'Home & Garden > Decor > Coat & Hat Racks','en-AU'),(8442,'Home & Garden > Decor > Decorative Bells','en-AU'),(8443,'Home & Garden > Decor > Decorative Bottles','en-AU'),(8444,'Home & Garden > Decor > Decorative Bowls','en-AU'),(8445,'Home & Garden > Decor > Decorative Jars','en-AU'),(8446,'Home & Garden > Decor > Decorative Plaques','en-AU'),(8447,'Home & Garden > Decor > Decorative Plates','en-AU'),(8448,'Home & Garden > Decor > Decorative Trays','en-AU'),(8449,'Home & Garden > Decor > Door Mats','en-AU'),(8450,'Home & Garden > Decor > Dreamcatchers','en-AU'),(8451,'Home & Garden > Decor > Dried Flowers','en-AU'),(8452,'Home & Garden > Decor > Figurines','en-AU'),(8453,'Home & Garden > Decor > Finials','en-AU'),(8454,'Home & Garden > Decor > Flag & Windsock Accessories','en-AU'),(8455,'Home & Garden > Decor > Flag & Windsock Accessories > Flag & Windsock Pole Lights','en-AU'),(8456,'Home & Garden > Decor > Flag & Windsock Accessories > Flag & Windsock Pole Mounting Hardware & Kits','en-AU'),(8457,'Home & Garden > Decor > Flag & Windsock Accessories > Flag & Windsock Poles','en-AU'),(8458,'Home & Garden > Decor > Flags & Windsocks','en-AU'),(8459,'Home & Garden > Decor > Flameless Candles','en-AU'),(8460,'Home & Garden > Decor > Fountains & Ponds','en-AU'),(8461,'Home & Garden > Decor > Fountains & Ponds > Fountain & Pond Accessories','en-AU'),(8462,'Home & Garden > Decor > Fountains & Ponds > Fountains & Waterfalls','en-AU'),(8463,'Home & Garden > Decor > Fountains & Ponds > Ponds','en-AU'),(8464,'Home & Garden > Decor > Garden & Stepping Stones','en-AU'),(8465,'Home & Garden > Decor > Growth Charts','en-AU'),(8466,'Home & Garden > Decor > Home Decor Decals','en-AU'),(8467,'Home & Garden > Decor > Home Fragrance Accessories','en-AU'),(8468,'Home & Garden > Decor > Home Fragrance Accessories > Candle & Oil Warmers','en-AU'),(8469,'Home & Garden > Decor > Home Fragrance Accessories > Candle Holders','en-AU'),(8470,'Home & Garden > Decor > Home Fragrance Accessories > Candle Snuffers','en-AU'),(8471,'Home & Garden > Decor > Home Fragrance Accessories > Incense Holders','en-AU'),(8472,'Home & Garden > Decor > Hourglasses','en-AU'),(8473,'Home & Garden > Decor > House Numbers & Letters','en-AU'),(8474,'Home & Garden > Decor > Lawn Ornaments & Garden Sculptures','en-AU'),(8475,'Home & Garden > Decor > Letterboxes','en-AU'),(8476,'Home & Garden > Decor > Mirrors','en-AU'),(8477,'Home & Garden > Decor > Music Boxes','en-AU'),(8478,'Home & Garden > Decor > Novelty Signs','en-AU'),(8479,'Home & Garden > Decor > Ottoman Cushions','en-AU'),(8480,'Home & Garden > Decor > Picture Frames','en-AU'),(8481,'Home & Garden > Decor > Piggy Banks & Money Jars','en-AU'),(8482,'Home & Garden > Decor > Post Boxes','en-AU'),(8483,'Home & Garden > Decor > Postbox Accessories','en-AU'),(8484,'Home & Garden > Decor > Postbox Accessories > Letterbox Covers','en-AU'),(8485,'Home & Garden > Decor > Postbox Accessories > Letterbox Enclosures','en-AU'),(8486,'Home & Garden > Decor > Postbox Accessories > Letterbox Flags','en-AU'),(8487,'Home & Garden > Decor > Postbox Accessories > Letterbox Replacement Doors','en-AU'),(8488,'Home & Garden > Decor > Postbox Accessories > Postbox Posts','en-AU'),(8489,'Home & Garden > Decor > Rain Chains','en-AU'),(8490,'Home & Garden > Decor > Rain Gauges','en-AU'),(8491,'Home & Garden > Decor > Refrigerator Magnets','en-AU'),(8492,'Home & Garden > Decor > Rugs','en-AU'),(8493,'Home & Garden > Decor > Seasonal & Holiday Decorations','en-AU'),(8494,'Home & Garden > Decor > Seasonal & Holiday Decorations > Advent Calendars','en-AU'),(8495,'Home & Garden > Decor > Seasonal & Holiday Decorations > Christmas Decoration Hooks','en-AU'),(8496,'Home & Garden > Decor > Seasonal & Holiday Decorations > Christmas Tree Skirts','en-AU'),(8497,'Home & Garden > Decor > Seasonal & Holiday Decorations > Christmas Tree Stands','en-AU'),(8498,'Home & Garden > Decor > Seasonal & Holiday Decorations > Easter Egg Decorating Kits','en-AU'),(8499,'Home & Garden > Decor > Seasonal & Holiday Decorations > Holiday Ornament Displays & Stands','en-AU'),(8500,'Home & Garden > Decor > Seasonal & Holiday Decorations > Holiday Ornaments','en-AU'),(8501,'Home & Garden > Decor > Seasonal & Holiday Decorations > Holiday Stocking Hangers','en-AU'),(8502,'Home & Garden > Decor > Seasonal & Holiday Decorations > Holiday Stockings','en-AU'),(8503,'Home & Garden > Decor > Seasonal & Holiday Decorations > Japanese Traditional Dolls','en-AU'),(8504,'Home & Garden > Decor > Seasonal & Holiday Decorations > Nativity Sets','en-AU'),(8505,'Home & Garden > Decor > Seasonal & Holiday Decorations > Seasonal Village Sets & Accessories','en-AU'),(8506,'Home & Garden > Decor > Serviette Rings','en-AU'),(8507,'Home & Garden > Decor > Shadow Boxes','en-AU'),(8508,'Home & Garden > Decor > Slipcovers','en-AU'),(8509,'Home & Garden > Decor > Snow Globes','en-AU'),(8510,'Home & Garden > Decor > Suncatchers','en-AU'),(8511,'Home & Garden > Decor > Sundials','en-AU'),(8512,'Home & Garden > Decor > Throw Pillows','en-AU'),(8513,'Home & Garden > Decor > Trunks','en-AU'),(8514,'Home & Garden > Decor > Vase Fillers & Table Scatters','en-AU'),(8515,'Home & Garden > Decor > Vases','en-AU'),(8516,'Home & Garden > Decor > Wallpaper','en-AU'),(8517,'Home & Garden > Decor > Weather Vanes & Roof Decoration','en-AU'),(8518,'Home & Garden > Decor > Wind Chimes','en-AU'),(8519,'Home & Garden > Decor > Wind Wheels & Spinners','en-AU'),(8520,'Home & Garden > Decor > Window Magnets','en-AU'),(8521,'Home & Garden > Decor > Window Treatment Accessories','en-AU'),(8522,'Home & Garden > Decor > Window Treatment Accessories > Curtain & Drape Rings','en-AU'),(8523,'Home & Garden > Decor > Window Treatment Accessories > Curtain & Drape Rods','en-AU'),(8524,'Home & Garden > Decor > Window Treatment Accessories > Curtain Holdbacks & Tassels','en-AU'),(8525,'Home & Garden > Decor > Window Treatment Accessories > Window Treatment Replacement Parts','en-AU'),(8526,'Home & Garden > Decor > Window Treatments','en-AU'),(8527,'Home & Garden > Decor > Window Treatments > Curtains & Drapes','en-AU'),(8528,'Home & Garden > Decor > Window Treatments > Stained Glass Panels','en-AU'),(8529,'Home & Garden > Decor > Window Treatments > Window Blinds & Shades','en-AU'),(8530,'Home & Garden > Decor > Window Treatments > Window Films','en-AU'),(8531,'Home & Garden > Decor > Window Treatments > Window Screens','en-AU'),(8532,'Home & Garden > Decor > Window Treatments > Window Valances & Cornices','en-AU'),(8533,'Home & Garden > Decor > World Globes','en-AU'),(8534,'Home & Garden > Decor > Wreaths & Garlands','en-AU'),(8535,'Home & Garden > Emergency Preparedness','en-AU'),(8536,'Home & Garden > Emergency Preparedness > Earthquake Alarms','en-AU'),(8537,'Home & Garden > Emergency Preparedness > Emergency Blankets','en-AU'),(8538,'Home & Garden > Emergency Preparedness > Emergency Food Kits','en-AU'),(8539,'Home & Garden > Emergency Preparedness > Emergency Tools & Kits','en-AU'),(8540,'Home & Garden > Emergency Preparedness > Furniture Anchors','en-AU'),(8541,'Home & Garden > Fireplace & Wood Stove Accessories','en-AU'),(8542,'Home & Garden > Fireplace & Wood Stove Accessories > Bellows','en-AU'),(8543,'Home & Garden > Fireplace & Wood Stove Accessories > Fireplace & Wood Stove Grates','en-AU'),(8544,'Home & Garden > Fireplace & Wood Stove Accessories > Fireplace Andirons','en-AU'),(8545,'Home & Garden > Fireplace & Wood Stove Accessories > Fireplace Reflectors','en-AU'),(8546,'Home & Garden > Fireplace & Wood Stove Accessories > Fireplace Screens','en-AU'),(8547,'Home & Garden > Fireplace & Wood Stove Accessories > Fireplace Tools','en-AU'),(8548,'Home & Garden > Fireplace & Wood Stove Accessories > Firewood & Fuel','en-AU'),(8549,'Home & Garden > Fireplace & Wood Stove Accessories > Hearth Pads','en-AU'),(8550,'Home & Garden > Fireplace & Wood Stove Accessories > Log Rack & Carrier Accessories','en-AU'),(8551,'Home & Garden > Fireplace & Wood Stove Accessories > Log Racks & Carriers','en-AU'),(8552,'Home & Garden > Fireplace & Wood Stove Accessories > Wood Stove Fans & Blowers','en-AU'),(8553,'Home & Garden > Fireplaces','en-AU'),(8554,'Home & Garden > Flood, Fire & Gas Safety','en-AU'),(8555,'Home & Garden > Flood, Fire & Gas Safety > Fire Alarm Control Panels','en-AU'),(8556,'Home & Garden > Flood, Fire & Gas Safety > Fire Alarms','en-AU'),(8557,'Home & Garden > Flood, Fire & Gas Safety > Fire Extinguisher & Equipment Storage','en-AU'),(8558,'Home & Garden > Flood, Fire & Gas Safety > Fire Extinguishers','en-AU'),(8559,'Home & Garden > Flood, Fire & Gas Safety > Fire Sprinklers','en-AU'),(8560,'Home & Garden > Flood, Fire & Gas Safety > Heat Detectors','en-AU'),(8561,'Home & Garden > Flood, Fire & Gas Safety > Smoke & Carbon Monoxide Detectors','en-AU'),(8562,'Home & Garden > Flood, Fire & Gas Safety > Water & Flood Detectors','en-AU'),(8563,'Home & Garden > Household Appliance Accessories','en-AU'),(8564,'Home & Garden > Household Appliance Accessories > Air Conditioner Accessories','en-AU'),(8565,'Home & Garden > Household Appliance Accessories > Air Conditioner Accessories > Air Conditioner Covers','en-AU'),(8566,'Home & Garden > Household Appliance Accessories > Air Conditioner Accessories > Air Conditioner Filters','en-AU'),(8567,'Home & Garden > Household Appliance Accessories > Air Purifier Accessories','en-AU'),(8568,'Home & Garden > Household Appliance Accessories > Air Purifier Accessories > Air Purifier Filters','en-AU'),(8569,'Home & Garden > Household Appliance Accessories > Dehumidifier Accessories','en-AU'),(8570,'Home & Garden > Household Appliance Accessories > Fan Accessories','en-AU'),(8571,'Home & Garden > Household Appliance Accessories > Floor & Steam Cleaner Accessories','en-AU'),(8572,'Home & Garden > Household Appliance Accessories > Furnace & Boiler Accessories','en-AU'),(8573,'Home & Garden > Household Appliance Accessories > Heating Radiator Accessories','en-AU'),(8574,'Home & Garden > Household Appliance Accessories > Heating Radiator Accessories > Heating Radiator Reflectors','en-AU'),(8575,'Home & Garden > Household Appliance Accessories > Humidifier Accessories','en-AU'),(8576,'Home & Garden > Household Appliance Accessories > Humidifier Accessories > Humidifier Filters','en-AU'),(8577,'Home & Garden > Household Appliance Accessories > Laundry Appliance Accessories','en-AU'),(8578,'Home & Garden > Household Appliance Accessories > Laundry Appliance Accessories > Garment Steamer Accessories','en-AU'),(8579,'Home & Garden > Household Appliance Accessories > Laundry Appliance Accessories > Iron Accessories','en-AU'),(8580,'Home & Garden > Household Appliance Accessories > Laundry Appliance Accessories > Steam Press Accessories','en-AU'),(8581,'Home & Garden > Household Appliance Accessories > Laundry Appliance Accessories > Washer & Dryer Accessories','en-AU'),(8582,'Home & Garden > Household Appliance Accessories > Patio Heater Accessories','en-AU'),(8583,'Home & Garden > Household Appliance Accessories > Patio Heater Accessories > Patio Heater Covers','en-AU'),(8584,'Home & Garden > Household Appliance Accessories > Vacuum Accessories','en-AU'),(8585,'Home & Garden > Household Appliance Accessories > Water Heater Accessories','en-AU'),(8586,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Anode Rods','en-AU'),(8587,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Hot Water Tanks','en-AU'),(8588,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Water Heater Elements','en-AU'),(8589,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Water Heater Expansion Tanks','en-AU'),(8590,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Water Heater Pans','en-AU'),(8591,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Water Heater Stacks','en-AU'),(8592,'Home & Garden > Household Appliance Accessories > Water Heater Accessories > Water Heater Vents','en-AU'),(8593,'Home & Garden > Household Appliances','en-AU'),(8594,'Home & Garden > Household Appliances > Climate Control Appliances','en-AU'),(8595,'Home & Garden > Household Appliances > Climate Control Appliances > Air Conditioners','en-AU'),(8596,'Home & Garden > Household Appliances > Climate Control Appliances > Air Purifiers','en-AU'),(8597,'Home & Garden > Household Appliances > Climate Control Appliances > Dehumidifiers','en-AU'),(8598,'Home & Garden > Household Appliances > Climate Control Appliances > Duct Heaters','en-AU'),(8599,'Home & Garden > Household Appliances > Climate Control Appliances > Evaporative Coolers','en-AU'),(8600,'Home & Garden > Household Appliances > Climate Control Appliances > Fans','en-AU'),(8601,'Home & Garden > Household Appliances > Climate Control Appliances > Fans > Ceiling Fans','en-AU'),(8602,'Home & Garden > Household Appliances > Climate Control Appliances > Fans > Desk & Pedestal Fans','en-AU'),(8603,'Home & Garden > Household Appliances > Climate Control Appliances > Fans > Powered Hand Fans & Misters','en-AU'),(8604,'Home & Garden > Household Appliances > Climate Control Appliances > Fans > Ventilation Fans','en-AU'),(8605,'Home & Garden > Household Appliances > Climate Control Appliances > Fans > Wall Mount Fans','en-AU'),(8606,'Home & Garden > Household Appliances > Climate Control Appliances > Furnaces & Boilers','en-AU'),(8607,'Home & Garden > Household Appliances > Climate Control Appliances > Heating Radiators','en-AU'),(8608,'Home & Garden > Household Appliances > Climate Control Appliances > Humidifiers','en-AU'),(8609,'Home & Garden > Household Appliances > Climate Control Appliances > Outdoor Misting Systems','en-AU'),(8610,'Home & Garden > Household Appliances > Climate Control Appliances > Patio Heaters','en-AU'),(8611,'Home & Garden > Household Appliances > Climate Control Appliances > Space Heaters','en-AU'),(8612,'Home & Garden > Household Appliances > Floor & Carpet Dryers','en-AU'),(8613,'Home & Garden > Household Appliances > Floor & Steam Cleaners','en-AU'),(8614,'Home & Garden > Household Appliances > Floor Polishers & Buffers','en-AU'),(8615,'Home & Garden > Household Appliances > Futon Dryers','en-AU'),(8616,'Home & Garden > Household Appliances > Garage Door Keypads & Remotes','en-AU'),(8617,'Home & Garden > Household Appliances > Garage Door Openers','en-AU'),(8618,'Home & Garden > Household Appliances > Laundry Appliances','en-AU'),(8619,'Home & Garden > Household Appliances > Laundry Appliances > Dryers','en-AU'),(8620,'Home & Garden > Household Appliances > Laundry Appliances > Garment Steamers','en-AU'),(8621,'Home & Garden > Household Appliances > Laundry Appliances > Irons & Ironing Systems','en-AU'),(8622,'Home & Garden > Household Appliances > Laundry Appliances > Laundry Combo Units','en-AU'),(8623,'Home & Garden > Household Appliances > Laundry Appliances > Steam Presses','en-AU'),(8624,'Home & Garden > Household Appliances > Laundry Appliances > Washing Machines','en-AU'),(8625,'Home & Garden > Household Appliances > Ultrasonic Cleaners','en-AU'),(8626,'Home & Garden > Household Appliances > Vacuums','en-AU'),(8627,'Home & Garden > Household Appliances > Wallpaper Steamers','en-AU'),(8628,'Home & Garden > Household Appliances > Water Heaters','en-AU'),(8629,'Home & Garden > Household Supplies','en-AU'),(8630,'Home & Garden > Household Supplies > Drawer & Shelf Liners','en-AU'),(8631,'Home & Garden > Household Supplies > Floor Protection Films & Runners','en-AU'),(8632,'Home & Garden > Household Supplies > Furniture Floor Protectors','en-AU'),(8633,'Home & Garden > Household Supplies > Garage Floor Mats','en-AU'),(8634,'Home & Garden > Household Supplies > Garbage Compactor Accessories','en-AU'),(8635,'Home & Garden > Household Supplies > Household Cleaning Supplies','en-AU'),(8636,'Home & Garden > Household Supplies > Household Cleaning Supplies > Broom & Mop Handles','en-AU'),(8637,'Home & Garden > Household Supplies > Household Cleaning Supplies > Broom Heads','en-AU'),(8638,'Home & Garden > Household Supplies > Household Cleaning Supplies > Brooms','en-AU'),(8639,'Home & Garden > Household Supplies > Household Cleaning Supplies > Buckets','en-AU'),(8640,'Home & Garden > Household Supplies > Household Cleaning Supplies > Carpet Sweepers','en-AU'),(8641,'Home & Garden > Household Supplies > Household Cleaning Supplies > Cleaning Gloves','en-AU'),(8642,'Home & Garden > Household Supplies > Household Cleaning Supplies > Duster Refills','en-AU'),(8643,'Home & Garden > Household Supplies > Household Cleaning Supplies > Dusters','en-AU'),(8644,'Home & Garden > Household Supplies > Household Cleaning Supplies > Dustpans','en-AU'),(8645,'Home & Garden > Household Supplies > Household Cleaning Supplies > Fabric & Upholstery Protectors','en-AU'),(8646,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products','en-AU'),(8647,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > All-Purpose Cleaners','en-AU'),(8648,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Carpet Cleaners','en-AU'),(8649,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Descalers & Decalcifiers','en-AU'),(8650,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Dishwasher Cleaners','en-AU'),(8651,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Fabric & Upholstery Cleaners','en-AU'),(8652,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Floor Cleaners','en-AU'),(8653,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Furniture Cleaners & Polish','en-AU'),(8654,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Glass & Surface Cleaners','en-AU'),(8655,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Household Disinfectants','en-AU'),(8656,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Oven & Grill Cleaners','en-AU'),(8657,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Pet Odour & Stain Removers','en-AU'),(8658,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Rinse Aids','en-AU'),(8659,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Stainless Steel Cleaners & Polishes','en-AU'),(8660,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Toilet Bowl Cleaners','en-AU'),(8661,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Tub & Tile Cleaners','en-AU'),(8662,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Washing Machine Cleaners','en-AU'),(8663,'Home & Garden > Household Supplies > Household Cleaning Supplies > Household Cleaning Products > Washing-up Detergent & Soap','en-AU'),(8664,'Home & Garden > Household Supplies > Household Cleaning Supplies > Mop Heads & Refills','en-AU'),(8665,'Home & Garden > Household Supplies > Household Cleaning Supplies > Mops','en-AU'),(8666,'Home & Garden > Household Supplies > Household Cleaning Supplies > Scrub Brush Heads & Refills','en-AU'),(8667,'Home & Garden > Household Supplies > Household Cleaning Supplies > Scrubbing Brushes','en-AU'),(8668,'Home & Garden > Household Supplies > Household Cleaning Supplies > Shop Towels','en-AU'),(8669,'Home & Garden > Household Supplies > Household Cleaning Supplies > Sponges & Scouring Pads','en-AU'),(8670,'Home & Garden > Household Supplies > Household Cleaning Supplies > Squeegees','en-AU'),(8671,'Home & Garden > Household Supplies > Household Paper Products','en-AU'),(8672,'Home & Garden > Household Supplies > Household Paper Products > Facial Tissues','en-AU'),(8673,'Home & Garden > Household Supplies > Household Paper Products > Paper Napkins','en-AU'),(8674,'Home & Garden > Household Supplies > Household Paper Products > Paper Towels','en-AU'),(8675,'Home & Garden > Household Supplies > Household Paper Products > Toilet Paper','en-AU'),(8676,'Home & Garden > Household Supplies > Household Thermometers','en-AU'),(8677,'Home & Garden > Household Supplies > Laundry Supplies','en-AU'),(8678,'Home & Garden > Household Supplies > Laundry Supplies > Bleach','en-AU'),(8679,'Home & Garden > Household Supplies > Laundry Supplies > Clothespins','en-AU'),(8680,'Home & Garden > Household Supplies > Laundry Supplies > Dry Cleaning Kits','en-AU'),(8681,'Home & Garden > Household Supplies > Laundry Supplies > Drying Racks & Hangers','en-AU'),(8682,'Home & Garden > Household Supplies > Laundry Supplies > Fabric Refreshers','en-AU'),(8683,'Home & Garden > Household Supplies > Laundry Supplies > Fabric Shavers','en-AU'),(8684,'Home & Garden > Household Supplies > Laundry Supplies > Fabric Softeners & Dryer Sheets','en-AU'),(8685,'Home & Garden > Household Supplies > Laundry Supplies > Fabric Stain Removers','en-AU'),(8686,'Home & Garden > Household Supplies > Laundry Supplies > Fabric Starch','en-AU'),(8687,'Home & Garden > Household Supplies > Laundry Supplies > Garment Shields','en-AU'),(8688,'Home & Garden > Household Supplies > Laundry Supplies > Iron Rests','en-AU'),(8689,'Home & Garden > Household Supplies > Laundry Supplies > Ironing Board Pads & Covers','en-AU'),(8690,'Home & Garden > Household Supplies > Laundry Supplies > Ironing Board Replacement Parts','en-AU'),(8691,'Home & Garden > Household Supplies > Laundry Supplies > Ironing Boards','en-AU'),(8692,'Home & Garden > Household Supplies > Laundry Supplies > Laundry Balls','en-AU'),(8693,'Home & Garden > Household Supplies > Laundry Supplies > Laundry Baskets','en-AU'),(8694,'Home & Garden > Household Supplies > Laundry Supplies > Laundry Detergent','en-AU'),(8695,'Home & Garden > Household Supplies > Laundry Supplies > Laundry Wash Bags & Frames','en-AU'),(8696,'Home & Garden > Household Supplies > Laundry Supplies > Lint Rollers','en-AU'),(8697,'Home & Garden > Household Supplies > Laundry Supplies > Wrinkle Releasers & Anti-Static Sprays','en-AU'),(8698,'Home & Garden > Household Supplies > Moisture Absorbers','en-AU'),(8699,'Home & Garden > Household Supplies > Pest Control','en-AU'),(8700,'Home & Garden > Household Supplies > Pest Control > Fly Swatters','en-AU'),(8701,'Home & Garden > Household Supplies > Pest Control > Pest Control Traps','en-AU'),(8702,'Home & Garden > Household Supplies > Pest Control > Pesticides','en-AU'),(8703,'Home & Garden > Household Supplies > Pest Control > Repellents','en-AU'),(8704,'Home & Garden > Household Supplies > Pest Control > Repellents > Animal & Pet Repellents','en-AU'),(8705,'Home & Garden > Household Supplies > Pest Control > Repellents > Household Insect Repellents','en-AU'),(8706,'Home & Garden > Household Supplies > Rubbish Bags','en-AU'),(8707,'Home & Garden > Household Supplies > Rug Pads','en-AU'),(8708,'Home & Garden > Household Supplies > Shoe Care & Tools','en-AU'),(8709,'Home & Garden > Household Supplies > Shoe Care & Tools > Boot Pulls','en-AU'),(8710,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Bags','en-AU'),(8711,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Brushes','en-AU'),(8712,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Care Kits','en-AU'),(8713,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Dryers','en-AU'),(8714,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Horns & Dressing Aids','en-AU'),(8715,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Polishers','en-AU'),(8716,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Polishes & Waxes','en-AU'),(8717,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Scrapers','en-AU'),(8718,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Treatments & Dyes','en-AU'),(8719,'Home & Garden > Household Supplies > Shoe Care & Tools > Shoe Trees & Shapers','en-AU'),(8720,'Home & Garden > Household Supplies > Stair Treads','en-AU'),(8721,'Home & Garden > Household Supplies > Storage & Organisation','en-AU'),(8722,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage','en-AU'),(8723,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Charging Valets','en-AU'),(8724,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Closet Organisers & Garment Racks','en-AU'),(8725,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Clothes Valets','en-AU'),(8726,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Hangers','en-AU'),(8727,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Hat Boxes','en-AU'),(8728,'Home & Garden > Household Supplies > Storage & Organisation > Clothing & Wardrobe Storage > Shoe Racks & Organisers','en-AU'),(8729,'Home & Garden > Household Supplies > Storage & Organisation > Cutlery Boxes','en-AU'),(8730,'Home & Garden > Household Supplies > Storage & Organisation > Household Drawer Organiser Inserts','en-AU'),(8731,'Home & Garden > Household Supplies > Storage & Organisation > Household Storage Bags','en-AU'),(8732,'Home & Garden > Household Supplies > Storage & Organisation > Household Storage Boxes','en-AU'),(8733,'Home & Garden > Household Supplies > Storage & Organisation > Household Storage Containers','en-AU'),(8734,'Home & Garden > Household Supplies > Storage & Organisation > Household Storage Drawers','en-AU'),(8735,'Home & Garden > Household Supplies > Storage & Organisation > Photo Storage','en-AU'),(8736,'Home & Garden > Household Supplies > Storage & Organisation > Photo Storage > Photo Albums','en-AU'),(8737,'Home & Garden > Household Supplies > Storage & Organisation > Photo Storage > Photo Storage Boxes','en-AU'),(8738,'Home & Garden > Household Supplies > Storage & Organisation > Storage Hooks & Racks','en-AU'),(8739,'Home & Garden > Household Supplies > Storage & Organisation > Storage Hooks & Racks > Ironing Board Hooks & Racks','en-AU'),(8740,'Home & Garden > Household Supplies > Storage & Organisation > Storage Hooks & Racks > Umbrella Stands & Racks','en-AU'),(8741,'Home & Garden > Household Supplies > Storage & Organisation > Storage Hooks & Racks > Utility Hooks','en-AU'),(8742,'Home & Garden > Household Supplies > Waste Containment','en-AU'),(8743,'Home & Garden > Household Supplies > Waste Containment > Hazardous Waste Containers','en-AU'),(8744,'Home & Garden > Household Supplies > Waste Containment > Recycling Containers','en-AU'),(8745,'Home & Garden > Household Supplies > Waste Containment > Rubbish Bins & Waste Paper Baskets','en-AU'),(8746,'Home & Garden > Household Supplies > Waste Containment > Skips','en-AU'),(8747,'Home & Garden > Household Supplies > Waste Containment Accessories','en-AU'),(8748,'Home & Garden > Household Supplies > Waste Containment Accessories > Waste Container Carts','en-AU'),(8749,'Home & Garden > Household Supplies > Waste Containment Accessories > Waste Container Enclosures','en-AU'),(8750,'Home & Garden > Household Supplies > Waste Containment Accessories > Waste Container Labels & Signs','en-AU'),(8751,'Home & Garden > Household Supplies > Waste Containment Accessories > Waste Container Lids','en-AU'),(8752,'Home & Garden > Household Supplies > Waste Containment Accessories > Waste Container Wheels','en-AU'),(8753,'Home & Garden > Kitchen & Dining','en-AU'),(8754,'Home & Garden > Kitchen & Dining > Barware','en-AU'),(8755,'Home & Garden > Kitchen & Dining > Barware > Absinthe Fountains','en-AU'),(8756,'Home & Garden > Kitchen & Dining > Barware > Beer Dispensers & Taps','en-AU'),(8757,'Home & Garden > Kitchen & Dining > Barware > Beverage Chilling Cubes & Sticks','en-AU'),(8758,'Home & Garden > Kitchen & Dining > Barware > Beverage Tubs & Chillers','en-AU'),(8759,'Home & Garden > Kitchen & Dining > Barware > Bottle Caps','en-AU'),(8760,'Home & Garden > Kitchen & Dining > Barware > Bottle Stoppers & Savers','en-AU'),(8761,'Home & Garden > Kitchen & Dining > Barware > Coaster Holders','en-AU'),(8762,'Home & Garden > Kitchen & Dining > Barware > Coasters','en-AU'),(8763,'Home & Garden > Kitchen & Dining > Barware > Cocktail & Barware Tool Sets','en-AU'),(8764,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools','en-AU'),(8765,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools > Bar Ice Picks','en-AU'),(8766,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools > Bottle Openers','en-AU'),(8767,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools > Cocktail Shakers','en-AU'),(8768,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools > Cocktail Strainers','en-AU'),(8769,'Home & Garden > Kitchen & Dining > Barware > Cocktail Shakers & Tools > Muddlers','en-AU'),(8770,'Home & Garden > Kitchen & Dining > Barware > Corkscrews','en-AU'),(8771,'Home & Garden > Kitchen & Dining > Barware > Decanters','en-AU'),(8772,'Home & Garden > Kitchen & Dining > Barware > Foil Cutters','en-AU'),(8773,'Home & Garden > Kitchen & Dining > Barware > Wine Aerators','en-AU'),(8774,'Home & Garden > Kitchen & Dining > Barware > Wine Bottle Holders','en-AU'),(8775,'Home & Garden > Kitchen & Dining > Barware > Wine Glass Charms','en-AU'),(8776,'Home & Garden > Kitchen & Dining > Cookware & Bakeware','en-AU'),(8777,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware','en-AU'),(8778,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Bakeware Sets','en-AU'),(8779,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Baking & Biscuit Baking Trays','en-AU'),(8780,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Bread Tins & Moulds','en-AU'),(8781,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Broiling Pans','en-AU'),(8782,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Cake Tins & Moulds','en-AU'),(8783,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Muffin & Pastry Tins','en-AU'),(8784,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Pie & Quiche Tins','en-AU'),(8785,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Pizza Pans','en-AU'),(8786,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Pizza Stones','en-AU'),(8787,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Ramekins & Souffle Dishes','en-AU'),(8788,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware > Roasting Pans','en-AU'),(8789,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware Accessories','en-AU'),(8790,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware Accessories > Baking Mats & Liners','en-AU'),(8791,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware Accessories > Pie Weights','en-AU'),(8792,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Bakeware Accessories > Roasting Pan Racks','en-AU'),(8793,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware','en-AU'),(8794,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware & Bakeware Combo Sets','en-AU'),(8795,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Casserole Dishes','en-AU'),(8796,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Cookware Sets','en-AU'),(8797,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Crêpe & Blini Pans','en-AU'),(8798,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Double Boilers','en-AU'),(8799,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Dutch Ovens','en-AU'),(8800,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Fermentation & Pickling Crocks','en-AU'),(8801,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Griddles & Grill Pans','en-AU'),(8802,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Grill Presses','en-AU'),(8803,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Paella Pans','en-AU'),(8804,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Pressure Cookers & Canners','en-AU'),(8805,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Saucepans','en-AU'),(8806,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Sauté Pans','en-AU'),(8807,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Skillets & Frying Pans','en-AU'),(8808,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Stock Pots','en-AU'),(8809,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Stove Top Kettles','en-AU'),(8810,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Tagines & Clay Cooking Pots','en-AU'),(8811,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware > Woks','en-AU'),(8812,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories','en-AU'),(8813,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Pot & Pan Handles','en-AU'),(8814,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Pot & Pan Lids','en-AU'),(8815,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Pressure Cooker & Canner Accessories','en-AU'),(8816,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Steamer Baskets','en-AU'),(8817,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Wok Accessories','en-AU'),(8818,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Wok Accessories > Wok Brushes','en-AU'),(8819,'Home & Garden > Kitchen & Dining > Cookware & Bakeware > Cookware Accessories > Wok Accessories > Wok Rings','en-AU'),(8820,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers','en-AU'),(8821,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Airpots','en-AU'),(8822,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Canteens','en-AU'),(8823,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Coolers','en-AU'),(8824,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Drink Sleeves','en-AU'),(8825,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Drink Sleeves > Cup Sleeves','en-AU'),(8826,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Drink Sleeves > Tin & Bottle Sleeves','en-AU'),(8827,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Flasks','en-AU'),(8828,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Insulated Bags','en-AU'),(8829,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Lunch Boxes & Bags','en-AU'),(8830,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Picnic Baskets','en-AU'),(8831,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Replacement Drink Lids','en-AU'),(8832,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Thermoses','en-AU'),(8833,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Water Bottles','en-AU'),(8834,'Home & Garden > Kitchen & Dining > Food & Beverage Carriers > Wine Carrier Bags','en-AU'),(8835,'Home & Garden > Kitchen & Dining > Food Storage','en-AU'),(8836,'Home & Garden > Kitchen & Dining > Food Storage > Biscuit Jars','en-AU'),(8837,'Home & Garden > Kitchen & Dining > Food Storage > Bread Boxes & Bags','en-AU'),(8838,'Home & Garden > Kitchen & Dining > Food Storage > Food Container Covers','en-AU'),(8839,'Home & Garden > Kitchen & Dining > Food Storage > Food Storage Bags','en-AU'),(8840,'Home & Garden > Kitchen & Dining > Food Storage > Food Storage Containers','en-AU'),(8841,'Home & Garden > Kitchen & Dining > Food Storage > Food Wraps','en-AU'),(8842,'Home & Garden > Kitchen & Dining > Food Storage > Food Wraps > Cling Film','en-AU'),(8843,'Home & Garden > Kitchen & Dining > Food Storage > Food Wraps > Food Wrapping Foil','en-AU'),(8844,'Home & Garden > Kitchen & Dining > Food Storage > Food Wraps > Parchment Paper','en-AU'),(8845,'Home & Garden > Kitchen & Dining > Food Storage > Food Wraps > Waxed Paper','en-AU'),(8846,'Home & Garden > Kitchen & Dining > Food Storage > Honey Jars','en-AU'),(8847,'Home & Garden > Kitchen & Dining > Food Storage > Sweet Buckets','en-AU'),(8848,'Home & Garden > Kitchen & Dining > Food Storage Accessories','en-AU'),(8849,'Home & Garden > Kitchen & Dining > Food Storage Accessories > Bag Ties & Bag Clips','en-AU'),(8850,'Home & Garden > Kitchen & Dining > Food Storage Accessories > Food & Beverage Labels','en-AU'),(8851,'Home & Garden > Kitchen & Dining > Food Storage Accessories > Food Wrap Dispensers','en-AU'),(8852,'Home & Garden > Kitchen & Dining > Food Storage Accessories > Oxygen Absorbers','en-AU'),(8853,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories','en-AU'),(8854,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Breadmaker Accessories','en-AU'),(8855,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Candyfloss Machine Accessories','en-AU'),(8856,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories','en-AU'),(8857,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Decanter Warmers','en-AU'),(8858,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Decanters','en-AU'),(8859,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Filter Baskets','en-AU'),(8860,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Filters','en-AU'),(8861,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Grinder Accessories','en-AU'),(8862,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Grinders','en-AU'),(8863,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Maker & Espresso Machine Replacement Parts','en-AU'),(8864,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Coffee Maker Water Filters','en-AU'),(8865,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Frothing Pitchers','en-AU'),(8866,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Coffee Maker & Espresso Machine Accessories > Portafilters','en-AU'),(8867,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Cooker Hood Accessories','en-AU'),(8868,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Deep Fryer Accessories','en-AU'),(8869,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Dishwasher Parts & Accessories','en-AU'),(8870,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Electric Kettle Accessories','en-AU'),(8871,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Electric Skillet & Wok Accessories','en-AU'),(8872,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Fondue Set Accessories','en-AU'),(8873,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Fondue Set Accessories > Cooking Gel Fuels','en-AU'),(8874,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Fondue Set Accessories > Fondue Forks','en-AU'),(8875,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Fondue Set Accessories > Fondue Pot Stands','en-AU'),(8876,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Food Dehydrator Accessories','en-AU'),(8877,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Food Dehydrator Accessories > Food Dehydrator Sheets','en-AU'),(8878,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Food Dehydrator Accessories > Food Dehydrator Trays','en-AU'),(8879,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Food Grinder Accessories','en-AU'),(8880,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Food Mixer & Blender Accessories','en-AU'),(8881,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Freezer Accessories','en-AU'),(8882,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Hob, Oven & Cooker Accessories','en-AU'),(8883,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Ice Cream Maker Accessories','en-AU'),(8884,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Ice Cream Maker Accessories > Ice Cream Maker Freezer Bowls','en-AU'),(8885,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Ice Crusher & Shaver Accessories','en-AU'),(8886,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Ice Maker Accessories','en-AU'),(8887,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Juicer Accessories','en-AU'),(8888,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Microwave Oven Accessories','en-AU'),(8889,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories','en-AU'),(8890,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Charcoal Briquettes','en-AU'),(8891,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Charcoal Chimneys','en-AU'),(8892,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grill Carts','en-AU'),(8893,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grill Covers','en-AU'),(8894,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grill Racks & Toppers','en-AU'),(8895,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grill Replacement Parts','en-AU'),(8896,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grill Spits & Baskets','en-AU'),(8897,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Outdoor Grilling Planks','en-AU'),(8898,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Outdoor Grill Accessories > Smoking Chips & Pellets','en-AU'),(8899,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Pasta Maker Accessories','en-AU'),(8900,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Popcorn Maker Accessories','en-AU'),(8901,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Portable Cooker Accessories','en-AU'),(8902,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Refrigerator Accessories','en-AU'),(8903,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Rubbish Disposal Accessories','en-AU'),(8904,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Soda Maker Accessories','en-AU'),(8905,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Steam Table Accessories','en-AU'),(8906,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Steam Table Accessories > Steam Table Pan Covers','en-AU'),(8907,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Steam Table Accessories > Steam Table Pans','en-AU'),(8908,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Toaster Accessories','en-AU'),(8909,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Vacuum Sealer Accessories','en-AU'),(8910,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Vacuum Sealer Accessories > Vacuum Sealer Bags','en-AU'),(8911,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Waffle Iron Accessories','en-AU'),(8912,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Water Cooler Accessories','en-AU'),(8913,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Water Cooler Accessories > Water Cooler Bottles','en-AU'),(8914,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Wine Fridge Accessories','en-AU'),(8915,'Home & Garden > Kitchen & Dining > Kitchen Appliance Accessories > Yoghurt Maker Accessories','en-AU'),(8916,'Home & Garden > Kitchen & Dining > Kitchen Appliances','en-AU'),(8917,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Beverage Warmers','en-AU'),(8918,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Breadmakers','en-AU'),(8919,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Candy Floss Machines','en-AU'),(8920,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Chocolate Tempering Machines','en-AU'),(8921,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines','en-AU'),(8922,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > Drip Coffee Makers','en-AU'),(8923,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > Electric & Stove-Top Espresso Pots','en-AU'),(8924,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > Espresso Machines','en-AU'),(8925,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > French Presses','en-AU'),(8926,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > Percolators','en-AU'),(8927,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Coffee Makers & Espresso Machines > Vacuum Coffee Makers','en-AU'),(8928,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Cooking Ranges','en-AU'),(8929,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Deep Fryers','en-AU'),(8930,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Deli Slicers','en-AU'),(8931,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Dishwashers','en-AU'),(8932,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Electric Griddles & Grills','en-AU'),(8933,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Electric Kettles','en-AU'),(8934,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Electric Skillets & Woks','en-AU'),(8935,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Fondue Pots & Sets','en-AU'),(8936,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers','en-AU'),(8937,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Egg Cookers','en-AU'),(8938,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Food Steamers','en-AU'),(8939,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Rice Cookers','en-AU'),(8940,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Slow Cookers','en-AU'),(8941,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Thermal Cookers','en-AU'),(8942,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Cookers & Steamers > Water Ovens','en-AU'),(8943,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Dehydrators','en-AU'),(8944,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Mincers & Mills','en-AU'),(8945,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Mixers & Blenders','en-AU'),(8946,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Smokers','en-AU'),(8947,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Warmers','en-AU'),(8948,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Warmers > Chafing Dishes','en-AU'),(8949,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Warmers > Food Heating Lamps','en-AU'),(8950,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Warmers > Rice Keepers','en-AU'),(8951,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Food Warmers > Steam Tables','en-AU'),(8952,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Freezers','en-AU'),(8953,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Frozen Drink Makers','en-AU'),(8954,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Gas Griddles','en-AU'),(8955,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Hobs','en-AU'),(8956,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Hot Drink Makers','en-AU'),(8957,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Hot Plates','en-AU'),(8958,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Ice Cream Makers','en-AU'),(8959,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Ice Crushers & Shavers','en-AU'),(8960,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Ice Makers','en-AU'),(8961,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Juicers','en-AU'),(8962,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Knife Sharpeners','en-AU'),(8963,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Microwave Ovens','en-AU'),(8964,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Milk Frothers & Steamers','en-AU'),(8965,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Mochi Makers','en-AU'),(8966,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Outdoor Grills','en-AU'),(8967,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Ovens','en-AU'),(8968,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Pasta Makers','en-AU'),(8969,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Popcorn Makers','en-AU'),(8970,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Portable Cooking Stoves','en-AU'),(8971,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Range Hoods','en-AU'),(8972,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Refrigerators','en-AU'),(8973,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Roaster Ovens & Rotisseries','en-AU'),(8974,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Rubbish Compactors','en-AU'),(8975,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Rubbish Disposals','en-AU'),(8976,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Soft Drink Makers','en-AU'),(8977,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Soy Milk Makers','en-AU'),(8978,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Tea Makers','en-AU'),(8979,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills','en-AU'),(8980,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Countertop & Toaster Ovens','en-AU'),(8981,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Doughnut Makers','en-AU'),(8982,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Muffin & Cupcake Makers','en-AU'),(8983,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Pizza Makers & Ovens','en-AU'),(8984,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Pizzelle Makers','en-AU'),(8985,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Pretzel Makers','en-AU'),(8986,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Sandwich Makers','en-AU'),(8987,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Toasters','en-AU'),(8988,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Tortilla & Flatbread Makers','en-AU'),(8989,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Toasters & Grills > Waffle Irons','en-AU'),(8990,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Vacuum Sealers','en-AU'),(8991,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Water Coolers','en-AU'),(8992,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Water Filters','en-AU'),(8993,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Wine Fridges','en-AU'),(8994,'Home & Garden > Kitchen & Dining > Kitchen Appliances > Yoghurt Makers','en-AU'),(8995,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils','en-AU'),(8996,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Aprons','en-AU'),(8997,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Baking Peels','en-AU'),(8998,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Basters','en-AU'),(8999,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Basting Brushes','en-AU'),(9000,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Biscuit Cutters','en-AU'),(9001,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Biscuit Presses','en-AU'),(9002,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cake Decorating Supplies','en-AU'),(9003,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cake Servers','en-AU'),(9004,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Can Crushers','en-AU'),(9005,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Carving Forks','en-AU'),(9006,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Channel Knives','en-AU'),(9007,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Colanders & Sieves','en-AU'),(9008,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Condiment Dispensers','en-AU'),(9009,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cooking Thermometer Accessories','en-AU'),(9010,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cooking Thermometers','en-AU'),(9011,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cooking Timers','en-AU'),(9012,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cooking Torches','en-AU'),(9013,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cooling Racks','en-AU'),(9014,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Cutting Boards','en-AU'),(9015,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Dish Racks & Draining Boards','en-AU'),(9016,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Dough Wheels','en-AU'),(9017,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Drink Dispensers','en-AU'),(9018,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Electric Knife Accessories','en-AU'),(9019,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Electric Knife Accessories > Electric Knife Replacement Blades','en-AU'),(9020,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Electric Knives','en-AU'),(9021,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Flour Sifters','en-AU'),(9022,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food & Drink Stencils','en-AU'),(9023,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Cracking Tools','en-AU'),(9024,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Cracking Tools > Lobster & Crab Crackers','en-AU'),(9025,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Cracking Tools > Nutcrackers','en-AU'),(9026,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Cracking Tools > Nutcrackers > Decorative Nutcrackers','en-AU'),(9027,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Dispensers','en-AU'),(9028,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Graters & Zesters','en-AU'),(9029,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Peelers & Corers','en-AU'),(9030,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Scoops','en-AU'),(9031,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Scoops > Ice Cream Scoops','en-AU'),(9032,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Scoops > Ice Scoops','en-AU'),(9033,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Scoops > Melon Ballers','en-AU'),(9034,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Scoops > Popcorn & French Fry Scoops','en-AU'),(9035,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Steaming Bags','en-AU'),(9036,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Food Sticks & Skewers','en-AU'),(9037,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Funnels','en-AU'),(9038,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Garlic Presses','en-AU'),(9039,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Ice Cube Trays','en-AU'),(9040,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Jelly Moulds','en-AU'),(9041,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Jerky Guns','en-AU'),(9042,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Knives','en-AU'),(9043,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Moulds','en-AU'),(9044,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers','en-AU'),(9045,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Can Organisers','en-AU'),(9046,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Drinkware Racks','en-AU'),(9047,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Kitchen Cabinet Organisers','en-AU'),(9048,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Kitchen Counter & Beverage Station Organisers','en-AU'),(9049,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Kitchen Utensil Holders & Racks','en-AU'),(9050,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Knife Blocks & Holders','en-AU'),(9051,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Napkin Holders & Dispensers','en-AU'),(9052,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Paper Towel Holders & Dispensers','en-AU'),(9053,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Pot Racks','en-AU'),(9054,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Spice Organisers','en-AU'),(9055,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Straw Holders & Dispensers','en-AU'),(9056,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Sugar Packet Caddies','en-AU'),(9057,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Toothpick Holders & Dispensers','en-AU'),(9058,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Organisers > Utensil & Cutlery Trays','en-AU'),(9059,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Scrapers','en-AU'),(9060,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Scrapers > Bench Scrapers','en-AU'),(9061,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Scrapers > Bowl Scrapers','en-AU'),(9062,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Scrapers > Grill Scrapers','en-AU'),(9063,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Shears','en-AU'),(9064,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Slicers','en-AU'),(9065,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Tongs','en-AU'),(9066,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Kitchen Utensil Sets','en-AU'),(9067,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Ladles','en-AU'),(9068,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Mashers','en-AU'),(9069,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Measuring Cups & Spoons','en-AU'),(9070,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Meat Tenderisers','en-AU'),(9071,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Mixing Bowls','en-AU'),(9072,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Mortars & Pestles','en-AU'),(9073,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Oil & Vinegar Dispensers','en-AU'),(9074,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Oven Bags','en-AU'),(9075,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Oven Mitts & Pot Holders','en-AU'),(9076,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Pasta Moulds & Stamps','en-AU'),(9077,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Pastry Blenders','en-AU'),(9078,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Pastry Cloths','en-AU'),(9079,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Pizza Cutter Accessories','en-AU'),(9080,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Pizza Cutters','en-AU'),(9081,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Ricers','en-AU'),(9082,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Rolling Pin Accessories','en-AU'),(9083,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Rolling Pin Accessories > Rolling Pin Covers & Sleeves','en-AU'),(9084,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Rolling Pin Accessories > Rolling Pin Rings','en-AU'),(9085,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Rolling Pins','en-AU'),(9086,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Salad Dressing Mixers & Shakers','en-AU'),(9087,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Salad Spinners','en-AU'),(9088,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Sink Caddies','en-AU'),(9089,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Sink Mats & Grids','en-AU'),(9090,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Slotted Spoons','en-AU'),(9091,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Spatulas','en-AU'),(9092,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Spice Grinder Accessories','en-AU'),(9093,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Spice Grinders','en-AU'),(9094,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Spoon Rests','en-AU'),(9095,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Sugar Dispensers','en-AU'),(9096,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Sushi Mats','en-AU'),(9097,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Tea Strainers','en-AU'),(9098,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Tin Openers','en-AU'),(9099,'Home & Garden > Kitchen & Dining > Kitchen Tools & Utensils > Whisks','en-AU'),(9100,'Home & Garden > Kitchen & Dining > Prefabricated Kitchens & Kitchenettes','en-AU'),(9101,'Home & Garden > Kitchen & Dining > Tableware','en-AU'),(9102,'Home & Garden > Kitchen & Dining > Tableware > Coffee & Tea Pots','en-AU'),(9103,'Home & Garden > Kitchen & Dining > Tableware > Coffee & Tea Sets','en-AU'),(9104,'Home & Garden > Kitchen & Dining > Tableware > Cutlery','en-AU'),(9105,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Chopstick Accessories','en-AU'),(9106,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Chopsticks','en-AU'),(9107,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Cutlery Sets','en-AU'),(9108,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Forks','en-AU'),(9109,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Spoons','en-AU'),(9110,'Home & Garden > Kitchen & Dining > Tableware > Cutlery > Table Knives','en-AU'),(9111,'Home & Garden > Kitchen & Dining > Tableware > Dinnerware','en-AU'),(9112,'Home & Garden > Kitchen & Dining > Tableware > Dinnerware > Bowls','en-AU'),(9113,'Home & Garden > Kitchen & Dining > Tableware > Dinnerware > Dinnerware Sets','en-AU'),(9114,'Home & Garden > Kitchen & Dining > Tableware > Dinnerware > Plates','en-AU'),(9115,'Home & Garden > Kitchen & Dining > Tableware > Drinkware','en-AU'),(9116,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Beer Glasses','en-AU'),(9117,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Coffee & Tea Cups','en-AU'),(9118,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Coffee & Tea Saucers','en-AU'),(9119,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Drinkware Sets','en-AU'),(9120,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Mugs','en-AU'),(9121,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Shot Glasses','en-AU'),(9122,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Stemware','en-AU'),(9123,'Home & Garden > Kitchen & Dining > Tableware > Drinkware > Tumblers','en-AU'),(9124,'Home & Garden > Kitchen & Dining > Tableware > Salt & Pepper Shakers','en-AU'),(9125,'Home & Garden > Kitchen & Dining > Tableware > Serveware','en-AU'),(9126,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Butter Dishes','en-AU'),(9127,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Cake Boards','en-AU'),(9128,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Cake Stands','en-AU'),(9129,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Egg Cups','en-AU'),(9130,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Gravy Boats','en-AU'),(9131,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Punch Bowls','en-AU'),(9132,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Serving Pitchers & Carafes','en-AU'),(9133,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Serving Platters','en-AU'),(9134,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Serving Trays','en-AU'),(9135,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Sugar Bowls & Milk Jugs','en-AU'),(9136,'Home & Garden > Kitchen & Dining > Tableware > Serveware > Tureens','en-AU'),(9137,'Home & Garden > Kitchen & Dining > Tableware > Serveware Accessories','en-AU'),(9138,'Home & Garden > Kitchen & Dining > Tableware > Serveware Accessories > Punch Bowl Stands','en-AU'),(9139,'Home & Garden > Kitchen & Dining > Tableware > Serveware Accessories > Tureen Lids','en-AU'),(9140,'Home & Garden > Kitchen & Dining > Tableware > Serveware Accessories > Tureen Stands','en-AU'),(9141,'Home & Garden > Kitchen & Dining > Tableware > Tablecloth Clips & Weights','en-AU'),(9142,'Home & Garden > Kitchen & Dining > Tableware > Trivets','en-AU'),(9143,'Home & Garden > Lawn & Garden','en-AU'),(9144,'Home & Garden > Lawn & Garden > Gardening','en-AU'),(9145,'Home & Garden > Lawn & Garden > Gardening > Composting','en-AU'),(9146,'Home & Garden > Lawn & Garden > Gardening > Composting > Compost','en-AU'),(9147,'Home & Garden > Lawn & Garden > Gardening > Composting > Compost Aerators','en-AU'),(9148,'Home & Garden > Lawn & Garden > Gardening > Composting > Composters','en-AU'),(9149,'Home & Garden > Lawn & Garden > Gardening > Fertilisers','en-AU'),(9150,'Home & Garden > Lawn & Garden > Gardening > Garden Disease Control','en-AU'),(9151,'Home & Garden > Lawn & Garden > Gardening > Garden Pot Saucers & Trays','en-AU'),(9152,'Home & Garden > Lawn & Garden > Gardening > Gardening Accessories','en-AU'),(9153,'Home & Garden > Lawn & Garden > Gardening > Gardening Accessories > Gardening Scooters, Seats & Kneelers','en-AU'),(9154,'Home & Garden > Lawn & Garden > Gardening > Gardening Accessories > Gardening Totes','en-AU'),(9155,'Home & Garden > Lawn & Garden > Gardening > Gardening Accessories > Potting Benches','en-AU'),(9156,'Home & Garden > Lawn & Garden > Gardening > Gardening Tool Accessories','en-AU'),(9157,'Home & Garden > Lawn & Garden > Gardening > Gardening Tool Accessories > Gardening Tool Handles','en-AU'),(9158,'Home & Garden > Lawn & Garden > Gardening > Gardening Tool Accessories > Gardening Tool Heads','en-AU'),(9159,'Home & Garden > Lawn & Garden > Gardening > Gardening Tool Accessories > Wheelbarrow Parts','en-AU'),(9160,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools','en-AU'),(9161,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Bulb Planting Tools','en-AU'),(9162,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Cultivating Tools','en-AU'),(9163,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Gardening Forks','en-AU'),(9164,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Gardening Sickles & Machetes','en-AU'),(9165,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Gardening Trowels','en-AU'),(9166,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Lawn & Garden Sprayers','en-AU'),(9167,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Lawn Rollers','en-AU'),(9168,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Pruning Saws','en-AU'),(9169,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Pruning Shears','en-AU'),(9170,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Rakes','en-AU'),(9171,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Shovels & Spades','en-AU'),(9172,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Spreaders','en-AU'),(9173,'Home & Garden > Lawn & Garden > Gardening > Gardening Tools > Wheelbarrows','en-AU'),(9174,'Home & Garden > Lawn & Garden > Gardening > Greenhouses','en-AU'),(9175,'Home & Garden > Lawn & Garden > Gardening > Herbicides','en-AU'),(9176,'Home & Garden > Lawn & Garden > Gardening > Landscape Fabric','en-AU'),(9177,'Home & Garden > Lawn & Garden > Gardening > Landscape Fabric Accessories','en-AU'),(9178,'Home & Garden > Lawn & Garden > Gardening > Landscape Fabric Accessories > Landscape Fabric Staples & Pins','en-AU'),(9179,'Home & Garden > Lawn & Garden > Gardening > Landscape Fabric Accessories > Landscape Fabric Tape','en-AU'),(9180,'Home & Garden > Lawn & Garden > Gardening > Mulch','en-AU'),(9181,'Home & Garden > Lawn & Garden > Gardening > Plant Cages & Supports','en-AU'),(9182,'Home & Garden > Lawn & Garden > Gardening > Plant Stands','en-AU'),(9183,'Home & Garden > Lawn & Garden > Gardening > Pot & Planter Liners','en-AU'),(9184,'Home & Garden > Lawn & Garden > Gardening > Pots & Planters','en-AU'),(9185,'Home & Garden > Lawn & Garden > Gardening > Rain Barrels','en-AU'),(9186,'Home & Garden > Lawn & Garden > Gardening > Sands & Soils','en-AU'),(9187,'Home & Garden > Lawn & Garden > Outdoor Living','en-AU'),(9188,'Home & Garden > Lawn & Garden > Outdoor Living > Hammock Parts & Accessories','en-AU'),(9189,'Home & Garden > Lawn & Garden > Outdoor Living > Hammocks','en-AU'),(9190,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Blankets','en-AU'),(9191,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Blankets > Beach Mats','en-AU'),(9192,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Blankets > Picnic Blankets','en-AU'),(9193,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Blankets > Poncho Liners','en-AU'),(9194,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures','en-AU'),(9195,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopies & Gazebos','en-AU'),(9196,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories','en-AU'),(9197,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories > Canopy & Gazebo Enclosure Kits','en-AU'),(9198,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories > Canopy & Gazebo Frames','en-AU'),(9199,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories > Canopy & Gazebo Tops','en-AU'),(9200,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories > Canopy Poles','en-AU'),(9201,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Canopy & Gazebo Accessories > Canopy Weights','en-AU'),(9202,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Garden Arches, Trellises, Arbours & Pergolas','en-AU'),(9203,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Garden Bridges','en-AU'),(9204,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Structures > Sheds, Garages & Carports','en-AU'),(9205,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories','en-AU'),(9206,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories > Outdoor Umbrella & Sunshade Fabric','en-AU'),(9207,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories > Outdoor Umbrella Bases','en-AU'),(9208,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories > Outdoor Umbrella Covers','en-AU'),(9209,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories > Outdoor Umbrella Enclosure Kits','en-AU'),(9210,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrella & Parasol Accessories > Outdoor Umbrella Lights','en-AU'),(9211,'Home & Garden > Lawn & Garden > Outdoor Living > Outdoor Umbrellas & Sunshades','en-AU'),(9212,'Home & Garden > Lawn & Garden > Outdoor Living > Porch Swing Accessories','en-AU'),(9213,'Home & Garden > Lawn & Garden > Outdoor Living > Porch Swings','en-AU'),(9214,'Home & Garden > Lawn & Garden > Outdoor Living > Window & Door Awning Accessories','en-AU'),(9215,'Home & Garden > Lawn & Garden > Outdoor Living > Window & Door Awnings','en-AU'),(9216,'Home & Garden > Lawn & Garden > Outdoor Power Equipment','en-AU'),(9217,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Chainsaws','en-AU'),(9218,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Grass Edgers','en-AU'),(9219,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Hedge Trimmers','en-AU'),(9220,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Aerators & Dethatchers','en-AU'),(9221,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Mowers','en-AU'),(9222,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Mowers > Ride-on Mowers','en-AU'),(9223,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Mowers > Robotic Mowers','en-AU'),(9224,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Mowers > Tow-Behind Mowers','en-AU'),(9225,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Mowers > Walk-Behind Mowers','en-AU'),(9226,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Lawn Vacuums','en-AU'),(9227,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Leaf Blowers','en-AU'),(9228,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Outdoor Power Equipment Base Units','en-AU'),(9229,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Outdoor Power Equipment Sets','en-AU'),(9230,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Power Sweepers','en-AU'),(9231,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Power Tillers & Cultivators','en-AU'),(9232,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Pressure Washers','en-AU'),(9233,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Snow Blowers','en-AU'),(9234,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Tractors','en-AU'),(9235,'Home & Garden > Lawn & Garden > Outdoor Power Equipment > Weed Trimmers','en-AU'),(9236,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories','en-AU'),(9237,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Chainsaw Accessories','en-AU'),(9238,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Chainsaw Accessories > Chainsaw Bars','en-AU'),(9239,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Chainsaw Accessories > Chainsaw Chains','en-AU'),(9240,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Grass Edger Accessories','en-AU'),(9241,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Hedge Trimmer Accessories','en-AU'),(9242,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories','en-AU'),(9243,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Brush Mower Attachments','en-AU'),(9244,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Bags','en-AU'),(9245,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Belts','en-AU'),(9246,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Blades','en-AU'),(9247,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Covers','en-AU'),(9248,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Mulch Kits','en-AU'),(9249,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Mulch Plugs & Plates','en-AU'),(9250,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Pulleys & Idlers','en-AU'),(9251,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Tyre Tubes','en-AU'),(9252,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Tyres','en-AU'),(9253,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Mower Wheels','en-AU'),(9254,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Striping Kits','en-AU'),(9255,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Lawn Mower Accessories > Lawn Sweepers','en-AU'),(9256,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Leaf Blower Accessories','en-AU'),(9257,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Leaf Blower Accessories > Leaf Blower Tubes','en-AU'),(9258,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments','en-AU'),(9259,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Grass Edger Attachments','en-AU'),(9260,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Ground & Leaf Blower Attachments','en-AU'),(9261,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Hedge Trimmer Attachments','en-AU'),(9262,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Pole Saw Attachments','en-AU'),(9263,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Tiller & Cultivator Attachments','en-AU'),(9264,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Multi-function Outdoor Power Equipment Attachments > Weed Trimmer Attachments','en-AU'),(9265,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Outdoor Power Equipment Batteries','en-AU'),(9266,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Pressure Washer Accessories','en-AU'),(9267,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Snow Blower Accessories','en-AU'),(9268,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Tractor Parts & Accessories','en-AU'),(9269,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Tractor Parts & Accessories > Tractor Tyres','en-AU'),(9270,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Tractor Parts & Accessories > Tractor Wheels','en-AU'),(9271,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Weed Trimmer Accessories','en-AU'),(9272,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Weed Trimmer Accessories > Weed Trimmer Blades & Spools','en-AU'),(9273,'Home & Garden > Lawn & Garden > Outdoor Power Equipment Accessories > Weed Trimmer Accessories > Weed Trimmer Spool Covers','en-AU'),(9274,'Home & Garden > Lawn & Garden > Snow Removal','en-AU'),(9275,'Home & Garden > Lawn & Garden > Snow Removal > Ice Scrapers & Snow Brushes','en-AU'),(9276,'Home & Garden > Lawn & Garden > Snow Removal > Snow Shovels','en-AU'),(9277,'Home & Garden > Lawn & Garden > Watering & Irrigation','en-AU'),(9278,'Home & Garden > Lawn & Garden > Watering & Irrigation > Garden Hose Fittings & Valves','en-AU'),(9279,'Home & Garden > Lawn & Garden > Watering & Irrigation > Garden Hose Spray Nozzles','en-AU'),(9280,'Home & Garden > Lawn & Garden > Watering & Irrigation > Garden Hoses','en-AU'),(9281,'Home & Garden > Lawn & Garden > Watering & Irrigation > Sprinkler Systems','en-AU'),(9282,'Home & Garden > Lawn & Garden > Watering & Irrigation > Sprinkler Systems > Sprinkler Controls','en-AU'),(9283,'Home & Garden > Lawn & Garden > Watering & Irrigation > Sprinkler Systems > Sprinkler Valves','en-AU'),(9284,'Home & Garden > Lawn & Garden > Watering & Irrigation > Sprinklers & Sprinkler Heads','en-AU'),(9285,'Home & Garden > Lawn & Garden > W